/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaInheritanceWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<Set<String>, ProximityLocation> PLACE_SUPER_CLASSES = NotNullLazyKey.create((String)"PLACE_SUPER_CLASSES", location -> {
        HashSet result = new HashSet();
        Processor processor = psiClass -> {
            ContainerUtilRt.addIfNotNull((Collection)result, (Object)psiClass.getQualifiedName());
            return true;
        };
        for (PsiClass contextClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)location.getPosition(), PsiClass.class, (boolean)false); contextClass != null; contextClass = contextClass.getContainingClass()) {
            InheritanceUtil.processSupers((PsiClass)contextClass, (boolean)true, (Processor)processor);
        }
        return result;
    });

    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            JavaInheritanceWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaInheritanceWeigher.$$$reportNull$$$0(1);
        }
        if (location.getPosition() == null || !(element instanceof PsiClass)) {
            return null;
        }
        if (JavaInheritanceWeigher.isTooGeneral((PsiClass)element)) {
            return Boolean.valueOf(false);
        }
        Set superClasses = (Set)PLACE_SUPER_CLASSES.getValue((UserDataHolder)location);
        if (superClasses.isEmpty()) {
            return Boolean.valueOf(false);
        }
        PsiElement position = location.getPosition();
        PsiClass placeClass = JavaInheritanceWeigher.findPlaceClass(element, position);
        if (placeClass == null) {
            return Boolean.valueOf(false);
        }
        for (PsiClass elementClass = placeClass; elementClass != null; elementClass = elementClass.getContainingClass()) {
            if (!superClasses.contains(elementClass.getQualifiedName())) continue;
            return Boolean.valueOf(true);
        }
        return Boolean.valueOf(false);
    }

    @Nullable
    private static PsiClass findPlaceClass(PsiElement element, PsiElement position) {
        PsiClass psiClass;
        PsiType type2;
        PsiExpression qualifierExpression2;
        if (position.getParent() instanceof PsiReferenceExpression && (qualifierExpression2 = ((PsiReferenceExpression)position.getParent()).getQualifierExpression()) != null && (type2 = qualifierExpression2.getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type2).resolve()) != null) {
            return psiClass;
        }
        return (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
    }

    private static boolean isTooGeneral(@Nullable PsiClass element) {
        if (element == null) {
            return true;
        }
        String qname = element.getQualifiedName();
        return qname == null || qname.startsWith("java.lang.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/JavaInheritanceWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

