/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.StubHierarchyIndexer;
import com.intellij.psi.stubsHierarchy.impl.HierarchyServiceImpl;
import com.intellij.psi.stubsHierarchy.impl.SerializedUnit;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class StubHierarchyIndex
extends FileBasedIndexExtension<Integer, SerializedUnit>
implements PsiDependentIndex {
    static final ID<Integer, SerializedUnit> INDEX_ID = ID.create((String)"jvm.hierarchy");

    @NotNull
    public ID<Integer, SerializedUnit> getName() {
        ID<Integer, SerializedUnit> iD = INDEX_ID;
        if (iD == null) {
            StubHierarchyIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, SerializedUnit, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            for (StubHierarchyIndexer indexer : StubHierarchyIndexer.EP_NAME.getExtensionList()) {
                VirtualFile file;
                IndexTree.Unit unit = indexer.handlesFile(file = inputData.getFile()) ? indexer.indexFile((FileContent)inputData) : null;
                if (unit == null || unit.myDecls.length <= 0) continue;
                int[] keys = file.getFileType().isBinary() ? HierarchyServiceImpl.BINARY_KEYS : HierarchyServiceImpl.SOURCE_KEYS;
                return Collections.singletonMap(keys[((VirtualFileWithId)file).getId() % keys.length], new SerializedUnit(unit));
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            StubHierarchyIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            StubHierarchyIndex.$$$reportNull$$$0(2);
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public DataExternalizer<SerializedUnit> getValueExternalizer() {
        DataExternalizer<SerializedUnit> dataExternalizer = new DataExternalizer<SerializedUnit>(){

            public void save(@NotNull DataOutput out, SerializedUnit value2) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                byte[] bytes = value2.getSerializedBytes();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)bytes.length);
                out.write(bytes);
            }

            public SerializedUnit read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                byte[] bytes = new byte[DataInputOutputUtil.readINT((DataInput)in)];
                in.readFully(bytes);
                return new SerializedUnit(bytes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            StubHierarchyIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return IndexTree.STUB_HIERARCHY_ENABLED ? 8 + StubHierarchyIndexer.EP_NAME.extensions().mapToInt(StubHierarchyIndexer::getVersion).sum() : 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file -> IndexTree.STUB_HIERARCHY_ENABLED && StubHierarchyIndexer.EP_NAME.extensions().anyMatch(indexer -> indexer.handlesFile(file)) && StubHierarchyIndex.isSourceOrLibrary(file);
        if (inputFilter == null) {
            StubHierarchyIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    private static boolean isSourceOrLibrary(VirtualFile file) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
            if (!index.isInLibraryClasses(file) && !index.isInSourceContent(file)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

