/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.HierarchyService;
import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import com.intellij.psi.stubsHierarchy.impl.SerializedUnit;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.StubEnter;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyIndex;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValueBase;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class HierarchyServiceImpl
extends HierarchyService {
    private static final SingleClassHierarchy EMPTY_HIERARCHY = new SingleClassHierarchy(Symbol.ClassSymbol.EMPTY_ARRAY, new AnchorRepository());
    private static final int KEY_COUNT = 20;
    static final int[] SOURCE_KEYS = IntStream.rangeClosed(-20, -1).toArray();
    static final int[] BINARY_KEYS = IntStream.rangeClosed(1, 20).toArray();
    private final Project myProject;
    private final CachedValue<SingleClassHierarchy> myHierarchy;

    public HierarchyServiceImpl(Project project) {
        this.myProject = project;
        this.myHierarchy = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.buildHierarchy(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public SingleClassHierarchy getHierarchy() {
        if (!IndexTree.STUB_HIERARCHY_ENABLED) {
            SingleClassHierarchy singleClassHierarchy = EMPTY_HIERARCHY;
            if (singleClassHierarchy != null) return singleClassHierarchy;
            HierarchyServiceImpl.$$$reportNull$$$0(0);
            return singleClassHierarchy;
        }
        CachedValue<SingleClassHierarchy> cachedValue = this.myHierarchy;
        // MONITORENTER : cachedValue
        SingleClassHierarchy singleClassHierarchy = (SingleClassHierarchy)this.myHierarchy.getValue();
        // MONITOREXIT : cachedValue
        if (singleClassHierarchy != null) return singleClassHierarchy;
        HierarchyServiceImpl.$$$reportNull$$$0(1);
        return singleClassHierarchy;
    }

    @Override
    public void clearHierarchy() {
        ((CachedValueBase)this.myHierarchy).clear();
    }

    private SingleClassHierarchy buildHierarchy() {
        Symbols symbols = new Symbols();
        StubEnter stubEnter = new StubEnter(symbols);
        IdSets idSets = IdSets.getIdSets(this.myProject);
        this.loadUnits(idSets.libraryFiles, BINARY_KEYS, stubEnter);
        stubEnter.connect1();
        this.loadUnits(idSets.sourceFiles, SOURCE_KEYS, stubEnter);
        stubEnter.connect2();
        return symbols.createHierarchy();
    }

    private void loadUnits(final BitSet files, int[] indexKeys, final StubEnter stubEnter) {
        FileBasedIndexImpl.IdValueProcessor<SerializedUnit> processor = new FileBasedIndexImpl.IdValueProcessor<SerializedUnit>(){
            final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            int count = 0;

            public boolean process(int fileId, SerializedUnit unit) {
                if (this.indicator != null && ++this.count % 128 == 0) {
                    this.indicator.checkCanceled();
                }
                if (files.get(fileId)) {
                    unit.readUnit(stubEnter, fileId);
                }
                return true;
            }
        };
        for (int indexKey : indexKeys) {
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).processAllValues(StubHierarchyIndex.INDEX_ID, (Object)indexKey, this.myProject, (FileBasedIndexImpl.IdValueProcessor)processor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/HierarchyServiceImpl", "getHierarchy"));
    }

    private static class IdSets {
        final BitSet sourceFiles = new BitSet();
        final BitSet libraryFiles = new BitSet();

        private IdSets() {
        }

        static IdSets getIdSets(@NotNull Project project) {
            if (project == null) {
                IdSets.$$$reportNull$$$0(0);
            }
            return (IdSets)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
                IdSets answer = new IdSets();
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                FileBasedIndex.getInstance().iterateIndexableFiles(file -> {
                    if (!file.isDirectory() && file instanceof VirtualFileWithId) {
                        if (index.isInSourceContent(file)) {
                            answer.sourceFiles.set(((VirtualFileWithId)file).getId());
                        } else if (index.isInLibraryClasses(file)) {
                            answer.libraryFiles.set(((VirtualFileWithId)file).getId());
                        }
                    }
                    return true;
                }, project, ProgressIndicatorProvider.getGlobalProgressIndicator());
                return CachedValueProvider.Result.create((Object)answer, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubsHierarchy/impl/HierarchyServiceImpl$IdSets", "getIdSets"));
        }
    }
}

