/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceExpressionImpl
extends ExpressionPsiElement
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl");
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private static final Function<PsiReferenceExpressionImpl, PsiType> TYPE_EVALUATOR = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        String qualifiedName;
        if (qualifierClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((qualifiedName = qualifierClass.getQualifiedName()) == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile).getImportList();
            assert (importList != null) : containingFile;
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManagerEx manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            LeafElement dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)manager);
            this.addInternal((TreeElement)dot, (ASTNode)dot, SourceTreeToPsiMap.psiElementToTree((PsiElement)this.getParameterList()), Boolean.TRUE);
            this.addBefore((PsiElement)classRef, SourceTreeToPsiMap.treeElementToPsi((ASTNode)dot));
        }
        return this;
    }

    public static void bindToElementViaStaticImport(PsiClass qualifierClass, String staticName, PsiImportList importList) throws IncorrectOperationException {
        assert (importList != null);
        String qualifiedName = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName);
        JavaCodeStyleSettingsFacade javaCodeStyleSettingsFacade = JavaCodeStyleSettingsFacade.getInstance((Project)qualifierClass.getProject());
        if (!javaCodeStyleSettingsFacade.isToImportInDemand(qualifiedName) && refs.size() + 1 < javaCodeStyleSettingsFacade.getNamesCountToUseImportOnDemand() || JavaCodeStyleManager.getInstance((Project)qualifierClass.getProject()).hasConflictingOnDemandImport((PsiJavaFile)importList.getContainingFile(), qualifierClass, staticName)) {
            importList.add((PsiElement)JavaPsiFacade.getElementFactory((Project)qualifierClass.getProject()).createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add((PsiElement)JavaPsiFacade.getElementFactory((Project)qualifierClass.getProject()).createImportStaticStatement(qualifierClass, "*"));
        }
    }

    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className) {
        if (importList == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual((String)psiClass.getQualifiedName(), (String)className)) continue;
            array.add(staticStatement.getImportReference());
        }
        return array;
    }

    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else if (oldQualifier != null) {
            oldQualifier.replace((PsiElement)newQualifier);
        } else {
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            TreeElement dot = (TreeElement)this.findChildByRole(55);
            if (dot == null) {
                dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                dot = this.addInternal(dot, (ASTNode)dot, (ASTNode)this.getFirstChildNode(), Boolean.TRUE);
            }
            this.addBefore((PsiElement)newQualifier, dot.getPsi());
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element != null ? element.getText() : null;
    }

    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
        super.clearCaches();
    }

    @NotNull
    private JavaResolveResult[] resolve(IElementType parentType, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            PsiElement classNameElement;
            JavaResolveResult[] variable = null;
            JavaResolveResult[] result = this.resolveToVariable(containingFile);
            if (result.length == 1) {
                if (result[0].isAccessible()) {
                    if (result == null) {
                        PsiReferenceExpressionImpl.$$$reportNull$$$0(3);
                    }
                    return result;
                }
                variable = result;
            }
            if (!((classNameElement = this.getReferenceNameElement()) instanceof PsiIdentifier)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(4);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result = this.resolveToClass(classNameElement, containingFile);
            if (result.length == 1 && !result[0].isAccessible()) {
                JavaResolveResult[] packageResult = this.resolveToPackage(containingFile);
                if (packageResult.length != 0) {
                    result = packageResult;
                }
            } else if (result.length == 0) {
                result = this.resolveToPackage(containingFile);
            }
            if (result.length == 0 && variable == null) {
                result = PsiJavaCodeReferenceElementImpl.tryClassResult(this.getCachedNormalizedText(), (PsiJavaCodeReferenceElement)this);
            }
            JavaResolveResult[] javaResolveResultArray = result.length == 0 && variable != null ? variable : result;
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(5);
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            JavaResolveResult[] javaResolveResultArray = this.resolveToMethod(containingFile);
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(6);
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.METHOD_REF_EXPRESSION) {
            if (((PsiMethodReferenceExpression)this.getParent()).isConstructor()) {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (classNameElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiReferenceExpressionImpl.$$$reportNull$$$0(7);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                JavaResolveResult[] javaResolveResultArray = this.resolveToClass(classNameElement, containingFile);
                if (javaResolveResultArray == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(8);
                }
                return javaResolveResultArray;
            }
            JavaResolveResult[] javaResolveResultArray = this.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(9);
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.BREAK_STATEMENT && this.getQualifierExpression() == null) {
            PsiElement breakStatement = this.getParent();
            Object[] labels2 = JavaResolveResult.EMPTY_ARRAY;
            PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement(breakStatement, this.getText());
            if (labeled != null) {
                labels2 = new JavaResolveResult[]{new CandidateInfo((PsiElement)labeled, PsiSubstitutor.EMPTY)};
            }
            boolean insideSwitchExpression = false;
            PsiElement context = breakStatement;
            while ((context = PsiImplUtil.findEnclosingSwitchOrLoop(context.getParent())) != null) {
                if (!(context instanceof PsiSwitchExpression)) continue;
                insideSwitchExpression = true;
                break;
            }
            if (!insideSwitchExpression) {
                if (labels2 == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(10);
                }
                return labels2;
            }
            if (labels2.length > 0) {
                Object[] vars = this.resolveToVariable(containingFile);
                JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])ArrayUtil.mergeArrays((Object[])labels2, (Object[])vars);
                if (javaResolveResultArray == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(11);
                }
                return javaResolveResultArray;
            }
        }
        JavaResolveResult[] javaResolveResultArray = this.resolveToVariable(containingFile);
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToMethod(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor = new MethodResolverProcessor(methodCall, containingFile);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, (PsiCallExpression)methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(14);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(15);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToPackage(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(16);
        }
        String packageName = this.getCachedNormalizedText();
        Project project = containingFile.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage aPackage = psiFacade.findPackage(packageName);
        if (aPackage == null) {
            JavaResolveResult[] javaResolveResultArray = psiFacade.isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(17);
            }
            return javaResolveResultArray;
        }
        PsiExpression qualifier = this.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(18);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY, (PsiElement)this, false)};
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(19);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToClass(@NotNull PsiElement classNameElement, @NotNull PsiFile containingFile) {
        if (classNameElement == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(20);
        }
        if (containingFile == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, (PsiElement)this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        return javaResolveResultArray;
    }

    @NotNull
    private JavaResolveResult[] resolveToVariable(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(23);
        }
        VariableResolverProcessor processor = new VariableResolverProcessor((PsiJavaCodeReferenceElement)this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, (PsiJavaCodeReferenceElement)this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(24);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(25);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String fqn;
        PsiElement element = this.resolve();
        if (element instanceof PsiClass && (fqn = ((PsiClass)element).getQualifiedName()) != null) {
            String string = fqn;
            if (string == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = this.getCachedNormalizedText();
        if (string == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, TYPE_EVALUATOR);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiElement parent;
        boolean parentIsMethodCall;
        if (element == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(28);
        }
        IElementType i = this.getLastChildNode().getElementType();
        boolean resolvingToMethod = element instanceof PsiMethod;
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element instanceof PsiPackage)) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                String name = ((PsiNamedElement)element).getName();
                if (name == null) {
                    return false;
                }
                if (!name.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!resolvingToMethod) {
                return false;
            }
            if (!((PsiMethod)element).isConstructor()) {
                return false;
            }
        }
        if ((parentIsMethodCall = (parent = this.getParent()) instanceof PsiMethodCallExpression) != resolvingToMethod) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.advancedResolve(true).getElement());
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(29);
        }
        DelegatingScopeProcessor filterProcessor = new DelegatingScopeProcessor(processor){
            private PsiElement myResolveContext;
            private final Set<String> myVarNames;
            {
                this.myVarNames = new THashSet();
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !this.shouldProcess(element) || super.execute(element, state);
            }

            private boolean shouldProcess(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (element instanceof PsiVariable) {
                    return this.ensureNonShadowedVariable((PsiVariable)element);
                }
                if (element instanceof PsiClass) {
                    return !PsiReferenceExpressionImpl.seemsScrambled((PsiClass)element);
                }
                if (element instanceof PsiPackage) {
                    return PsiReferenceExpressionImpl.this.isQualified();
                }
                if (element instanceof PsiMethod) {
                    return this.shouldProcessMethod((PsiMethod)element);
                }
                return false;
            }

            private boolean ensureNonShadowedVariable(@NotNull PsiVariable element) {
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                    this.myVarNames.add(element.getName());
                }
                return !(element instanceof PsiField) || !this.myVarNames.contains(element.getName());
            }

            private boolean shouldProcessMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(4);
                }
                PsiReferenceExpressionImpl ref = PsiReferenceExpressionImpl.this;
                return !method.isConstructor() && PsiReferenceExpressionImpl.hasValidQualifier(method, ref, this.myResolveContext);
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
                    this.myResolveContext = (PsiElement)associated;
                }
                super.handleEvent(event, associated);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldProcess";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ensureNonShadowedVariable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldProcessMethod";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiScopesUtil.resolveAndWalk((PsiScopeProcessor)filterProcessor, (PsiJavaCodeReferenceElement)this, null, true);
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(30);
        }
        return javaResolveResult;
    }

    private static boolean hasValidQualifier(PsiMethod method, PsiReferenceExpression ref, PsiElement scope) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!PsiUtil.getLanguageLevel((PsiElement)ref).isAtLeast(LanguageLevel.JDK_1_8)) {
                return false;
            }
            PsiExpression qualifierExpression2 = ref.getQualifierExpression();
            if (qualifierExpression2 == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
                return true;
            }
            if (qualifierExpression2 instanceof PsiReferenceExpression) {
                PsiElement resolve = ((PsiReferenceExpression)qualifierExpression2).resolve();
                if (containingClass.getManager().areElementsEquivalent(resolve, (PsiElement)containingClass)) {
                    return true;
                }
                if (resolve instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve).getExtendsListTypes()) {
                        PsiClass aClass = type2.resolve();
                        if (aClass == null) continue;
                        classes2.add(aClass);
                    }
                    if (classes2.size() == 1 && classes2.contains(containingClass)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean seemsScrambled(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement && PsiReferenceExpressionImpl.seemsScrambledByStructure(aClass);
    }

    @VisibleForTesting
    public static boolean seemsScrambledByStructure(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(31);
        }
        if ((containingClass = aClass.getContainingClass()) != null && !PsiReferenceExpressionImpl.seemsScrambledByStructure(containingClass)) {
            return false;
        }
        if (PsiReferenceExpressionImpl.seemsScrambled(aClass.getName())) {
            List methods = ContainerUtil.filter((Object[])aClass.getMethods(), method -> !method.hasModifierProperty("private"));
            return !methods.isEmpty() && ContainerUtil.and((Iterable)methods, method -> PsiReferenceExpressionImpl.seemsScrambled(method.getName()));
        }
        return false;
    }

    private static boolean seemsScrambled(String name) {
        return name != null && !name.isEmpty() && name.length() <= 2;
    }

    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)PsiTreeUtil.getChildOfType((PsiElement)this, PsiReferenceParameterList.class);
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList != null ? parameterList.getTypeArguments() : PsiType.EMPTY_ARRAY;
        if (psiTypeArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(32);
        }
        return psiTypeArray;
    }

    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(33);
        }
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiReferenceExpression expression2 = (PsiReferenceExpression)factory.createExpressionFromText("X." + newElementName, (PsiElement)this);
        PsiReferenceExpression result = (PsiReferenceExpression)this.replace((PsiElement)expression2);
        ((PsiReferenceExpression)result.getQualifierExpression()).bindToElement((PsiElement)psiClass);
        return result;
    }

    private PsiElement renameDirectly(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || Comparing.strEqual((String)oldRefName, (String)newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(34);
        }
        CheckUtil.checkWritable((PsiElement)this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        PsiManagerEx manager = this.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiJavaParserFacade parserFacade = facade.getParserFacade();
        if (element instanceof PsiClass) {
            boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance((Project)this.getProject()).useFQClassNames() && PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)this);
            String qName = ((PsiClass)element).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element).getName();
            } else {
                if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                    return this;
                }
                if (facade.getResolveHelper().resolveReferencedClass(qName, (PsiElement)this) == null && facade.getResolveHelper().resolveReferencedClass(StringUtil.getPackageName((String)qName), (PsiElement)this) != null) {
                    qName = ((PsiClass)element).getName();
                    assert (qName != null) : element;
                }
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
            if (!preserveQualification) {
                ref = (PsiExpression)codeStyleManager.shortenClassReferences((PsiElement)ref, 8192);
            }
            return ref;
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            if (qName.isEmpty()) {
                throw new IncorrectOperationException();
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            return ref;
        }
        if ((element instanceof PsiField || element instanceof PsiMethod) && ((PsiMember)element).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            return ref;
        }
        throw new IncorrectOperationException(element.toString());
    }

    private static boolean isFullyQualified(CompositeElement classRef) {
        ASTNode qualifier = classRef.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        if (qualifier.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
            return false;
        }
        PsiElement refElement = ((PsiReference)qualifier).resolve();
        return refElement instanceof PsiPackage || PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)qualifier);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(35);
        }
        if (this.getChildRole(child) == 54) {
            ASTNode start;
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            TreeElement first = this.getFirstChildNode();
            if (this.getChildRole((ASTNode)first) == 246 && first.getFirstChildNode() == null && PsiImplUtil.isWhitespaceOrComment(start = first.getTreeNext())) {
                ASTNode next = PsiImplUtil.skipWhitespaceAndComments(start);
                assert (next != null) : this;
                CodeEditUtil.removeChildren((ASTNode)this, (ASTNode)start, (ASTNode)next.getTreePrev());
            }
        } else if (child.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
            this.replaceChildInternal(child, PsiReferenceExpressionImpl.createEmptyRefParameterList(this.getProject()));
        } else {
            super.deleteChildInternal(child);
        }
    }

    public static TreeElement createEmptyRefParameterList(Project project) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        return (TreeElement)Objects.requireNonNull(factory.createReferenceFromText("foo", null).getParameterList()).getNode();
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                TreeElement lastChild = this.getLastChildNode();
                return this.getChildRole((ASTNode)lastChild) == role ? lastChild : this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                return this.getChildRole((ASTNode)firstChild) == 54 ? firstChild : null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(36);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    public PsiReference getReference() {
        return this.getReferenceNameElement() != null ? this : null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(37);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceExpression((PsiReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiElement getElement() {
        PsiReferenceExpressionImpl psiReferenceExpressionImpl = this;
        if (psiReferenceExpressionImpl == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(38);
        }
        return psiReferenceExpressionImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
        if (textRange == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(39);
        }
        return textRange;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getCachedNormalizedText(), (boolean)false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(40);
        }
        JavaSourceUtil.fullyQualifyReference((CompositeElement)this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole((ASTNode)this.getFirstChildNode()) == 54;
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @NotNull
    private String getCachedNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText((PsiJavaCodeReferenceElement)this);
        }
        String string = whiteSpaceAndComments;
        if (string == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(41);
        }
        return string;
    }

    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 2: 
            case 13: 
            case 16: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameElement";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToMethod";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToPackage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToClass";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToVariable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedNormalizedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getImportsFromClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveToMethod";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveToPackage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveToClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveToVariable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "seemsScrambledByStructure";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fullyQualify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeEvaluator
    implements NullableFunction<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        public PsiType fun(PsiReferenceExpressionImpl expr) {
            PsiElement resolve;
            PsiFile file = expr.getContainingFile();
            Project project = file.getProject();
            ResolveResult[] results = ResolveCache.getInstance((Project)project).resolveWithCaching((PsiPolyVariantReference)expr, (ResolveCache.PolyVariantContextResolver)OurGenericsResolver.INSTANCE, true, false, file);
            JavaResolveResult result = results.length == 1 ? (JavaResolveResult)results[0] : null;
            PsiElement psiElement = resolve = result == null ? null : result.getElement();
            if (resolve == null) {
                PsiType type2;
                ASTNode qualifier;
                ASTNode refName = expr.findChildByRole(53);
                if (refName != null && "length".equals(refName.getText()) && (qualifier = expr.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getElementType()) && (type2 = ((PsiExpression)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)qualifier)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            PsiMethod owner = null;
            PsiType ret = null;
            if (resolve instanceof PsiVariable) {
                PsiType type3 = ((PsiVariable)resolve).getType();
                PsiType psiType = ret = type3 instanceof PsiEllipsisType ? ((PsiEllipsisType)type3).toArrayType() : type3;
                if (ret != null && !ret.isValid()) {
                    PsiUtil.ensureValidType((PsiType)ret, (String)("invalid type of " + resolve + " of class " + resolve.getClass() + ", valid=" + resolve.isValid()));
                }
                if (resolve instanceof PsiField && !((PsiField)resolve).hasModifierProperty("static")) {
                    owner = ((PsiField)resolve).getContainingClass();
                }
            } else if (resolve instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve;
                ret = method.getReturnType();
                if (ret != null) {
                    PsiUtil.ensureValidType((PsiType)ret);
                }
                owner = method;
            }
            if (ret == null) {
                return null;
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (owner == null || !PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)substitutor)) {
                    PsiType substitutedType = substitutor.substitute(ret);
                    PsiUtil.ensureValidType((PsiType)substitutedType);
                    PsiType normalized = PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, (PsiExpression)expr);
                    PsiUtil.ensureValidType((PsiType)normalized);
                    return PsiClassImplUtil.correctType(normalized, expr.getResolveScope());
                }
            }
            return PsiClassImplUtil.correctType(TypeConversionUtil.erasure((PsiType)ret), expr.getResolveScope());
        }
    }

    public static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        public static final OurGenericsResolver INSTANCE = new OurGenericsResolver();
        private static final TokenSet EXACT_REFS = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.REFERENCE_EXPRESSION, JavaElementType.BREAK_STATEMENT});

        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            PsiReferenceExpressionImpl expression2;
            CompositeElement treeParent;
            if (ref == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                OurGenericsResolver.$$$reportNull$$$0(1);
            }
            IElementType parentType = (treeParent = (expression2 = (PsiReferenceExpressionImpl)ref).getTreeParent()) == null ? null : treeParent.getElementType();
            List<ResolveResult[]> qualifiers = OurGenericsResolver.resolveAllQualifiers(expression2, containingFile);
            JavaResolveResult[] result = expression2.resolve(parentType, containingFile);
            if (result.length == 0 && incompleteCode && !EXACT_REFS.contains(parentType)) {
                result = expression2.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
            }
            JavaResolveUtil.substituteResults((PsiJavaCodeReferenceElement)expression2, result);
            qualifiers.clear();
            if (result == null) {
                OurGenericsResolver.$$$reportNull$$$0(2);
            }
            return result;
        }

        @NotNull
        private static List<ResolveResult[]> resolveAllQualifiers(@NotNull PsiReferenceExpressionImpl expression2, @NotNull PsiFile containingFile) {
            PsiElement qualifier;
            if (expression2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(3);
            }
            if (containingFile == null) {
                OurGenericsResolver.$$$reportNull$$$0(4);
            }
            if ((qualifier = expression2.getQualifier()) == null) {
                List<ResolveResult[]> list = Collections.emptyList();
                if (list == null) {
                    OurGenericsResolver.$$$reportNull$$$0(5);
                }
                return list;
            }
            SmartList qualifiers = new SmartList();
            final ResolveCache resolveCache = ResolveCache.getInstance((Project)containingFile.getProject());
            final boolean physical = containingFile.isPhysical();
            qualifier.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)qualifiers, containingFile){
                final /* synthetic */ List val$qualifiers;
                final /* synthetic */ PsiFile val$containingFile;
                {
                    this.val$qualifiers = list;
                    this.val$containingFile = psiFile;
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    if (!(expression2 instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    ResolveResult[] cachedResults = resolveCache.getCachedResults((PsiPolyVariantReference)expression2, physical, false, true);
                    if (cachedResults != null) {
                        return;
                    }
                    this.visitElement((PsiElement)expression2);
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(element instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)element;
                    this.val$qualifiers.add(resolveCache.resolveWithCaching((PsiPolyVariantReference)expression2, (ResolveCache.PolyVariantContextResolver)INSTANCE, false, false, this.val$containingFile));
                }

                public void visitExpressionList(PsiExpressionList list) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                public void visitClass(PsiClass aClass) {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver$1", "elementFinished"));
                }
            });
            SmartList smartList = qualifiers;
            if (smartList == null) {
                OurGenericsResolver.$$$reportNull$$$0(6);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveAllQualifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveAllQualifiers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

