/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCodeBlockImpl
extends LazyParseablePsiElement
implements PsiCodeBlock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiCodeBlockImpl");
    private volatile Set<String> myVariablesSet;
    private volatile Set<String> myClassesSet;
    private volatile boolean myConflict;

    public PsiCodeBlockImpl(CharSequence text2) {
        super((IElementType)JavaElementType.CODE_BLOCK, text2);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myVariablesSet = null;
        this.myClassesSet = null;
        this.myConflict = false;
    }

    @NotNull
    public PsiStatement[] getStatements() {
        PsiStatement[] psiStatementArray = PsiImplUtil.getChildStatements((CompositeElement)this);
        if (psiStatementArray == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(0);
        }
        return psiStatementArray;
    }

    public int getStatementCount() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return false;
        }
        return true;
    }

    public PsiElement getFirstBodyElement() {
        PsiJavaToken lBrace = this.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == this.getRBrace() ? null : nextSibling;
    }

    public PsiElement getLastBodyElement() {
        PsiJavaToken rBrace = this.getRBrace();
        if (rBrace != null) {
            PsiElement prevSibling = rBrace.getPrevSibling();
            return prevSibling == this.getLBrace() ? null : prevSibling;
        }
        return this.getLastChild();
    }

    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(18);
    }

    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(19);
    }

    @Nullable
    private Couple<Set<String>> buildMaps() {
        THashSet set1 = this.myClassesSet;
        THashSet set2 = this.myVariablesSet;
        boolean wasConflict = this.myConflict;
        if (set1 == null || set2 == null) {
            THashSet localsSet = new THashSet();
            THashSet classesSet = new THashSet();
            Ref conflict = new Ref((Object)Boolean.FALSE);
            PsiScopesUtil.walkChildrenScopes((PsiElement)this, new PsiScopeProcessor((Set)localsSet, conflict, (Set)classesSet){
                final /* synthetic */ Set val$localsSet;
                final /* synthetic */ Ref val$conflict;
                final /* synthetic */ Set val$classesSet;
                {
                    this.val$localsSet = set;
                    this.val$conflict = ref;
                    this.val$classesSet = set2;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    PsiClass psiClass;
                    String name;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof PsiLocalVariable) {
                        PsiLocalVariable variable = (PsiLocalVariable)element;
                        String name2 = variable.getName();
                        if (!this.val$localsSet.add(name2)) {
                            this.val$conflict.set((Object)Boolean.TRUE);
                            this.val$localsSet.clear();
                            this.val$classesSet.clear();
                        }
                    } else if (element instanceof PsiClass && !this.val$classesSet.add(name = (psiClass = (PsiClass)element).getName())) {
                        this.val$conflict.set((Object)Boolean.TRUE);
                        this.val$localsSet.clear();
                        this.val$classesSet.clear();
                    }
                    return (Boolean)this.val$conflict.get() == false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, ResolveState.initial(), (PsiElement)this, (PsiElement)this);
            set1 = classesSet.isEmpty() ? Collections.emptySet() : classesSet;
            this.myClassesSet = set1;
            set2 = localsSet.isEmpty() ? Collections.emptySet() : localsSet;
            this.myVariablesSet = set2;
            this.myConflict = wasConflict = ((Boolean)conflict.get()).booleanValue();
        }
        return wasConflict ? null : Couple.of(set1, set2);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        block6: {
            block5: {
                if (anchor == null) {
                    if (before == null || before.booleanValue()) {
                        anchor = this.findChildByRole(19);
                        before = Boolean.TRUE;
                    } else {
                        anchor = this.findChildByRole(18);
                        before = Boolean.FALSE;
                    }
                }
                if (before != Boolean.TRUE) break block5;
                while (anchor != null && PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                    anchor = anchor.getTreePrev();
                    before = Boolean.FALSE;
                }
                break block6;
            }
            if (before != Boolean.FALSE) break block6;
            while (anchor != null && PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                anchor = anchor.getTreeNext();
                before = Boolean.TRUE;
            }
        }
        return super.addInternal(first, last, anchor, before);
    }

    private static boolean isNonJavaStatement(ASTNode anchor) {
        PsiElement psi = anchor.getPsi();
        return psi instanceof PsiStatement && psi.getLanguage() != JavaLanguage.INSTANCE;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.RBRACE);
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == JavaTokenType.RBRACE) {
            return this.getChildRole(child, 19);
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCodeBlock((PsiCodeBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiCodeBlock";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            PsiCodeBlockImpl.$$$reportNull$$$0(5);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        Couple<Set<String>> pair = this.buildMaps();
        boolean conflict = pair == null;
        Set classesSet = conflict ? null : (Set)pair.getFirst();
        Set variablesSet = conflict ? null : (Set)pair.getSecond();
        NameHint hint = (NameHint)processor.getHint(NameHint.KEY);
        if (hint != null && !conflict) {
            ElementClassHint elementClassHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
            String name = hint.getName(state);
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && classesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor, state, lastParent, place);
            }
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) && variablesSet.contains(name)) {
                return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor, state, lastParent, place);
            }
        } else {
            return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor, state, lastParent, place);
        }
        return true;
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        PsiElement parent = this.getParent();
        return !(parent instanceof PsiMethod) && !(parent instanceof PsiClassInitializer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiCodeBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

