/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.changesHandler.BaseInjectedFileChangesHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JavaInjectedFileChangesHandler
extends BaseInjectedFileChangesHandler {
    @NotNull
    private final RangeMarker myAltFullRange;

    JavaInjectedFileChangesHandler(List<PsiLanguageInjectionHost.Shred> shreds, Editor editor, Document newDocument, PsiFile injectedFile) {
        super(editor, newDocument, injectedFile);
        PsiLanguageInjectionHost.Shred firstShred = (PsiLanguageInjectionHost.Shred)ContainerUtil.getFirstItem(shreds);
        PsiLanguageInjectionHost.Shred lastShred = (PsiLanguageInjectionHost.Shred)ContainerUtil.getLastItem(shreds);
        this.myAltFullRange = this.myOrigDocument.createRangeMarker(firstShred.getHostRangeMarker().getStartOffset(), lastShred.getHostRangeMarker().getEndOffset());
        this.myAltFullRange.setGreedyToLeft(true);
        this.myAltFullRange.setGreedyToRight(true);
    }

    public boolean isValid() {
        return this.myAltFullRange.isValid();
    }

    public void commitToOriginal(@NotNull DocumentEvent e) {
        DocumentWindow documentWindow;
        if (e == null) {
            JavaInjectedFileChangesHandler.$$$reportNull$$$0(0);
        }
        PsiFile origPsiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myOrigDocument);
        String newText = this.myNewDocument.getText();
        LinkedHashMap replacementMap = new LinkedHashMap();
        int count = 0;
        for (Object o : ContainerUtil.reverse((List)((DocumentEx)this.myNewDocument).getGuardedBlocks())) {
            String replacement = (String)o.getUserData(QuickEditHandler.REPLACEMENT_KEY);
            String tempText = "REPLACE" + count++ + Long.toHexString(StringHash.calc((String)replacement));
            newText = newText.substring(0, o.getStartOffset()) + tempText + newText.substring(o.getEndOffset());
            replacementMap.put((Object)tempText, (Object)replacement);
        }
        int hostStartOffset = this.myAltFullRange.getStartOffset();
        this.myEditor.getCaretModel().moveToOffset(hostStartOffset);
        for (CopyPastePreProcessor preProcessor : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            newText = preProcessor.preprocessOnPaste(this.myProject, origPsiFile, this.myEditor, newText, null);
        }
        this.myOrigDocument.replaceString(hostStartOffset, this.myAltFullRange.getEndOffset(), (CharSequence)newText);
        for (String tempText : replacementMap.keySet()) {
            int idx = CharArrayUtil.indexOf((CharSequence)this.myOrigDocument.getCharsSequence(), (CharSequence)tempText, (int)hostStartOffset, (int)this.myAltFullRange.getEndOffset());
            this.myOrigDocument.replaceString(idx, idx + tempText.length(), (CharSequence)replacementMap.get((Object)tempText));
        }
        JavaInjectedFileChangesHandler.fixDocumentQuotes(this.myOrigDocument, hostStartOffset - 1);
        JavaInjectedFileChangesHandler.fixDocumentQuotes(this.myOrigDocument, this.myAltFullRange.getEndOffset());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myOrigDocument);
        try {
            CodeStyleManager.getInstance((Project)this.myProject).reformatRange((PsiElement)origPsiFile, hostStartOffset, this.myAltFullRange.getEndOffset(), true);
        }
        catch (IncorrectOperationException o) {
            // empty catch block
        }
        PsiElement newInjected = InjectedLanguageManager.getInstance((Project)this.myProject).findInjectedElementAt(origPsiFile, hostStartOffset);
        DocumentWindow documentWindow2 = documentWindow = newInjected == null ? null : InjectedLanguageUtil.getDocumentWindow((PsiElement)newInjected);
        if (documentWindow != null) {
            this.myEditor.getCaretModel().moveToOffset(documentWindow.injectedToHost(e.getOffset()));
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    public boolean tryReuse(@NotNull PsiFile newInjectedFile, @NotNull TextRange newHostRange) {
        DocumentWindow documentWindow;
        if (newInjectedFile == null) {
            JavaInjectedFileChangesHandler.$$$reportNull$$$0(1);
        }
        if (newHostRange == null) {
            JavaInjectedFileChangesHandler.$$$reportNull$$$0(2);
        }
        if ((documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)newInjectedFile)) == null || documentWindow.getDelegate() != this.myAltFullRange.getDocument()) {
            return false;
        }
        return super.tryReuse(newInjectedFile, newHostRange);
    }

    public boolean handlesRange(@NotNull TextRange hostRange) {
        if (hostRange == null) {
            JavaInjectedFileChangesHandler.$$$reportNull$$$0(3);
        }
        return hostRange.intersects(this.myAltFullRange.getStartOffset(), this.myAltFullRange.getEndOffset());
    }

    private static void fixDocumentQuotes(Document doc, int offset) {
        if (doc.getCharsSequence().charAt(offset) == '\'') {
            doc.replaceString(offset, offset + 1, (CharSequence)"\"");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInjectedFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHostRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/JavaInjectedFileChangesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "commitToOriginal";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryReuse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handlesRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

