/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodHandleCompletionContributor
extends CompletionContributor {
    private static final Set<String> METHOD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findConstructor", "findVirtual", "findStatic", "findSpecial"});
    private static final PsiJavaElementPattern.Capture<PsiElement> METHOD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(1, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findConstructor")), PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findVirtual", "findStatic", "findSpecial"))}));
    private static final Set<String> FIELD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findGetter", "findSetter", "findStaticGetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle"});
    private static final PsiJavaElementPattern.Capture<PsiElement> FIELD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern(ArrayUtil.toStringArray(FIELD_HANDLE_FACTORY_NAMES))));

    @NotNull
    private static PsiMethodPattern methodPattern(String ... methodNames) {
        PsiMethodPattern psiMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodNames)).definedInClass("java.lang.invoke.MethodHandles.Lookup");
        if (psiMethodPattern == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(0);
        }
        return psiMethodPattern;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement position;
        if (parameters2 == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(1);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!JavaCompletionContributor.isInJavaContext(position = parameters2.getPosition())) {
            return;
        }
        if (METHOD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addMethodHandleVariants(position, (Consumer<? super LookupElement>)result);
        } else if (FIELD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addFieldHandleVariants(position, (Consumer<? super LookupElement>)result);
        }
    }

    private static void addMethodHandleVariants(@NotNull PsiElement position, @NotNull Consumer<? super LookupElement> result) {
        String methodName;
        PsiMethodCallExpression methodCall;
        if (position == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class)) != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && METHOD_HANDLE_FACTORY_NAMES.contains(methodName)) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            JavaReflectionReferenceUtil.ReflectiveClass reflectiveClass = ownerClass = arguments.length != 0 ? JavaReflectionReferenceUtil.getReflectiveClass(arguments[0]) : null;
            if (ownerClass != null) {
                switch (methodName) {
                    case "findConstructor": {
                        JavaMethodHandleCompletionContributor.addConstructorSignatures(ownerClass, position, result);
                        break;
                    }
                    case "findVirtual": 
                    case "findStatic": 
                    case "findSpecial": {
                        String name;
                        String string = name = arguments.length > 1 ? JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class) : null;
                        if (StringUtil.isEmpty(name)) break;
                        JavaMethodHandleCompletionContributor.addMethodSignatures(ownerClass, name, "findStatic".equals(methodName), position, result);
                    }
                }
            }
        }
    }

    private static void addConstructorSignatures(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiMethod[] constructors;
        if (ownerClass == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(7);
        }
        if ((constructors = ownerClass.getPsiClass().getConstructors()).length != 0) {
            JavaMethodHandleCompletionContributor.lookupMethodTypes(Arrays.stream(constructors), context, result);
        } else {
            result.consume((Object)JavaMethodHandleCompletionContributor.lookupSignature(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE, context));
        }
    }

    private static void addMethodSignatures(@NotNull JavaReflectionReferenceUtil.ReflectiveClass psiClass, @NotNull String methodName, boolean isStaticExpected, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiMethod[] methods;
        if (psiClass == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(10);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(11);
        }
        if ((methods = psiClass.getPsiClass().findMethodsByName(methodName, false)).length != 0) {
            Stream<PsiMethod> methodStream = Arrays.stream(methods).filter(method -> method.hasModifierProperty("static") == isStaticExpected);
            JavaMethodHandleCompletionContributor.lookupMethodTypes(methodStream, context, result);
        }
    }

    private static void lookupMethodTypes(@NotNull Stream<? extends PsiMethod> methods, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        if (methods == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(13);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(14);
        }
        methods.map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> JavaMethodHandleCompletionContributor.lookupSignature(signature, context)).forEach(arg_0 -> result.consume(arg_0));
    }

    @NotNull
    private static LookupElement lookupSignature(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature, @NotNull PsiElement context) {
        if (signature == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(16);
        }
        String expressionText = JavaReflectionReferenceUtil.getMethodTypeExpressionText(signature);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiExpression expression2 = factory.createExpressionFromText(expressionText, context);
        String shortTypes = signature.getText(true, type2 -> PsiNameHelper.getShortClassName((String)type2) + ".class");
        String presentableText = PsiNameHelper.getShortClassName((String)"java.lang.invoke.MethodType") + "." + "methodType" + shortTypes;
        String lookupText = "methodType" + signature.getText(true, PsiNameHelper::getShortClassName);
        LookupElement lookupElement = JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.METHOD_ICON, presentableText, lookupText);
        if (lookupElement == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(17);
        }
        return lookupElement;
    }

    private static void addFieldHandleVariants(@NotNull PsiElement position, @NotNull Consumer<? super LookupElement> result) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String fieldName;
        PsiExpression[] arguments;
        String methodName;
        PsiMethodCallExpression methodCall;
        if (position == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(18);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(19);
        }
        if ((methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class)) != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && FIELD_HANDLE_FACTORY_NAMES.contains(methodName) && (arguments = methodCall.getArgumentList().getExpressions()).length > 2 && !StringUtil.isEmpty((String)(fieldName = JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class))) && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null) {
            JavaMethodHandleCompletionContributor.addFieldType(ownerClass, fieldName, position, result);
        }
    }

    private static void addFieldType(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String fieldName, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiField field;
        if (ownerClass == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(20);
        }
        if (fieldName == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(21);
        }
        if (context == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(22);
        }
        if (result == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(23);
        }
        if ((field = ownerClass.getPsiClass().findFieldByName(fieldName, false)) != null) {
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ownerClass.getPsiClass().getProject());
            PsiExpression expression2 = factory.createExpressionFromText(typeText + ".class", context);
            String shortType = PsiNameHelper.getShortClassName((String)typeText);
            result.consume((Object)JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.CLASS_ICON, shortType + ".class", shortType));
        }
    }

    @NotNull
    private static LookupElement lookupExpression(@NotNull PsiExpression expression2, @Nullable Icon icon, @NotNull String presentableText, @NotNull String lookupText) {
        if (expression2 == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(24);
        }
        if (presentableText == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(25);
        }
        if (lookupText == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(26);
        }
        ExpressionLookupItem element = new ExpressionLookupItem(expression2, icon, presentableText, new String[]{lookupText}){

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                context.commitDocument();
                JavaReflectionReferenceUtil.replaceText(context, this.getObject().getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor$1", "handleInsert"));
            }
        };
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0);
        if (lookupElement == null) {
            JavaMethodHandleCompletionContributor.$$$reportNull$$$0(27);
        }
        return lookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "methodPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupSignature";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMethodHandleVariants";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addConstructorSignatures";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMethodSignatures";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lookupMethodTypes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lookupSignature";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addFieldHandleVariants";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFieldType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lookupExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

