/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class PsiBasedFormatterModelWithShiftIndentInside
extends PsiBasedFormattingModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside");
    private final Project myProject;

    public PsiBasedFormatterModelWithShiftIndentInside(PsiFile file, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            PsiBasedFormatterModelWithShiftIndentInside.$$$reportNull$$$0(0);
        }
        super(file, rootBlock, documentModel);
        this.myProject = file.getProject();
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        return this.shiftIndentInsideWithPsi(node, textRange, shift);
    }

    private TextRange shiftIndentInsideWithPsi(ASTNode node, TextRange textRange, int shift) {
        if (node != null && node.getTextRange().equals((Object)textRange) && ShiftIndentInsideHelper.mayShiftIndentInside(node)) {
            PsiFile file = node.getPsi().getContainingFile();
            return new ShiftIndentInsideHelper(file).shiftIndentInside(node, shift).getTextRange();
        }
        return textRange;
    }

    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces) {
            if (leafElement.getElementType() == TokenType.WHITE_SPACE) {
                return null;
            }
            ASTNode prevNode = TreeUtil.prevLeaf((ASTNode)leafElement);
            if (prevNode != null) {
                IElementType type2 = prevNode.getElementType();
                if (type2 == TokenType.WHITE_SPACE) {
                    String text2 = prevNode.getText();
                    String cdataStartMarker = "<![CDATA[";
                    int cdataPos = text2.indexOf("<![CDATA[");
                    if (cdataPos != -1 && whiteSpace.indexOf("<![CDATA[") == -1 && (whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker((String)whiteSpace, (String)text2, (int)cdataPos)) == null) {
                        return null;
                    }
                    type2 = (prevNode = TreeUtil.prevLeaf((ASTNode)prevNode)) != null ? prevNode.getElementType() : null;
                }
                String cdataEndMarker = "]]>";
                if (type2 == XmlTokenType.XML_CDATA_END && whiteSpace.indexOf("]]>") == -1) {
                    ASTNode at = this.findElementAt(prevNode.getStartOffset());
                    if (at != null && at.getPsi() instanceof PsiWhiteSpace) {
                        String s = at.getText();
                        int cdataEndPos = s.indexOf("]]>");
                        whiteSpace = DocumentBasedFormattingModel.mergeWsWithCdataMarker((String)whiteSpace, (String)s, (int)cdataEndPos);
                        leafElement = at;
                    } else {
                        whiteSpace = null;
                    }
                    if (whiteSpace == null) {
                        return null;
                    }
                }
            }
        }
        FormatterUtil.replaceWhiteSpace((String)whiteSpace, (ASTNode)leafElement, (IElementType)TokenType.WHITE_SPACE, (TextRange)textRange);
        return whiteSpace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/psi/impl/source/codeStyle/PsiBasedFormatterModelWithShiftIndentInside", "<init>"));
    }
}

