/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiTypeCodeFragmentImpl
extends PsiCodeFragmentImpl
implements PsiTypeCodeFragment {
    private static final Logger LOG = Logger.getInstance(PsiTypeCodeFragmentImpl.class);
    private final boolean myAllowEllipsis;
    private final boolean myAllowDisjunction;
    private final boolean myAllowConjunction;

    public PsiTypeCodeFragmentImpl(Project project, boolean isPhysical, @NonNls String name, CharSequence text2, int flags, PsiElement context) {
        super(project, BitUtil.isSet((int)flags, (int)8) ? JavaElementType.TYPE_WITH_CONJUNCTIONS_TEXT : JavaElementType.TYPE_WITH_DISJUNCTIONS_TEXT, isPhysical, name, text2, context);
        this.myAllowEllipsis = BitUtil.isSet((int)flags, (int)2);
        this.myAllowDisjunction = BitUtil.isSet((int)flags, (int)4);
        this.myAllowConjunction = BitUtil.isSet((int)flags, (int)8);
        LOG.assertTrue(!this.myAllowConjunction || !this.myAllowDisjunction);
        if (BitUtil.isSet((int)flags, (int)1)) {
            this.putUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT, Boolean.TRUE);
        }
    }

    @NotNull
    public PsiType getType() throws PsiTypeCodeFragment.TypeSyntaxException, PsiTypeCodeFragment.NoTypeException {
        class MyTypeSyntaxException
        extends RuntimeException {
            final PsiErrorElement error;

            MyTypeSyntaxException(PsiErrorElement e) {
                super(e.getErrorDescription());
                this.error = e;
            }
        }
        try {
            this.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitErrorElement(PsiErrorElement element) {
                    throw new MyTypeSyntaxException(element);
                }
            });
        }
        catch (MyTypeSyntaxException e) {
            throw new PsiTypeCodeFragment.TypeSyntaxException(e.getMessage(), e.error.getTextRange().getStartOffset());
        }
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiTypeElement.class);
        if (typeElement == null) {
            throw new PsiTypeCodeFragment.NoTypeException("No type found in '" + this.getText() + "'");
        }
        PsiType type2 = typeElement.getType();
        if (type2 instanceof PsiEllipsisType && !this.myAllowEllipsis) {
            throw new PsiTypeCodeFragment.TypeSyntaxException("Ellipsis not allowed: " + type2);
        }
        if (type2 instanceof PsiDisjunctionType && !this.myAllowDisjunction) {
            throw new PsiTypeCodeFragment.TypeSyntaxException("Disjunction not allowed: " + type2);
        }
        if (type2 instanceof PsiDisjunctionType && !this.myAllowConjunction) {
            throw new PsiTypeCodeFragment.TypeSyntaxException("Conjunction not allowed: " + type2);
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiTypeCodeFragmentImpl.$$$reportNull$$$0(0);
        }
        return psiType;
    }

    public boolean isVoidValid() {
        return this.getOriginalFile().getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeCodeFragmentImpl", "getType"));
    }
}

