/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="AllIcons.Nodes.Property")
public class BeanProperty {
    private final PsiMethod myMethod;

    protected BeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            BeanProperty.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
    }

    public PsiNamedElement getPsiElement() {
        return new BeanPropertyElement(this.myMethod, this.getName()){

            @Override
            public PsiType getPropertyType() {
                return BeanProperty.this.getPropertyType();
            }
        };
    }

    @NotNull
    public String getName() {
        String name = PropertyUtilBase.getPropertyName((PsiMethod)this.myMethod);
        String string = name == null ? "" : name;
        if (string == null) {
            BeanProperty.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiType getPropertyType() {
        PsiType type2 = PropertyUtilBase.getPropertyType((PsiMember)this.myMethod);
        assert (type2 != null);
        PsiType psiType = type2;
        if (psiType == null) {
            BeanProperty.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            BeanProperty.$$$reportNull$$$0(3);
        }
        return psiMethod;
    }

    @Nullable
    public PsiMethod getGetter() {
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtilBase.findPropertyGetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    @Nullable
    public PsiMethod getSetter() {
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)this.myMethod)) {
            return this.myMethod;
        }
        return PropertyUtilBase.findPropertySetter((PsiClass)this.myMethod.getContainingClass(), (String)this.getName(), (boolean)false, (boolean)true);
    }

    public void setName(String newName) throws IncorrectOperationException {
        PsiMethod setter = this.getSetter();
        PsiMethod getter = this.getGetter();
        if (getter != null) {
            String getterName = PropertyUtilBase.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            getter.setName(getterName);
        }
        if (setter != null) {
            String setterName = PropertyUtilBase.suggestSetterName((String)newName);
            setter.setName(setterName);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Property;
    }

    @Nullable
    public static BeanProperty createBeanProperty(@NotNull PsiMethod method) {
        if (method == null) {
            BeanProperty.$$$reportNull$$$0(4);
        }
        return PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method) ? new BeanProperty(method) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/beanProperties/BeanProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/beanProperties/BeanProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createBeanProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

