/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaModuleExternalPathsImpl
extends JavaModuleExternalPaths {
    private static final String ROOT_ELEMENT = "root";
    private final Map<OrderRootType, VirtualFilePointerContainer> myOrderRootPointerContainers = new THashMap();
    private final JavaModuleExternalPathsImpl mySource;

    public JavaModuleExternalPathsImpl() {
        this(null);
    }

    private JavaModuleExternalPathsImpl(JavaModuleExternalPathsImpl source) {
        this.mySource = source;
        if (source != null) {
            this.copyContainersFrom(source);
        }
    }

    @NotNull
    public ModuleExtension getModifiableModel(boolean writable) {
        JavaModuleExternalPathsImpl javaModuleExternalPathsImpl = new JavaModuleExternalPathsImpl(this);
        if (javaModuleExternalPathsImpl == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(0);
        }
        return javaModuleExternalPathsImpl;
    }

    public void commit() {
        this.mySource.copyContainersFrom(this);
    }

    @NotNull
    public String[] getJavadocUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(JavadocOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExternalAnnotationsRoots() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        VirtualFile[] virtualFileArray = container != null ? container.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getExternalAnnotationsUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    public void setJavadocUrls(@NotNull String[] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(4);
        }
        this.setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    public void setExternalAnnotationUrls(@NotNull String[] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(5);
        }
        this.setRootUrls(AnnotationOrderRootType.getInstance(), urls);
    }

    private void setRootUrls(OrderRootType orderRootType, @NotNull String[] urls) {
        VirtualFilePointerContainer container;
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(6);
        }
        if ((container = this.myOrderRootPointerContainers.get(orderRootType)) == null) {
            if (urls.length == 0) {
                return;
            }
            container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put(orderRootType, container);
        } else {
            container.clear();
        }
        for (String url : urls) {
            container.add(url);
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(7);
        }
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null || pathsElement.getChildren(ROOT_ELEMENT).isEmpty()) continue;
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put((OrderRootType)orderRootType, container);
            container.readExternal(pathsElement, ROOT_ELEMENT, false);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(8);
        }
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || container.size() <= 0) continue;
            Element javaDocPaths = new Element(((PersistentOrderRootType)orderRootType).getModulePathsName());
            container.writeExternal(javaDocPaths, ROOT_ELEMENT, false);
            element.addContent(javaDocPaths);
        }
    }

    private void copyContainersFrom(@NotNull JavaModuleExternalPathsImpl source) {
        if (source == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(9);
        }
        this.myOrderRootPointerContainers.clear();
        for (OrderRootType orderRootType : source.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer otherContainer = source.myOrderRootPointerContainers.get(orderRootType);
            if (otherContainer == null) continue;
            this.myOrderRootPointerContainers.put(orderRootType, otherContainer.clone((Disposable)this, null));
        }
    }

    public boolean isChanged() {
        if (this.myOrderRootPointerContainers.size() != this.mySource.myOrderRootPointerContainers.size()) {
            return true;
        }
        for (OrderRootType type2 : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(type2);
            VirtualFilePointerContainer otherContainer = this.mySource.myOrderRootPointerContainers.get(type2);
            if (container == null || otherContainer == null) {
                if (container == otherContainer) continue;
                return true;
            }
            String[] urls = container.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i = 0; i < urls.length; ++i) {
                if (Comparing.strEqual((String)urls[i], (String)otherUrls[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavadocUrls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsUrls";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setExternalAnnotationUrls";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRootUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyContainersFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

