/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerModuleExtensionImpl
extends CompilerModuleExtension {
    @NonNls
    private static final String OUTPUT_TAG = "output";
    @NonNls
    private static final String TEST_OUTPUT_TAG = "output-test";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    private String myCompilerOutput;
    private VirtualFilePointer myCompilerOutputPointer;
    private String myCompilerOutputForTests;
    private VirtualFilePointer myCompilerOutputPathForTestsPointer;
    private boolean myInheritedCompilerOutput;
    private boolean myExcludeOutput;
    @NotNull
    private final Module myModule;
    private CompilerModuleExtensionImpl mySource;
    private boolean myWritable;
    private boolean myDisposed;

    public CompilerModuleExtensionImpl(@NotNull Module module) {
        if (module == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(0);
        }
        this.myInheritedCompilerOutput = true;
        this.myExcludeOutput = true;
        this.myModule = module;
    }

    private CompilerModuleExtensionImpl(@NotNull CompilerModuleExtensionImpl source, boolean writable) {
        if (source == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(1);
        }
        this(source.myModule);
        this.myWritable = writable;
        this.myCompilerOutput = source.myCompilerOutput;
        this.myCompilerOutputPointer = this.duplicatePointer(source.myCompilerOutputPointer);
        this.myCompilerOutputForTests = source.myCompilerOutputForTests;
        this.myCompilerOutputPathForTestsPointer = this.duplicatePointer(source.myCompilerOutputPathForTestsPointer);
        this.myInheritedCompilerOutput = source.myInheritedCompilerOutput;
        this.myExcludeOutput = source.myExcludeOutput;
        this.mySource = source;
    }

    private VirtualFilePointer duplicatePointer(VirtualFilePointer pointer) {
        if (pointer == null) {
            return null;
        }
        VirtualFilePointerManager filePointerManager = VirtualFilePointerManager.getInstance();
        return filePointerManager.duplicate(pointer, (Disposable)this, null);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(2);
        }
        assert (!this.myDisposed);
        this.myInheritedCompilerOutput = Boolean.parseBoolean(element.getAttributeValue("inherit-compiler-output", "false"));
        this.myExcludeOutput = element.getChild(EXCLUDE_OUTPUT_TAG) != null;
        this.myCompilerOutputPointer = this.getOutputPathValue(element, OUTPUT_TAG, !this.myInheritedCompilerOutput);
        this.myCompilerOutput = CompilerModuleExtensionImpl.getOutputPathValue(element, OUTPUT_TAG);
        this.myCompilerOutputPathForTestsPointer = this.getOutputPathValue(element, TEST_OUTPUT_TAG, !this.myInheritedCompilerOutput);
        this.myCompilerOutputForTests = CompilerModuleExtensionImpl.getOutputPathValue(element, TEST_OUTPUT_TAG);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(3);
        }
        assert (!this.myDisposed);
        if (!this.myInheritedCompilerOutput) {
            Element pathElement;
            if (this.myCompilerOutput != null) {
                pathElement = new Element(OUTPUT_TAG);
                pathElement.setAttribute(ATTRIBUTE_URL, this.myCompilerOutput);
                element.addContent(pathElement);
            }
            if (this.myCompilerOutputForTests != null) {
                pathElement = new Element(TEST_OUTPUT_TAG);
                pathElement.setAttribute(ATTRIBUTE_URL, this.myCompilerOutputForTests);
                element.addContent(pathElement);
            }
        } else {
            element.setAttribute("inherit-compiler-output", "true");
        }
        if (this.myExcludeOutput) {
            element.addContent(new Element(EXCLUDE_OUTPUT_TAG));
        }
    }

    @Nullable
    private VirtualFilePointer getOutputPathValue(Element element, String tag, boolean createPointer) {
        Element outputPathChild = element.getChild(tag);
        VirtualFilePointer vptr = null;
        if (outputPathChild != null && createPointer) {
            String outputPath = outputPathChild.getAttributeValue(ATTRIBUTE_URL);
            vptr = this.createPointer(outputPath);
        }
        return vptr;
    }

    @Nullable
    private static String getOutputPathValue(@NotNull Element element, @NotNull String tag) {
        Element outputPathChild;
        if (element == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(4);
        }
        if (tag == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(5);
        }
        if ((outputPathChild = element.getChild(tag)) != null) {
            return outputPathChild.getAttributeValue(ATTRIBUTE_URL);
        }
        return null;
    }

    @Nullable
    public VirtualFile getCompilerOutputPath() {
        if (this.myInheritedCompilerOutput) {
            VirtualFile projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutput();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath.findFileByRelativePath("production/" + this.getSanitizedModuleName());
        }
        return this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getFile();
    }

    @Nullable
    public VirtualFile getCompilerOutputPathForTests() {
        if (this.myInheritedCompilerOutput) {
            VirtualFile projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutput();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath.findFileByRelativePath("test/" + this.getSanitizedModuleName());
        }
        return this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getFile();
    }

    @Nullable
    public String getCompilerOutputUrl() {
        if (this.myInheritedCompilerOutput) {
            String projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutputUrl();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath + "/" + "production" + "/" + this.getSanitizedModuleName();
        }
        return this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getUrl();
    }

    @Nullable
    public String getCompilerOutputUrlForTests() {
        if (this.myInheritedCompilerOutput) {
            String projectOutputPath = CompilerProjectExtension.getInstance((Project)this.getProject()).getCompilerOutputUrl();
            if (projectOutputPath == null) {
                return null;
            }
            return projectOutputPath + "/" + "test" + "/" + this.getSanitizedModuleName();
        }
        return this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getUrl();
    }

    @NotNull
    private String getSanitizedModuleName() {
        Module module = this.getModule();
        VirtualFile file = module.getModuleFile();
        String string = file != null ? file.getNameWithoutExtension() : module.getName();
        if (string == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setCompilerOutputPath(VirtualFile file) {
        this.setCompilerOutputPath(file == null ? null : file.getUrl());
    }

    @NotNull
    private VirtualFilePointer createPointer(@NotNull String url) {
        if (url == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(7);
        }
        VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, ProjectRootManagerImpl.getInstanceImpl((Project)this.getProject()).getRootsValidityChangedListener());
        if (virtualFilePointer == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(8);
        }
        return virtualFilePointer;
    }

    public void setCompilerOutputPath(String url) {
        this.assertWritable();
        this.myCompilerOutput = url;
        this.myCompilerOutputPointer = url == null ? null : this.createPointer(url);
    }

    public void setCompilerOutputPathForTests(VirtualFile file) {
        this.setCompilerOutputPathForTests(file == null ? null : file.getUrl());
    }

    public void setCompilerOutputPathForTests(String url) {
        this.assertWritable();
        this.myCompilerOutputForTests = url;
        this.myCompilerOutputPathForTestsPointer = url == null ? null : this.createPointer(url);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(9);
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(10);
        }
        return project;
    }

    public void inheritCompilerOutputPath(boolean inherit) {
        if (this.myInheritedCompilerOutput == inherit) {
            return;
        }
        this.assertWritable();
        this.myInheritedCompilerOutput = inherit;
    }

    private void assertWritable() {
        assert (this.myWritable) : "Writable model can be retrieved from writable ModifiableRootModel";
    }

    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutputPointer;
    }

    public VirtualFilePointer getCompilerOutputForTestsPointer() {
        return this.myCompilerOutputPathForTestsPointer;
    }

    public void setExcludeOutput(boolean exclude) {
        this.assertWritable();
        this.myExcludeOutput = exclude;
    }

    public boolean isExcludeOutput() {
        return this.myExcludeOutput;
    }

    @NotNull
    public CompilerModuleExtension getModifiableModel(boolean writable) {
        assert (!this.myDisposed);
        CompilerModuleExtensionImpl compilerModuleExtensionImpl = new CompilerModuleExtensionImpl(this, writable);
        if (compilerModuleExtensionImpl == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(11);
        }
        return compilerModuleExtensionImpl;
    }

    public void commit() {
        if (this.mySource != null) {
            this.mySource.myCompilerOutput = this.myCompilerOutput;
            boolean old = this.mySource.myWritable;
            this.mySource.myWritable = true;
            this.mySource.setCompilerOutputPath(this.myCompilerOutputPointer == null ? null : this.myCompilerOutputPointer.getUrl());
            this.mySource.myCompilerOutputForTests = this.myCompilerOutputForTests;
            this.mySource.setCompilerOutputPathForTests(this.myCompilerOutputPathForTestsPointer == null ? null : this.myCompilerOutputPathForTestsPointer.getUrl());
            this.mySource.myInheritedCompilerOutput = this.myInheritedCompilerOutput;
            this.mySource.myExcludeOutput = this.myExcludeOutput;
            this.mySource.myWritable = old;
        }
    }

    public boolean isChanged() {
        if (this.myInheritedCompilerOutput != this.mySource.myInheritedCompilerOutput) {
            return true;
        }
        if (!CompilerModuleExtensionImpl.vptrEqual(this.myCompilerOutputPointer, this.mySource.myCompilerOutputPointer)) {
            return true;
        }
        if (!CompilerModuleExtensionImpl.vptrEqual(this.myCompilerOutputPathForTestsPointer, this.mySource.myCompilerOutputPathForTestsPointer)) {
            return true;
        }
        return this.myExcludeOutput != this.mySource.myExcludeOutput;
    }

    private static boolean vptrEqual(VirtualFilePointer p1, VirtualFilePointer p2) {
        return Comparing.equal((String)(p1 == null ? null : p1.getUrl()), (String)(p2 == null ? null : p2.getUrl()));
    }

    public void dispose() {
        this.myDisposed = true;
        this.mySource = null;
        this.myCompilerOutput = null;
        this.myCompilerOutputForTests = null;
    }

    @NotNull
    public VirtualFile[] getOutputRoots(boolean includeTests) {
        VirtualFile outputRoot;
        VirtualFile outputPathForTests;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile virtualFile = outputPathForTests = includeTests ? this.getCompilerOutputPathForTests() : null;
        if (outputPathForTests != null) {
            result.add(outputPathForTests);
        }
        if ((outputRoot = this.getCompilerOutputPath()) != null && !outputRoot.equals(outputPathForTests)) {
            result.add(outputRoot);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(12);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getOutputRootUrls(boolean includeTests) {
        String outputRoot;
        String outputPathForTests;
        ArrayList<String> result = new ArrayList<String>();
        String string = outputPathForTests = includeTests ? this.getCompilerOutputUrlForTests() : null;
        if (outputPathForTests != null) {
            result.add(outputPathForTests);
        }
        if ((outputRoot = this.getCompilerOutputUrl()) != null && !outputRoot.equals(outputPathForTests)) {
            result.add(outputRoot);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            CompilerModuleExtensionImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/CompilerModuleExtensionImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_URL;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/CompilerModuleExtensionImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedModuleName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPathValue";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

