/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParserDefinition
implements ParserDefinition {
    public static final IStubFileElementType JAVA_FILE = new JavaFileElementType();

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        LanguageLevel level = project != null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        if (lexer == null) {
            JavaParserDefinition.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    @NotNull
    public static Lexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(1);
        }
        JavaLexer javaLexer = new JavaLexer(level);
        if (javaLexer == null) {
            JavaParserDefinition.$$$reportNull$$$0(2);
        }
        return javaLexer;
    }

    @NotNull
    public static Lexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(3);
        }
        JavaDocLexer javaDocLexer = new JavaDocLexer(level);
        if (javaDocLexer == null) {
            JavaParserDefinition.$$$reportNull$$$0(4);
        }
        return javaDocLexer;
    }

    public IFileElementType getFileNodeType() {
        return JAVA_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.WHITE_SPACE;
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(5);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(6);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LITERAL_EXPRESSION});
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(7);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type2).createPsi(node);
            if (PsiT == null) {
                JavaParserDefinition.$$$reportNull$$$0(8);
            }
            return PsiT;
        }
        throw new IllegalStateException("Incorrect node for JavaParserDefinition: " + node + " (" + type2 + ")");
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text2;
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN || left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        LanguageLevel level = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text2 = left.getText()).length() > 0 && Character.isWhitespace(text2.charAt(text2.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text2 = right.getText()).length() > 0 && Character.isWhitespace(text2.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/JavaParserDefinition";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/JavaParserDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocLexer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocLexer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

