/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import org.jetbrains.annotations.Nullable;

public class PsiClassListCellRenderer
extends PsiElementListCellRenderer<PsiClass> {
    public String getElementText(PsiClass element) {
        return ClassPresentationUtil.getNameForClass(element, false);
    }

    protected String getContainerText(PsiClass element, String name) {
        return PsiClassListCellRenderer.getContainerTextStatic((PsiElement)element);
    }

    @Nullable
    public static String getContainerTextStatic(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            if (packageName.isEmpty()) {
                return null;
            }
            return "(" + packageName + ")";
        }
        return null;
    }

    protected int getIconFlags() {
        return 0;
    }
}

