/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateClassAction
extends JavaCreateTemplateInPackageAction<PsiClass>
implements DumbAware {
    public CreateClassAction() {
        super("", IdeBundle.message((String)"action.create.new.class.description", (Object[])new Object[0]), PlatformIcons.CLASS_ICON, true);
    }

    protected void buildDialog(final Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(IdeBundle.message((String)"action.create.new.class", (Object[])new Object[0])).addKind("Class", PlatformIcons.CLASS_ICON, "Class").addKind("Interface", PlatformIcons.INTERFACE_ICON, "Interface");
        final LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)directory);
        if (level.isAtLeast(LanguageLevel.JDK_1_5)) {
            builder.addKind("Enum", PlatformIcons.ENUM_ICON, "Enum");
            builder.addKind("Annotation", PlatformIcons.ANNOTATION_TYPE_ICON, "AnnotationType");
        }
        FileTemplate[] fileTemplateArray = FileTemplateManager.getInstance((Project)project).getAllTemplates();
        int n = fileTemplateArray.length;
        for (int i = 0; i < n; ++i) {
            JavaCreateFromTemplateHandler handler = new JavaCreateFromTemplateHandler();
            FileTemplate template = fileTemplateArray[i];
            if (!handler.handlesTemplate(template) || !JavaCreateFromTemplateHandler.canCreate(directory)) continue;
            builder.addKind(template.getName(), JavaFileType.INSTANCE.getIcon(), template.getName());
        }
        builder.setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                if (inputString.length() > 0 && !PsiNameHelper.getInstance((Project)project).isQualifiedName(inputString)) {
                    return "This is not a valid Java qualified name";
                }
                if (level.isAtLeast(LanguageLevel.JDK_10) && "var".equals(StringUtil.getShortName((String)inputString))) {
                    return "var cannot be used for type declarations";
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && this.getErrorText(inputString) == null;
            }
        });
    }

    protected String removeExtension(String templateName, String className) {
        return StringUtil.trimEnd((String)className, (String)".java");
    }

    @NotNull
    protected String getErrorTitle() {
        String string = IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
        if (string == null) {
            CreateClassAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            CreateClassAction.$$$reportNull$$$0(1);
        }
        return IdeBundle.message((String)"progress.creating.class", (Object[])new Object[]{StringUtil.getQualifiedName((String)JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), (String)newName)});
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected final PsiClass doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        return JavaDirectoryService.getInstance().createClass(dir, className, templateName, true);
    }

    protected PsiElement getNavigationElement(@NotNull PsiClass createdElement) {
        if (createdElement == null) {
            CreateClassAction.$$$reportNull$$$0(2);
        }
        return createdElement.getLBrace();
    }

    protected void postProcess(PsiClass createdElement, String templateName, Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
        CreateClassAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)createdElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateClassAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateClassAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

