/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ParameterCanBeLocal";

    protected ConvertParameterToLocalQuickFix createFix() {
        return new ConvertParameterToLocalQuickFix();
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASS_LAYOUT_GROUP_NAME;
        if (string == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.parameter.can.be.local.display.name", (Object[])new Object[0]);
        if (string == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(4);
        }
        List<PsiParameter> parameters2 = ParameterCanBeLocalInspection.filterFinal(method.getParameterList().getParameters());
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || parameters2.isEmpty() || ParameterCanBeLocalInspection.isOverrides(method) || MethodUtils.isOverridden(method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (PsiParameter parameter2 : ParameterCanBeLocalInspection.getWriteBeforeRead(parameters2, body2)) {
            PsiIdentifier identifier = parameter2.getNameIdentifier();
            if (identifier == null || !identifier.isPhysical()) continue;
            result.add(this.createProblem(manager, identifier, isOnTheFly));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull PsiIdentifier identifier, boolean isOnTheFly) {
        if (manager == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(5);
        }
        if (identifier == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(6);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)identifier, InspectionsBundle.message((String)"inspection.parameter.can.be.local.problem.descriptor", (Object[])new Object[0]), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly, new LocalQuickFix[]{this.createFix()});
        if (problemDescriptor == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(7);
        }
        return problemDescriptor;
    }

    @NotNull
    private static List<PsiParameter> filterFinal(PsiParameter[] parameters2) {
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>(parameters2.length);
        for (PsiParameter parameter2 : parameters2) {
            if (parameter2.hasModifierProperty("final")) continue;
            result.add(parameter2);
        }
        ArrayList<PsiParameter> arrayList = result;
        if (arrayList == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static Collection<PsiParameter> getWriteBeforeRead(@NotNull Collection<? extends PsiParameter> parameters2, @NotNull PsiCodeBlock body2) {
        ControlFlow controlFlow;
        if (parameters2 == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(9);
        }
        if (body2 == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(10);
        }
        if ((controlFlow = ParameterCanBeLocalInspection.getControlFlow((PsiElement)body2)) == null) {
            return Collections.emptyList();
        }
        Set<PsiParameter> result = ParameterCanBeLocalInspection.filterParameters(controlFlow, parameters2);
        result.retainAll(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite(controlFlow)) {
            PsiElement resolved = readBeforeWrite.resolve();
            if (!(resolved instanceof PsiParameter)) continue;
            result.remove(resolved);
        }
        return result;
    }

    private static Set<PsiParameter> filterParameters(@NotNull ControlFlow controlFlow, @NotNull Collection<? extends PsiParameter> parameters2) {
        if (controlFlow == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(11);
        }
        if (parameters2 == null) {
            ParameterCanBeLocalInspection.$$$reportNull$$$0(12);
        }
        HashSet<PsiVariable> usedVars = new HashSet<PsiVariable>(ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize()));
        HashSet<PsiParameter> result = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : parameters2) {
            if (!usedVars.contains(psiParameter)) continue;
            result.add(psiParameter);
        }
        return result;
    }

    private static boolean isOverrides(PsiMethod method) {
        return SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement context) {
        try {
            return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFinal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWriteBeforeRead";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConvertParameterToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiParameter> {
        @Override
        protected PsiParameter getVariable(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(0);
            }
            return (PsiParameter)descriptor.getPsiElement().getParent();
        }

        @Override
        protected PsiElement applyChanges(final @NotNull Project project, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull PsiParameter parameter2, final @NotNull Collection<? extends PsiReference> references, boolean delete, final @NotNull NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action) {
            PsiElement scope;
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (localName == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(2);
            }
            if (parameter2 == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (references == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(4);
            }
            if (action == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(5);
            }
            if ((scope = parameter2.getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter psiParameter = parameters2[i];
                    if (psiParameter == parameter2) continue;
                    info.add(new ParameterInfoImpl(i, psiParameter.getName(), psiParameter.getType()));
                }
                ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[0]);
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
                PsiType returnType = method.getReturnType();
                JavaChangeInfoImpl changeInfo = new JavaChangeInfoImpl(visibilityModifier, method, method.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, newParams, null, false, ContainerUtil.newHashSet(), ContainerUtil.newHashSet());
                class ParameterToLocalProcessor
                extends ChangeSignatureProcessor {
                    private PsiElement newDeclaration;

                    ParameterToLocalProcessor(Project project3, JavaChangeInfo changeInfo) {
                        super(project3, changeInfo);
                    }

                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            ParameterToLocalProcessor.$$$reportNull$$$0(0);
                        }
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                        this.newDeclaration = ConvertParameterToLocalQuickFix.this.moveDeclaration(elementFactory, localName, parameter2, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                        super.performRefactoring(usages);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix$1ParameterToLocalProcessor", "performRefactoring"));
                    }
                }
                ParameterToLocalProcessor processor = new ParameterToLocalProcessor(project, changeInfo);
                processor.run();
                return processor.newDeclaration;
            }
            return null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project, @NotNull PsiParameter parameter2, @NotNull PsiCodeBlock scope) {
            if (project == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(6);
            }
            if (parameter2 == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(7);
            }
            if (scope == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(8);
            }
            String string = parameter2.getName();
            if (string == null) {
                ConvertParameterToLocalQuickFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localName";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestLocalName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyChanges";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestLocalName";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

