/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptionalUtil {
    public static final String OPTIONAL_INT = "java.util.OptionalInt";
    public static final String OPTIONAL_LONG = "java.util.OptionalLong";
    public static final String OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    public static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    public static final CallMatcher GUAVA_OPTIONAL_FROM_NULLABLE = CallMatcher.staticCall("com.google.common.base.Optional", "fromNullable").parameterCount(1);
    public static final CallMatcher JDK_OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    public static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.anyOf(JDK_OPTIONAL_OF_NULLABLE, GUAVA_OPTIONAL_FROM_NULLABLE);
    public static final CallMatcher JDK_OPTIONAL_GET = CallMatcher.exactInstanceCall("java.util.Optional", "get").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_INT_GET = CallMatcher.exactInstanceCall("java.util.OptionalInt", "getAsInt").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_LONG_GET = CallMatcher.exactInstanceCall("java.util.OptionalLong", "getAsLong").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_DOUBLE_GET = CallMatcher.exactInstanceCall("java.util.OptionalDouble", "getAsDouble").parameterCount(0);
    public static final CallMatcher GUAVA_OPTIONAL_GET = CallMatcher.instanceCall("com.google.common.base.Optional", "get").parameterCount(0);
    public static final CallMatcher OPTIONAL_GET = CallMatcher.anyOf(JDK_OPTIONAL_GET, JDK_OPTIONAL_INT_GET, JDK_OPTIONAL_LONG_GET, JDK_OPTIONAL_DOUBLE_GET, GUAVA_OPTIONAL_GET);
    public static final CallMatcher JDK_OPTIONAL_WRAP_METHOD = CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1);

    @NotNull
    @Contract(pure=true)
    public static String getOptionalClass(String type2) {
        switch (type2) {
            case "int": {
                if (OPTIONAL_INT == null) {
                    OptionalUtil.$$$reportNull$$$0(0);
                }
                return OPTIONAL_INT;
            }
            case "long": {
                if (OPTIONAL_LONG == null) {
                    OptionalUtil.$$$reportNull$$$0(1);
                }
                return OPTIONAL_LONG;
            }
            case "double": {
                if (OPTIONAL_DOUBLE == null) {
                    OptionalUtil.$$$reportNull$$$0(2);
                }
                return OPTIONAL_DOUBLE;
            }
        }
        if ("java.util.Optional" == null) {
            OptionalUtil.$$$reportNull$$$0(3);
        }
        return "java.util.Optional";
    }

    public static boolean isJdkOptionalClassName(String className) {
        return "java.util.Optional".equals(className) || OPTIONAL_INT.equals(className) || OPTIONAL_LONG.equals(className) || OPTIONAL_DOUBLE.equals(className);
    }

    @Contract(value="null -> null")
    public static PsiType getOptionalElementType(PsiType type2) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        switch (className) {
            case "java.util.OptionalInt": {
                return PsiType.INT;
            }
            case "java.util.OptionalLong": {
                return PsiType.LONG;
            }
            case "java.util.OptionalDouble": {
                return PsiType.DOUBLE;
            }
            case "java.util.Optional": 
            case "com.google.common.base.Optional": {
                PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiType streamType = parameters2[0];
                if (streamType instanceof PsiCapturedWildcardType) {
                    streamType = ((PsiCapturedWildcardType)streamType).getUpperBound();
                }
                return streamType;
            }
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isOptionalEmptyCall(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression2, "java.util.Optional", "empty", 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/OptionalUtil", "getOptionalClass"));
    }
}

