/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaModuleImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastVisitorAdapter;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Condition<PsiElement> PROBLEM_ELEMENT_CONDITION = Conditions.or((Condition)Conditions.instanceOf((Class[])new Class[]{PsiFile.class, PsiJavaModule.class}), (Condition)Conditions.and((Condition)Conditions.notInstanceOf(PsiTypeParameter.class), psi -> {
        UDeclaration decl = (UDeclaration)UastContextKt.toUElement((PsiElement)psi, UDeclaration.class);
        return decl != null && (decl instanceof UField || !(decl instanceof UVariable)) && !(decl instanceof UClassInitializer);
    }));
    private static final Logger LOG = Logger.getInstance(RefJavaManagerImpl.class);
    public static final String JAVAX_SERVLET_SERVLET = "javax.servlet.Servlet";
    private final PsiMethod myAppMainPattern;
    private final PsiMethod myAppPremainPattern;
    private final PsiMethod myAppAgentmainPattern;
    private final PsiClass myApplet;
    private volatile RefPackage myCachedDefaultPackage;
    private Map<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        if (manager == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(0);
        }
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
        this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
        this.myAppAgentmainPattern = factory.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        this.myApplet = JavaPsiFacade.getInstance((Project)project).findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
    }

    public RefImplicitConstructor getImplicitConstructor(String classFQName) {
        RefEntity entity = this.getReference("class", classFQName);
        if (entity == null) {
            return null;
        }
        RefClass refClass = (RefClass)entity;
        return (RefImplicitConstructor)refClass.getDefaultConstructor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            if (this.myPackages == null) {
                this.myPackages = new THashMap();
            }
            refPackage = this.myPackages.get(packageName);
        }
        if (refPackage == null) {
            boolean saved;
            refPackage = new RefPackageImpl(packageName, (RefManager)this.myRefManager);
            RefJavaManagerImpl refJavaManagerImpl2 = this;
            synchronized (refJavaManagerImpl2) {
                RefPackage oldPackage = this.myPackages.get(packageName);
                if (oldPackage == null) {
                    this.myPackages.put(packageName, refPackage);
                    saved = true;
                } else {
                    refPackage = oldPackage;
                    saved = false;
                }
            }
            if (saved) {
                int dotIndex = packageName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add((RefEntity)refPackage);
                } else {
                    ((RefProjectImpl)this.myRefManager.getRefProject()).add((RefEntity)refPackage);
                }
            }
        }
        return refPackage;
    }

    private boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspectionBase tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element) && RefJavaManagerImpl.isTestSource(tool, element);
    }

    private static boolean isTestSource(UnusedDeclarationInspectionBase tool, RefElement refElement) {
        if (tool.isTestEntryPoints()) {
            return true;
        }
        PsiElement element = refElement.getPsiElement();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInTestSourceContent(file);
    }

    @Nullable
    private UnusedDeclarationInspectionBase getDeadCodeTool(RefElement element) {
        PsiFile file = ((RefElementImpl)element).getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getDeadCodeTool(file.getContainingFile());
    }

    private UnusedDeclarationInspectionBase getDeadCodeTool(PsiFile file) {
        GlobalInspectionContextBase contextBase = (GlobalInspectionContextBase)this.myRefManager.getContext();
        Tools tools = (Tools)contextBase.getTools().get("unused");
        if (tools == null) {
            String singleTool = contextBase.getCurrentProfile().getSingleTool();
            if (singleTool != null && !"unused".equals(singleTool)) {
                return UnusedDeclarationInspectionBase.findUnusedDeclarationInspection((PsiElement)file);
            }
            return null;
        }
        InspectionToolWrapper toolWrapper = tools.getEnabledTool((PsiElement)file);
        InspectionProfileEntry tool = toolWrapper == null ? null : toolWrapper.getTool();
        return tool instanceof UnusedDeclarationInspectionBase ? (UnusedDeclarationInspectionBase)tool : null;
    }

    public RefPackage getDefaultPackage() {
        RefPackage defaultPackage = this.myCachedDefaultPackage;
        if (defaultPackage == null) {
            this.myCachedDefaultPackage = defaultPackage = this.getPackage(InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]));
        }
        return defaultPackage;
    }

    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    public PsiClass getApplet() {
        return this.myApplet;
    }

    public String getAppletQName() {
        return this.myApplet.getQualifiedName();
    }

    public String getServletQName() {
        return JAVAX_SERVLET_SERVLET;
    }

    public RefParameter getParameterReference(UParameter param, int index, RefMethod refMethod) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), (Object)"References may become invalid after process is finished");
        PsiElement psi = param.getSourcePsi();
        return (RefParameter)this.myRefManager.getFromRefTableOrCache(psi, () -> {
            RefParameterImpl ref = new RefParameterImpl(param, psi, index, (RefManager)this.myRefManager, refMethod);
            ref.initialize();
            return ref;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(@NotNull RefVisitor visitor) {
        Map<String, RefPackage> packages;
        if (visitor == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(1);
        }
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            packages = this.myPackages;
        }
        if (packages != null) {
            for (RefPackage refPackage : packages.values()) {
                refPackage.accept(visitor);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose((Disposable)this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            this.myPackages = null;
            this.myCachedDefaultPackage = null;
        }
        this.myProjectIterator = null;
    }

    public void removeReference(@NotNull RefElement refElement) {
        if (refElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public RefElement createRefElement(@NotNull PsiElement psi) {
        if (psi == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(3);
        }
        if (!this.getLanguages().contains(psi.getLanguage())) {
            return null;
        }
        if (psi instanceof PsiFile) {
            return new RefJavaFileImpl((PsiFile)psi, (RefManager)this.myRefManager);
        }
        if (psi instanceof PsiJavaModule) {
            return new RefJavaModuleImpl((PsiJavaModule)psi, this.myRefManager);
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)psi);
        if (uElement instanceof UClass) {
            return new RefClassImpl((UClass)uElement, psi, (RefManager)this.myRefManager);
        }
        if (uElement instanceof UMethod) {
            return new RefMethodImpl((UMethod)uElement, psi, (RefManager)this.myRefManager);
        }
        if (uElement instanceof UField) {
            return new RefFieldImpl((UField)uElement, psi, (RefManager)this.myRefManager);
        }
        return null;
    }

    @Nullable
    public PsiNamedElement getElementContainer(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(4);
        }
        return (PsiNamedElement)PsiTreeUtil.findFirstParent((PsiElement)psiElement, PROBLEM_ELEMENT_CONDITION);
    }

    @Nullable
    public RefEntity getReference(String type2, String fqName) {
        if ("implicit.constructor".equals(type2)) {
            return this.getImplicitConstructor(fqName);
        }
        if ("method".equals(type2)) {
            return RefMethodImpl.methodFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("class".equals(type2)) {
            return RefClassImpl.classFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("field".equals(type2)) {
            return RefFieldImpl.fieldFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("parameter".equals(type2)) {
            return RefParameterImpl.parameterFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("package".equals(type2)) {
            return RefPackageImpl.packageFromFQName((RefManager)this.myRefManager, fqName);
        }
        if ("java.module".equals(type2)) {
            return RefJavaModuleImpl.moduleFromExternalName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(5);
        }
        if (ref instanceof RefImplicitConstructor) {
            return "implicit.constructor";
        }
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        if (ref instanceof RefJavaModule) {
            return "java.module";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(6);
        }
        if (ref instanceof RefImplicitConstructor) {
            RefClass refClass = ((RefImplicitConstructor)ref).getOwnerClass();
            if (refClass == null) {
                RefJavaManagerImpl.$$$reportNull$$$0(7);
            }
            return refClass;
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(8);
        }
        return refEntity;
    }

    public void visitElement(@NotNull PsiElement element) {
        Object projectIterator;
        if (element == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(9);
        }
        if ((projectIterator = this.myProjectIterator) == null) {
            this.myProjectIterator = projectIterator = new UastVisitorAdapter(new MyJavaElementVisitor(), true){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (element instanceof PsiJavaModule) {
                        this.visitJavaModule((PsiJavaModule)element);
                    }
                }

                private void visitJavaModule(PsiJavaModule module) {
                    RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)module);
                    if (refElement != null) {
                        ((RefJavaModuleImpl)refElement).buildReferences();
                    }
                }
            };
        }
        element.accept(projectIterator);
    }

    @Nullable
    public String getGroupName(@NotNull RefEntity entity) {
        if (entity == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(10);
        }
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    public boolean belongsToScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(11);
        }
        return !(psiElement instanceof PsiTypeParameter);
    }

    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        String packageName;
        if (refEntity == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(12);
        }
        if (element == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(13);
        }
        if ((packageName = RefJavaUtil.getInstance().getPackageName(refEntity)) != null) {
            Element packageElement = new Element("package");
            packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : packageName);
            element.addContent(packageElement);
        }
    }

    public void onEntityInitialized(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(14);
        }
        if (psiElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(15);
        }
        if (this.myRefManager.isOfflineView()) {
            return;
        }
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    public boolean shouldProcessExternalFile(@NotNull PsiFile file) {
        if (file == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(16);
        }
        return file instanceof PsiClassOwner;
    }

    @NotNull
    public Stream<? extends PsiElement> extractExternalFileImplicitReferences(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(17);
        }
        Stream<PsiClass> stream = Arrays.stream(((PsiClassOwner)psiFile).getClasses()).flatMap(c -> Arrays.stream(c.getSuperTypes())).map(PsiClassType::resolve).filter(Objects::nonNull);
        if (stream == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(18);
        }
        return stream;
    }

    public void markExternalReferencesProcessed(@NotNull RefElement file) {
        if (file == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(19);
        }
        this.getEntryPointsManager().addEntryPoint(file, false);
    }

    public EntryPointsManager getEntryPointsManager() {
        EntryPointsManager entryPointsManager = this.myEntryPointsManager;
        if (entryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = entryPointsManager = new EntryPointsManagerBase(project){

                public void configureAnnotations() {
                }
            };
            Disposer.register((Disposable)project, (Disposable)entryPointsManager);
            ((EntryPointsManagerBase)entryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project));
        }
        return entryPointsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaManagerImpl";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaManagerImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedElement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractExternalFileImplicitReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRefElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementContainer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedElement";
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "belongsToScope";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onEntityInitialized";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessExternalFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalFileImplicitReferences";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "markExternalReferencesProcessed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyJavaElementVisitor
    extends AbstractUastNonRecursiveVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();
        private final ExternalAnnotationsManager myExternalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)RefJavaManagerImpl.access$100(RefJavaManagerImpl.this).getProject());

        private MyJavaElementVisitor() {
        }

        public boolean visitFile(@NotNull UFile node) {
            RefElement refElement;
            if (node == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(0);
            }
            if ((refElement = RefJavaManagerImpl.this.myRefManager.getReference(node.getSourcePsi())) instanceof RefJavaFileImpl) {
                ((RefJavaFileImpl)refElement).buildReferences();
            }
            return true;
        }

        public boolean visitDeclaration(@NotNull UDeclaration node) {
            PsiAnnotation externalAnnotation;
            UAnnotation uAnnotation2;
            PsiModifierListOwner javaModifiersListOwner;
            if (node == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(1);
            }
            this.processComments((UElement)node);
            RefElement decl = RefJavaManagerImpl.this.myRefManager.getReference(node.getSourcePsi());
            if (decl != null) {
                ((RefElementImpl)decl).buildReferences();
            }
            if ((javaModifiersListOwner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)node.getJavaPsi(), PsiModifierListOwner.class)) != null && (uAnnotation2 = (UAnnotation)UastContextKt.toUElement((PsiElement)(externalAnnotation = this.myExternalAnnotationsManager.findExternalAnnotation(javaModifiersListOwner, "java.lang.SuppressWarnings")), UAnnotation.class)) != null) {
                this.retrieveSuppressions(uAnnotation2, (UAnnotated)node);
            }
            return true;
        }

        public boolean visitField(@NotNull UField node) {
            if (node == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(2);
            }
            this.visitDeclaration((UDeclaration)node);
            return false;
        }

        public boolean visitVariable(@NotNull UVariable variable) {
            RefElement reference;
            if (variable == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(3);
            }
            this.myRefUtil.addTypeReference((UElement)variable, variable.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            if (variable instanceof UParameter && (reference = RefJavaManagerImpl.this.myRefManager.getReference(variable.getSourcePsi())) instanceof RefParameterImpl) {
                ((RefParameterImpl)reference).buildReferences();
            }
            return false;
        }

        public boolean visitAnnotation(@NotNull UAnnotation annotation) {
            String qualifiedName;
            if (annotation == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(4);
            }
            if (Comparing.strEqual((String)(qualifiedName = annotation.getQualifiedName()), (String)"java.lang.SuppressWarnings") || Comparing.strEqual((String)qualifiedName, (String)"kotlin.Suppress")) {
                PsiElement sourcePsi;
                UElement parent;
                UAnnotated annotated = (UAnnotated)UastUtils.getParentOfType((UElement)annotation, UAnnotated.class);
                if (annotated == null && (parent = annotation.getUastParent()) == null && (sourcePsi = annotation.getSourcePsi()) != null) {
                    annotated = (UAnnotated)UastContextKt.toUElement((PsiElement)sourcePsi.getContainingFile(), UFile.class);
                }
                this.retrieveSuppressions(annotation, annotated);
            }
            return false;
        }

        private void retrieveSuppressions(UAnnotation annotation, UAnnotated annotated) {
            if (annotated != null) {
                PsiElement annotatedSrc = annotated.getSourcePsi();
                WritableRefElement element = (WritableRefElement)RefJavaManagerImpl.this.myRefManager.getReference(annotatedSrc);
                if (element != null) {
                    StringBuilder buf = new StringBuilder();
                    List nameValuePairs = annotation.getAttributeValues();
                    for (UNamedExpression nameValuePair : nameValuePairs) {
                        UExpression value2 = nameValuePair.getExpression();
                        if (value2 instanceof ULiteralExpression) {
                            Object val = ((ULiteralExpression)value2).getValue();
                            if (!(val instanceof String)) continue;
                            buf.append(",").append(String.valueOf(val).replaceAll("[{}\"\"]", ""));
                            continue;
                        }
                        if (!(value2 instanceof UCallExpression) || ((UCallExpression)value2).getKind() != UastCallKind.NESTED_ARRAY_INITIALIZER) continue;
                        for (UExpression argument : ((UCallExpression)value2).getValueArguments()) {
                            Object val;
                            if (!(argument instanceof ULiteralExpression) || !((val = ((ULiteralExpression)argument).getValue()) instanceof String)) continue;
                            buf.append(",").append(val);
                        }
                    }
                    if (buf.length() > 0) {
                        String suppressId = buf.substring(1);
                        element.addSuppression(suppressId);
                        if (annotatedSrc instanceof PsiField) {
                            this.addSuppressionsForSiblings((PsiField)annotatedSrc, suppressId);
                        }
                    }
                }
            }
        }

        private void processComments(@NotNull UElement node) {
            if (node == null) {
                MyJavaElementVisitor.$$$reportNull$$$0(5);
            }
            for (UComment comment : node.getComments()) {
                PsiDocTag[] tags;
                PsiElement psi;
                if (!(comment instanceof UComment) || !((psi = comment.getSourcePsi()) instanceof PsiDocComment)) continue;
                for (PsiDocTag tag : tags = ((PsiDocComment)psi).getTags()) {
                    WritableRefElement element;
                    PsiModifierListOwner listOwner;
                    Object[] dataElements;
                    if (!Comparing.strEqual((String)tag.getName(), (String)"noinspection") || (dataElements = tag.getDataElements()).length <= 0 || (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psi, PsiModifierListOwner.class)) == null || (element = (WritableRefElement)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) == null) continue;
                    String suppression = StringUtil.join((Object[])dataElements, PsiElement::getText, (String)",");
                    element.addSuppression(suppression);
                }
            }
        }

        private void addSuppressionsForSiblings(PsiField listOwner, String suppressId) {
            PsiElement psiElement;
            PsiField field = listOwner;
            while ((psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)field)) != null && JavaTokenType.COMMA.equals(psiElement.getNode().getElementType()) && (psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psiElement)) instanceof PsiField) {
                field = (PsiField)psiElement;
                RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)field);
                if (refElement == null) continue;
                ((WritableRefElement)refElement).addSuppression(suppressId);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaManagerImpl$MyJavaElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processComments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

