/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.lambdaToExplicit.LambdaAndExplicitMethodPair;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitArgumentCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExplicitArgumentCanBeLambdaInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ExplicitArgumentCanBeLambdaInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                for (LambdaAndExplicitMethodPair info : LambdaAndExplicitMethodPair.INFOS) {
                    PsiExpression arg = info.getLambdaCandidateFromExplicitCall(call);
                    if (arg == null || arg instanceof PsiEmptyExpressionImpl || ExpressionUtils.isSafelyRecomputableExpression(arg)) continue;
                    holder.registerProblem((PsiElement)arg, "Explicit argument can be converted to lambda", new LocalQuickFix[]{new ConvertExplicitCallToLambdaFix(info, info.getLambdaMethodName(call))});
                    return;
                }
            }
        };
        if (javaElementVisitor == null) {
            ExplicitArgumentCanBeLambdaInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertExplicitCallToLambdaFix
    implements LocalQuickFix {
        private final LambdaAndExplicitMethodPair myInfo;
        private final String myName;

        ConvertExplicitCallToLambdaFix(LambdaAndExplicitMethodPair info, String name) {
            this.myInfo = info;
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression arg;
            if (project == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(3);
            }
            if ((arg = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)arg, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            Object[] args = call.getArgumentList().getExpressions();
            int idx = ArrayUtil.indexOf((Object[])args, (Object)arg);
            if (idx < 0) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myName);
            String lambdaText = this.myInfo.makeLambda(arg);
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(lambdaText, (PsiElement)arg));
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection$ConvertExplicitCallToLambdaFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection$ConvertExplicitCallToLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

