/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.DummyEntryPointsEP;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    private final Map<RefEntity, UnusedDeclarationHint> myFixedElements;
    private final Set<RefEntity> myExcludedElements;
    private WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    private final AtomicNotNullLazyValue<InspectionToolWrapper> myDummyWrapper;
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    final QuickFixAction[] myQuickFixActions;
    private static final String DELETE_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    private static final String COMMENT_OUT_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);

    public UnusedDeclarationPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(1);
        }
        super(toolWrapper, context);
        this.myFixedElements = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myExcludedElements = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myDummyWrapper = new AtomicNotNullLazyValue<InspectionToolWrapper>(){

            @NotNull
            protected InspectionToolWrapper compute() {
                GlobalInspectionToolWrapper toolWrapper = new GlobalInspectionToolWrapper((InspectionEP)new DummyEntryPointsEP());
                toolWrapper.initialize((GlobalInspectionContext)UnusedDeclarationPresentation.this.myContext);
                GlobalInspectionToolWrapper globalInspectionToolWrapper = toolWrapper;
                if (globalInspectionToolWrapper == null) {
                    1.$$$reportNull$$$0(0);
                }
                return globalInspectionToolWrapper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$1", "compute"));
            }
        };
        this.myQuickFixActions = this.createQuickFixes(toolWrapper);
        ((EntryPointsManagerBase)this.getEntryPointsManager()).setAddNonJavaEntries(this.getTool().ADD_NONJAVA_TO_ENTRIES);
    }

    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new WeakUnreferencedFilter(this.getTool(), this.getContext());
        }
        return this.myFilter;
    }

    @NotNull
    private UnusedDeclarationInspectionBase getTool() {
        UnusedDeclarationInspectionBase unusedDeclarationInspectionBase = (UnusedDeclarationInspectionBase)this.getToolWrapper().getTool();
        if (unusedDeclarationInspectionBase == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(2);
        }
        return unusedDeclarationInspectionBase;
    }

    @NotNull
    public DeadHTMLComposer getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer((InspectionToolPresentation)this);
        }
        DeadHTMLComposer deadHTMLComposer = this.myComposer;
        if (deadHTMLComposer == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(3);
        }
        return deadHTMLComposer;
    }

    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(4);
        }
        return this.myExcludedElements.contains(entity);
    }

    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(5);
        }
        this.myExcludedElements.remove(element);
    }

    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(6);
        }
        this.myExcludedElements.add(element);
    }

    public void exportResults(@NotNull Consumer<org.jdom.Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptions) {
        if (resultConsumer == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(7);
        }
        if (refEntity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(8);
        }
        if (excludedDescriptions == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(9);
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return;
        }
        RefFilter filter = this.getFilter();
        if (!this.myFixedElements.containsKey(refEntity) && filter.accepts((RefJavaElement)refEntity)) {
            refEntity = this.getRefManager().getRefinedElement(refEntity);
            if (!refEntity.isValid()) {
                return;
            }
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (!UnusedDeclarationPresentation.compareVisibilities(refElement, this.getTool().getSharedLocalInspectionTool())) {
                return;
            }
            if (this.skipEntryPoints(refElement)) {
                return;
            }
            org.jdom.Element element = refEntity.getRefManager().export(refEntity, -1);
            if (element == null) {
                return;
            }
            org.jdom.Element problemClassElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            HighlightSeverity severity = this.getSeverity((RefElement)refElement);
            String attributeKey = HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", attributeKey);
            problemClassElement.addContent(InspectionsBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
            element.addContent(problemClassElement);
            org.jdom.Element hintsElement = new org.jdom.Element("hints");
            for (UnusedDeclarationHint hint : UnusedDeclarationHint.values()) {
                org.jdom.Element hintElement = new org.jdom.Element("hint");
                hintElement.setAttribute("value", hint.toString().toLowerCase());
                hintsElement.addContent(hintElement);
            }
            element.addContent(hintsElement);
            org.jdom.Element descriptionElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
            StringBuffer buf = new StringBuffer();
            DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
            descriptionElement.addContent(buf.toString());
            element.addContent(descriptionElement);
            resultConsumer.accept(element);
        }
        super.exportResults(resultConsumer, refEntity, excludedDescriptions);
    }

    @NotNull
    public QuickFixAction[] getQuickFixes(RefEntity ... refElements) {
        if (refElements == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(10);
        }
        QuickFixAction[] quickFixActionArray = Arrays.stream(refElements).anyMatch(element -> element instanceof RefJavaElement && this.getFilter().accepts((RefJavaElement)element) && !this.myFixedElements.containsKey(element) && element.isValid()) ? this.myQuickFixActions : QuickFixAction.EMPTY;
        if (quickFixActionArray == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(11);
        }
        return quickFixActionArray;
    }

    @NotNull
    private QuickFixAction[] createQuickFixes(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(12);
        }
        QuickFixAction[] quickFixActionArray = new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBin(toolWrapper), new MoveToEntries(toolWrapper)};
        if (quickFixActionArray == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(13);
        }
        return quickFixActionArray;
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            String date = DateFormatUtil.formatDateTime((Date)new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    public void patchToolNode(@NotNull InspectionTreeNode node, @NotNull InspectionRVContentProvider provider, boolean showStructure, boolean groupByStructure) {
        if (node == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(14);
        }
        if (provider == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(15);
        }
        InspectionTreeModel model = this.myContext.getView().getTree().getInspectionTreeModel();
        EntryPointsNode epNode = (EntryPointsNode)model.createCustomNode(this.myDummyWrapper.getValue(), () -> new EntryPointsNode((InspectionToolWrapper)this.myDummyWrapper.getValue(), this.myContext, node), node);
        InspectionToolPresentation presentation = this.myContext.getPresentation((InspectionToolWrapper)this.myDummyWrapper.getValue());
        presentation.updateContent();
        provider.appendToolNodeContent(this.myContext, (InspectionToolWrapper)this.myDummyWrapper.getValue(), (InspectionTreeNode)epNode, showStructure, groupByStructure);
    }

    @NotNull
    public RefElementNode createRefNode(@Nullable RefEntity entity, @NotNull InspectionTreeModel model, @NotNull InspectionTreeNode parent) {
        if (model == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(17);
        }
        RefElementNode refElementNode = new RefElementNode(entity, (InspectionToolPresentation)this, parent){

            @Nullable
            public String getTailText() {
                UnusedDeclarationHint hint = (UnusedDeclarationHint)((Object)UnusedDeclarationPresentation.this.myFixedElements.get(this.getElement()));
                if (hint != null) {
                    return hint.getDescription();
                }
                return super.getTailText();
            }

            public boolean isQuickFixAppliedFromView() {
                return UnusedDeclarationPresentation.this.myFixedElements.containsKey(this.getElement());
            }
        };
        if (refElementNode == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(18);
        }
        return refElementNode;
    }

    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myFixedElements.containsKey(entity);
    }

    public synchronized void updateContent() {
        this.getTool().checkForReachableRefs((GlobalInspectionContext)this.getContext());
        this.myContents.clear();
        final UnusedSymbolLocalInspectionBase localInspectionTool = this.getTool().getSharedLocalInspectionTool();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (!UnusedDeclarationPresentation.compareVisibilities(refElement, localInspectionTool)) {
                    return;
                }
                if ((!UnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !UnusedDeclarationPresentation.this.myFixedElements.containsKey(refElement) && !UnusedDeclarationPresentation.this.isExcluded(refEntity) && !UnusedDeclarationPresentation.this.isSuppressed((RefEntity)refElement)) && refElement.isValid() && UnusedDeclarationPresentation.this.getFilter().accepts(refElement)) {
                    if (UnusedDeclarationPresentation.this.skipEntryPoints(refElement)) {
                        return;
                    }
                    UnusedDeclarationPresentation.this.registerContentEntry(refEntity, RefJavaUtil.getInstance().getPackageName(refEntity));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$3", "visitElement"));
            }
        });
        this.updateProblemElements();
    }

    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return this.getTool().isEntryPoint((RefElement)refElement);
    }

    @PsiModifier.ModifierConstant
    private static String getAcceptedVisibility(UnusedSymbolLocalInspectionBase tool, RefJavaElement element) {
        if (element instanceof RefImplicitConstructor) {
            element = ((RefImplicitConstructor)element).getOwnerClass();
        }
        if (element instanceof RefClass) {
            return element.getOwner() instanceof RefClass ? tool.getInnerClassVisibility() : tool.getClassVisibility();
        }
        if (element instanceof RefField) {
            return tool.getFieldVisibility();
        }
        if (element instanceof RefMethod) {
            PsiElement psi;
            String methodVisibility = tool.getMethodVisibility();
            if (methodVisibility != null && tool.isIgnoreAccessors() && (psi = element.getPsiElement()) instanceof PsiMethod && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)psi))) {
                return null;
            }
            return methodVisibility;
        }
        if (element instanceof RefParameter) {
            return tool.getParameterVisibility();
        }
        return "public";
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, UnusedSymbolLocalInspectionBase localInspectionTool) {
        return UnusedDeclarationPresentation.compareVisibilities(listOwner, UnusedDeclarationPresentation.getAcceptedVisibility(localInspectionTool, listOwner));
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, String acceptedVisibility) {
        if (acceptedVisibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)listOwner.getAccessModifier(), (String)acceptedVisibility) >= 0) {
                    return true;
                }
                RefEntity parent = listOwner.getOwner();
                if (!(parent instanceof RefJavaElement)) break;
                listOwner = (RefJavaElement)parent;
            }
        }
        return false;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] descriptors;
        if (refEntity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(19);
        }
        RefEntity owner = refEntity;
        if (refEntity instanceof RefParameter) {
            owner = refEntity.getOwner();
        }
        if ((descriptors = (CommonProblemDescriptor[])this.getProblemElements().get((Object)owner)) != null) {
            PsiElement psiElement = (PsiElement)ReadAction.compute(() -> ((RefElement)refEntity).getPsiElement());
            ArrayList<CommonProblemDescriptor> foreignDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                PsiElement problemElement;
                if (descriptor instanceof ProblemDescriptor && (problemElement = (PsiElement)ReadAction.compute(() -> {
                    PsiElement element = ((ProblemDescriptor)descriptor).getPsiElement();
                    if (element instanceof PsiIdentifier) {
                        element = element.getParent();
                    }
                    return element;
                })) == psiElement) continue;
                foreignDescriptors.add(descriptor);
            }
            if (foreignDescriptors.size() == descriptors.length) {
                return;
            }
        }
        super.ignoreElement(owner);
    }

    public void cleanup() {
        super.cleanup();
        this.myFixedElements.clear();
    }

    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, String hint) {
        if (descriptor == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(20);
        }
        if (entity instanceof RefElement) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix((RefElement)entity);
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix((RefElement)entity);
            }
            if (entity instanceof RefParameter) {
                return super.findQuickFixes(descriptor, entity, hint);
            }
        }
        return null;
    }

    @NotNull
    public JComponent getCustomPreviewPanel(@NotNull RefEntity entity) {
        if (entity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(21);
        }
        final Project project = entity.getRefManager().getProject();
        JEditorPane htmlView = new JEditorPane(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                String objectPackage;
                HTMLDocument hdoc;
                Element e;
                AttributeSet a;
                SimpleAttributeSet value2;
                int pos = this.viewToModel(evt.getPoint());
                if (pos >= 0 && (value2 = (SimpleAttributeSet)(a = (e = (hdoc = (HTMLDocument)this.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null && (objectPackage = (String)value2.getAttribute("qualifiedname")) != null) {
                    return objectPackage;
                }
                return null;
            }
        };
        htmlView.setContentType("text/html");
        htmlView.setEditable(false);
        htmlView.setOpaque(false);
        htmlView.setBackground(UIUtil.getLabelBackground());
        htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                if (url == null) {
                    return;
                }
                String ref = url.getRef();
                int offset = Integer.parseInt(ref);
                String fileURL = url.toExternalForm();
                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                if (vFile == null) {
                    vFile = VfsUtil.findFileByURL((URL)url);
                }
                if (vFile != null) {
                    Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, vFile, offset);
                    descriptor.navigate(true);
                }
            }
        });
        StyleSheet css = ((HTMLEditorKit)htmlView.getEditorKit()).getStyleSheet();
        css.addRule("p.problem-description-group {text-indent: " + JBUI.scale((int)9) + "px;font-weight:bold;}");
        css.addRule("div.problem-description {margin-left: " + JBUI.scale((int)9) + "px;}");
        css.addRule("ul {margin-left:" + JBUI.scale((int)10) + "px;text-indent: 0}");
        css.addRule("code {font-family:" + UIUtil.getLabelFont().getFamily() + "}");
        StringBuffer buf = new StringBuffer();
        this.getComposer().compose(buf, entity, false);
        String text2 = buf.toString();
        SingleInspectionProfilePanel.readHTML((JEditorPane)htmlView, (String)SingleInspectionProfilePanel.toHTML((JEditorPane)htmlView, (String)text2, (boolean)false));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)htmlView, (boolean)true);
        if (jScrollPane == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(22);
        }
        return jScrollPane;
    }

    public boolean showProblemCount() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefNode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 18: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchToolNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRefNode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPreviewPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 13: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PermanentDeleteFix
    implements QuickFix {
        private final RefElement myElement;

        private PermanentDeleteFix(@Nullable RefElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            String string = DELETE_QUICK_FIX;
            if (string == null) {
                PermanentDeleteFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                PermanentDeleteFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PermanentDeleteFix.$$$reportNull$$$0(2);
            }
            if (this.myElement != null && this.myElement.isValid()) {
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{this.myElement.getPsiElement()}, (boolean)false);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CommentOutFix
    implements QuickFix {
        private final RefElement myElement;

        private CommentOutFix(RefElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            String string = COMMENT_OUT_QUICK_FIX;
            if (string == null) {
                CommentOutFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                CommentOutFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CommentOutFix.$$$reportNull$$$0(2);
            }
            if (this.myElement != null && (element = this.myElement.getPsiElement()) != null) {
                UnusedDeclarationPresentation.commentOutDead(element);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class CommentOutBin
    extends QuickFixAction {
        CommentOutBin(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                CommentOutBin.$$$reportNull$$$0(0);
            }
            super(COMMENT_OUT_QUICK_FIX, null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), toolWrapper);
        }

        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                CommentOutBin.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            RefFilter filter = UnusedDeclarationPresentation.this.getFilter();
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
                if (psiElement == null || filter.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                RefEntity owner = refElement.getOwner();
                if (!(owner instanceof RefJavaElement) || filter.getElementProblemCount((RefJavaElement)owner) == 0 || ArrayUtil.find((Object[])refElements, (Object)owner) <= -1) {
                    UnusedDeclarationPresentation.commentOutDead(psiElement);
                }
                refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            for (RefElement ref : deletedRefs) {
                UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.COMMENT);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutBin";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class MoveToEntries
    extends QuickFixAction {
        MoveToEntries(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                MoveToEntries.$$$reportNull$$$0(0);
            }
            super(InspectionsBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveToEntries.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabledAndVisible()) {
                RefEntity[] elements;
                for (RefEntity element : elements = MoveToEntries.getInvoker((AnActionEvent)e).getTree().getSelectedElements()) {
                    if (((RefElement)element).isEntry()) continue;
                    return;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                MoveToEntries.$$$reportNull$$$0(2);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.addEntryPoint((RefElement)refElement, true);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$MoveToEntries";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                PermanentDeleteAction.$$$reportNull$$$0(0);
            }
            super(DELETE_QUICK_FIX, AllIcons.Actions.Cancel, null, toolWrapper);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("SafeDelete"));
        }

        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                PermanentDeleteAction.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            RefElement[] filteredRefElements = (RefElement[])Arrays.stream(refElements).filter(entry -> entry instanceof RefJavaElement && UnusedDeclarationPresentation.this.getFilter().accepts((RefJavaElement)entry)).toArray(RefElement[]::new);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = UnusedDeclarationPresentation.this.getContext().getProject();
                if (UnusedDeclarationPresentation.this.isDisposed() || project.isDisposed()) {
                    return;
                }
                Set classes2 = Arrays.stream(filteredRefElements).filter(refElement -> refElement instanceof RefClass).collect(Collectors.toSet());
                PsiElement[] elements = (PsiElement[])Arrays.stream(filteredRefElements).filter(e -> {
                    RefEntity owner = e.getOwner();
                    return owner == null || !classes2.contains(owner);
                }).map(e -> e.getPsiElement()).filter(e -> e != null).toArray(PsiElement[]::new);
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])elements, (boolean)false, () -> {
                    PermanentDeleteAction.removeElements((RefEntity[])filteredRefElements, (Project)project, (InspectionToolWrapper)this.myToolWrapper);
                    for (RefElement ref : filteredRefElements) {
                        UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.DELETE);
                    }
                });
            });
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContextImpl context) {
            if (tool == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(1);
            }
            super(tool, (GlobalInspectionContext)context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount;
            if (refElement == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(2);
            }
            if ((problemCount = super.getElementProblemCount(refElement)) > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            for (RefElement element : refElement.getInReferences()) {
                if (refElement instanceof RefFile) {
                    return 1;
                }
                if (!((UnusedDeclarationInspectionBase)this.myTool).isEntryPoint(element)) continue;
                return 1;
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$WeakUnreferencedFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementProblemCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum UnusedDeclarationHint {
        COMMENT("Commented out"),
        DELETE("Deleted");

        private final String myDescription;

        private UnusedDeclarationHint(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

