/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialFieldValue {
    @NotNull
    private final SpecialField myField;
    @NotNull
    private final DfaValue myValue;

    public SpecialFieldValue(@NotNull SpecialField field, @NotNull DfaValue value2) {
        if (field == null) {
            SpecialFieldValue.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            SpecialFieldValue.$$$reportNull$$$0(1);
        }
        if (value2 instanceof DfaFactMapValue) {
            this.myValue = ((DfaFactMapValue)value2).withFact(DfaFactType.SPECIAL_FIELD_VALUE, null);
        } else if (value2 instanceof DfaConstValue) {
            this.myValue = value2;
        } else {
            throw new IllegalArgumentException("Unexpected value: " + value2);
        }
        this.myField = field;
    }

    @NotNull
    public SpecialField getField() {
        SpecialField specialField = this.myField;
        if (specialField == null) {
            SpecialFieldValue.$$$reportNull$$$0(2);
        }
        return specialField;
    }

    @NotNull
    public DfaValue getValue() {
        DfaValue dfaValue = this.myValue;
        if (dfaValue == null) {
            SpecialFieldValue.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecialFieldValue)) {
            return false;
        }
        SpecialFieldValue value2 = (SpecialFieldValue)o;
        return this.myField == value2.myField && this.myValue == value2.myValue;
    }

    @Nullable
    public SpecialFieldValue unite(SpecialFieldValue other) {
        if (other == this) {
            return this;
        }
        if (this.myField != other.myField) {
            return null;
        }
        DfaValue newValue = this.myValue.unite(other.myValue);
        if (newValue instanceof DfaConstValue || newValue instanceof DfaFactMapValue) {
            return new SpecialFieldValue(this.myField, newValue);
        }
        return null;
    }

    public int hashCode() {
        return this.myField.hashCode() * 31 + Objects.hashCode(this.myValue);
    }

    public String toString() {
        return this.myField + " = " + this.myValue;
    }

    public String getPresentationText(PsiType type2) {
        return this.myField.getPresentationText(this.myValue, type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/SpecialFieldValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/SpecialFieldValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

