/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DataFlowInstructionVisitor
extends StandardInstructionVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowInstructionVisitor");
    private final Map<NullabilityProblemKind.NullabilityProblem<?>, StateInfo> myStateInfos = new LinkedHashMap();
    private final Set<TypeCastInstruction> myCCEInstructions = ContainerUtil.newHashSet();
    private final Map<PsiCallExpression, Boolean> myFailingCalls = new HashMap<PsiCallExpression, Boolean>();
    private final Map<PsiExpression, ConstantResult> myConstantExpressions = new HashMap<PsiExpression, ConstantResult>();
    private final Map<PsiElement, ThreeState> myOfNullableCalls = new HashMap<PsiElement, ThreeState>();
    private final Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> myArrayStoreProblems = new HashMap<PsiAssignmentExpression, Pair<PsiType, PsiType>>();
    private final Map<PsiMethodReferenceExpression, DfaValue> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DfaValue>();
    private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
    private final Set<PsiElement> myReceiverMutabilityViolation = new HashSet<PsiElement>();
    private final Set<PsiElement> myArgumentMutabilityViolation = new HashSet<PsiElement>();
    private final Map<PsiExpression, Boolean> mySameValueAssigned = new HashMap<PsiExpression, Boolean>();
    private final Map<PsiReferenceExpression, Boolean> mySameArguments = new HashMap<PsiReferenceExpression, Boolean>();
    private boolean myAlwaysReturnsNotNull = true;
    private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();
    private static final CallMatcher USELESS_SAME_ARGUMENTS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Integer", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Long", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Float", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Double", "min", "max").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "replace").parameterCount(2));

    DataFlowInstructionVisitor() {
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression left = instruction.getLExpression();
        if (left != null && !Boolean.FALSE.equals(this.mySameValueAssigned.get(left)) && !TypeUtils.isJavaLangString(left.getType())) {
            if (!left.isPhysical()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Non-physical element in assignment instruction: " + left.getParent().getText(), new Throwable());
                }
            } else {
                DfaValue value2 = memState.peek();
                DfaValue target = memState.getStackValue(1);
                if (!(target == null || !memState.areEqual(value2, target) || value2 instanceof DfaConstValue && DataFlowInstructionVisitor.isFloatingZero(((DfaConstValue)value2).getValue()) || DataFlowInstructionVisitor.isAssignmentToDefaultValueInConstructor(instruction, runner, target))) {
                    this.mySameValueAssigned.merge(left, Boolean.TRUE, Boolean::logicalAnd);
                } else {
                    this.mySameValueAssigned.put(left, Boolean.FALSE);
                }
            }
        }
        return super.visitAssign(instruction, runner, memState);
    }

    private static boolean isAssignmentToDefaultValueInConstructor(AssignInstruction instruction, DataFlowRunner runner, DfaValue target) {
        boolean isDefaultValue;
        if (!(target instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)target;
        if (!(var.getPsiVariable() instanceof PsiField) || var.getQualifier() == null || !(var.getQualifier().getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor)) {
            return false;
        }
        PsiExpression rExpression = instruction.getRExpression();
        while (rExpression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)rExpression).getOperationTokenType().equals(JavaTokenType.EQ)) {
            rExpression = ((PsiAssignmentExpression)rExpression).getRExpression();
        }
        if (rExpression == null) {
            return false;
        }
        DfaValue dest = runner.getFactory().createValue(rExpression);
        if (!(dest instanceof DfaConstValue)) {
            return false;
        }
        Object value2 = ((DfaConstValue)dest).getValue();
        PsiType type2 = var.getType();
        boolean bl = isDefaultValue = Objects.equals(PsiTypesUtil.getDefaultValue((PsiType)type2), value2) || Long.valueOf(0L).equals(value2) && TypeConversionUtil.isIntegralNumberType((PsiType)type2);
        if (!isDefaultValue) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)rExpression, PsiMethod.class);
        return method != null && method.isConstructor();
    }

    private static boolean isFloatingZero(Object value2) {
        if (value2 instanceof Double) {
            return (Double)value2 == 0.0;
        }
        if (value2 instanceof Float) {
            return ((Float)value2).floatValue() == 0.0f;
        }
        return false;
    }

    StreamEx<PsiExpression> sameValueAssignments() {
        return StreamEx.ofKeys(this.mySameValueAssigned, Boolean::booleanValue);
    }

    StreamEx<PsiReferenceExpression> pointlessSameArguments() {
        return StreamEx.ofKeys(this.mySameArguments, Boolean::booleanValue);
    }

    @Override
    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
        this.myCCEInstructions.add(instruction);
    }

    StreamEx<NullabilityProblemKind.NullabilityProblem<?>> problems() {
        return StreamEx.ofKeys(this.myStateInfos, info -> info.normalNpe || info.ephemeralNpe && !info.normalOk);
    }

    public Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> getArrayStoreProblems() {
        return this.myArrayStoreProblems;
    }

    Map<PsiElement, ThreeState> getOfNullableCalls() {
        return this.myOfNullableCalls;
    }

    Map<PsiExpression, ConstantResult> getConstantExpressions() {
        return this.myConstantExpressions;
    }

    Map<PsiMethodReferenceExpression, DfaValue> getMethodReferenceResults() {
        return this.myMethodReferenceResults;
    }

    Set<TypeCastInstruction> getClassCastExceptionInstructions() {
        return this.myCCEInstructions;
    }

    Set<PsiElement> getMutabilityViolations(boolean receiver2) {
        return receiver2 ? this.myReceiverMutabilityViolation : this.myArgumentMutabilityViolation;
    }

    public List<DfaMemoryState> getEndOfInitializerStates() {
        return this.myEndOfInitializerStates;
    }

    Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
        return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, arg_0 -> ThreeState.YES.equals(arg_0));
    }

    StreamEx<PsiCallExpression> alwaysFailingCalls() {
        return StreamEx.ofKeys(this.myFailingCalls, v -> v);
    }

    boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
        return this.myAlwaysReturnsNotNull && ContainerUtil.exists((Object[])instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
    }

    @Override
    protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState memState) {
        Application application;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(1);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (!expression2.isPhysical() && ((application = ApplicationManager.getApplication()).isEAP() || application.isInternal() || application.isUnitTestMode())) {
            throw new IllegalStateException("Non-physical expression is passed");
        }
        expression2.accept((PsiElementVisitor)new ExpressionVisitor(value2, memState));
        if (range == null) {
            this.reportConstantExpressionValue(value2, memState, expression2);
        }
    }

    @Override
    protected void beforeMethodCall(@NotNull PsiExpression expression2, @NotNull DfaCallArguments arguments, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState memState) {
        PsiReferenceExpression reference;
        if (expression2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (runner == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(5);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(6);
        }
        if ((reference = USELESS_SAME_ARGUMENTS.getReferenceIfMatched(expression2)) != null) {
            this.mySameArguments.merge(reference, memState.areEqual(arguments.myArguments[0], arguments.myArguments[1]), Boolean::logicalAnd);
        }
    }

    @Override
    protected void beforeMethodReferenceResultPush(@NotNull DfaValue value2, @NotNull PsiMethodReferenceExpression methodRef, @NotNull DfaMemoryState state) {
        List<StandardMethodContract> contracts2;
        PsiMethod method;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(7);
        }
        if (methodRef == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(9);
        }
        if (OptionalUtil.OPTIONAL_OF_NULLABLE.methodReferenceMatches(methodRef)) {
            this.processOfNullableResult(value2, state, methodRef.getReferenceNameElement());
        }
        if ((method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class)) != null && ((contracts2 = JavaMethodContractUtil.getMethodContracts(method)).isEmpty() || !contracts2.get(0).isTrivial())) {
            this.myMethodReferenceResults.merge(methodRef, value2, (a, b) -> a == b ? a : DfaUnknownValue.getInstance());
        }
    }

    private void processOfNullableResult(@NotNull DfaValue value2, @NotNull DfaMemoryState memState, PsiElement anchor) {
        DfaValueFactory factory;
        DfaUnknownValue optionalValue;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(10);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(11);
        }
        DfaValue dfaValue = optionalValue = (factory = value2.getFactory()) == null ? DfaUnknownValue.getInstance() : SpecialField.OPTIONAL_VALUE.createValue(factory, value2);
        ThreeState present = memState.isNull(optionalValue) ? ThreeState.NO : (memState.isNotNull(optionalValue) ? ThreeState.YES : ThreeState.UNSURE);
        this.myOfNullableCalls.merge(anchor, present, ThreeState::merge);
    }

    @Override
    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
        this.myOutOfBoundsArrayAccesses.merge(expression2, ThreeState.fromBoolean((boolean)alwaysOutOfBounds), ThreeState::merge);
    }

    @Override
    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
        if (assignmentExpression != null) {
            this.myArrayStoreProblems.put(assignmentExpression, (Pair<PsiType, PsiType>)Pair.create((Object)fromType, (Object)toType));
        }
    }

    @Override
    public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        if (!instruction.isStatic()) {
            this.myEndOfInitializerStates.add(state.createCopy());
        }
        return super.visitEndOfInitializer(instruction, runner, state);
    }

    private static boolean hasNonTrivialFailingContracts(PsiCallExpression call) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(call);
        return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue().isFail() && !contract.isTrivial());
    }

    private void reportConstantExpressionValue(DfaValue value2, DfaMemoryState memState, PsiExpression expression2) {
        if (expression2 instanceof PsiLiteralExpression) {
            return;
        }
        ConstantResult curState = this.myConstantExpressions.get(expression2);
        if (curState == ConstantResult.UNKNOWN) {
            return;
        }
        ConstantResult nextState = ConstantResult.UNKNOWN;
        DfaConstValue dfaConst = memState.getConstantValue(value2);
        if (dfaConst != null) {
            nextState = ConstantResult.fromConstValue(dfaConst);
            if (curState != null && curState != nextState) {
                nextState = ConstantResult.UNKNOWN;
            }
        }
        this.myConstantExpressions.put(expression2, nextState);
    }

    @Override
    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (problem != null && problem.getKind() == NullabilityProblemKind.nullableReturn && !state.isNotNull(value2)) {
            this.myAlwaysReturnsNotNull = false;
        }
        boolean ok = super.checkNotNullable(state, value2, problem);
        if (problem == null) {
            return ok;
        }
        StateInfo info = this.myStateInfos.computeIfAbsent(problem, k -> new StateInfo());
        if (state.isEphemeral() && !ok) {
            info.ephemeralNpe = true;
        } else if (!state.isEphemeral()) {
            if (ok) {
                info.normalOk = true;
            } else {
                info.normalNpe = true;
            }
        }
        return ok;
    }

    @Override
    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(12);
        }
        if (receiver2) {
            if (anchor instanceof PsiMethodReferenceExpression) {
                anchor = ((PsiMethodReferenceExpression)anchor).getReferenceNameElement();
            } else if (anchor instanceof PsiMethodCallExpression) {
                anchor = ((PsiMethodCallExpression)anchor).getMethodExpression().getReferenceNameElement();
            }
            if (anchor != null) {
                this.myReceiverMutabilityViolation.add(anchor);
            }
        } else {
            this.myArgumentMutabilityViolation.add(anchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeExpressionPush";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMethodCall";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMethodReferenceResultPush";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processOfNullableResult";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMutabilityViolation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ConstantResult {
        TRUE,
        FALSE,
        NULL,
        UNKNOWN;


        @NotNull
        public String toString() {
            String string = this.name().toLowerCase(Locale.ENGLISH);
            if (string == null) {
                ConstantResult.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Object value() {
            switch (this) {
                case TRUE: {
                    return Boolean.TRUE;
                }
                case FALSE: {
                    return Boolean.FALSE;
                }
                case NULL: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        static ConstantResult fromConstValue(@NotNull DfaConstValue constant) {
            Object value2;
            if (constant == null) {
                ConstantResult.$$$reportNull$$$0(1);
            }
            if ((value2 = constant.getValue()) == null) {
                ConstantResult constantResult = NULL;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(2);
                }
                return constantResult;
            }
            if (Boolean.TRUE.equals(value2)) {
                ConstantResult constantResult = TRUE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(3);
                }
                return constantResult;
            }
            if (Boolean.FALSE.equals(value2)) {
                ConstantResult constantResult = FALSE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(4);
                }
                return constantResult;
            }
            ConstantResult constantResult = UNKNOWN;
            if (constantResult == null) {
                ConstantResult.$$$reportNull$$$0(5);
            }
            return constantResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor$ConstantResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor$ConstantResult";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromConstValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromConstValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ExpressionVisitor
    extends JavaElementVisitor {
        private final DfaValue myValue;
        private final DfaMemoryState myMemState;

        ExpressionVisitor(DfaValue value2, DfaMemoryState memState) {
            this.myValue = value2;
            this.myMemState = memState;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            if (OptionalUtil.OPTIONAL_OF_NULLABLE.test(call)) {
                DataFlowInstructionVisitor.this.processOfNullableResult(this.myValue, this.myMemState, (PsiElement)call.getArgumentList().getExpressions()[0]);
            }
        }

        public void visitCallExpression(PsiCallExpression call) {
            super.visitCallExpression(call);
            Boolean isFailing = (Boolean)DataFlowInstructionVisitor.this.myFailingCalls.get(call);
            if (isFailing != null || DataFlowInstructionVisitor.hasNonTrivialFailingContracts(call)) {
                DataFlowInstructionVisitor.this.myFailingCalls.put(call, DfaConstValue.isContractFail(this.myValue) && !Boolean.FALSE.equals(isFailing));
            }
        }
    }

    private static class StateInfo {
        boolean ephemeralNpe;
        boolean normalNpe;
        boolean normalOk;

        private StateInfo() {
        }
    }
}

