/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.ExitFinallyTransfer;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.ReturnTransfer;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.inliner.AssertAllInliner;
import com.intellij.codeInspection.dataFlow.inliner.AssumeInliner;
import com.intellij.codeInspection.dataFlow.inliner.BoxingInliner;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.inliner.ClassMethodsInliner;
import com.intellij.codeInspection.dataFlow.inliner.CollectionFactoryInliner;
import com.intellij.codeInspection.dataFlow.inliner.CollectionMethodInliner;
import com.intellij.codeInspection.dataFlow.inliner.LambdaInliner;
import com.intellij.codeInspection.dataFlow.inliner.MapUpdateInliner;
import com.intellij.codeInspection.dataFlow.inliner.OptionalChainInliner;
import com.intellij.codeInspection.dataFlow.inliner.SimpleMethodInliner;
import com.intellij.codeInspection.dataFlow.inliner.StreamChainInliner;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BoxingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PrimitiveConversionInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.instructions.UnwrapSpecialFieldInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    private static final CallMatcher LIST_INITIALIZER = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Arrays", "asList"), CallMatcher.staticCall("java.util.List", "of"));
    static final int MAX_UNROLL_SIZE = 3;
    private static final int MAX_ARRAY_INDEX_FOR_INITIALIZER = 32;
    private final PsiElement myCodeFragment;
    private final boolean myIgnoreAssertions;
    private final boolean myInlining;
    private final Project myProject;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private FList<Trap> myTrapStack;
    private final Map<PsiExpression, NullabilityProblemKind<? super PsiExpression>> myCustomNullabilityProblems;
    private final Map<String, ExceptionTransfer> myExceptionCache;
    private ExpressionBlockContext myExpressionBlockContext;
    static final CallInliner[] INLINERS = new CallInliner[]{new OptionalChainInliner(), new LambdaInliner(), new CollectionFactoryInliner(), new StreamChainInliner(), new MapUpdateInliner(), new AssumeInliner(), new ClassMethodsInliner(), new AssertAllInliner(), new BoxingInliner(), new SimpleMethodInliner(), new CollectionMethodInliner()};

    ControlFlowAnalyzer(DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean ignoreAssertions, boolean inlining) {
        if (codeFragment == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        this.myTrapStack = FList.emptyList();
        this.myCustomNullabilityProblems = new HashMap<PsiExpression, NullabilityProblemKind<? super PsiExpression>>();
        this.myInlining = inlining;
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myProject = codeFragment.getProject();
        this.myIgnoreAssertions = ignoreAssertions;
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myExceptionCache = FactoryMap.create(fqn -> new ExceptionTransfer(this.myFactory.createDfaType((PsiType)this.createClassType(scope, (String)fqn))));
    }

    private void buildClassInitializerFlow(PsiClass psiClass, boolean isStatic) {
        for (PsiElement element : psiClass.getChildren()) {
            if (!(element instanceof PsiField) || ((PsiField)element).hasInitializer() || ((PsiField)element).hasModifierProperty("static") != isStatic) continue;
            this.visitField((PsiField)element);
        }
        if (!isStatic && ImplicitUsageProvider.EP_NAME.getExtensionList().stream().anyMatch(p -> p.isClassWithCustomizedInitialization((PsiElement)psiClass))) {
            this.addInstruction(new EscapeInstruction(Collections.singleton(this.getFactory().getVarFactory().createThisValue(psiClass))));
            this.addInstruction(new FlushFieldsInstruction());
        }
        for (PsiElement element : psiClass.getChildren()) {
            if ((!(element instanceof PsiField) || !((PsiField)element).hasInitializer()) && !(element instanceof PsiClassInitializer) || ((PsiMember)element).hasModifierProperty("static") != isStatic) continue;
            element.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new EndOfInitializerInstruction(isStatic));
        this.addInstruction(new FlushFieldsInstruction());
    }

    @Nullable
    public ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            if (this.myCodeFragment instanceof PsiClass) {
                this.pushUnknown();
                ConditionalGotoInstruction conditionalGoto = new ConditionalGotoInstruction(null, false, null);
                this.addInstruction(conditionalGoto);
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, true);
                GotoInstruction unconditionalGoto = new GotoInstruction(null);
                this.addInstruction(unconditionalGoto);
                conditionalGoto.setOffset(this.getInstructionCount());
                this.buildClassInitializerFlow((PsiClass)this.myCodeFragment, false);
                unconditionalGoto.setOffset(this.getInstructionCount());
            } else {
                this.myCodeFragment.accept((PsiElementVisitor)this);
            }
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, (FList<Trap>)FList.emptyList()), null));
        if (Registry.is((String)"idea.dfa.live.variables.analysis")) {
            new LiveVariablesAnalyzer(this.myCurrentFlow, this.myFactory).flushDeadVariablesOnStatementFinish();
        }
        return this.myCurrentFlow;
    }

    DfaValueFactory getFactory() {
        return this.myFactory;
    }

    PsiElement getContext() {
        return this.myCodeFragment;
    }

    private PsiClassType createClassType(GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqn, scope);
    }

    <T extends Instruction> T addInstruction(T i) {
        this.myCurrentFlow.addInstruction(i);
        return i;
    }

    int getInstructionCount() {
        return this.myCurrentFlow.getInstructionCount();
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        assert (!(element instanceof PsiExpression) || element instanceof PsiSwitchExpression);
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        assert (!(element instanceof PsiExpression) || element instanceof PsiSwitchExpression);
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiField || element instanceof PsiStatement && !(element instanceof PsiReturnStatement) && !(element instanceof PsiSwitchLabeledRuleStatement)) {
            List<DfaVariableValue> synthetics = this.getSynthetics(element);
            FinishElementInstruction instruction = new FinishElementInstruction(element);
            instruction.getVarsToFlush().addAll(synthetics);
            this.addInstruction(instruction);
        }
    }

    @NotNull
    private List<DfaVariableValue> getSynthetics(PsiElement element) {
        int startOffset = this.getStartOffset(element).getInstructionOffset();
        ArrayList<DfaVariableValue> synthetics = new ArrayList<DfaVariableValue>();
        for (DfaValue value2 : this.myFactory.getValues()) {
            DfaVariableValue var;
            VariableDescriptor descriptor;
            if (!(value2 instanceof DfaVariableValue) || !((descriptor = (var = (DfaVariableValue)value2).getDescriptor()) instanceof Synthetic) || ((Synthetic)descriptor).myLocation < startOffset) continue;
            synthetics.add(var);
        }
        ArrayList<DfaVariableValue> arrayList = synthetics;
        if (arrayList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        PsiExpression lExpr = expression2.getLExpression();
        PsiExpression rExpr = expression2.getRExpression();
        this.startElement((PsiElement)expression2);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiType type2 = expression2.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals((Object)type2);
        if (op == JavaTokenType.EQ) {
            lExpr.accept((PsiElementVisitor)this);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type2);
        } else if (op == JavaTokenType.ANDEQ && isBoolean) {
            this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.OREQ && isBoolean) {
            this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.XOREQ && isBoolean) {
            this.generateXorExpression((PsiExpression)expression2, new PsiExpression[]{lExpr, rExpr}, type2, true);
        } else if (op == JavaTokenType.PLUSEQ && type2 != null && type2.equalsToText("java.lang.String")) {
            lExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new DupInstruction());
            rExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, type2));
        } else {
            IElementType sign = TypeConversionUtil.convertEQtoOperation((IElementType)op);
            PsiType resType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lExpr.getType(), (PsiType)rExpr.getType(), (IElementType)sign, (boolean)true);
            lExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new DupInstruction());
            this.generateBoxingUnboxingInstructionFor(lExpr, resType);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, resType);
            sign = this.substituteBinaryOperation(rExpr, sign);
            if (ControlFlowAnalyzer.isAssignmentDivision(op) && resType != null && PsiType.LONG.isAssignableFrom(resType)) {
                this.checkZeroDivisor();
            }
            this.addInstruction(new BinopInstruction(sign, (PsiExpression)(expression2.isPhysical() ? expression2 : null), resType));
            this.generateBoxingUnboxingInstructionFor(rExpr, resType, type2);
        }
        this.addInstruction(new AssignInstruction(rExpr, this.myFactory.createValue(lExpr)));
        this.finishElement((PsiElement)expression2);
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, (PsiElement)condition2));
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.throwException(this.myExceptionCache.get("java.lang.AssertionError"), (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                this.handleEscapedVariables(element);
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.startElement((PsiElement)field);
            this.initializeVariable((PsiVariable)field, initializer);
            this.finishElement((PsiElement)field);
        } else if (!field.hasModifierProperty("final") && !UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
            DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)field);
            DfaConstValue value2 = this.myFactory.getConstFactory().createDefault(field.getType());
            new CFGBuilder(this).assignAndPop(dfaVariable, value2);
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        this.visitCodeBlock(initializer.getBody());
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        if (DfaUtil.ignoreInitializer(variable)) {
            return;
        }
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable);
        this.addInstruction(new PushInstruction(dfaVariable, initializer, true));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer, dfaVariable));
        this.addInstruction(new PopInstruction());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression2;
        this.startElement((PsiElement)codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression2 = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement((PsiElement)block);
        for (PsiStatement statement : block.getStatements()) {
            statement.accept((PsiElementVisitor)this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement((PsiElement)block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement : block.getStatements()) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration2 : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                                if (!(declaration2 instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration2);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable((PsiVariable)((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable((PsiVariable)((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement = ((PsiForStatement)parent).getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration3 : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaration3 instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration3);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)resource);
                }
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement((PsiElement)statement);
        statement.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement((PsiElement)statement);
        PsiElement exitedElement = statement.findExitedElement();
        if (exitedElement instanceof PsiSwitchExpression && this.myExpressionBlockContext != null && this.myExpressionBlockContext.myCodeBlock == ((PsiSwitchExpression)exitedElement).getBody()) {
            this.myExpressionBlockContext.generateReturn(statement.getExpression(), this);
        } else {
            this.jumpOut(exitedElement);
        }
        this.finishElement((PsiElement)statement);
    }

    void addNullCheck(PsiExpression expression2) {
        this.addNullCheck(NullabilityProblemKind.fromContext(expression2, this.myCustomNullabilityProblems));
    }

    void addNullCheck(NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (problem != null) {
            DfaControlTransferValue transfer = this.shouldHandleException() && problem.thrownException() != null ? this.myFactory.controlTransfer(this.myExceptionCache.get(problem.thrownException()), this.myTrapStack) : null;
            this.addInstruction(new CheckNotNullInstruction(problem, transfer));
        }
    }

    private void jumpOut(PsiElement exitedStatement) {
        if (exitedStatement != null && PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)exitedStatement, (boolean)false)) {
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(exitedStatement), this.getVariablesInside(exitedStatement)), this.getTrapsInsideElement(exitedStatement));
        } else {
            this.controlTransfer(ReturnTransfer.INSTANCE, this.getTrapsInsideElement(this.myCodeFragment));
        }
    }

    private void controlTransfer(@NotNull TransferTarget target, FList<Trap> traps) {
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        this.addInstruction(new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    @NotNull
    private FList<Trap> getTrapsInsideElement(PsiElement element) {
        FList fList = FList.createFromReversed((Iterable)ContainerUtil.reverse((List)ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)cd.getAnchor(), (boolean)true))));
        if (fList == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        return fList;
    }

    @NotNull
    private List<DfaVariableValue> getVariablesInside(PsiElement exitedStatement) {
        List list = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)exitedStatement, PsiVariable.class), this.myFactory.getVarFactory()::createVariableValue);
        if (list == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement && PsiTreeUtil.isAncestor((PsiElement)this.myCodeFragment, (PsiElement)continuedStatement, (boolean)false)) {
            PsiStatement body2 = ((PsiLoopStatement)continuedStatement).getBody();
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)body2), this.getVariablesInside((PsiElement)body2)), this.getTrapsInsideElement((PsiElement)body2));
        } else {
            this.controlTransfer(ReturnTransfer.INSTANCE, this.getTrapsInsideElement(this.myCodeFragment));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 != null) {
                condition2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement), false, (PsiElement)condition2));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction(new PopInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions2 = statement.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    private DfaValue getIteratedElement(PsiType type2, PsiExpression iteratedValue2) {
        PsiElement arrayVar;
        PsiExpression[] expressions2 = null;
        if (iteratedValue2 instanceof PsiNewExpression) {
            PsiArrayInitializerExpression initializer = ((PsiNewExpression)iteratedValue2).getArrayInitializer();
            if (initializer != null) {
                expressions2 = initializer.getInitializers();
            }
        } else if (iteratedValue2 instanceof PsiReferenceExpression && (arrayVar = ((PsiReferenceExpression)iteratedValue2).resolve()) instanceof PsiVariable) {
            expressions2 = ExpressionUtils.getConstantArrayElements((PsiVariable)arrayVar);
        }
        if (iteratedValue2 instanceof PsiMethodCallExpression && LIST_INITIALIZER.test((PsiMethodCallExpression)iteratedValue2)) {
            expressions2 = ((PsiMethodCallExpression)iteratedValue2).getArgumentList().getExpressions();
        }
        return expressions2 == null ? DfaUnknownValue.getInstance() : this.getFactory().createCommonValue(expressions2, type2);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        PsiStatement body2;
        this.startElement((PsiElement)statement);
        PsiParameter parameter2 = statement.getIterationParameter();
        PsiExpression iteratedValue2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getIteratedValue());
        ControlFlow.ControlFlowOffset loopEndOffset = this.getEndOffset((PsiElement)statement);
        boolean hasSizeCheck = false;
        if (iteratedValue2 != null) {
            iteratedValue2.accept((PsiElementVisitor)this);
            PsiType type2 = iteratedValue2.getType();
            SpecialField length = null;
            if (type2 instanceof PsiArrayType) {
                length = SpecialField.ARRAY_LENGTH;
            } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection")) {
                length = SpecialField.COLLECTION_SIZE;
            }
            if (length != null) {
                this.addInstruction(new UnwrapSpecialFieldInstruction(length));
                this.addInstruction(new PushInstruction(this.myFactory.getInt(0), null));
                this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, (PsiType)PsiType.BOOLEAN));
                this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, false, null));
                hasSizeCheck = true;
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)parameter2);
        new CFGBuilder(this).assignAndPop(dfaVariable, this.getIteratedElement(parameter2.getType(), iteratedValue2));
        if (!hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        if ((body2 = statement.getBody()) != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if (hasSizeCheck) {
            this.pushUnknown();
            this.addInstruction(new ConditionalGotoInstruction(loopEndOffset, true, null));
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        this.myCurrentFlow.removeVariable((PsiVariable)parameter2);
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update2;
        PsiExpression condition2;
        this.startElement((PsiElement)statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    this.visitElement((PsiElement)expression2);
                }

                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition2 = statement.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition2));
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if (!this.addCountingLoopBound(statement) && (update2 = statement.getUpdate()) != null) {
            update2.accept((PsiElementVisitor)this);
        }
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    @Nullable
    private static Long asLong(PsiExpression expression2) {
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (value2 instanceof Integer || value2 instanceof Long) {
            return ((Number)value2).longValue();
        }
        return null;
    }

    private boolean addCountingLoopBound(PsiForStatement statement) {
        PsiVariable initialVariable;
        CountingLoop loop = CountingLoop.from(statement);
        if (loop == null || loop.isDescending()) {
            return false;
        }
        PsiLocalVariable counter = loop.getCounter();
        Long start = ControlFlowAnalyzer.asLong(loop.getInitializer());
        Long end = ControlFlowAnalyzer.asLong(loop.getBound());
        if (!(!loop.isIncluding() || PsiType.LONG.equals((Object)counter.getType()) && PsiType.INT.equals((Object)loop.getBound().getType()) || end != null && end != Long.MAX_VALUE && end != Integer.MAX_VALUE)) {
            return false;
        }
        PsiExpression initializer = loop.getInitializer();
        PsiType type2 = loop.getCounter().getType();
        if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
            return false;
        }
        DfaValue origin = null;
        Object initialValue = ExpressionUtils.computeConstantExpression(initializer);
        if (initialValue instanceof Number) {
            origin = this.myFactory.getConstFactory().createFromValue(initialValue, type2);
        } else if (initializer instanceof PsiReferenceExpression && ((initialVariable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)initializer).resolve(), PsiVariable.class)) instanceof PsiLocalVariable || initialVariable instanceof PsiParameter) && !VariableAccessUtils.variableIsAssigned(initialVariable, (PsiElement)statement.getBody())) {
            origin = this.myFactory.getVarFactory().createVariableValue(initialVariable);
        }
        if (origin == null) {
            return false;
        }
        long diff = start == null || end == null ? -1L : end - start;
        DfaVariableValue loopVar = this.myFactory.getVarFactory().createVariableValue((PsiVariable)counter);
        if (diff >= 0L && diff <= 3L) {
            this.addInstruction(new PushInstruction(loopVar, null, true));
            this.addInstruction(new PushInstruction(loopVar, null));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(1, (PsiType)PsiType.INT), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, loopVar.getType()));
            this.addInstruction(new AssignInstruction(null, null));
            this.addInstruction(new PopInstruction());
        } else if (start != null) {
            long maxValue;
            if (end != null) {
                maxValue = loop.isIncluding() ? end + 1L : end;
            } else {
                long l = maxValue = type2.equals(PsiType.LONG) ? Long.MAX_VALUE : Integer.MAX_VALUE;
            }
            if (start >= maxValue) {
                this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)statement)));
            } else {
                DfaValue range = this.myFactory.getFactValue(DfaFactType.RANGE, LongRangeSet.range(start + 1L, maxValue));
                new CFGBuilder(this).assignAndPop(loopVar, range);
            }
        } else {
            new CFGBuilder(this).assign(loopVar, DfaUnknownValue.getInstance()).push(origin).compare(JavaTokenType.LE);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, null));
        }
        return true;
    }

    public void visitIfStatement(PsiIfStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset((PsiElement)elseStatement) : this.getEndOffset((PsiElement)statement);
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, (PsiElement)condition2));
        }
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset((PsiElement)statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitStatement(PsiStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        this.handleEscapedVariables((PsiElement)expression2);
        this.addInstruction(new LambdaInstruction(expression2));
        this.finishElement((PsiElement)expression2);
    }

    private void handleEscapedVariables(PsiElement element) {
        final HashSet variables = new HashSet();
        final HashSet<DfaVariableValue> escapedVars = new HashSet<DfaVariableValue>();
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                DfaVariableValue qualifier;
                super.visitReferenceExpression(expression2);
                PsiElement target = expression2.resolve();
                if (target instanceof PsiLocalVariable) {
                    variables.add((PsiLocalVariable)target);
                }
                if (target instanceof PsiMember && !((PsiMember)target).hasModifierProperty("static") && (qualifier = ControlFlowAnalyzer.this.getFactory().getExpressionFactory().getQualifierOrThisVariable(expression2)) != null) {
                    escapedVars.add(qualifier);
                }
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                DfaValue value2 = ControlFlowAnalyzer.this.getFactory().createValue((PsiExpression)expression2);
                if (value2 instanceof DfaVariableValue) {
                    escapedVars.add((DfaVariableValue)value2);
                }
            }
        });
        for (DfaValue value2 : this.getFactory().getValues()) {
            PsiModifierListOwner var;
            if (!(value2 instanceof DfaVariableValue) || !((var = ((DfaVariableValue)value2).getPsiVariable()) instanceof PsiLocalVariable) || !variables.contains(var)) continue;
            escapedVars.add((DfaVariableValue)value2);
        }
        if (!escapedVars.isEmpty()) {
            this.addInstruction(new EscapeInstruction(escapedVars));
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (this.myExpressionBlockContext != null) {
            this.myExpressionBlockContext.generateReturn(returnValue, this);
        } else {
            if (returnValue != null) {
                returnValue.accept((PsiElementVisitor)this);
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
                if (method != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
                } else {
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (lambdaExpression != null) {
                        this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression));
                    }
                }
                this.addInstruction(new PopInstruction());
            }
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), (PsiElement)statement));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
        boolean expressionSwitch;
        PsiSwitchBlock switchBlock = statement.getEnclosingSwitchBlock();
        if (switchBlock == null) {
            return;
        }
        this.startElement((PsiElement)statement);
        PsiStatement body2 = statement.getBody();
        PsiCodeBlock switchBody = switchBlock.getBody();
        boolean bl = expressionSwitch = this.myExpressionBlockContext != null && this.myExpressionBlockContext.myCodeBlock == switchBody;
        if (expressionSwitch && body2 instanceof PsiExpressionStatement) {
            this.myExpressionBlockContext.generateReturn(((PsiExpressionStatement)body2).getExpression(), this);
        } else {
            if (body2 != null) {
                body2.accept((PsiElementVisitor)this);
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                this.jumpOut((PsiElement)(expressionSwitch ? switchBody : switchBlock));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        this.startElement((PsiElement)switchStmt);
        this.processSwitch((PsiSwitchBlock)switchStmt);
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitSwitchExpression(PsiSwitchExpression expression2) {
        PsiCodeBlock body2 = expression2.getBody();
        if (body2 == null) {
            this.processSwitch((PsiSwitchBlock)expression2);
            this.pushUnknown();
        } else {
            this.startElement((PsiElement)expression2);
            DfaVariableValue resultVariable = this.createTempVariable(expression2.getType());
            this.enterExpressionBlock(body2, Nullability.UNKNOWN, resultVariable);
            this.processSwitch((PsiSwitchBlock)expression2);
            this.exitExpressionBlock();
            this.addInstruction(new PushInstruction(resultVariable, (PsiExpression)expression2));
            this.finishElement((PsiElement)expression2);
        }
    }

    private void processSwitch(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body2;
        if (switchBlock == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        PsiExpression selector2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)switchBlock.getExpression());
        HashSet<PsiEnumConstant> enumValues = null;
        DfaVariableValue expressionValue = null;
        boolean syntheticVar = true;
        if (selector2 != null) {
            PsiType targetType = selector2.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)targetType);
            if (unboxedType != null) {
                targetType = unboxedType;
            } else {
                DfaValue selectorValue = this.myFactory.createValue(selector2);
                if (selectorValue instanceof DfaVariableValue && !((DfaVariableValue)selectorValue).isFlushableByCalls()) {
                    expressionValue = (DfaVariableValue)selectorValue;
                    syntheticVar = false;
                }
            }
            if (syntheticVar) {
                expressionValue = this.createTempVariable(targetType);
                this.addInstruction(new PushInstruction(expressionValue, null, true));
            }
            selector2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(selector2, targetType);
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
            if (psiClass != null && psiClass.isEnum()) {
                enumValues = new HashSet<PsiEnumConstant>();
                for (PsiField f : psiClass.getFields()) {
                    if (!(f instanceof PsiEnumConstant)) continue;
                    enumValues.add((PsiEnumConstant)f);
                }
            }
            if (syntheticVar) {
                this.addInstruction(new AssignInstruction(null, null));
            }
            this.addInstruction(new PopInstruction());
        }
        if ((body2 = switchBlock.getBody()) != null) {
            PsiStatement[] statements = body2.getStatements();
            ControlFlow.ControlFlowOffset offset = null;
            PsiSwitchLabelStatementBase defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatementBase)) continue;
                PsiSwitchLabelStatementBase psiLabelStatement = (PsiSwitchLabelStatementBase)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    offset = this.getStartOffset((PsiElement)statement);
                    PsiExpressionList values = psiLabelStatement.getCaseValues();
                    if (values == null) continue;
                    for (PsiExpression caseValue : values.getExpressions()) {
                        if (enumValues != null && caseValue instanceof PsiReferenceExpression) {
                            enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                        }
                        if (caseValue != null && expressionValue != null) {
                            this.addInstruction(new PushInstruction(expressionValue, null));
                            caseValue.accept((PsiElementVisitor)this);
                            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, (PsiType)PsiType.BOOLEAN));
                        } else {
                            this.pushUnknown();
                        }
                        this.addInstruction(new ConditionalGotoInstruction(offset, false, (PsiElement)caseValue));
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (offset == null || enumValues == null || !enumValues.isEmpty()) {
                offset = defaultLabel != null ? this.getStartOffset((PsiElement)defaultLabel) : this.getEndOffset((PsiElement)body2);
            }
            this.addInstruction(new GotoInstruction(offset));
            body2.accept((PsiElementVisitor)this);
        }
        if (syntheticVar && expressionValue != null) {
            this.addInstruction(new FlushVariableInstruction(expressionValue));
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new MethodReferenceInstruction(expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.addInstruction(new FlushFieldsInstruction());
        PsiCodeBlock body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
            this.throwException(exception.getType(), (PsiElement)statement);
        }
        this.finishElement((PsiElement)statement);
    }

    void addConditionalRuntimeThrow() {
        if (!this.shouldHandleException()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.throwException(this.myExceptionCache.get("java.lang.RuntimeException"), null);
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.throwException(this.myExceptionCache.get("java.lang.Error"), null);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private boolean shouldHandleException() {
        for (Trap trap : this.myTrapStack) {
            if (!(trap instanceof Trap.TryCatch) && !(trap instanceof Trap.TryFinally) && !(trap instanceof Trap.TwrFinally)) continue;
            return true;
        }
        return false;
    }

    public void visitTryStatement(PsiTryStatement statement) {
        PsiCatchSection[] sections;
        Trap.TryFinally finallyDescriptor;
        this.startElement((PsiElement)statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        Trap.TryFinally tryFinally = finallyDescriptor = finallyBlock != null ? new Trap.TryFinally(finallyBlock, this.getStartOffset((PsiElement)finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.pushTrap(finallyDescriptor);
        }
        if ((sections = statement.getCatchSections()).length > 0) {
            LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(section, this.getStartOffset((PsiElement)catchBlock));
            }
            this.pushTrap(new Trap.TryCatch(statement, clauses));
        }
        this.processTryWithResources(resourceList, tryBlock);
        InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset((PsiElement)statement), this.getVariablesInside((PsiElement)tryBlock));
        FList singleFinally = FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList((Object)finallyDescriptor));
        this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        if (sections.length > 0) {
            this.popTrap(Trap.TryCatch.class);
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        }
        if (finallyBlock != null) {
            this.popTrap(Trap.TryFinally.class);
            this.pushTrap(new Trap.InsideFinally((PsiElement)finallyBlock));
            finallyBlock.accept((PsiElementVisitor)this);
            this.controlTransfer(new ExitFinallyTransfer(finallyDescriptor), (FList<Trap>)FList.emptyList());
            this.popTrap(Trap.InsideFinally.class);
        }
        this.finishElement((PsiElement)statement);
    }

    void pushTrap(Trap elem) {
        this.myTrapStack = this.myTrapStack.prepend((Object)elem);
    }

    void popTrap(Class<? extends Trap> aClass) {
        if (!aClass.isInstance(this.myTrapStack.getHead())) {
            throw new IllegalStateException("Unexpected trap-stack head (wanted: " + aClass.getSimpleName() + "); stack: " + this.myTrapStack);
        }
        this.myTrapStack = this.myTrapStack.getTail();
    }

    private void processTryWithResources(@Nullable PsiResourceList resourceList, @Nullable PsiCodeBlock tryBlock) {
        Set closerExceptions = Collections.emptySet();
        Trap.TwrFinally twrFinallyDescriptor = null;
        if (resourceList != null) {
            resourceList.accept((PsiElementVisitor)this);
            closerExceptions = StreamEx.of((Iterator)resourceList.iterator()).flatCollection(ExceptionUtil::getCloserExceptions).toSet();
            if (!closerExceptions.isEmpty()) {
                twrFinallyDescriptor = new Trap.TwrFinally(resourceList, this.getStartOffset((PsiElement)resourceList));
                this.pushTrap(twrFinallyDescriptor);
            }
        }
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        if (twrFinallyDescriptor != null) {
            InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset((PsiElement)resourceList), this.getVariablesInside((PsiElement)tryBlock));
            this.controlTransfer(gotoEnd, (FList<Trap>)FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList(twrFinallyDescriptor)));
            this.popTrap(Trap.TwrFinally.class);
            this.pushTrap(new Trap.InsideFinally((PsiElement)resourceList));
            this.startElement((PsiElement)resourceList);
            this.addThrows(null, closerExceptions.toArray(PsiClassType.EMPTY_ARRAY));
            this.controlTransfer(new ExitFinallyTransfer(twrFinallyDescriptor), (FList<Trap>)FList.emptyList());
            this.finishElement((PsiElement)resourceList);
            this.popTrap(Trap.InsideFinally.class);
        }
    }

    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) continue;
                this.initializeVariable((PsiVariable)variable, initializer);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression condition2 = statement.getCondition();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition2));
        PsiStatement body2 = statement.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(this.getStartOffset((PsiElement)statement)));
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)list);
        for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(PsiExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression arrayExpression = expression2.getArrayExpression();
        arrayExpression.accept((PsiElementVisitor)this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, (PsiType)PsiType.INT);
        } else {
            this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
        }
        DfaValue toPush = this.myFactory.createValue((PsiExpression)expression2);
        if (toPush == null) {
            toPush = this.myFactory.createTypeValue(expression2.getType(), Nullability.UNKNOWN);
        }
        this.addInstruction(new ArrayAccessInstruction(toPush, expression2));
        this.addNullCheck((PsiExpression)expression2);
        this.finishElement((PsiElement)expression2);
    }

    @Nullable
    private DfaVariableValue getTargetVariable(PsiExpression expression2) {
        DfaValue value2;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (expression2 instanceof PsiArrayInitializerExpression && parent instanceof PsiNewExpression) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiVariable) {
            return this.getFactory().getVarFactory().createVariableValue((PsiVariable)parent);
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ) && PsiTreeUtil.isAncestor((PsiElement)assignmentExpression.getRExpression(), (PsiElement)expression2, (boolean)false) && (value2 = this.getFactory().createValue(assignmentExpression.getLExpression())) instanceof DfaVariableValue) {
            return (DfaVariableValue)value2;
        }
        return null;
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.initializeArray(expression2, (PsiExpression)expression2);
        this.finishElement((PsiElement)expression2);
    }

    private void initializeArray(PsiArrayInitializerExpression expression2, PsiExpression originalExpression) {
        DfaVariableValue var;
        PsiType type2 = expression2.getType();
        PsiType componentType = type2 instanceof PsiArrayType ? ((PsiArrayType)type2).getComponentType() : null;
        DfaVariableValue arrayWriteTarget = var = this.getTargetVariable((PsiExpression)expression2);
        if (var == null) {
            var = this.createTempVariable(type2);
        }
        PsiExpression[] initializers = expression2.getInitializers();
        DfaExpressionFactory expressionFactory = this.myFactory.getExpressionFactory();
        if (arrayWriteTarget != null) {
            PsiVariable arrayVariable = (PsiVariable)ObjectUtils.tryCast((Object)arrayWriteTarget.getPsiVariable(), PsiVariable.class);
            if (arrayWriteTarget.isFlushableByCalls() || arrayVariable == null || VariableAccessUtils.variableIsUsed(arrayVariable, (PsiElement)expression2) || ExpressionUtils.getConstantArrayElements(arrayVariable) != null || !(expressionFactory.getArrayElementValue((DfaValue)arrayWriteTarget, 0) instanceof DfaVariableValue)) {
                arrayWriteTarget = null;
            }
        }
        DfaFactMap arrayFacts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, type2 == null ? null : TypeConstraint.exact(this.myFactory.createDfaType(type2))).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL).with(DfaFactType.LOCALITY, true).with(DfaFactType.SPECIAL_FIELD_VALUE, SpecialField.ARRAY_LENGTH.withValue(this.myFactory.getInt(expression2.getInitializers().length)));
        DfaValue arrayValue = this.myFactory.getFactFactory().createValue(arrayFacts);
        if (arrayWriteTarget != null) {
            this.addInstruction(new PushInstruction(arrayWriteTarget, null, true));
            this.addInstruction(new PushInstruction(arrayValue, (PsiExpression)expression2));
            this.addInstruction(new AssignInstruction(originalExpression, arrayWriteTarget));
            int index = 0;
            for (PsiExpression initializer : initializers) {
                if (index < 32) {
                    DfaValue target = Objects.requireNonNull(expressionFactory.getArrayElementValue((DfaValue)arrayWriteTarget, index));
                    this.addInstruction(new PushInstruction(target, null, true));
                }
                initializer.accept((PsiElementVisitor)this);
                if (componentType != null) {
                    this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                }
                if (index < 32) {
                    this.addInstruction(new AssignInstruction(initializer, null));
                }
                ++index;
                this.addInstruction(new PopInstruction());
            }
        } else {
            for (PsiExpression initializer : initializers) {
                initializer.accept((PsiElementVisitor)this);
                if (componentType != null) {
                    this.generateBoxingUnboxingInstructionFor(initializer, componentType);
                }
                this.addInstruction(new PopInstruction());
            }
            this.addInstruction(new PushInstruction(var, null, true));
            this.addInstruction(new PushInstruction(arrayValue, (PsiExpression)expression2));
            this.addInstruction(new AssignInstruction(originalExpression, var));
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length <= 1) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        PsiType type2 = expression2.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateShortCircuitAndOr((PsiExpression)expression2, operands2, type2, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateShortCircuitAndOr((PsiExpression)expression2, operands2, type2, false);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateXorExpression((PsiExpression)expression2, operands2, type2, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateAndOr(operands2, type2, true);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateAndOr(operands2, type2, false);
        } else if (ControlFlowAnalyzer.isBinaryDivision(op) && operands2.length == 2 && type2 != null && PsiType.LONG.isAssignableFrom(type2)) {
            this.generateDivMod(expression2, type2, operands2[0], operands2[1]);
        } else {
            this.generateOther(expression2, op, operands2, type2);
        }
        this.finishElement((PsiElement)expression2);
    }

    static boolean isBinaryDivision(IElementType binaryOp) {
        return binaryOp == JavaTokenType.DIV || binaryOp == JavaTokenType.PERC;
    }

    static boolean isAssignmentDivision(IElementType op) {
        return op == JavaTokenType.PERCEQ || op == JavaTokenType.DIVEQ;
    }

    private void generateDivMod(PsiPolyadicExpression expression2, PsiType type2, PsiExpression left, PsiExpression right) {
        left.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(left, type2);
        right.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(right, type2);
        Object divisorValue = ExpressionUtils.computeConstantExpression(right);
        if (!(divisorValue instanceof Number) || ((Number)divisorValue).longValue() == 0L) {
            this.checkZeroDivisor();
        }
        this.addInstruction(new BinopInstruction(expression2.getOperationTokenType(), (PsiExpression)(expression2.isPhysical() ? expression2 : null), type2));
    }

    private void checkZeroDivisor() {
        this.addInstruction(new DupInstruction());
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(0, (PsiType)PsiType.LONG), null));
        this.addInstruction(new BinopInstruction(JavaTokenType.NE, null, (PsiType)PsiType.BOOLEAN));
        ConditionalGotoInstruction ifNonZero = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(ifNonZero);
        this.throwException(this.myExceptionCache.get(ArithmeticException.class.getName()), null);
        ifNonZero.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private void generateOther(PsiPolyadicExpression expression2, IElementType op, PsiExpression[] operands2, PsiType type2) {
        op = this.substituteBinaryOperation((PsiExpression)expression2, op);
        PsiExpression lExpr = operands2[0];
        lExpr.accept((PsiElementVisitor)this);
        PsiType lType = lExpr.getType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression rExpr = operands2[i];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type2, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, (PsiExpression)expression2, type2, i));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private IElementType substituteBinaryOperation(PsiExpression expression2, IElementType op) {
        if (JavaTokenType.PLUS == op) {
            if (TypeUtils.isJavaLangString(expression2.getType()) || this.isAcceptableContextForMathOperation(expression2)) {
                return op;
            }
            return null;
        }
        if (!(JavaTokenType.MINUS != op && JavaTokenType.ASTERISK != op || this.isAcceptableContextForMathOperation(expression2))) {
            return null;
        }
        return op;
    }

    private boolean isAcceptableContextForMathOperation(PsiExpression expression2) {
        for (PsiElement parent = expression2.getParent(); parent != null && parent != this.myCodeFragment; parent = parent.getParent()) {
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression || parent instanceof PsiArrayInitializerExpression || parent instanceof PsiArrayAccessExpression) {
                return true;
            }
            if (parent instanceof PsiBinaryExpression && DfaRelationValue.RelationType.fromElementType(((PsiBinaryExpression)parent).getOperationTokenType()) != null) {
                return true;
            }
            if (!(parent instanceof PsiLoopStatement) || parent instanceof PsiForStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)parent).getInitialization(), (PsiElement)expression2, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type2, PsiExpression lExpr, @Nullable PsiType lType, PsiExpression rExpr, @Nullable PsiType rType) {
        PsiType castType;
        boolean shift;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
        boolean comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
        boolean bl = shift = op == JavaTokenType.GTGT || op == JavaTokenType.LTLT || op == JavaTokenType.GTGTGT;
        PsiType psiType = comparingPrimitiveNumeric ? TypeConversionUtil.unboxAndBalanceTypes((PsiType)lType, (PsiType)rType) : (castType = shift && PsiType.LONG.equals((Object)rType) ? rType : type2);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept((PsiElementVisitor)this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression2, PsiType expectedType) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        this.generateBoxingUnboxingInstructionFor(expression2, expression2.getType(), expectedType);
    }

    void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression context, PsiType actualType, PsiType expectedType) {
        if (context == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        if (PsiType.VOID.equals((Object)expectedType)) {
            return;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)actualType)) {
            this.addInstruction(new UnwrapSpecialFieldInstruction(SpecialField.UNBOX));
        } else if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expectedType)) {
            this.addConditionalRuntimeThrow();
            PsiClassType boxedType = ((PsiPrimitiveType)actualType).getBoxedType((PsiElement)context);
            this.addInstruction(new BoxingInstruction((PsiType)boxedType));
        } else if (actualType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)actualType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)actualType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            this.addInstruction(new PrimitiveConversionInstruction((PsiPrimitiveType)expectedType, context));
        }
    }

    private void generateXorExpression(PsiExpression expression2, PsiExpression[] operands2, PsiType exprType, boolean forAssignment) {
        PsiExpression operand2 = operands2[0];
        operand2.accept((PsiElementVisitor)this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand2, exprType);
        for (int i = 1; i < operands2.length; ++i) {
            operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            PsiExpression psiAnchor = expression2.isPhysical() ? expression2 : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, psiAnchor, exprType, i));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, (PsiElement)anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = this.myFactory.getBoolean(!and);
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndOr(PsiExpression[] operands2, PsiType exprType, boolean and) {
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            if (i <= 0) continue;
            this.combineStackBooleans(and, operand2);
        }
    }

    private void generateShortCircuitAndOr(PsiExpression expression2, PsiExpression[] operands2, PsiType exprType, boolean and) {
        ControlFlow.DeferredOffset endOffset = new ControlFlow.DeferredOffset();
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression nextOperand;
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            PsiExpression psiExpression = nextOperand = i == operands2.length - 1 ? null : operands2[i + 1];
            if (nextOperand == null) continue;
            ControlFlow.DeferredOffset nextOffset = new ControlFlow.DeferredOffset();
            this.addInstruction(new ConditionalGotoInstruction(nextOffset, !and, (PsiElement)operand2));
            this.addInstruction(new PushInstruction(this.myFactory.getBoolean(!and), expression2));
            this.addInstruction(new GotoInstruction(endOffset));
            nextOffset.setOffset(this.getInstructionCount());
            this.addInstruction(new FinishElementInstruction(null));
        }
        endOffset.setOffset(this.getInstructionCount());
        this.addInstruction(new ResultOfInstruction(expression2));
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiTypeElement operand2 = expression2.getOperand();
        DfaConstValue classConstant = this.myFactory.getConstFactory().createFromValue(operand2.getType(), expression2.getType());
        this.addInstruction(new PushInstruction(classConstant, (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression condition2 = expression2.getCondition();
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        ControlFlow.DeferredOffset elseOffset = new ControlFlow.DeferredOffset();
        if (thenExpression2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            PsiType type2 = expression2.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, (PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)));
            thenExpression2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(thenExpression2, type2);
            ControlFlow.DeferredOffset endOffset = new ControlFlow.DeferredOffset();
            this.addInstruction(new GotoInstruction(endOffset));
            elseOffset.setOffset(this.getInstructionCount());
            if (elseExpression2 != null) {
                elseExpression2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(elseExpression2, type2);
            } else {
                this.pushUnknown();
            }
            endOffset.setOffset(this.getInstructionCount());
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        PsiTypeElement checkType = expression2.getCheckType();
        if (checkType != null) {
            operand2.accept((PsiElementVisitor)this);
            PsiType type2 = checkType.getType();
            if (type2 instanceof PsiClassType) {
                type2 = ((PsiClassType)type2).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type2, Nullability.NOT_NULL), null));
            this.addInstruction(new InstanceofInstruction((PsiExpression)expression2, operand2, type2));
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    void addMethodThrows(PsiMethod method, @Nullable PsiElement explicitCall) {
        if (method != null && this.shouldHandleException()) {
            this.addThrows(explicitCall, method.getThrowsList().getReferencedTypes());
        }
    }

    private void addThrows(@Nullable PsiElement explicitCall, PsiClassType[] refs) {
        for (PsiClassType ref : refs) {
            this.pushUnknown();
            ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
            this.addInstruction(cond);
            this.throwException((PsiType)ref, explicitCall);
            cond.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    void throwException(@Nullable PsiType ref, @Nullable PsiElement anchor) {
        if (ref != null) {
            this.throwException(new ExceptionTransfer(this.myFactory.createDfaType(ref)), anchor);
        }
    }

    private void throwException(ExceptionTransfer kind2, @Nullable PsiElement anchor) {
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(kind2, this.myTrapStack), anchor));
    }

    public void visitMethodCallExpression(PsiMethodCallExpression call) {
        ArrayDeque<PsiMethodCallExpression> calls;
        block7: {
            PsiExpression qualifierExpression2;
            calls = new ArrayDeque<PsiMethodCallExpression>();
            do {
                calls.addFirst(call);
                this.startElement((PsiElement)call);
                if (this.tryInline(call)) {
                    this.finishElement((PsiElement)call);
                    calls.removeFirst();
                } else {
                    qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
                    if (qualifierExpression2 == null) {
                        DfaVariableValue thisVariable = this.myFactory.getExpressionFactory().getQualifierOrThisVariable(call.getMethodExpression());
                        if (thisVariable != null) {
                            this.addInstruction(new PushInstruction(thisVariable, null));
                        } else {
                            this.pushUnknown();
                        }
                    } else {
                        if (qualifierExpression2.isPhysical() || !call.isPhysical()) continue;
                        this.pushUnknown();
                    }
                }
                break block7;
            } while ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierExpression2), PsiMethodCallExpression.class)) != null);
            qualifierExpression2.accept((PsiElementVisitor)this);
        }
        calls.forEach(this::finishCall);
    }

    private boolean tryInline(PsiMethodCallExpression call) {
        if (this.myInlining) {
            for (CallInliner inliner : INLINERS) {
                if (!inliner.tryInlineCall(new CFGBuilder(this), call)) continue;
                this.addNullCheck((PsiExpression)call);
                return true;
            }
        }
        return false;
    }

    private void finishCall(PsiMethodCallExpression call) {
        PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
        JavaResolveResult result = call.getMethodExpression().advancedResolve(false);
        PsiElement method = result.getElement();
        PsiParameter[] parameters2 = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression paramExpr = expressions2[i];
            paramExpr.accept((PsiElementVisitor)this);
            if (parameters2 == null || i >= parameters2.length) continue;
            this.generateBoxingUnboxingInstructionFor(paramExpr, result.getSubstitutor().substitute(parameters2[i].getType()));
        }
        this.addBareCall(call, call.getMethodExpression());
        this.finishElement((PsiElement)call);
    }

    void addBareCall(@Nullable PsiMethodCallExpression expression2, @NotNull PsiReferenceExpression reference) {
        PsiReferenceExpression anchor;
        List contracts2;
        if (reference == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        this.addConditionalRuntimeThrow();
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)reference.resolve(), PsiMethod.class);
        List<Object> list = contracts2 = method == null ? Collections.emptyList() : JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)expression2);
        if (expression2 == null) {
            assert (reference instanceof PsiMethodReferenceExpression);
            this.addInstruction(new MethodCallInstruction((PsiMethodReferenceExpression)reference, contracts2));
            anchor = reference;
        } else {
            this.addInstruction(new MethodCallInstruction((PsiCall)expression2, this.myFactory.createValue((PsiExpression)expression2), contracts2));
            this.addNullCheck((PsiExpression)expression2);
            anchor = expression2;
        }
        if (contracts2.stream().anyMatch(c -> c.getReturnValue().isFail())) {
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getContractFail(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, (PsiType)PsiType.BOOLEAN));
            ConditionalGotoInstruction ifNotFail = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(ifNotFail);
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(new ExceptionTransfer(null), this.myTrapStack), (PsiElement)anchor));
            ifNotFail.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        this.addMethodThrows(method, (PsiElement)anchor);
    }

    @Deprecated
    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        return JavaMethodContractUtil.findContractAnnotation(method);
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments((PsiConstructorCall)enumConstant);
        this.addInstruction(new MethodCallInstruction((PsiCall)enumConstant, null, Collections.emptyList()));
        this.addInstruction(new PopInstruction());
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiType type2;
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifier();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        if ((type2 = expression2.getType()) instanceof PsiArrayType) {
            PsiArrayInitializerExpression arrayInitializer = expression2.getArrayInitializer();
            if (arrayInitializer != null) {
                this.initializeArray(arrayInitializer, (PsiExpression)expression2);
                return;
            }
            DfaVariableValue var = this.getTargetVariable((PsiExpression)expression2);
            if (var == null) {
                var = this.createTempVariable(type2);
            }
            DfaValue length = SpecialField.ARRAY_LENGTH.createValue(this.getFactory(), var);
            this.addInstruction(new PushInstruction(length, null, true));
            PsiExpression[] dimensions = expression2.getArrayDimensions();
            if (dimensions.length > 0) {
                boolean sizeOnStack = false;
                for (PsiExpression dimension : dimensions) {
                    dimension.accept((PsiElementVisitor)this);
                    if (sizeOnStack) {
                        this.addInstruction(new PopInstruction());
                    }
                    sizeOnStack = true;
                }
            } else {
                this.pushUnknown();
            }
            this.addInstruction(new PushInstruction(var, null, true));
            DfaValue arrayValue = this.myFactory.withFact(this.myFactory.createExactTypeValue(type2), DfaFactType.LOCALITY, true);
            this.addInstruction(new PushInstruction(arrayValue, (PsiExpression)expression2));
            this.addInstruction(new AssignInstruction((PsiExpression)expression2, var));
            this.addInstruction(new SpliceInstruction(3, 0, 2, 1));
            this.addInstruction(new AssignInstruction(null, length));
            this.addInstruction(new PopInstruction());
            this.initializeSmallArray((PsiArrayType)type2, var, dimensions);
        } else {
            this.pushUnknown();
            PsiMethod constructor = this.pushConstructorArguments((PsiConstructorCall)expression2);
            PsiAnonymousClass anonymousClass = expression2.getAnonymousClass();
            if (anonymousClass != null) {
                this.handleEscapedVariables((PsiElement)anonymousClass);
            }
            this.addConditionalRuntimeThrow();
            DfaValue precalculatedNewValue = this.getPrecalculatedNewValue(expression2);
            List<Object> contracts2 = constructor == null ? Collections.emptyList() : JavaMethodContractUtil.getMethodContracts(constructor);
            this.addInstruction(new MethodCallInstruction((PsiCall)expression2, precalculatedNewValue, contracts2));
            this.addMethodThrows(constructor, (PsiElement)expression2);
        }
        this.finishElement((PsiElement)expression2);
    }

    private DfaValue getPrecalculatedNewValue(PsiNewExpression expression2) {
        PsiType type2 = expression2.getType();
        if (type2 != null && ConstructionUtils.isEmptyCollectionInitializer((PsiExpression)expression2)) {
            DfaFactMap facts = DfaFactMap.EMPTY.with(DfaFactType.TYPE_CONSTRAINT, TypeConstraint.exact(this.myFactory.createDfaType(type2))).with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL).with(DfaFactType.LOCALITY, true).with(DfaFactType.SPECIAL_FIELD_VALUE, SpecialField.COLLECTION_SIZE.withValue(this.myFactory.getInt(0)));
            return this.myFactory.getFactFactory().createValue(facts);
        }
        return null;
    }

    private void initializeSmallArray(PsiArrayType type2, DfaVariableValue var, PsiExpression[] dimensions) {
        int lengthValue;
        if (dimensions.length != 1) {
            return;
        }
        PsiType componentType = type2.getComponentType();
        if (!(componentType instanceof PsiPrimitiveType)) {
            return;
        }
        Object val = ExpressionUtils.computeConstantExpression(dimensions[0]);
        if (val instanceof Integer && (lengthValue = ((Integer)val).intValue()) > 0 && lengthValue <= 3) {
            DfaValue value2;
            int i;
            for (i = 0; i < lengthValue; ++i) {
                value2 = this.getFactory().getExpressionFactory().getArrayElementValue((DfaValue)var, i);
                this.addInstruction(new PushInstruction(value2, null, true));
            }
            this.addInstruction(new PushInstruction(this.getFactory().getConstFactory().createDefault(componentType), null));
            for (i = lengthValue - 1; i >= 0; --i) {
                value2 = this.getFactory().getExpressionFactory().getArrayElementValue((DfaValue)var, i);
                this.addInstruction(new AssignInstruction(null, value2));
            }
            this.addInstruction(new PopInstruction());
        }
    }

    @Nullable
    private PsiMethod pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        if (args != null) {
            PsiExpression[] params = args.getExpressions();
            PsiParameter[] parameters2 = ctr == null ? null : ctr.getParameterList().getParameters();
            for (int i = 0; i < params.length; ++i) {
                PsiExpression param = params[i];
                param.accept((PsiElementVisitor)this);
                if (parameters2 == null || i >= parameters2.length) continue;
                this.generateBoxingUnboxingInstructionFor(param, parameters2[i].getType());
            }
        }
        return ctr;
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression inner = expression2.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)PsiType.INT);
            this.pushUnknown();
            this.addInstruction(new AssignInstruction(operand2, null, this.myFactory.createValue(operand2)));
            this.addInstruction(new PopInstruction());
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression2);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        DfaValue dfaValue;
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue2 = dfaValue = expression2.getOperationTokenType() == JavaTokenType.EXCL ? null : this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        } else {
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (operand2 == null) {
                this.pushUnknown();
            } else {
                operand2.accept((PsiElementVisitor)this);
                PsiType type2 = expression2.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
                this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)(unboxed == null ? type2 : unboxed));
                if (PsiUtil.isIncrementDecrementOperation((PsiElement)expression2)) {
                    this.pushUnknown();
                    this.addInstruction(new AssignInstruction(operand2, null, this.myFactory.createValue(operand2)));
                } else if (expression2.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction(expression2));
                } else if (expression2.getOperationTokenType() == JavaTokenType.MINUS && (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2))) {
                    this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createDefault(type2), null));
                    this.addInstruction(new SwapInstruction());
                    this.addInstruction(new BinopInstruction(expression2.getOperationTokenType(), (PsiExpression)expression2, type2));
                } else {
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                }
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiElement target;
        this.startElement((PsiElement)expression2);
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (!(qualifierExpression2 == null || (target = expression2.resolve()) instanceof PsiMember && ((PsiMember)target).hasModifierProperty("static"))) {
            qualifierExpression2.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        boolean writing = PsiUtil.isAccessedForWriting((PsiExpression)expression2) && !PsiUtil.isAccessedForReading((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createValue((PsiExpression)expression2), (PsiExpression)expression2, writing));
        this.addNullCheck((PsiExpression)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        if (dfaValue == this.myFactory.getConstFactory().getNull()) {
            this.addNullCheck((PsiExpression)expression2);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement((PsiElement)castExpression);
        PsiExpression operand2 = castExpression.getOperand();
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor((PsiExpression)castExpression, operand2.getType(), castExpression.getType());
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(castExpression.getType(), Nullability.UNKNOWN), null));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand2 != null && operand2.getType() != null && !(typeElement.getType() instanceof PsiPrimitiveType)) {
            this.addInstruction(new TypeCastInstruction(castExpression, operand2, typeElement.getType()));
        }
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(PsiClass aClass) {
    }

    void inlineBlock(@NotNull PsiCodeBlock block, @NotNull Nullability resultNullability, @NotNull DfaVariableValue target) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        if (resultNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(11);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(12);
        }
        this.enterExpressionBlock(block, resultNullability, target);
        block.accept((PsiElementVisitor)this);
        this.exitExpressionBlock();
    }

    private void enterExpressionBlock(@NotNull PsiCodeBlock block, @NotNull Nullability resultNullability, @NotNull DfaVariableValue target) {
        if (block == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(13);
        }
        if (resultNullability == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(14);
        }
        if (target == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(15);
        }
        this.pushTrap(new Trap.InsideInlinedBlock(block));
        this.addInstruction(new PushInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, (FList<Trap>)FList.emptyList()), null));
        this.myExpressionBlockContext = new ExpressionBlockContext(this.myExpressionBlockContext, block, resultNullability == Nullability.NOT_NULL, target);
        this.startElement((PsiElement)block);
    }

    private void exitExpressionBlock() {
        this.finishElement((PsiElement)this.myExpressionBlockContext.myCodeBlock);
        this.myExpressionBlockContext = this.myExpressionBlockContext.myPreviousBlock;
        this.popTrap(Trap.InsideInlinedBlock.class);
        this.addInstruction(new PopInstruction());
    }

    void addCustomNullabilityProblem(@NotNull PsiExpression expression2, @NotNull NullabilityProblemKind<? super PsiExpression> problem) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(16);
        }
        if (problem == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(17);
        }
        this.myCustomNullabilityProblems.put(expression2, problem);
    }

    void removeCustomNullabilityProblem(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(18);
        }
        this.myCustomNullabilityProblems.remove(expression2);
    }

    @NotNull
    DfaVariableValue createTempVariable(@Nullable PsiType type2) {
        if (type2 == null) {
            type2 = PsiType.VOID;
        }
        DfaVariableValue dfaVariableValue = this.getFactory().getVarFactory().createVariableValue(new Synthetic(this.getInstructionCount(), type2));
        if (dfaVariableValue == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(19);
        }
        return dfaVariableValue;
    }

    public static boolean isTempVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(20);
        }
        return variable.getDescriptor() instanceof Synthetic;
    }

    public static boolean inlinerMayInferPreciseType(PsiExpression expression2) {
        return Arrays.stream(INLINERS).anyMatch(inliner -> inliner.mayInferPreciseType(expression2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 2: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultNullability";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynthetics";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrapsInsideElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesInside";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "controlTransfer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSwitch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateBoxingUnboxingInstructionFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBareCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContractAnnotation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inlineBlock";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enterExpressionBlock";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addCustomNullabilityProblem";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomNullabilityProblem";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTempVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ExpressionBlockContext {
        @Nullable
        final ExpressionBlockContext myPreviousBlock;
        @NotNull
        final PsiCodeBlock myCodeBlock;
        final boolean myForceNonNullBlockResult;
        @NotNull
        final DfaVariableValue myTarget;

        ExpressionBlockContext(@Nullable ExpressionBlockContext previousBlock, @NotNull PsiCodeBlock codeBlock, boolean forceNonNullBlockResult, @NotNull DfaVariableValue target) {
            if (codeBlock == null) {
                ExpressionBlockContext.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ExpressionBlockContext.$$$reportNull$$$0(1);
            }
            this.myPreviousBlock = previousBlock;
            this.myCodeBlock = codeBlock;
            this.myForceNonNullBlockResult = forceNonNullBlockResult;
            this.myTarget = target;
        }

        boolean isSwitch() {
            return this.myCodeBlock.getParent() instanceof PsiSwitchExpression;
        }

        void generateReturn(PsiExpression returnValue, ControlFlowAnalyzer analyzer) {
            if (returnValue != null) {
                analyzer.addInstruction(new PushInstruction(this.myTarget, null, true));
                if (!this.isSwitch()) {
                    analyzer.addCustomNullabilityProblem(returnValue, this.myForceNonNullBlockResult ? NullabilityProblemKind.nullableFunctionReturn : NullabilityProblemKind.noProblem);
                }
                returnValue.accept((PsiElementVisitor)analyzer);
                analyzer.removeCustomNullabilityProblem(returnValue);
                analyzer.generateBoxingUnboxingInstructionFor(returnValue, this.myTarget.getType());
                analyzer.addInstruction(new AssignInstruction(returnValue, null));
                analyzer.addInstruction(new PopInstruction());
            }
            analyzer.jumpOut((PsiElement)this.myCodeBlock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codeBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer$ExpressionBlockContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Synthetic
    implements VariableDescriptor {
        private final int myLocation;
        private final PsiType myType;

        private Synthetic(int location, PsiType type2) {
            this.myLocation = location;
            this.myType = type2;
        }

        @NotNull
        public String toString() {
            String string = "tmp$" + this.myLocation;
            if (string == null) {
                Synthetic.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiType getType(@Nullable DfaVariableValue qualifier) {
            return this.myType;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer$Synthetic", "toString"));
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

