/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EndlessStreamInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> ALL_CONSUMING_OPERATIONS = new HashSet<String>(Arrays.asList("sorted", "count", "reduce", "max", "min", "sum", "average", "collect", "toArray", "forEach", "summaryStatistics"));
    private static final Set<String> NON_LIMITING_OPERATIONS = new HashSet<String>(Arrays.asList("filter", "map", "distinct", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "flatMapToObj", "onClose", "peek", "skip", "dropWhile", "mapToDouble", "mapToLong", "mapToObj", "mapToInt", "parallel", "boxed", "sequential", "unordered", "asLongStream", "asDoubleStream"));
    private static final CallMatcher INFINITE_SOURCE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.IntStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.IntStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.LongStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.LongStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.DoubleStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.DoubleStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.Stream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.Stream", "iterate").parameterCount(2), CallMatcher.instanceCall("java.util.Random", "ints", "longs", "doubles").parameterCount(2), CallMatcher.instanceCall("java.util.Random", "ints", "longs", "doubles").parameterCount(0));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EndlessStreamInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                EndlessStreamInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!INFINITE_SOURCE.test(call)) {
                    return;
                }
                PsiMethodCallExpression allConsumingCall = StreamApiUtil.findSubsequentCall(call, name -> ALL_CONSUMING_OPERATIONS.contains(name), name -> NON_LIMITING_OPERATIONS.contains(name));
                if (allConsumingCall == null) {
                    return;
                }
                PsiElement nameElement = allConsumingCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.endless.stream.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        };
        if (javaElementVisitor == null) {
            EndlessStreamInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/EndlessStreamInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/EndlessStreamInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

