/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalBreakInInfiniteLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean noConversionToDoWhile = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), "noConversionToDoWhile");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitWhileStatement(PsiWhileStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            public void visitDoWhileStatement(PsiDoWhileStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            public void visitForStatement(PsiForStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            private void visitLoop(@NotNull PsiLoopStatement loopStatement) {
                LocalQuickFix[] fixes;
                PsiElement keyword;
                if (loopStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((keyword = ConditionalBreakInInfiniteLoopInspection.getKeyword(loopStatement)) == null) {
                    return;
                }
                Context context = Context.from(loopStatement, ConditionalBreakInInfiniteLoopInspection.this.noConversionToDoWhile);
                if (context == null) {
                    return;
                }
                if (context.myConditionInTheBeginning) {
                    fixes = new LocalQuickFix[]{new LoopTransformationFix()};
                } else {
                    SetInspectionOptionFix setInspectionOptionFix = new SetInspectionOptionFix((LocalInspectionTool)ConditionalBreakInInfiniteLoopInspection.this, "noConversionToDoWhile", InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), true);
                    fixes = new LocalQuickFix[]{new LoopTransformationFix(), setInspectionOptionFix};
                }
                holder.registerProblem(keyword, InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.description", (Object[])new Object[0]), fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$1", "visitLoop"));
            }
        };
        if (javaElementVisitor == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiElement getKeyword(@NotNull PsiLoopStatement loopStatement) {
        if (loopStatement == null) {
            ConditionalBreakInInfiniteLoopInspection.$$$reportNull$$$0(2);
        }
        if (loopStatement instanceof PsiWhileStatement || loopStatement instanceof PsiForStatement) {
            return loopStatement.getFirstChild();
        }
        return ((PsiDoWhileStatement)loopStatement).getWhileKeyword();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoopTransformationFix
    implements LocalQuickFix {
        private LoopTransformationFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop", (Object[])new Object[0]);
            if (string == null) {
                LoopTransformationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLoopStatement loop;
            if (project == null) {
                LoopTransformationFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                LoopTransformationFix.$$$reportNull$$$0(2);
            }
            if ((loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLoopStatement.class)) == null) {
                return;
            }
            Context context = Context.from(loop, false);
            if (context == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String negated = BoolUtils.getNegatedExpressionText(context.myCondition, ct);
            ct.delete((PsiElement)context.myConditionStatement);
            String loopText = context.myConditionInTheBeginning ? "while(" + negated + ")" + ct.text((PsiElement)context.myLoopBody) : "do" + ct.text((PsiElement)context.myLoopBody) + "while(" + negated + ");";
            ct.replaceAndRestoreComments((PsiElement)context.myLoopStatement, loopText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$LoopTransformationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$LoopTransformationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Context {
        @NotNull
        final PsiLoopStatement myLoopStatement;
        @NotNull
        final PsiStatement myLoopBody;
        @NotNull
        final PsiExpression myCondition;
        @NotNull
        final PsiStatement myConditionStatement;
        final boolean myConditionInTheBeginning;

        Context(@NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement loopBody, @NotNull PsiExpression condition2, @NotNull PsiStatement statement, boolean conditionInTheBeginning) {
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (loopBody == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (condition2 == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (statement == null) {
                Context.$$$reportNull$$$0(3);
            }
            this.myLoopStatement = loopStatement;
            this.myLoopBody = loopBody;
            this.myCondition = condition2;
            this.myConditionStatement = statement;
            this.myConditionInTheBeginning = conditionInTheBeginning;
        }

        @Nullable
        static Context from(@NotNull PsiLoopStatement loopStatement, boolean noConversionToDoWhile) {
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(4);
            }
            if (!ControlFlowUtils.isEndlessLoop(loopStatement)) {
                return null;
            }
            PsiStatement body2 = loopStatement.getBody();
            if (body2 == null) {
                return null;
            }
            Object[] statements = ControlFlowUtils.unwrapBlock(body2);
            if (statements.length < 2) {
                return null;
            }
            if (((StreamEx)StreamEx.ofTree((Object)body2, el -> StreamEx.of((Object[])el.getChildren())).select(PsiBreakStatement.class).filter(stmt -> ControlFlowUtils.statementBreaksLoop((PsiStatement)stmt, loopStatement))).count() != 1L) {
                return null;
            }
            PsiStatement first = statements[0];
            PsiExpression firstBreakCondition = Context.extractBreakCondition(first, loopStatement);
            if (firstBreakCondition != null) {
                return new Context(loopStatement, body2, firstBreakCondition, first, true);
            }
            if (noConversionToDoWhile) {
                return null;
            }
            PsiStatement last = statements[statements.length - 1];
            PsiExpression lastBreakCondition = Context.extractBreakCondition(last, loopStatement);
            if (lastBreakCondition != null) {
                if (StreamEx.of((Object[])statements).flatMap(statement -> StreamEx.ofTree((Object)statement, el -> StreamEx.of((Object[])el.getChildren()))).anyMatch(e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).findContinuedStatement() == loopStatement)) {
                    return null;
                }
                boolean variablesInLoop = VariableAccessUtils.collectUsedVariables((PsiElement)lastBreakCondition).stream().anyMatch(var -> PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)var, (boolean)false));
                if (variablesInLoop) {
                    return null;
                }
                return new Context(loopStatement, body2, lastBreakCondition, last, false);
            }
            return null;
        }

        @Nullable
        private static PsiExpression extractBreakCondition(@NotNull PsiStatement statement, @NotNull PsiLoopStatement loopStatement) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                Context.$$$reportNull$$$0(5);
            }
            if (loopStatement == null) {
                Context.$$$reportNull$$$0(6);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (!ControlFlowUtils.statementBreaksLoop(ControlFlowUtils.stripBraces(thenBranch), loopStatement)) {
                return null;
            }
            return ifStatement.getCondition();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopBody";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ConditionalBreakInInfiniteLoopInspection$Context";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractBreakCondition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

