/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageLookupItem
extends LookupElement {
    private final PsiPackage myPackage;
    private final String myString;
    private final boolean myAddDot;

    public PackageLookupItem(@NotNull PsiPackage aPackage) {
        if (aPackage == null) {
            PackageLookupItem.$$$reportNull$$$0(0);
        }
        this(aPackage, null);
    }

    public PackageLookupItem(@NotNull PsiPackage pkg, @Nullable PsiElement context) {
        if (pkg == null) {
            PackageLookupItem.$$$reportNull$$$0(1);
        }
        this.myPackage = pkg;
        this.myString = StringUtil.notNullize((String)this.myPackage.getName());
        PsiFile file = context == null ? null : context.getContainingFile();
        this.myAddDot = !(file instanceof PsiJavaCodeReferenceCodeFragment) || ((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted();
    }

    @NotNull
    public Object getObject() {
        PsiPackage psiPackage = this.myPackage;
        if (psiPackage == null) {
            PackageLookupItem.$$$reportNull$$$0(2);
        }
        return psiPackage;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myString;
        if (string == null) {
            PackageLookupItem.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        if (this.myAddDot) {
            presentation.setItemText(this.myString + ".");
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PackageLookupItem.$$$reportNull$$$0(4);
        }
        if (this.myAddDot) {
            context.setAddCompletionChar(false);
            TailType.DOT.processTail(context.getEditor(), context.getTailOffset());
        }
        if (this.myAddDot || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/PackageLookupItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/PackageLookupItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

