/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamRefactoringUtil {
    static boolean isRefactoringCandidate(PsiExpression expression2, boolean requireExpressionLambda) {
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression2;
            return lambdaExpression.getParameterList().getParametersCount() == 1 && (!requireExpressionLambda || LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody()) != null);
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            return methodRef.resolve() != null && LambdaRefactoringUtil.canConvertToLambdaWithoutSideEffects(methodRef);
        }
        return false;
    }

    @NotNull
    public static String generateMapOperation(PsiVariable variable, @Nullable PsiType outType, PsiElement mapper) {
        String shortcutMappingMethod = StreamRefactoringUtil.getShortcutMappingMethod(variable, outType, mapper);
        if (shortcutMappingMethod != null) {
            String string = shortcutMappingMethod.isEmpty() ? "" : "." + shortcutMappingMethod + "()";
            if (string == null) {
                StreamRefactoringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiType inType = variable.getType();
        String operationName = StreamRefactoringUtil.getMapOperationName(inType, outType);
        if (outType != null && mapper instanceof PsiArrayInitializerExpression) {
            mapper = RefactoringUtil.convertInitializerToNormalExpression((PsiExpression)mapper, outType);
        }
        String typeArgument = mapper instanceof PsiExpression ? OptionalRefactoringUtil.getMapTypeArgument((PsiExpression)mapper, outType) : "";
        String string = "." + typeArgument + operationName + "(" + variable.getName() + "->" + mapper.getText() + ")";
        if (string == null) {
            StreamRefactoringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getShortcutMappingMethod(PsiVariable variable, @Nullable PsiType outType, PsiElement mapper) {
        if (!(mapper instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)mapper));
        PsiType inType = variable.getType();
        if (expression2 instanceof PsiTypeCastExpression && inType instanceof PsiPrimitiveType && Objects.equals(expression2.getType(), outType)) {
            expression2 = ((PsiTypeCastExpression)expression2).getOperand();
        }
        if (ExpressionUtils.isReferenceTo(expression2, variable)) {
            if (!(outType instanceof PsiPrimitiveType)) {
                return inType instanceof PsiPrimitiveType ? "boxed" : "";
            }
            if (outType.equals(inType)) {
                return "";
            }
            if (PsiType.LONG.equals((Object)outType) && PsiType.INT.equals((Object)inType)) {
                return "asLongStream";
            }
            if (PsiType.DOUBLE.equals((Object)outType) && (PsiType.LONG.equals((Object)inType) || PsiType.INT.equals((Object)inType))) {
                return "asDoubleStream";
            }
        }
        return null;
    }

    @NotNull
    public static String getMapOperationName(PsiType inType, @Nullable PsiType outType) {
        if (outType instanceof PsiPrimitiveType) {
            if (!outType.equals(inType)) {
                if (PsiType.INT.equals((Object)outType)) {
                    if ("mapToInt" == null) {
                        StreamRefactoringUtil.$$$reportNull$$$0(2);
                    }
                    return "mapToInt";
                }
                if (PsiType.LONG.equals((Object)outType)) {
                    if ("mapToLong" == null) {
                        StreamRefactoringUtil.$$$reportNull$$$0(3);
                    }
                    return "mapToLong";
                }
                if (PsiType.DOUBLE.equals((Object)outType)) {
                    if ("mapToDouble" == null) {
                        StreamRefactoringUtil.$$$reportNull$$$0(4);
                    }
                    return "mapToDouble";
                }
            }
        } else if (inType instanceof PsiPrimitiveType) {
            if ("mapToObj" == null) {
                StreamRefactoringUtil.$$$reportNull$$$0(5);
            }
            return "mapToObj";
        }
        if ("map" == null) {
            StreamRefactoringUtil.$$$reportNull$$$0(6);
        }
        return "map";
    }

    @Nullable
    public static String getFlatMapOperationName(PsiType inType, PsiType outType) {
        if (!(inType instanceof PsiPrimitiveType)) {
            if (PsiType.INT.equals((Object)outType)) {
                return "flatMapToInt";
            }
            if (PsiType.LONG.equals((Object)outType)) {
                return "flatMapToLong";
            }
            if (PsiType.DOUBLE.equals((Object)outType)) {
                return "flatMapToDouble";
            }
        } else if (!inType.equals(outType)) {
            return null;
        }
        return "flatMap";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/intention/impl/StreamRefactoringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMapOperation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapOperationName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

