/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitConditionUtil {
    public static PsiPolyadicExpression findCondition(PsiElement element) {
        return SplitConditionUtil.findCondition(element, true, true);
    }

    public static PsiPolyadicExpression findCondition(PsiElement element, boolean acceptAnd, boolean acceptOr) {
        boolean isOrExpression;
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (!(token.getParent() instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)token.getParent();
        boolean isAndExpression = acceptAnd && expression2.getOperationTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = acceptOr && expression2.getOperationTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return null;
        }
        if (ErrorUtil.containsError((PsiElement)expression2)) {
            return null;
        }
        while (expression2.getParent() instanceof PsiPolyadicExpression) {
            expression2 = (PsiPolyadicExpression)expression2.getParent();
            if (isAndExpression && expression2.getOperationTokenType() != JavaTokenType.ANDAND) {
                return null;
            }
            if (!isOrExpression || expression2.getOperationTokenType() == JavaTokenType.OROR) continue;
            return null;
        }
        return expression2;
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression2, PsiJavaToken separator) {
        return SplitConditionUtil.getROperands(expression2, separator, new CommentTracker());
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression2, PsiJavaToken separator, CommentTracker ct) {
        int offsetInParent;
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)separator);
        if (next == null) {
            offsetInParent = separator.getStartOffsetInParent() + separator.getTextLength();
        } else {
            ct.markRangeUnchanged(next, expression2.getLastChild());
            offsetInParent = next.getStartOffsetInParent();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        String rOperands = expression2.getText().substring(offsetInParent);
        return factory.createExpressionFromText(rOperands, expression2.getParent());
    }

    public static PsiExpression getLOperands(PsiPolyadicExpression expression2, PsiJavaToken separator) {
        return SplitConditionUtil.getLOperands(expression2, separator, new CommentTracker());
    }

    public static PsiExpression getLOperands(PsiPolyadicExpression expression2, PsiJavaToken separator, CommentTracker ct) {
        PsiJavaToken prev = separator;
        if (prev.getPrevSibling() instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        ct.markRangeUnchanged(expression2.getFirstChild(), prev.getPrevSibling());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        String rOperands = expression2.getText().substring(0, prev.getStartOffsetInParent());
        return factory.createExpressionFromText(rOperands, expression2.getParent());
    }

    @Nullable
    static PsiIfStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation, CommentTracker tracker) {
        PsiStatement thenBranch;
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(0);
        }
        if (ifStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(1);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(2);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(3);
        }
        if (operation == null) {
            SplitConditionUtil.$$$reportNull$$$0(4);
        }
        if ((thenBranch = ifStatement.getThenBranch()) == null) {
            return null;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (operation == JavaTokenType.OROR) {
            return SplitConditionUtil.createOrOr(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        if (operation == JavaTokenType.ANDAND) {
            return SplitConditionUtil.createAndAnd(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        return null;
    }

    @NotNull
    private static PsiIfStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        PsiExpression nextCondition;
        PsiIfStatement nextIf;
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(5);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(6);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(7);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(8);
        }
        ArrayList<String> elseChain = new ArrayList<String>();
        boolean chainFinished = false;
        block0: while (!chainFinished && (nextIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(elseBranch), PsiIfStatement.class)) != null && (nextCondition = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextIf.getCondition())) != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)extract, (PsiElement)nextCondition) && nextIf.getThenBranch() != null) {
                elseChain.add(tracker.text((PsiElement)nextIf.getThenBranch()));
                chainFinished = true;
            } else {
                PsiExpression[] operands2;
                PsiPolyadicExpression nextPolyadic;
                if (!(nextCondition instanceof PsiPolyadicExpression) || !(nextPolyadic = (PsiPolyadicExpression)nextCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) break;
                PsiExpression[] nextOperands = nextPolyadic.getOperands();
                if (nextOperands.length <= (operands2 = extract instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)extract).getOperationTokenType().equals(JavaTokenType.ANDAND) ? ((PsiPolyadicExpression)extract).getOperands() : new PsiExpression[]{extract}).length) break;
                for (int i = 0; i < operands2.length; ++i) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nextOperands[i], (PsiElement)operands2[i])) break block0;
                }
                PsiExpression nextExtracted = SplitConditionUtil.getROperands(nextPolyadic, nextPolyadic.getTokenBeforeOperand(nextOperands[operands2.length]), tracker);
                elseChain.add(SplitConditionUtil.createIfString(nextExtracted, nextIf.getThenBranch(), (PsiStatement)null, tracker));
            }
            elseBranch = nextIf.getElseBranch();
        }
        if (!chainFinished && elseBranch != null) {
            elseChain.add(elseBranch.getText());
        }
        String thenString = elseChain.isEmpty() ? SplitConditionUtil.createIfString(leave, thenBranch, (String)null, tracker) : "{" + SplitConditionUtil.createIfString(leave, thenBranch, String.join((CharSequence)"\nelse ", elseChain), tracker) + "\n}";
        String ifString = SplitConditionUtil.createIfString(extract, thenString, elseBranch, tracker);
        PsiIfStatement psiIfStatement = (PsiIfStatement)factory.createStatementFromText(ifString, (PsiElement)thenBranch);
        if (psiIfStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(9);
        }
        return psiIfStatement;
    }

    @NotNull
    private static PsiIfStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(10);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(11);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(12);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(13);
        }
        PsiIfStatement psiIfStatement = (PsiIfStatement)factory.createStatementFromText(SplitConditionUtil.createIfString(extract, thenBranch, SplitConditionUtil.createIfString(leave, thenBranch, elseBranch, tracker), tracker), (PsiElement)thenBranch);
        if (psiIfStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(14);
        }
        return psiIfStatement;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition2 == null) {
            SplitConditionUtil.$$$reportNull$$$0(15);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(16);
        }
        String string = SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) == null ? condition2 : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), SplitConditionUtil.toElseBranchString(elseBranch != null ? tracker.markUnchanged(elseBranch) : null, false));
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable String elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition2 == null) {
            SplitConditionUtil.$$$reportNull$$$0(18);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(19);
        }
        String string = SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) == null ? condition2 : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), elseBranch);
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull String thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition2 == null) {
            SplitConditionUtil.$$$reportNull$$$0(21);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(22);
        }
        String string = SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) == null ? condition2 : stripped)), thenBranch, SplitConditionUtil.toElseBranchString(elseBranch != null ? tracker.markUnchanged(elseBranch) : null, true));
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull String condition2, @NotNull String thenBranch, @Nullable String elseBranch) {
        if (condition2 == null) {
            SplitConditionUtil.$$$reportNull$$$0(24);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(25);
        }
        String elsePart = elseBranch != null ? "\n else " + elseBranch : "";
        String string = "if (" + condition2 + ")\n" + thenBranch + elsePart;
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement) {
        if (statement == null) {
            SplitConditionUtil.$$$reportNull$$$0(27);
        }
        if (!(statement instanceof PsiBlockStatement)) {
            String string = "{ " + statement.getText() + "\n }";
            if (string == null) {
                SplitConditionUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = statement.getText();
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement, boolean skipElse) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof PsiBlockStatement || skipElse && statement instanceof PsiIfStatement) {
            return statement.getText();
        }
        return "{ " + statement.getText() + "\n }";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extract";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leave";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitConditionUtil";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitConditionUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAnd";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrOr";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfString";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toThenBranchString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAndAnd";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOrOr";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createIfString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toThenBranchString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

