/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.PsiImplementationViewSession;
import com.intellij.codeInsight.hint.actions.ShowImplementationsAction;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ShowSiblingsAction
extends ShowImplementationsAction {
    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        PsiElementListCellRenderer listRenderer;
        String findUsagesTitle;
        String title;
        Object[] superElements;
        PsiFile containingFile;
        if (dataContext == null) {
            ShowSiblingsAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = PsiImplementationViewSession.getEditor((DataContext)dataContext);
        PsiElement element = PsiImplementationViewSession.getElement((Project)project, (PsiFile)file, (Editor)editor, (PsiElement)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)));
        if (element == null && file == null) {
            return;
        }
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : file;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return;
        }
        if (editor != null) {
            PsiReference ref = TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtil.getInstance().adjustReference(ref);
            }
        }
        if ((superElements = ShowSiblingsAction.findSuperElements(element)).length == 0) {
            return;
        }
        boolean isMethod = superElements[0] instanceof PsiMethod;
        NavigatablePsiElement[] navigatablePsiElements = (NavigatablePsiElement[])ContainerUtil.findAllAsArray((Object[])superElements, NavigatablePsiElement.class);
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])navigatablePsiElements, (String)(title = "Choose super " + (isMethod ? "method" : "class or interface")), (String)(findUsagesTitle = "Super " + (isMethod ? "methods" : "classes/interfaces")), (ListCellRenderer)(listRenderer = isMethod ? new MethodCellRenderer(false) : new PsiClassListCellRenderer()), null, objects -> this.showSiblings(invokedByShortcut, project, editor, file, editor != null, (PsiElement)objects[0]));
        if (popup != null) {
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    protected boolean isSearchDeep() {
        return true;
    }

    private void showSiblings(boolean invokedByShortcut, @NotNull Project project, Editor editor, PsiFile file, boolean invokedFromEditor, @NotNull PsiElement element) {
        if (project == null) {
            ShowSiblingsAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ShowSiblingsAction.$$$reportNull$$$0(2);
        }
        PsiElement[] impls = PsiImplementationViewSession.getSelfAndImplementations((Editor)editor, (PsiElement)element, (ImplementationSearcher)PsiImplementationViewSession.createImplementationsSearcher((boolean)true), (boolean)false);
        String text2 = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)element);
        this.showImplementations((ImplementationViewSession)new PsiImplementationViewSession(project, element, impls, text2, editor, file != null ? file.getVirtualFile() : null, true, false), invokedFromEditor, invokedByShortcut);
    }

    protected boolean isIncludeAlwaysSelf() {
        return false;
    }

    @NotNull
    private static PsiElement[] findSuperElements(PsiElement element) {
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ShowSiblingsAction.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = FindSuperElementsHelper.findSuperElements((PsiElement)parent);
        if (psiElementArray == null) {
            ShowSiblingsAction.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/actions/ShowSiblingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/actions/ShowSiblingsAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performForContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showSiblings";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

