/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateGetterHandler;
import com.intellij.codeInsight.generation.GenerateGetterSetterHandlerBase;
import com.intellij.codeInsight.generation.GenerateSetterHandler;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.GetterTemplatesManager;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.SetterTemplatesManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class GenerateGetterAndSetterHandler
extends GenerateGetterSetterHandlerBase {
    private final GenerateGetterHandler myGenerateGetterHandler = new GenerateGetterHandler();
    private final GenerateSetterHandler myGenerateSetterHandler = new GenerateSetterHandler();

    public GenerateGetterAndSetterHandler() {
        super(CodeInsightBundle.message((String)"generate.getter.setter.title", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected JComponent getHeaderPanel(Project project) {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)GenerateGetterAndSetterHandler.getHeaderPanel(project, GetterTemplatesManager.getInstance(), CodeInsightBundle.message((String)"generate.getter.template", (Object[])new Object[0])), "North");
        panel.add((Component)GenerateGetterAndSetterHandler.getHeaderPanel(project, SetterTemplatesManager.getInstance(), CodeInsightBundle.message((String)"generate.setter.template", (Object[])new Object[0])), "South");
        return panel;
    }

    @Override
    public GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember original) throws IncorrectOperationException {
        GenerationInfo[] setters;
        ArrayList array = new ArrayList();
        GenerationInfo[] getters = this.myGenerateGetterHandler.generateMemberPrototypes(aClass, original);
        if (getters.length + (setters = this.myGenerateSetterHandler.generateMemberPrototypes(aClass, original)).length > 0) {
            Collections.addAll(array, getters);
            Collections.addAll(array, setters);
        }
        return array.toArray(GenerationInfo.EMPTY_ARRAY);
    }

    @Override
    protected void notifyOnSuccess(Editor editor, ClassMember[] members, List<? extends GenerationInfo> generatedMembers) {
        super.notifyOnSuccess(editor, members, generatedMembers);
        if (Arrays.stream(members).anyMatch(fm -> fm instanceof PsiFieldMember && GetterSetterPrototypeProvider.isReadOnlyProperty((PsiField)((PsiFieldMember)fm).getElement()))) {
            HintManager.getInstance().showErrorHint(editor, "Setters for read-only fields were not generated", (short)1);
        }
    }

    @Override
    protected String getNothingFoundMessage() {
        return "No fields have been found to generate getters/setters for";
    }

    @Override
    protected String getNothingAcceptedMessage() {
        return "No fields without getter/setter were found";
    }
}

