/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseVariableDeclarationFix
implements IntentionAction {
    private final PsiLocalVariable myVariable;

    public ReuseVariableDeclarationFix(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(0);
        }
        this.myVariable = variable;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("reuse.variable.declaration.family", new Object[0]);
        if (string == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("reuse.variable.declaration.text", this.myVariable.getName());
        if (string == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(3);
        }
        if (!this.myVariable.isValid()) {
            return false;
        }
        PsiVariable previousVariable = ReuseVariableDeclarationFix.findPreviousVariable(this.myVariable);
        return previousVariable != null && Comparing.equal((Object)previousVariable.getType(), (Object)this.myVariable.getType()) && BaseIntentionAction.canModify((PsiElement)this.myVariable);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(4);
        }
        PsiLocalVariable psiLocalVariable = this.myVariable;
        if (psiLocalVariable == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(5);
        }
        return psiLocalVariable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiVariable refVariable;
        if (project == null) {
            ReuseVariableDeclarationFix.$$$reportNull$$$0(6);
        }
        if ((refVariable = ReuseVariableDeclarationFix.findPreviousVariable(this.myVariable)) == null) {
            return;
        }
        PsiExpression initializer = this.myVariable.getInitializer();
        if (initializer == null) {
            this.myVariable.delete();
            return;
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)refVariable, (String)"final", (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myVariable.getProject());
        PsiStatement statement = factory.createStatementFromText(this.myVariable.getName() + " = " + initializer.getText() + ";", null);
        this.myVariable.getParent().replace((PsiElement)statement);
    }

    @Nullable
    static PsiVariable findPreviousVariable(PsiLocalVariable variable) {
        PsiElement scope;
        for (scope = variable.getParent(); !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return null;
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        VariablesNotProcessor processor = new VariablesNotProcessor((PsiVariable)variable, false);
        PsiScopesUtil.treeWalkUp(processor, (PsiElement)nameIdentifier, scope);
        return processor.size() > 0 ? processor.getResult(0) : null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReuseVariableDeclarationFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

