/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateServiceClassFixBase
implements IntentionAction {
    public static final Key<PsiDirectory> SERVICE_ROOT_DIR = Key.create((String)"SERVICE_ROOT_DIR");
    public static final Key<CreateClassKind> SERVICE_CLASS_KIND = Key.create((String)"SERVICE_CLASS_KIND");
    public static final Key<Boolean> SERVICE_IS_SUBCLASS = Key.create((String)"SERVICE_IS_SUBCLASS");

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected static PsiJavaCodeReferenceElement findTopmostReference(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (referenceElement == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(0);
        }
        PsiElement parent = referenceElement.getParent();
        while (parent instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)parent;
            parent = parent.getParent();
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = referenceElement;
        if (psiJavaCodeReferenceElement == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(1);
        }
        return psiJavaCodeReferenceElement;
    }

    protected static boolean isQualifierInProject(@NotNull String classFQN, @NotNull Project project) {
        if (classFQN == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(3);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String qualifierText = StringUtil.getPackageName((String)classFQN);
        PsiClass outerClass = psiFacade.findClass(qualifierText, GlobalSearchScope.projectScope((Project)project));
        if (outerClass != null) {
            return psiManager.isInProject((PsiElement)outerClass);
        }
        while (!StringUtil.isEmpty((String)qualifierText)) {
            PsiPackage psiPackage = psiFacade.findPackage(qualifierText);
            if (psiPackage != null) {
                return psiManager.isInProject((PsiElement)psiPackage);
            }
            qualifierText = StringUtil.getPackageName((String)qualifierText);
        }
        return false;
    }

    @NotNull
    protected static PsiClass createClassInOuterImpl(@NotNull String name, @NotNull PsiClass outerClass, @Nullable String superClassName) {
        if (name == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(4);
        }
        if (outerClass == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(5);
        }
        Project project = outerClass.getProject();
        PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)project).createClass(name);
        psiClass = (PsiClass)outerClass.addBefore((PsiElement)psiClass, outerClass.getRBrace());
        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass, (String)"static", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass, (String)"public", (boolean)true);
        if (superClassName != null) {
            CreateFromUsageUtils.setupSuperClassReference(psiClass, superClassName);
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(6);
        }
        return psiClass2;
    }

    @Nullable
    public static PsiDirectory getOrCreatePackageDirInRoot(@NotNull String packageName, @NotNull PsiDirectory rootDir) {
        String[] shortNames;
        if (packageName == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(7);
        }
        if (rootDir == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(8);
        }
        if (packageName.isEmpty()) {
            return rootDir;
        }
        PsiDirectory directory = rootDir;
        for (String lastName : shortNames = packageName.split("\\.")) {
            PsiDirectory subdirectory = directory.findSubdirectory(lastName);
            if (subdirectory != null) {
                directory = subdirectory;
                continue;
            }
            try {
                directory = directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
                return null;
            }
        }
        return directory;
    }

    @Nullable
    protected static PsiClass createClassInRoot(@NotNull String classFQN, @NotNull CreateClassKind classKind, @NotNull PsiDirectory rootDir, @NotNull PsiElement contextElement, @Nullable String superClassName) {
        if (classFQN == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(9);
        }
        if (classKind == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(10);
        }
        if (rootDir == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(11);
        }
        if (contextElement == null) {
            CreateServiceClassFixBase.$$$reportNull$$$0(12);
        }
        String packageName = StringUtil.getPackageName((String)classFQN);
        int lastDot = classFQN.lastIndexOf(46);
        String className = lastDot >= 0 ? classFQN.substring(lastDot + 1) : classFQN;
        PsiDirectory packageDir = CreateServiceClassFixBase.getOrCreatePackageDirInRoot(packageName, rootDir);
        if (packageDir == null) {
            return null;
        }
        return CreateFromUsageUtils.createClass(classKind, packageDir, className, contextElement.getManager(), contextElement, null, superClassName);
    }

    protected static PsiDirectory[] getModuleRootDirs(Module module) {
        ArrayList roots = new ArrayList();
        JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(module, roots);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        return (PsiDirectory[])roots.stream().map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparing(psiDir -> psiDir.getVirtualFile().getPresentableUrl())).toArray(PsiDirectory[]::new);
    }

    public static void positionCursor(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            CodeInsightUtil.positionCursor(psiClass.getProject(), psiClass.getContainingFile(), (PsiElement)psiClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceClassFixBase";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateServiceClassFixBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassInOuterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostReference";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQualifierInProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createClassInOuterImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePackageDirInRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createClassInRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PsiDirectoryListCellRenderer
    extends ListCellRendererWrapper<PsiDirectory> {
        public void customize(JList list, PsiDirectory psiDir, int index, boolean selected, boolean hasFocus) {
            if (psiDir != null) {
                String text2 = ProjectUtil.calcRelativeToProjectPath((VirtualFile)psiDir.getVirtualFile(), (Project)psiDir.getProject(), (boolean)true, (boolean)false, (boolean)true);
                this.setText(text2);
            }
        }
    }
}

