/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.concatenation.CopyConcatenatedStringToClipboardIntention;
import org.jetbrains.annotations.NotNull;

public class ConvertStringLiteralToRawAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("convert.to.raw.string.text", new Object[0]);
        if (string == null) {
            ConvertStringLiteralToRawAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert to raw string literal" == null) {
            ConvertStringLiteralToRawAction.$$$reportNull$$$0(1);
        }
        return "Convert to raw string literal";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement parent;
        PsiElement element;
        if (project == null) {
            ConvertStringLiteralToRawAction.$$$reportNull$$$0(2);
        }
        if (PsiUtil.isJavaToken((PsiElement)(element = file.findElementAt(editor.getCaretModel().getOffset())), (IElementType)JavaTokenType.STRING_LITERAL) && HighlightUtil.Feature.RAW_LITERALS.isAvailable((PsiElement)file) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2 = ((PsiLiteralExpressionImpl)parent).getInnerText();
            return text2 != null && PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2) < text2.length();
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element;
        if (project == null) {
            ConvertStringLiteralToRawAction.$$$reportNull$$$0(3);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.STRING_LITERAL) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2;
            PsiElement elementToReplace = parent;
            PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            if (gParent instanceof PsiPolyadicExpression) {
                text2 = CopyConcatenatedStringToClipboardIntention.buildConcatenationText((PsiPolyadicExpression)gParent);
                elementToReplace = gParent;
            } else {
                String innerText = ((PsiLiteralExpressionImpl)parent).getInnerText();
                if (innerText == null) {
                    return;
                }
                text2 = StringUtil.unescapeStringCharacters((String)innerText);
            }
            String prefix = "";
            int startingSeq = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
            if (startingSeq > 0) {
                prefix = "\"" + StringUtil.repeat((String)"`", (int)startingSeq) + "\" + ";
            }
            String suffix = "";
            int trailingSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2);
            if (trailingSequence > 0) {
                suffix = "+ \"" + StringUtil.repeat((String)"`", (int)trailingSequence) + "\"";
            }
            String textTicsTrimmed = text2.substring(Math.max(startingSeq, 0), text2.length() - Math.max(trailingSequence, 0));
            String additionalQuotes = PsiRawStringLiteralUtil.getAdditionalTicks((String)textTicsTrimmed, (String)"`");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            CodeStyleManager.getInstance((Project)project).reformat(elementToReplace.replace((PsiElement)elementFactory.createExpressionFromText(prefix + '`' + additionalQuotes + StringUtil.convertLineSeparators((String)textTicsTrimmed) + additionalQuotes + '`' + suffix, null)));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertStringLiteralToRawAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertStringLiteralToRawAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

