/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsConditionalFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteRepeatedInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.FlipIntersectionSidesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyWithThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUtil
extends HighlightUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil");
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers = new THashMap(7);
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers = new THashMap(11);
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers = new THashMap(8);
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourModuleIncompatibleModifiers = new THashMap(1);
    private static final Map<String, Set<String>> ourRequiresIncompatibleModifiers = new THashMap(2);
    private static final Set<String> ourConstructorNotAllowedModifiers = ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "native", "final", "strictfp", "synchronized"});
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";
    private static final Pattern FP_LITERAL_PARTS;

    private HighlightUtil() {
    }

    @Nullable
    private static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList, @NotNull Map<String, Set<String>> incompatibleModifiersHash) {
        if (modifier == null) {
            HighlightUtil.$$$reportNull$$$0(0);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(1);
        }
        if (incompatibleModifiersHash == null) {
            HighlightUtil.$$$reportNull$$$0(2);
        }
        PsiElement[] modifiers = modifierList.getChildren();
        int modifierCount = 0;
        for (PsiElement otherModifier : modifiers) {
            if (!Comparing.equal((String)modifier, (String)otherModifier.getText(), (boolean)true)) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        PsiElement parent = modifierList.getParent();
        boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList);
        boolean level9OrHigher = PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierList);
        for (String incompatible : incompatibles) {
            PsiClass containingClass;
            if (level8OrHigher && modifier.equals("static") && incompatible.equals("abstract") || parent instanceof PsiMethod && (level9OrHigher && modifier.equals("private") && incompatible.equals("public") || modifier.equals("static") && incompatible.equals("final") && ((containingClass = ((PsiMethod)parent).getContainingClass()) == null || !containingClass.isInterface()))) continue;
            if (modifierList.hasModifierProperty(incompatible)) {
                return incompatible;
            }
            if (!"abstract".equals(incompatible) || !modifierList.hasExplicitModifier(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInstanceOfApplicable(@NotNull PsiInstanceOfExpression expression2) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(3);
        }
        PsiExpression operand2 = expression2.getOperand();
        PsiTypeElement typeElement = expression2.getCheckType();
        if (typeElement == null) {
            return null;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand2.getType();
        if (operandType == null) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)checkType) || !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)checkType)) {
            String message2 = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(checkType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIntersectionInTypeCast(@NotNull PsiTypeCastExpression expression2, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        PsiTypeElement castTypeElement;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(6);
        }
        if ((castTypeElement = expression2.getCastType()) != null && HighlightUtil.isIntersection(castTypeElement, castTypeElement.getType())) {
            HighlightInfo info = HighlightUtil.checkFeature((PsiElement)expression2, Feature.INTERSECTION_CASTS, languageLevel, file);
            if (info != null) {
                return info;
            }
            PsiTypeElement[] conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class);
            if (conjuncts != null) {
                Ref differentArgumentsMessage;
                com.intellij.util.containers.hash.HashSet erasures = new com.intellij.util.containers.hash.HashSet(conjuncts.length);
                erasures.add(TypeConversionUtil.erasure((PsiType)conjuncts[0].getType()));
                ArrayList<PsiTypeElement> conjList = new ArrayList<PsiTypeElement>(Arrays.asList(conjuncts));
                for (int i = 1; i < conjuncts.length; ++i) {
                    PsiTypeElement conjunct = conjuncts[i];
                    PsiType conjType = conjunct.getType();
                    if (conjType instanceof PsiClassType) {
                        PsiClass aClass = ((PsiClassType)conjType).resolve();
                        if (aClass != null && !aClass.isInterface()) {
                            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip(JavaErrorMessages.message("interface.expected", new Object[0])).create();
                            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new FlipIntersectionSidesFix(aClass.getName(), conjList, conjunct, castTypeElement), null);
                            return errorResult;
                        }
                    } else {
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip("Unexpected type: class is expected").create();
                    }
                    if (erasures.add(TypeConversionUtil.erasure((PsiType)conjType))) continue;
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip("Repeated interface").create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new DeleteRepeatedInterfaceFix(conjunct, conjList), null);
                    return highlightInfo;
                }
                List typeList = ContainerUtil.map(conjList, PsiTypeElement::getType);
                PsiClass sameGenericParameterization = InferenceSession.findParameterizationOfTheSameGenericClass(typeList, (Processor<? super Pair<PsiType, PsiType>>)((Processor)arg_0 -> HighlightUtil.lambda$checkIntersectionInTypeCast$0(differentArgumentsMessage = new Ref(), arg_0)));
                if (sameGenericParameterization != null) {
                    String message2 = HighlightUtil.formatClass(sameGenericParameterization) + " cannot be inherited with different arguments: " + (String)differentArgumentsMessage.get();
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
                }
            }
        }
        return null;
    }

    private static boolean isIntersection(@NotNull PsiTypeElement castTypeElement, @NotNull PsiType castType) {
        if (castTypeElement == null) {
            HighlightUtil.$$$reportNull$$$0(7);
        }
        if (castType == null) {
            HighlightUtil.$$$reportNull$$$0(8);
        }
        if (castType instanceof PsiIntersectionType) {
            return true;
        }
        return castType instanceof PsiClassType && PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class) != null;
    }

    @Nullable
    static HighlightInfo checkInconvertibleTypeCast(@NotNull PsiTypeCastExpression expression2) {
        PsiTypeElement castTypeElement;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(9);
        }
        if ((castTypeElement = expression2.getCastType()) == null) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            return null;
        }
        PsiType operandType = operand2.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)expression2)) && !RedundantCastUtil.isInPolymorphicCall((PsiTypeCastExpression)expression2)) {
            String message2 = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkVariableExpected(@NotNull PsiExpression expression2) {
        PsiExpression lValue;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(10);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation((PsiElement)expression2) ? ((PsiUnaryExpression)expression2).getOperand() : null;
        }
        HighlightInfo errorResult = null;
        if (lValue != null && !TypeConversionUtil.isLValue((PsiExpression)lValue)) {
            String description = JavaErrorMessages.message("variable.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)lValue).descriptionAndTooltip(description).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentOperatorApplicable(@NotNull PsiAssignmentExpression assignment) {
        PsiJavaToken operationSign;
        IElementType eqOpSign;
        IElementType opSign;
        if (assignment == null) {
            HighlightUtil.$$$reportNull$$$0(11);
        }
        if ((opSign = TypeConversionUtil.convertEQtoOperation((IElementType)(eqOpSign = (operationSign = assignment.getOperationSign()).getTokenType()))) == null) {
            return null;
        }
        PsiType lType = assignment.getLExpression().getType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return null;
        }
        PsiType rType = rExpression.getType();
        HighlightInfo errorResult = null;
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiType)lType, (PsiType)rType, (boolean)true)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message2 = JavaErrorMessages.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)assignment).descriptionAndTooltip(message2).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentCompatibleTypes(@NotNull PsiAssignmentExpression assignment) {
        HighlightInfo highlightInfo;
        if (assignment == null) {
            HighlightUtil.$$$reportNull$$$0(12);
        }
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return null;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return null;
        }
        IElementType sign = assignment.getOperationTokenType();
        if (JavaTokenType.EQ.equals(sign)) {
            highlightInfo = HighlightUtil.checkAssignability(lType, rType, rExpr, (PsiElement)assignment);
        } else {
            IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)sign);
            PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opSign, (boolean)true);
            if (type2 == null || lType == null || TypeConversionUtil.areTypesConvertible((PsiType)type2, (PsiType)lType)) {
                return null;
            }
            highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, type2, assignment.getTextRange(), 0);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createChangeToAppendFix(sign, lType, assignment));
        }
        if (highlightInfo == null) {
            return null;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes(lExpr, rType, rExpr, highlightInfo);
        if (lType != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(rExpr, lType, lExpr, highlightInfo);
        }
        return highlightInfo;
    }

    private static boolean isCastIntentionApplicable(@NotNull PsiExpression expression2, @Nullable PsiType toType) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(13);
        }
        while (expression2 instanceof PsiTypeCastExpression || expression2 instanceof PsiParenthesizedExpression) {
            if (expression2 instanceof PsiTypeCastExpression) {
                expression2 = ((PsiTypeCastExpression)expression2).getOperand();
            }
            if (!(expression2 instanceof PsiParenthesizedExpression)) continue;
            expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
        }
        if (expression2 == null) {
            return false;
        }
        PsiType rType = expression2.getType();
        PsiType castType = GenericsUtil.getVariableTypeByExpressionType((PsiType)toType);
        return rType != null && toType != null && TypeConversionUtil.areTypesConvertible((PsiType)rType, (PsiType)toType) && toType.isAssignableFrom(castType);
    }

    @Nullable
    static HighlightInfo checkVariableInitializerType(@NotNull PsiVariable variable) {
        int end;
        PsiTypeElement typeElement;
        int start;
        PsiType rType;
        PsiExpression initializer;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(14);
        }
        if ((initializer = variable.getInitializer()) == null || initializer instanceof PsiArrayInitializerExpression) {
            return null;
        }
        PsiType lType = variable.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType = initializer.getType(), initializer, new TextRange(start = (typeElement = variable.getTypeElement()) != null ? typeElement.getTextRange().getStartOffset() : variable.getTextRange().getStartOffset(), end = variable.getTextRange().getEndOffset()), 0);
        if (highlightInfo != null) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, rType, variable.getInitializer(), highlightInfo);
            HighlightFixUtil.registerChangeVariableTypeFixes(initializer, lType, null, highlightInfo);
        }
        return highlightInfo;
    }

    static HighlightInfo checkLegalVarReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiClass resolved) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(15);
        }
        if (resolved == null) {
            HighlightUtil.$$$reportNull$$$0(16);
        }
        if ("var".equals(resolved.getName()) && PsiUtil.getLanguageLevel((PsiElement)ref).isAtLeast(LanguageLevel.JDK_10)) {
            String message2 = JavaErrorMessages.message("lvti.illegal", new Object[0]);
            PsiElement range = (PsiElement)ObjectUtils.notNull((Object)ref.getReferenceNameElement(), (Object)ref);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(range).create();
        }
        return null;
    }

    static HighlightInfo checkVarTypeApplicability(@NotNull PsiVariable variable) {
        PsiTypeElement typeElement;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(17);
        }
        if ((typeElement = variable.getTypeElement()) != null && typeElement.isInferredType()) {
            if (variable instanceof PsiLocalVariable) {
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    String message2 = JavaErrorMessages.message("lvti.no.initializer", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range((PsiElement)typeElement).create();
                }
                if (initializer instanceof PsiFunctionalExpression) {
                    boolean lambda2 = initializer instanceof PsiLambdaExpression;
                    String message3 = JavaErrorMessages.message(lambda2 ? "lvti.lambda" : "lvti.method.ref", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message3).range((PsiElement)typeElement).create();
                }
                PsiElement parent = variable.getParent();
                if (parent instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                    String message4 = JavaErrorMessages.message("lvti.compound", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message4).range((PsiElement)variable).create();
                }
                if (HighlightUtil.isArray(variable)) {
                    String message5 = JavaErrorMessages.message("lvti.array", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message5).range((PsiElement)typeElement).create();
                }
                PsiType lType = variable.getType();
                if (PsiType.NULL.equals((Object)lType)) {
                    String message6 = JavaErrorMessages.message("lvti.null", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message6).range((PsiElement)typeElement).create();
                }
                if (PsiType.VOID.equals((Object)lType)) {
                    String message7 = JavaErrorMessages.message("lvti.void", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message7).range((PsiElement)typeElement).create();
                }
            } else if (variable instanceof PsiParameter && variable.getParent() instanceof PsiParameterList && HighlightUtil.isArray(variable)) {
                String message8 = JavaErrorMessages.message("lvti.array", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message8).range((PsiElement)typeElement).create();
            }
        }
        return null;
    }

    private static boolean isArray(PsiVariable variable) {
        return Stream.of(variable.getChildren()).anyMatch(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACKET));
    }

    @Nullable
    static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression2, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            HighlightUtil.$$$reportNull$$$0(18);
        }
        TextRange textRange = elementToHighlight.getTextRange();
        return HighlightUtil.checkAssignability(lType, rType, expression2, textRange, 0);
    }

    @Nullable
    private static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression2, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(19);
        }
        if (lType == rType) {
            return null;
        }
        if (expression2 == null ? rType == null || lType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) : TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)expression2)) {
            return null;
        }
        if (rType == null) {
            rType = expression2.getType();
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange, navigationShift);
        if (rType != null && expression2 != null && HighlightUtil.isCastIntentionApplicable(expression2, lType)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix(lType, expression2));
        }
        if (expression2 != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createWrapWithOptionalFix(lType, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createWrapExpressionFix(lType, expression2));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createWrapWithAdapterFix(lType, expression2));
            AddTypeArgumentsConditionalFix.register(highlightInfo, expression2, lType);
            HighlightFixUtil.registerCollectionToArrayFixAction(highlightInfo, rType, lType, expression2);
            HighlightFixUtil.registerChangeReturnTypeFix(highlightInfo, expression2, lType);
        }
        ChangeNewOperatorTypeFix.register(highlightInfo, expression2, lType);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkReturnFromSwitchExpr(@NotNull PsiStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(20);
        }
        if (PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)statement) instanceof PsiSwitchExpression) {
            String message2 = JavaErrorMessages.message("return.outside.switch.expr", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkReturnStatementType(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(21);
        }
        PsiMethod method = null;
        PsiLambdaExpression lambda2 = null;
        PsiElement parent = statement.getParent();
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiClassInitializer)) {
            if (parent instanceof PsiLambdaExpression) {
                lambda2 = (PsiLambdaExpression)parent;
                break;
            }
            if (parent instanceof PsiMethod) {
                method = (PsiMethod)parent;
                break;
            }
            parent = parent.getParent();
        }
        if (parent instanceof PsiCodeFragment) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (method != null || lambda2 == null) {
            if (method == null && !(parent instanceof ServerPageFile)) {
                String description = JavaErrorMessages.message("return.outside.method", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            } else {
                PsiType returnType = method != null ? method.getReturnType() : null;
                boolean isMethodVoid = returnType == null || PsiType.VOID.equals((Object)returnType);
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    PsiType valueType = RefactoringChangeUtil.getTypeByExpression(returnValue);
                    if (isMethodVoid) {
                        String description = JavaErrorMessages.message("return.from.void.method", new Object[0]);
                        errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
                        if (valueType != null && method != null) {
                            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                        }
                    } else {
                        TextRange textRange = statement.getTextRange();
                        errorResult = HighlightUtil.checkAssignability(returnType, valueType, returnValue, textRange, returnValue.getStartOffsetInParent());
                        if (errorResult != null && valueType != null) {
                            PsiType erasedValueType;
                            if (!PsiType.VOID.equals((Object)valueType)) {
                                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                            }
                            HighlightFixUtil.registerChangeParameterClassFix(returnType, valueType, errorResult);
                            if (returnType instanceof PsiArrayType && (erasedValueType = TypeConversionUtil.erasure((PsiType)valueType)) != null && TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)returnType).getComponentType(), (PsiType)erasedValueType)) {
                                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix(null, returnValue));
                            }
                            HighlightFixUtil.registerCollectionToArrayFixAction(errorResult, valueType, returnType, returnValue);
                        }
                    }
                } else if (!isMethodVoid) {
                    String description = JavaErrorMessages.message("missing.return.value", new Object[0]);
                    errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).navigationShift("return".length()).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.VOID, true));
                }
            }
        }
        return errorResult;
    }

    @NotNull
    public static String getUnhandledExceptionsDescriptor(@NotNull Collection<? extends PsiClassType> unhandled) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(22);
        }
        String string = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, null);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String getUnhandledExceptionsDescriptor(@NotNull Collection<? extends PsiClassType> unhandled, @Nullable String source) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(24);
        }
        String exceptions = HighlightUtil.formatTypes(unhandled);
        String string = source == null ? JavaErrorMessages.message("unhandled.exceptions", exceptions, unhandled.size()) : JavaErrorMessages.message("unhandled.close.exceptions", exceptions, unhandled.size(), source);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String formatTypes(@NotNull Collection<? extends PsiClassType> unhandled) {
        if (unhandled == null) {
            HighlightUtil.$$$reportNull$$$0(26);
        }
        String string = StringUtil.join(unhandled, JavaHighlightUtil::formatType, (String)", ");
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkVariableAlreadyDefined(@NotNull PsiVariable variable) {
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(28);
        }
        if (variable instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        PsiVariable oldVariable = null;
        PsiElement declarationScope = null;
        if (variable instanceof PsiLocalVariable || variable instanceof PsiParameter && ((declarationScope = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiCatchSection || declarationScope instanceof PsiForeachStatement || declarationScope instanceof PsiLambdaExpression)) {
            PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class, PsiResourceList.class});
            VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return (var instanceof PsiLocalVariable || var instanceof PsiParameter) && super.check(var, state);
                }
            };
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            if (scope instanceof PsiResourceList && proc.size() == 0) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class});
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            }
            if (proc.size() > 0) {
                oldVariable = proc.getResult(0);
            } else if (declarationScope instanceof PsiLambdaExpression) {
                oldVariable = HighlightUtil.checkSameNames(variable);
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField fieldByName = aClass.findFieldByName(variable.getName(), false);
            if (fieldByName != null && fieldByName != field) {
                oldVariable = fieldByName;
            }
        } else {
            oldVariable = HighlightUtil.checkSameNames(variable);
        }
        if (oldVariable != null) {
            String description = JavaErrorMessages.message("variable.already.defined", variable.getName());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)identifier);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier);
            if (vFile != null) {
                String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
                String linkText = "<a href=\"#navigation/" + path + ":" + oldVariable.getTextOffset() + "\">" + variable.getName() + "</a>";
                builder = builder.description(description).escapedToolTip("<html>" + JavaErrorMessages.message("variable.already.defined", linkText) + "</html>");
            } else {
                builder = builder.descriptionAndTooltip(description);
            }
            HighlightInfo highlightInfo = builder.create();
            if (variable instanceof PsiLocalVariable) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createReuseVariableDeclarationFix((PsiLocalVariable)variable));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createNavigateToAlreadyDeclaredVariableFix(oldVariable));
            return highlightInfo;
        }
        return null;
    }

    private static PsiVariable checkSameNames(@NotNull PsiVariable variable) {
        PsiElement[] children;
        if (variable == null) {
            HighlightUtil.$$$reportNull$$$0(29);
        }
        PsiElement scope = variable.getParent();
        for (PsiElement child : children = scope.getChildren()) {
            if (!(child instanceof PsiVariable) || child.equals(variable) || !Objects.equals(variable.getName(), ((PsiVariable)child).getName())) continue;
            return (PsiVariable)child;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnderscore(@NotNull PsiIdentifier identifier, @NotNull LanguageLevel languageLevel) {
        if (identifier == null) {
            HighlightUtil.$$$reportNull$$$0(30);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(31);
        }
        if ("_".equals(identifier.getText())) {
            PsiElement parent;
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                String text2 = JavaErrorMessages.message("underscore.identifier.error", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text2).create();
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (parent = identifier.getParent()) instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression) {
                String text3 = JavaErrorMessages.message("underscore.lambda.identifier", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(32);
        }
        String string = HighlightUtil.formatClass(aClass, true);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(34);
        }
        String string = PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static String formatField(@NotNull PsiField field) {
        if (field == null) {
            HighlightUtil.$$$reportNull$$$0(36);
        }
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkUnhandledExceptions(@NotNull PsiElement element, @Nullable TextRange textRange) {
        List<PsiClassType> unhandledExceptions;
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(38);
        }
        if ((unhandledExceptions = ExceptionUtil.getOwnUnhandledExceptions(element)).isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType(element);
        if (highlightType == null) {
            return null;
        }
        if (textRange == null) {
            textRange = element.getTextRange();
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandledExceptions);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightType).range(textRange).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes(element, errorResult, unhandledExceptions);
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkUnhandledCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> unhandled;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(39);
        }
        if ((unhandled = ExceptionUtil.getUnhandledCloserExceptions(resource, null)).isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType((PsiElement)resource);
        if (highlightType == null) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, "auto-closeable resource");
        HighlightInfo highlight = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightType).range((PsiElement)resource).descriptionAndTooltip(description).create();
        HighlightFixUtil.registerUnhandledExceptionFixes((PsiElement)resource, highlight, unhandled);
        return highlight;
    }

    @Nullable
    private static HighlightInfoType getUnhandledExceptionHighlightType(@NotNull PsiElement element) {
        PsiMethod targetMethod;
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(40);
        }
        if (FileTypeUtils.isInServerPageFile((PsiElement)element) && (targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) instanceof SyntheticElement) {
            return null;
        }
        return HighlightInfoType.UNHANDLED_EXCEPTION;
    }

    @Nullable
    static HighlightInfo checkBreakOutsideSwitchOrLoop(@NotNull PsiBreakStatement statement) {
        PsiElement enclosing;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(41);
        }
        if ((enclosing = PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)statement)) == null) {
            String message2 = JavaErrorMessages.message("break.outside.switch.or.loop", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkValueBreakExpression(@NotNull PsiBreakStatement statement, @Nullable PsiExpression expression2) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(42);
        }
        PsiElement enclosing = PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)statement);
        boolean plainRef = PsiImplUtil.isUnqualifiedReference(expression2);
        if (enclosing instanceof PsiSwitchExpression) {
            if (expression2 == null) {
                String message2 = JavaErrorMessages.message("value.break.missing", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            }
            if (plainRef && PsiTreeUtil.isAncestor((PsiElement)((PsiReferenceExpression)expression2).resolve(), (PsiElement)enclosing, (boolean)true)) {
                String message3 = JavaErrorMessages.message("break.outside.switch.expr", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
            }
        } else if (expression2 != null && (!plainRef || ((PsiReferenceExpression)expression2).resolve() instanceof PsiVariable)) {
            String message4 = JavaErrorMessages.message("value.break.unexpected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message4).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkContinueOutsideLoop(@NotNull PsiContinueStatement statement, LanguageLevel languageLevel) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(43);
        }
        if (PsiImplUtil.findEnclosingLoop((PsiElement)statement) == null) {
            String message2 = JavaErrorMessages.message("continue.outside.loop", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return HighlightUtil.checkContinueOutsideOfSwitchExpression(statement, statement.findContinuedStatement(), languageLevel);
    }

    @Nullable
    static HighlightInfo checkContinueTarget(@NotNull PsiContinueStatement statement, @NotNull PsiIdentifier label, @NotNull LanguageLevel level) {
        PsiStatement continuedStatement;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(44);
        }
        if (label == null) {
            HighlightUtil.$$$reportNull$$$0(45);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(46);
        }
        if ((continuedStatement = statement.findContinuedStatement()) == null) {
            String message2 = JavaErrorMessages.message("unresolved.label", label.getText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)label).descriptionAndTooltip(message2).create();
        }
        if (!(continuedStatement instanceof PsiLoopStatement)) {
            String message3 = JavaErrorMessages.message("not.loop.label", label.getText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
        }
        return HighlightUtil.checkContinueOutsideOfSwitchExpression(statement, continuedStatement, level);
    }

    private static HighlightInfo checkContinueOutsideOfSwitchExpression(PsiContinueStatement statement, PsiStatement continuedStatement, LanguageLevel level) {
        PsiElement enclosing;
        if (Feature.ENHANCED_SWITCH.isSufficient(level) && (enclosing = PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)statement)) instanceof PsiSwitchExpression && PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)enclosing, (boolean)true)) {
            String message2 = JavaErrorMessages.message("continue.outside.switch.expr", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalModifierCombination(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        String modifier;
        String incompatible;
        if (keyword == null) {
            HighlightUtil.$$$reportNull$$$0(47);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(48);
        }
        if ((incompatible = HighlightUtil.getIncompatibleModifier(modifier = keyword.getText(), modifierList)) != null) {
            String message2 = JavaErrorMessages.message("incompatible.modifiers", modifier, incompatible);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    public static boolean isIllegalModifierCombination(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(49);
        }
        for (PsiElement child : modifierList.getChildren()) {
            if (!(child instanceof PsiKeyword) || HighlightUtil.getIncompatibleModifier(child.getText(), modifierList) == null) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    private static Map<String, Set<String>> getIncompatibleModifierMap(@NotNull PsiElement modifierListOwner) {
        if (modifierListOwner == null) {
            HighlightUtil.$$$reportNull$$$0(50);
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)modifierListOwner)) {
            return null;
        }
        if (modifierListOwner instanceof PsiClass) {
            return ((PsiClass)modifierListOwner).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiMethod) {
            return ourMethodIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiVariable) {
            return ourFieldIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiClassInitializer) {
            return ourClassInitializerIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiJavaModule) {
            return ourModuleIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiRequiresStatement) {
            return ourRequiresIncompatibleModifiers;
        }
        return null;
    }

    @Nullable
    static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList) {
        if (modifier == null) {
            HighlightUtil.$$$reportNull$$$0(51);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(52);
        }
        PsiElement parent = modifierList.getParent();
        Map<String, Set<String>> incompatibleModifierMap = null;
        if (parent != null) {
            incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(parent);
        }
        return incompatibleModifierMap == null ? null : HighlightUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap);
    }

    @Nullable
    static HighlightInfo checkNotAllowedModifier(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        PsiElement modifierOwnerParent;
        PsiElement modifierOwner;
        if (keyword == null) {
            HighlightUtil.$$$reportNull$$$0(53);
        }
        if (modifierList == null) {
            HighlightUtil.$$$reportNull$$$0(54);
        }
        if ((modifierOwner = modifierList.getParent()) == null) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierOwner);
        if (incompatibleModifierMap == null) {
            return null;
        }
        String modifier = keyword.getText();
        Set<String> incompatibles = incompatibleModifierMap.get(modifier);
        Object object = modifierOwnerParent = modifierOwner instanceof PsiMember ? ((PsiMember)modifierOwner).getContainingClass() : modifierOwner.getParent();
        if (modifierOwnerParent == null) {
            modifierOwnerParent = modifierOwner.getParent();
        }
        boolean isAllowed = true;
        if (modifierOwner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)modifierOwner;
            if (aClass.isInterface()) {
                if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
            } else {
                if ("public".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiImportHolder || modifierOwnerParent instanceof PsiClass && (modifierOwnerParent instanceof PsiSyntheticClass || ((PsiClass)modifierOwnerParent).getQualifiedName() != null || !modifierOwnerParent.isPhysical());
                } else if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    boolean bl = isAllowed = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).getQualifiedName() != null || FileTypeUtils.isInServerPageFile((PsiElement)modifierOwnerParent) || !modifierOwnerParent.isPhysical();
                }
                if (aClass.isEnum()) {
                    isAllowed &= !"final".equals(modifier) && !"abstract".equals(modifier);
                }
                if (aClass.getContainingClass() instanceof PsiAnonymousClass) {
                    isAllowed &= !"private".equals(modifier) && !"protected".equals(modifier);
                }
            }
        } else if (modifierOwner instanceof PsiMethod) {
            boolean isInterface;
            PsiMethod method = (PsiMethod)modifierOwner;
            isAllowed = !method.isConstructor() || !ourConstructorNotAllowedModifiers.contains(modifier);
            PsiClass containingClass = method.getContainingClass();
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                isAllowed = false;
            }
            boolean bl = isInterface = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).isInterface();
            if ("private".equals(modifier) && modifierOwnerParent instanceof PsiClass) {
                isAllowed &= !isInterface || PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierOwner) && !((PsiClass)modifierOwnerParent).isAnnotationType();
            } else if ("strictfp".equals(modifier)) {
                isAllowed &= !isInterface || PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierOwner);
            } else if ("protected".equals(modifier) || "transient".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed &= !isInterface;
            }
            if (containingClass != null && containingClass.isInterface()) {
                isAllowed &= !"native".equals(modifier);
            }
            if (containingClass != null && containingClass.isAnnotationType()) {
                isAllowed &= !"static".equals(modifier);
                isAllowed &= !"default".equals(modifier);
            }
        } else if (modifierOwner instanceof PsiField) {
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed = modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiClassInitializer) {
            isAllowed = "static".equals(modifier);
        } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
            isAllowed = "final".equals(modifier);
        } else if (modifierOwner instanceof PsiReceiverParameter) {
            isAllowed = false;
        }
        if (!(isAllowed &= incompatibles != null)) {
            String message2 = JavaErrorMessages.message("modifier.not.allowed", modifier);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkLiteralExpressionParsingError(@NotNull PsiLiteralExpression expression2, @NotNull LanguageLevel level, @Nullable PsiFile file) {
        Number number;
        int success;
        Object chars;
        String cleanText;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(55);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(56);
        }
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type2 = ((PsiJavaToken)literal).getTokenType();
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD || type2 == JavaTokenType.NULL_KEYWORD) {
            return null;
        }
        boolean isInt = PsiLiteralExpressionImpl.INTEGER_LITERALS.contains(type2);
        boolean isFP = PsiLiteralExpressionImpl.REAL_LITERALS.contains(type2);
        String text2 = isInt || isFP ? literal.getText().toLowerCase() : literal.getText();
        Object value2 = expression2.getValue();
        if (file != null) {
            HighlightInfo info;
            if (isFP && text2.startsWith("0x") && (info = HighlightUtil.checkFeature((PsiElement)expression2, Feature.HEX_FP_LITERALS, level, file)) != null) {
                return info;
            }
            if (isInt && text2.startsWith("0b") && (info = HighlightUtil.checkFeature((PsiElement)expression2, Feature.BIN_LITERALS, level, file)) != null) {
                return info;
            }
            if ((isInt || isFP) && text2.contains("_")) {
                info = HighlightUtil.checkFeature((PsiElement)expression2, Feature.UNDERSCORES, level, file);
                if (info != null) {
                    return info;
                }
                info = HighlightUtil.checkUnderscores((PsiElement)expression2, text2, isInt);
                if (info != null) {
                    return info;
                }
            }
        }
        PsiElement parent = expression2.getParent();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            cleanText = StringUtil.replace((String)text2, (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_31) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message2 = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
                }
                if (cleanText.equals("0b")) {
                    String message3 = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message3).create();
                }
                if (value2 == null || cleanText.equals(PsiLiteralUtil._2_IN_31)) {
                    String message4 = JavaErrorMessages.message("integer.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message4).create();
                }
            }
        } else if (type2 == JavaTokenType.LONG_LITERAL) {
            cleanText = StringUtil.replace((String)StringUtil.trimEnd((String)text2, (char)'l'), (String)"_", (String)"");
            if (!cleanText.equals(PsiLiteralUtil._2_IN_63) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (cleanText.equals("0x")) {
                    String message5 = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message5).create();
                }
                if (cleanText.equals("0b")) {
                    String message6 = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message6).create();
                }
                if (value2 == null || cleanText.equals(PsiLiteralUtil._2_IN_63)) {
                    String message7 = JavaErrorMessages.message("long.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message7).create();
                }
            }
        } else if (isFP) {
            if (value2 == null) {
                String message8 = JavaErrorMessages.message("malformed.floating.point.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message8).create();
            }
        } else if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            if (value2 == null) {
                if (!StringUtil.startsWithChar((CharSequence)text2, (char)'\'')) {
                    return null;
                }
                if (!StringUtil.endsWithChar((CharSequence)text2, (char)'\'') || text2.length() == 1) {
                    String message9 = JavaErrorMessages.message("unclosed.char.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message9).create();
                }
                success = PsiLiteralExpressionImpl.parseStringCharacters(text2 = text2.substring(1, text2.length() - 1), (StringBuilder)(chars = new StringBuilder()), null) ? 1 : 0;
                if (success == 0) {
                    String message10 = JavaErrorMessages.message("illegal.escape.character.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message10).create();
                }
                int length = ((StringBuilder)chars).length();
                if (length > 1) {
                    String message11 = JavaErrorMessages.message("too.many.characters.in.character.literal", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message11).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createConvertToStringLiteralAction());
                    return info;
                }
                if (length == 0) {
                    String message12 = JavaErrorMessages.message("empty.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message12).create();
                }
            }
        } else if (type2 == JavaTokenType.STRING_LITERAL && value2 == null) {
            String message13;
            for (PsiElement element : expression2.getChildren()) {
                if (!(element instanceof OuterLanguageElement)) continue;
                return null;
            }
            if (!StringUtil.startsWithChar((CharSequence)text2, (char)'\"')) {
                return null;
            }
            if (StringUtil.endsWithChar((CharSequence)text2, (char)'\"')) {
                if (text2.length() == 1) {
                    message13 = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message13).create();
                }
            } else {
                message13 = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message13).create();
            }
            text2 = text2.substring(1, text2.length() - 1);
            chars = new StringBuilder();
            success = PsiLiteralExpressionImpl.parseStringCharacters(text2, (StringBuilder)chars, null) ? 1 : 0;
            if (success == 0) {
                String message14 = JavaErrorMessages.message("illegal.escape.character.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message14).create();
            }
        }
        if (value2 instanceof Float) {
            number = (Float)value2;
            if (((Float)number).isInfinite()) {
                String message15 = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message15).create();
            }
            if (((Float)number).floatValue() == 0.0f && !TypeConversionUtil.isFPZero((String)text2)) {
                String message16 = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message16).create();
            }
        } else if (value2 instanceof Double) {
            number = (Double)value2;
            if (((Double)number).isInfinite()) {
                String message17 = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message17).create();
            }
            if ((Double)number == 0.0 && !TypeConversionUtil.isFPZero((String)text2)) {
                String message18 = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message18).create();
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkUnderscores(@NotNull PsiElement expression2, @NotNull String text2, boolean isInt) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(57);
        }
        if (text2 == null) {
            HighlightUtil.$$$reportNull$$$0(58);
        }
        String[] parts = ArrayUtil.EMPTY_STRING_ARRAY;
        if (isInt) {
            int start = 0;
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            int end = text2.length();
            if (StringUtil.endsWithChar((CharSequence)text2, (char)'l')) {
                --end;
            }
            parts = new String[]{text2.substring(start, end)};
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text2);
            if (matcher.matches()) {
                parts = new String[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts[i] = matcher.group(i + 1);
                }
            }
        }
        for (String part : parts) {
            if (part == null || !StringUtil.startsWithChar((CharSequence)part, (char)'_') && !StringUtil.endsWithChar((CharSequence)part, (char)'_')) continue;
            String message2 = JavaErrorMessages.message("illegal.underscore", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeBoolean(@NotNull PsiExpression expr, @Nullable PsiType type2) {
        PsiElement parent;
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(59);
        }
        if ((parent = expr.getParent()) instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement && expr.equals(((PsiForStatement)parent).getCondition()) || parent instanceof PsiDoWhileStatement && expr.equals(((PsiDoWhileStatement)parent).getCondition())) {
            if (expr.getNextSibling() instanceof PsiErrorElement) {
                return null;
            }
            if (!TypeConversionUtil.isBooleanType((PsiType)type2)) {
                return HighlightUtil.createMustBeBooleanInfo(expr, type2);
            }
        }
        return null;
    }

    private static HighlightInfo createMustBeBooleanInfo(@NotNull PsiExpression expr, @Nullable PsiType type2) {
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(60);
        }
        HighlightInfo info = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type2, expr.getTextRange(), 0);
        if (expr instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expr;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.BOOLEAN, true));
            }
        } else if (expr instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr).getOperationTokenType() == JavaTokenType.EQ) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAssignmentToComparisonFix((PsiAssignmentExpression)expr));
        }
        return info;
    }

    @NotNull
    static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiTryStatement statement) {
        PsiResourceList resources;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(61);
        }
        HashSet thrownTypes = ContainerUtil.newHashSet();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock));
        }
        if ((resources = statement.getResourceList()) != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)resources, (PsiElement)resources));
        }
        HashSet hashSet = thrownTypes;
        if (hashSet == null) {
            HighlightUtil.$$$reportNull$$$0(62);
        }
        return hashSet;
    }

    @Nullable
    static List<HighlightInfo> checkExceptionThrownInTry(@NotNull PsiParameter parameter2, @NotNull Set<? extends PsiClassType> thrownTypes) {
        PsiElement declarationScope;
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(63);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(64);
        }
        if (!((declarationScope = parameter2.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiType caughtType = parameter2.getType();
        if (caughtType instanceof PsiClassType) {
            HighlightInfo info = HighlightUtil.checkSimpleCatchParameter(parameter2, thrownTypes, (PsiClassType)caughtType);
            return info == null ? null : Collections.singletonList(info);
        }
        if (caughtType instanceof PsiDisjunctionType) {
            return HighlightUtil.checkMultiCatchParameter(parameter2, thrownTypes);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSimpleCatchParameter(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownTypes, @NotNull PsiClassType caughtType) {
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(65);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(66);
        }
        if (caughtType == null) {
            HighlightUtil.$$$reportNull$$$0(67);
        }
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass(caughtType)) {
            return null;
        }
        for (PsiClassType psiClassType : thrownTypes) {
            if (!psiClassType.isAssignableFrom((PsiType)caughtType) && !caughtType.isAssignableFrom((PsiType)psiClassType)) continue;
            return null;
        }
        String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType((PsiType)caughtType));
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteCatchFix(parameter2));
        return highlightInfo;
    }

    @NotNull
    private static List<HighlightInfo> checkMultiCatchParameter(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownTypes) {
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(68);
        }
        if (thrownTypes == null) {
            HighlightUtil.$$$reportNull$$$0(69);
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(typeElements.size());
        for (PsiTypeElement typeElement : typeElements) {
            PsiType catchType = typeElement.getType();
            if (catchType instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)catchType)) continue;
            boolean used = false;
            for (PsiClassType psiClassType : thrownTypes) {
                if (!psiClassType.isAssignableFrom(catchType) && !catchType.isAssignableFrom((PsiType)psiClassType)) continue;
                used = true;
                break;
            }
            if (used) continue;
            String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType(catchType));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
            highlights.add(highlightInfo);
        }
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            HighlightUtil.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    @Nullable
    static Collection<HighlightInfo> checkWithImprovedCatchAnalysis(@NotNull PsiParameter parameter2, @NotNull Collection<? extends PsiClassType> thrownInTryStatement, @NotNull PsiFile containingFile) {
        PsiElement scope;
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(71);
        }
        if (thrownInTryStatement == null) {
            HighlightUtil.$$$reportNull$$$0(72);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(73);
        }
        if (!((scope = parameter2.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int idx = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection);
        if (idx <= 0) {
            return null;
        }
        HashSet thrownTypes = ContainerUtil.newHashSet(thrownInTryStatement);
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope parameterResolveScope = parameter2.getResolveScope();
        thrownTypes.add(PsiType.getJavaLangError((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        thrownTypes.add(PsiType.getJavaLangRuntimeException((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        ArrayList result = ContainerUtil.newArrayList();
        List parameterTypeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        boolean isMultiCatch = parameterTypeElements.size() > 1;
        for (PsiTypeElement catchTypeElement : parameterTypeElements) {
            List caught;
            PsiType catchType = catchTypeElement.getType();
            if (ExceptionUtil.isGeneralExceptionType(catchType) || (caught = ContainerUtil.findAll((Collection)thrownTypes, type2 -> catchType.isAssignableFrom((PsiType)type2) || type2.isAssignableFrom(catchType))).isEmpty()) continue;
            HashSet caughtCopy = ContainerUtil.newHashSet((Iterable)caught);
            block1: for (int i = 0; i < idx; ++i) {
                PsiParameter prevCatchParameter = allCatchSections[i].getParameter();
                if (prevCatchParameter == null) continue;
                for (PsiTypeElement prevCatchTypeElement : PsiUtil.getParameterTypeElements((PsiParameter)prevCatchParameter)) {
                    PsiType prevCatchType = prevCatchTypeElement.getType();
                    caught.removeIf(arg_0 -> ((PsiType)prevCatchType).isAssignableFrom(arg_0));
                    if (!caught.isEmpty()) continue;
                    continue block1;
                }
            }
            if (!caught.isEmpty()) continue;
            String message2 = JavaErrorMessages.message("exception.already.caught.warn", HighlightUtil.formatTypes(caughtCopy), caughtCopy.size());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)catchSection).descriptionAndTooltip(message2).create();
            if (isMultiCatch) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMultiCatchFix(catchTypeElement));
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteCatchFix(parameter2));
            }
            result.add(highlightInfo);
        }
        return result;
    }

    @Nullable
    static HighlightInfo checkNotAStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(74);
        }
        if (!PsiUtil.isStatement((PsiElement)statement) && !PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
            boolean isDeclarationNotAllowed = false;
            if (statement instanceof PsiDeclarationStatement) {
                PsiElement parent = statement.getParent();
                isDeclarationNotAllowed = parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement;
            }
            String description = JavaErrorMessages.message(isDeclarationNotAllowed ? "declaration.not.allowed" : "not.a.statement", new Object[0]);
            HighlightInfo error = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            if (statement instanceof PsiExpressionStatement) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)error, (IntentionAction)QuickFixFactory.getInstance().createDeleteSideEffectAwareFix((PsiExpressionStatement)statement));
            }
            return error;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSwitchSelectorType(@NotNull PsiSwitchBlock switchBlock, @NotNull LanguageLevel level) {
        PsiExpression expression2;
        if (switchBlock == null) {
            HighlightUtil.$$$reportNull$$$0(75);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(76);
        }
        if ((expression2 = switchBlock.getExpression()) == null) {
            return null;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return null;
        }
        SelectorKind kind2 = HighlightUtil.getSwitchSelectorKind(type2);
        if (kind2 == SelectorKind.INT) {
            return null;
        }
        LanguageLevel requiredLevel = null;
        if (kind2 == SelectorKind.ENUM) {
            requiredLevel = LanguageLevel.JDK_1_5;
        }
        if (kind2 == SelectorKind.STRING) {
            requiredLevel = LanguageLevel.JDK_1_7;
        }
        if (kind2 == null || requiredLevel != null && !level.isAtLeast(requiredLevel)) {
            boolean is7 = level.isAtLeast(LanguageLevel.JDK_1_7);
            String expected = JavaErrorMessages.message(is7 ? "valid.switch.17.selector.types" : "valid.switch.selector.types", new Object[0]);
            String message2 = JavaErrorMessages.message("incompatible.types", expected, JavaHighlightUtil.formatType(type2));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
            if (switchBlock instanceof PsiSwitchStatement) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createConvertSwitchToIfIntention((PsiSwitchStatement)switchBlock));
            }
            if (PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix((PsiType)PsiType.INT, expression2));
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createWrapWithAdapterFix((PsiType)PsiType.INT, expression2));
            }
            if (requiredLevel != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(requiredLevel));
            }
            return info;
        }
        PsiClass member = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (member != null && !PsiUtil.isAccessible((Project)member.getProject(), (PsiMember)member, (PsiElement)expression2, null)) {
            String className = PsiFormatUtil.formatClass((PsiClass)member, (int)2049);
            String message3 = JavaErrorMessages.message("inaccessible.type", className);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    static Collection<HighlightInfo> checkSwitchExpressionReturnTypeCompatible(PsiSwitchExpression switchExpression) {
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)switchExpression)) {
            return null;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        PsiType switchExpressionType = switchExpression.getType();
        if (switchExpressionType != null) {
            for (PsiExpression expression2 : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)switchExpression)) {
                PsiType expressionType = (PsiType)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression2, true, () -> ((PsiExpression)expression2).getType());
                if (expressionType == null || switchExpressionType.isAssignableFrom(expressionType)) continue;
                infos.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip("Bad type in switch expression: " + expressionType.getCanonicalText() + " cannot be converted to " + switchExpressionType.getCanonicalText()).create());
            }
            if (PsiType.VOID.equals((Object)switchExpressionType)) {
                infos.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(switchExpression.getFirstChild()).descriptionAndTooltip("Target type for switch expression cannot be void").create());
            }
        }
        return infos;
    }

    private static SelectorKind getSwitchSelectorKind(@NotNull PsiType type2) {
        if (type2 == null) {
            HighlightUtil.$$$reportNull$$$0(77);
        }
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 4) {
            return SelectorKind.INT;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return SelectorKind.ENUM;
            }
            if (Comparing.strEqual((String)psiClass.getQualifiedName(), (String)"java.lang.String")) {
                return SelectorKind.STRING;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPolyadicOperatorApplicable(@NotNull PsiPolyadicExpression expression2) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(78);
        }
        PsiExpression[] operands2 = expression2.getOperands();
        PsiType lType = operands2[0].getType();
        IElementType operationSign = expression2.getOperationTokenType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            PsiType rType = operand2.getType();
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationSign, (PsiType)lType, (PsiType)rType, (boolean)false)) {
                PsiJavaToken token = expression2.getTokenBeforeOperand(operand2);
                assert (token != null) : expression2;
                String message2 = JavaErrorMessages.message("binary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(message2).create();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)operationSign, (boolean)true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnaryOperatorApplicable(@NotNull PsiJavaToken token, @Nullable PsiExpression expression2) {
        if (token == null) {
            HighlightUtil.$$$reportNull$$$0(79);
        }
        if (expression2 != null && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)token, (PsiExpression)expression2)) {
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return null;
            }
            String message2 = JavaErrorMessages.message("unary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(type2));
            PsiElement parentExpr = token.getParent();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(parentExpr).descriptionAndTooltip(message2).create();
            if (parentExpr instanceof PsiPrefixExpression && token.getTokenType() == JavaTokenType.EXCL) {
                PsiMethod method;
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createNegationBroadScopeFix((PsiPrefixExpression)parentExpr));
                if (expression2 instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expression2).resolveMethod()) != null) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.BOOLEAN, true));
                }
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThisOrSuperExpressionInIllegalContext(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull LanguageLevel languageLevel) {
        PsiMethod psiMethod;
        PsiClass classT;
        PsiClass aClass;
        PsiElement resolved;
        PsiElement parent;
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(80);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(81);
        }
        if (expr instanceof PsiSuperExpression && !((parent = expr.getParent()) instanceof PsiReferenceExpression)) {
            int o = expr.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("dot.expected.after.super.or.this", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(o, o + 1).descriptionAndTooltip(description).create();
        }
        if (qualifier != null) {
            resolved = qualifier.advancedResolve(true).getElement();
            if (resolved != null && !(resolved instanceof PsiClass)) {
                String description = JavaErrorMessages.message("class.expected", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
            aClass = (PsiClass)resolved;
        } else {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)aClass).getArgumentList(), (PsiElement)expr, (boolean)false)) {
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
            }
        }
        if (aClass == null) {
            return null;
        }
        if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)expr, (boolean)false, (boolean)false)) {
            if (!HighlightUtil.resolvesToImmediateSuperInterface(expr, qualifier, aClass, languageLevel)) {
                return HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)expr, null, aClass, (PsiElement)expr);
            }
            if (expr instanceof PsiSuperExpression && (resolved = ((PsiReferenceExpression)expr.getParent()).resolve()) instanceof PsiField) {
                String description = JavaErrorMessages.message("is.not.an.enclosing.class", HighlightUtil.formatClass(aClass));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(description).create();
            }
        }
        if (qualifier != null && aClass.isInterface() && expr instanceof PsiSuperExpression && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (classT = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null) {
            PsiElement parent2 = expr.getParent();
            PsiElement resolved2 = parent2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)parent2).resolve() : null;
            PsiClass containingClass = (PsiClass)ObjectUtils.notNull((Object)(resolved2 instanceof PsiMethod ? ((PsiMethod)resolved2).getContainingClass() : null), (Object)aClass);
            for (PsiClass superClass : classT.getSupers()) {
                if (!superClass.isInheritor(containingClass, true)) continue;
                String cause = null;
                if (superClass.isInheritor(aClass, true) && superClass.isInterface()) {
                    cause = "redundant interface " + HighlightUtil.format((PsiElement)containingClass) + " is extended by ";
                } else if (resolved2 instanceof PsiMethod && MethodSignatureUtil.findMethodBySuperMethod((PsiClass)superClass, (PsiMethod)((PsiMethod)resolved2), (boolean)true) != resolved2) {
                    cause = "method " + ((PsiMethod)resolved2).getName() + " is overridden in ";
                }
                if (cause == null) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorMessages.message("bad.qualifier.in.super.method.reference", cause + HighlightUtil.formatClass(superClass))).create();
            }
            if (!classT.isInheritor(aClass, false)) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.format((PsiElement)aClass))).create();
            }
        }
        if (expr instanceof PsiThisExpression && ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) == null || psiMethod.getContainingClass() != aClass && !HighlightUtil.isInsideDefaultMethod(psiMethod, aClass))) {
            PsiClass parentClass;
            if (aClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)aClass).getArgumentList(), (PsiElement)expr, (boolean)true) && (parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true)) != null && parentClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
        }
        return null;
    }

    static HighlightInfo checkUnqualifiedSuperInDefaultMethod(@NotNull LanguageLevel languageLevel, @NotNull PsiReferenceExpression expr, @Nullable PsiExpression qualifier) {
        PsiMethod method;
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(82);
        }
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(83);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && qualifier instanceof PsiSuperExpression && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) != null && method.hasModifierProperty("default") && ((PsiSuperExpression)qualifier).getQualifier() == null) {
            String description = JavaErrorMessages.message("unqualified.super.disallowed", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(description).create();
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifier, info);
            return info;
        }
        return null;
    }

    private static boolean isInsideDefaultMethod(@NotNull PsiMethod method, @NotNull PsiClass aClass) {
        if (method == null) {
            HighlightUtil.$$$reportNull$$$0(84);
        }
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(85);
        }
        while (method != null && method.getContainingClass() != aClass) {
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true);
        }
        return method != null && method.hasModifierProperty("default");
    }

    private static HighlightInfo thisNotFoundInInterfaceInfo(@NotNull PsiExpression expr) {
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(86);
        }
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip("Cannot find symbol variable this").create();
    }

    private static boolean resolvesToImmediateSuperInterface(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull PsiClass aClass, @NotNull LanguageLevel languageLevel) {
        if (expr == null) {
            HighlightUtil.$$$reportNull$$$0(87);
        }
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(88);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(89);
        }
        if (!(expr instanceof PsiSuperExpression) || qualifier == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiType superType = expr.getType();
        if (!(superType instanceof PsiClassType)) {
            return false;
        }
        PsiClass superClass = ((PsiClassType)superType).resolve();
        return aClass.equals(superClass) && PsiUtil.getEnclosingStaticElement((PsiElement)expr, (PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class))) == null;
    }

    @NotNull
    static String staticContextProblemDescription(@NotNull PsiElement refElement) {
        if (refElement == null) {
            HighlightUtil.$$$reportNull$$$0(90);
        }
        String type2 = LanguageFindUsages.getType((PsiElement)refElement);
        String name = HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY);
        String string = JavaErrorMessages.message("non.static.symbol.referenced.from.static.context", type2, name);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(91);
        }
        return string;
    }

    @NotNull
    static String accessProblemDescription(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(92);
        }
        if (resolved == null) {
            HighlightUtil.$$$reportNull$$$0(93);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(94);
        }
        String string = (String)HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)ref, (PsiElement)resolved, (JavaResolveResult)result).first;
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(95);
        }
        return string;
    }

    @NotNull
    static Pair<String, List<IntentionAction>> accessProblemDescriptionAndFixes(@NotNull PsiElement ref, @NotNull PsiElement resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(96);
        }
        if (resolved == null) {
            HighlightUtil.$$$reportNull$$$0(97);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(98);
        }
        assert (resolved instanceof PsiModifierListOwner) : resolved;
        PsiModifierListOwner refElement = (PsiModifierListOwner)resolved;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        if (refElement.hasModifierProperty("private")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair pair = Pair.pair((Object)JavaErrorMessages.message("private.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(99);
            }
            return pair;
        }
        if (refElement.hasModifierProperty("protected")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair pair = Pair.pair((Object)JavaErrorMessages.message("protected.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(100);
            }
            return pair;
        }
        PsiClass packageLocalClass = HighlightFixUtil.getPackageLocalClassInTheMiddle(ref);
        if (packageLocalClass != null) {
            refElement = packageLocalClass;
            symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        }
        if (refElement.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            Pair pair = Pair.pair((Object)JavaErrorMessages.message("package.local.symbol", symbolName, containerName), null);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(101);
            }
            return pair;
        }
        String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
        JavaModuleSystemEx.ErrorWithFixes problem = HighlightUtil.checkModuleAccess(resolved, ref, symbolName, containerName);
        if (problem != null) {
            Pair pair = Pair.pair((Object)problem.message, (Object)problem.fixes);
            if (pair == null) {
                HighlightUtil.$$$reportNull$$$0(102);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)JavaErrorMessages.message("visibility.access.problem", symbolName, containerName), null);
        if (pair == null) {
            HighlightUtil.$$$reportNull$$$0(103);
        }
        return pair;
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkModuleAccess(@NotNull PsiElement target, @NotNull PsiElement place, @Nullable String symbolName, @Nullable String containerName) {
        if (target == null) {
            HighlightUtil.$$$reportNull$$$0(104);
        }
        if (place == null) {
            HighlightUtil.$$$reportNull$$$0(105);
        }
        JavaModuleSystemEx.ErrorWithFixes error = null;
        for (JavaModuleSystem moduleSystem : (JavaModuleSystem[])JavaModuleSystem.EP_NAME.getExtensions()) {
            if (moduleSystem instanceof JavaModuleSystemEx) {
                error = HighlightUtil.checkAccess((JavaModuleSystemEx)moduleSystem, target, place);
            } else if (!HighlightUtil.isAccessible(moduleSystem, target, place)) {
                String message2 = JavaErrorMessages.message("visibility.module.access.problem", symbolName, containerName, moduleSystem.getName());
                error = new JavaModuleSystemEx.ErrorWithFixes(message2);
            }
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull JavaModuleSystemEx system, @NotNull PsiElement target, @NotNull PsiElement place) {
        if (system == null) {
            HighlightUtil.$$$reportNull$$$0(106);
        }
        if (target == null) {
            HighlightUtil.$$$reportNull$$$0(107);
        }
        if (place == null) {
            HighlightUtil.$$$reportNull$$$0(108);
        }
        if (target instanceof PsiClass) {
            return system.checkAccess((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.checkAccess(((PsiPackage)target).getQualifiedName(), null, place);
        }
        return null;
    }

    private static boolean isAccessible(@NotNull JavaModuleSystem system, @NotNull PsiElement target, @NotNull PsiElement place) {
        if (system == null) {
            HighlightUtil.$$$reportNull$$$0(109);
        }
        if (target == null) {
            HighlightUtil.$$$reportNull$$$0(110);
        }
        if (place == null) {
            HighlightUtil.$$$reportNull$$$0(111);
        }
        if (target instanceof PsiClass) {
            return system.isAccessible((PsiClass)target, place);
        }
        if (target instanceof PsiPackage) {
            return system.isAccessible(((PsiPackage)target).getQualifiedName(), null, place);
        }
        return true;
    }

    private static PsiElement getContainer(@NotNull PsiModifierListOwner refElement) {
        if (refElement == null) {
            HighlightUtil.$$$reportNull$$$0(112);
        }
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer((PsiElement)refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    private static String getContainerName(@NotNull PsiModifierListOwner refElement, @NotNull PsiSubstitutor substitutor) {
        PsiElement container;
        if (refElement == null) {
            HighlightUtil.$$$reportNull$$$0(113);
        }
        if (substitutor == null) {
            HighlightUtil.$$$reportNull$$$0(114);
        }
        return (container = HighlightUtil.getContainer(refElement)) == null ? "?" : HighlightMessageUtil.getSymbolName(container, substitutor);
    }

    @Nullable
    static HighlightInfo checkValidArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        PsiExpression arrayExpression;
        PsiType arrayExpressionType;
        if (arrayAccessExpression == null) {
            HighlightUtil.$$$reportNull$$$0(115);
        }
        if ((arrayExpressionType = (arrayExpression = arrayAccessExpression.getArrayExpression()).getType()) != null && !(arrayExpressionType instanceof PsiArrayType)) {
            String description = JavaErrorMessages.message("array.type.expected", JavaHighlightUtil.formatType(arrayExpressionType));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)arrayExpression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createReplaceWithListAccessFix(arrayAccessExpression));
            return info;
        }
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        return indexExpression != null ? HighlightUtil.checkAssignability((PsiType)PsiType.INT, indexExpression.getType(), indexExpression, (PsiElement)indexExpression) : null;
    }

    @Nullable
    static HighlightInfo checkCatchParameterIsThrowable(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(116);
        }
        if (parameter2.getDeclarationScope() instanceof PsiCatchSection) {
            PsiType type2 = parameter2.getType();
            return HighlightUtil.checkMustBeThrowable(type2, (PsiElement)parameter2, true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkTryResourceIsAutoCloseable(@NotNull PsiResourceListElement resource) {
        PsiType type2;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(117);
        }
        if ((type2 = resource.getType()) == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)resource.getProject());
        PsiClassType autoCloseable = factory.createTypeByFQClassName("java.lang.AutoCloseable", resource.getResolveScope());
        if (TypeConversionUtil.isAssignable((PsiType)autoCloseable, (PsiType)type2)) {
            return null;
        }
        return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)autoCloseable, type2, resource.getTextRange(), 0);
    }

    @Nullable
    static HighlightInfo checkResourceVariableIsFinal(@NotNull PsiResourceExpression resource) {
        PsiExpression expression2;
        if (resource == null) {
            HighlightUtil.$$$reportNull$$$0(118);
        }
        if ((expression2 = resource.getExpression()) instanceof PsiThisExpression) {
            return null;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression2).resolve();
            if (target == null) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                PsiModifierList modifierList = variable.getModifierList();
                if (modifierList != null && modifierList.hasModifierProperty("final")) {
                    return null;
                }
                if (!(variable instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)resource, (PsiJavaCodeReferenceElement)expression2)) {
                    return null;
                }
            }
            String text2 = JavaErrorMessages.message("resource.variable.must.be.final", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(text2).create();
        }
        String text3 = JavaErrorMessages.message("declaration.or.variable.expected", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(text3).create();
    }

    @Nullable
    static Collection<HighlightInfo> checkArrayInitializer(@NotNull PsiExpression initializer, @Nullable PsiType type2) {
        PsiExpression[] initializers;
        if (initializer == null) {
            HighlightUtil.$$$reportNull$$$0(119);
        }
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        if (!(type2 instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)initializer;
        boolean arrayTypeFixChecked = false;
        VariableArrayTypeFix fix2 = null;
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (PsiExpression expression2 : initializers = arrayInitializer.getInitializers()) {
            HighlightInfo info = HighlightUtil.checkArrayInitializerCompatibleTypes(expression2, componentType);
            if (info == null) continue;
            result.add(info);
            if (!arrayTypeFixChecked) {
                PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                fix2 = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                arrayTypeFixChecked = true;
            }
            if (fix2 == null) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(fix2));
        }
        return result;
    }

    @Nullable
    private static HighlightInfo checkArrayInitializerCompatibleTypes(@NotNull PsiExpression initializer, @NotNull PsiType componentType) {
        PsiType initializerType;
        if (initializer == null) {
            HighlightUtil.$$$reportNull$$$0(120);
        }
        if (componentType == null) {
            HighlightUtil.$$$reportNull$$$0(121);
        }
        if ((initializerType = initializer.getType()) == null) {
            String description = JavaErrorMessages.message("illegal.initializer", JavaHighlightUtil.formatType(componentType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
        }
        PsiExpression expression2 = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
        return HighlightUtil.checkAssignability(componentType, initializerType, expression2, (PsiElement)initializer);
    }

    @Nullable
    static HighlightInfo checkExpressionRequired(@NotNull PsiReferenceExpression expression2, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(122);
        }
        if (resultForIncompleteCode == null) {
            HighlightUtil.$$$reportNull$$$0(123);
        }
        if (expression2.getNextSibling() instanceof PsiErrorElement) {
            return null;
        }
        PsiElement resolved = resultForIncompleteCode.getElement();
        if (resolved == null || resolved instanceof PsiVariable) {
            return null;
        }
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression || parent instanceof PsiBreakStatement) {
            return null;
        }
        String description = JavaErrorMessages.message("expression.expected", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)expression2, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
        return info;
    }

    @Nullable
    static HighlightInfo checkArrayInitializerApplicable(@NotNull PsiArrayInitializerExpression expression2) {
        PsiElement parent;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(124);
        }
        if ((parent = expression2.getParent()) instanceof PsiVariable) {
            boolean isInferredType;
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement typeElement = variable.getTypeElement();
            boolean bl = isInferredType = typeElement != null && typeElement.isInferredType();
            if (!isInferredType && variable.getType() instanceof PsiArrayType) {
                return null;
            }
        } else if (parent instanceof PsiNewExpression || parent instanceof PsiArrayInitializerExpression) {
            return null;
        }
        String description = JavaErrorMessages.message("array.initializer.not.allowed", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddNewArrayExpressionFix(expression2));
        return info;
    }

    @Nullable
    static HighlightInfo checkCaseStatement(@NotNull PsiSwitchLabelStatementBase statement) {
        PsiSwitchBlock switchBlock;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(125);
        }
        if ((switchBlock = statement.getEnclosingSwitchBlock()) == null) {
            String description = JavaErrorMessages.message("case.statement.outside.switch", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkSwitchLabelValues(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body2;
        if (switchBlock == null) {
            HighlightUtil.$$$reportNull$$$0(126);
        }
        if ((body2 = switchBlock.getBody()) == null) {
            return null;
        }
        PsiExpression selectorExpression = switchBlock.getExpression();
        PsiPrimitiveType selectorType = selectorExpression == null ? PsiType.INT : selectorExpression.getType();
        MultiMap values = new MultiMap();
        Object defaultValue = new Object();
        ArrayList<HighlightInfo> results = new ArrayList<HighlightInfo>();
        boolean hasDefaultCase = false;
        for (PsiStatement st : body2.getStatements()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            boolean defaultCase = labelStatement.isDefaultCase();
            if (defaultCase) {
                values.putValue(defaultValue, ObjectUtils.notNull((Object)labelStatement.getFirstChild(), (Object)labelStatement));
                hasDefaultCase = true;
                continue;
            }
            PsiExpressionList expressionList = labelStatement.getCaseValues();
            if (expressionList == null) continue;
            for (PsiExpression expr : expressionList.getExpressions()) {
                PsiElement element;
                HighlightInfo result;
                if (selectorExpression != null && (result = HighlightUtil.checkAssignability((PsiType)selectorType, expr.getType(), expr, (PsiElement)expr)) != null) {
                    results.add(result);
                    continue;
                }
                Object value2 = null;
                if (expr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expr).resolve()) instanceof PsiEnumConstant) {
                    value2 = ((PsiEnumConstant)element).getName();
                    if (((PsiReferenceExpression)expr).getQualifier() != null) {
                        String message2 = JavaErrorMessages.message("qualified.enum.constant.in.switch", new Object[0]);
                        results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(message2).create());
                        continue;
                    }
                }
                if (value2 == null) {
                    value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expr, (PsiType)selectorType);
                }
                if (value2 == null) {
                    String description = JavaErrorMessages.message("constant.expression.required", new Object[0]);
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(description).create());
                    continue;
                }
                values.putValue(value2, (Object)expr);
            }
        }
        for (Map.Entry entry : values.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            Object value3 = entry.getKey();
            PsiField[] description = value3 == defaultValue ? JavaErrorMessages.message("duplicate.default.switch.label", new Object[0]) : JavaErrorMessages.message("duplicate.switch.label", value3);
            for (PsiElement element : (Collection)entry.getValue()) {
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip((String)description).create());
            }
        }
        if (results.isEmpty() && switchBlock instanceof PsiSwitchExpression) {
            PsiClass type2;
            com.intellij.util.containers.hash.HashSet missingConstants = new com.intellij.util.containers.hash.HashSet();
            boolean exhaustive = hasDefaultCase;
            if (!exhaustive && !values.isEmpty() && selectorType instanceof PsiClassType && (type2 = ((PsiClassType)selectorType).resolve()) != null && type2.isEnum()) {
                for (PsiField field : type2.getFields()) {
                    if (!(field instanceof PsiEnumConstant) || values.containsKey((Object)field.getName())) continue;
                    missingConstants.add(field.getName());
                }
                exhaustive = missingConstants.isEmpty();
            }
            if (!exhaustive) {
                PsiElement range = (PsiElement)ObjectUtils.notNull((Object)selectorExpression, (Object)switchBlock);
                String message3 = JavaErrorMessages.message(values.isEmpty() ? "switch.expr.empty" : "switch.expr.incomplete", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(message3).create();
                if (!missingConstants.isEmpty()) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddMissingEnumBranchesFix(switchBlock, (Set)missingConstants));
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddSwitchDefaultFix(switchBlock, null));
                results.add(info);
            }
        }
        return results;
    }

    @Nullable
    static Collection<HighlightInfo> checkSwitchExpressionHasResult(@NotNull PsiSwitchExpression switchExpression) {
        PsiCodeBlock switchBody;
        if (switchExpression == null) {
            HighlightUtil.$$$reportNull$$$0(127);
        }
        if ((switchBody = switchExpression.getBody()) != null) {
            PsiStatement lastStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)switchBody.getRBrace(), PsiStatement.class);
            if (lastStatement instanceof PsiSwitchLabeledRuleStatement) {
                ArrayList<HighlightInfo> results = new ArrayList<HighlightInfo>();
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)lastStatement;
                while (rule != null) {
                    PsiStatement ruleBody = rule.getBody();
                    if (ruleBody instanceof PsiBlockStatement && ControlFlowUtils.statementMayCompleteNormally(ruleBody)) {
                        PsiElement target = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)rule.getFirstChild(), PsiKeyword.class), (Object)rule);
                        results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(target).descriptionAndTooltip(JavaErrorMessages.message("switch.expr.rule.should.produce.result", new Object[0])).create());
                    }
                    rule = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)rule, PsiSwitchLabeledRuleStatement.class);
                }
                return results;
            }
            if (lastStatement != null && ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                PsiElement target = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.tryCast((Object)switchExpression.getFirstChild(), PsiKeyword.class), (Object)switchExpression);
                return Collections.singletonList(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(target).descriptionAndTooltip(JavaErrorMessages.message("switch.expr.should.produce.result", new Object[0])).create());
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression2, @NotNull PsiField referencedField) {
        Boolean isIllegalForwardReference;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(128);
        }
        if (referencedField == null) {
            HighlightUtil.$$$reportNull$$$0(129);
        }
        if ((isIllegalForwardReference = HighlightUtil.isIllegalForwardReferenceToField(expression2, referencedField, false)) == null) {
            return null;
        }
        String description = JavaErrorMessages.message(isIllegalForwardReference != false ? "illegal.forward.reference" : "illegal.self.reference", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
    }

    public static Boolean isIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression2, @NotNull PsiField referencedField, boolean acceptQualified) {
        boolean inStaticContext;
        PsiClass containingClass;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(130);
        }
        if (referencedField == null) {
            HighlightUtil.$$$reportNull$$$0(131);
        }
        if ((containingClass = referencedField.getContainingClass()) == null) {
            return null;
        }
        if (expression2.getContainingFile() != referencedField.getContainingFile()) {
            return null;
        }
        TextRange fieldRange = referencedField.getTextRange();
        if (fieldRange == null || expression2.getTextRange().getStartOffset() >= fieldRange.getEndOffset()) {
            return null;
        }
        if (!acceptQualified && expression2.getQualifierExpression() != null) {
            return null;
        }
        PsiField initField = HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression2);
        PsiClassInitializer classInitializer = HighlightUtil.findParentClassInitializer((PsiElement)expression2);
        if (initField == null && classInitializer == null) {
            return null;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            return null;
        }
        if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2) && !PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
            return null;
        }
        if (!containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class))) {
            return null;
        }
        return initField != referencedField;
    }

    @Nullable
    static PsiField findEnclosingFieldInitializer(@NotNull PsiElement entry) {
        if (entry == null) {
            HighlightUtil.$$$reportNull$$$0(132);
        }
        PsiElement element = entry;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    @Nullable
    private static PsiClassInitializer findParentClassInitializer(@NotNull PsiElement root) {
        if (root == null) {
            HighlightUtil.$$$reportNull$$$0(133);
        }
        for (PsiElement element = root; element != null; element = element.getParent()) {
            if (element instanceof PsiClassInitializer) {
                return (PsiClassInitializer)element;
            }
            if (!(element instanceof PsiClass) && !(element instanceof PsiMethod)) continue;
            return null;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalType(@NotNull PsiTypeElement typeElement) {
        PsiClass aClass;
        if (typeElement == null) {
            HighlightUtil.$$$reportNull$$$0(134);
        }
        if (typeElement.getParent() instanceof PsiTypeElement) {
            return null;
        }
        if (PsiUtil.isInsideJavadocComment((PsiElement)typeElement)) {
            return null;
        }
        PsiType type2 = typeElement.getType();
        PsiType componentType = type2.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType((PsiType)componentType)) == null) {
            String canonicalText = type2.getCanonicalText();
            String description = JavaErrorMessages.message("unknown.class", canonicalText);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement != null) {
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)referenceElement, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
            }
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalVoidType(@NotNull PsiKeyword type2) {
        if (type2 == null) {
            HighlightUtil.$$$reportNull$$$0(135);
        }
        if (!"void".equals(type2.getText())) {
            return null;
        }
        PsiElement parent = type2.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiMethod method;
            PsiElement typeOwner = parent.getParent();
            if (typeOwner != null && PsiUtilCore.hasErrorElementChild((PsiElement)typeOwner)) {
                return null;
            }
            if (typeOwner instanceof PsiMethod ? (method = (PsiMethod)typeOwner).getReturnTypeElement() == parent && PsiType.VOID.equals((Object)method.getReturnType()) : (typeOwner instanceof PsiClassObjectAccessExpression ? TypeConversionUtil.isVoidType((PsiType)((PsiClassObjectAccessExpression)typeOwner).getOperand().getType()) : typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null)) {
                return null;
            }
        }
        String description = JavaErrorMessages.message("illegal.type.void", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)type2).descriptionAndTooltip(description).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static HighlightInfo checkMemberReferencedBeforeConstructorCalled(@NotNull PsiElement expression2, @Nullable PsiElement resolved, @NotNull PsiFile containingFile) {
        PsiClass aClass;
        String resolvedName;
        PsiClass referencedClass;
        PsiType type2;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(136);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(137);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            if ("this".equals(((PsiJavaCodeReferenceElement)expression2).getReferenceName()) && resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            PsiElement qualifier = ((PsiJavaCodeReferenceElement)expression2).getQualifier();
            type2 = qualifier instanceof PsiExpression ? ((PsiExpression)qualifier).getType() : null;
            referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
            boolean isSuperCall = JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)expression2.getParent());
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    resolved = ((PsiReferenceExpression)qualifier).resolve();
                    expression2 = qualifier;
                    type2 = ((PsiReferenceExpression)qualifier).getType();
                    referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
                } else if (qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (resolved != null) {
                        referencedClass = ((PsiMethod)resolved).getContainingClass();
                    }
                } else if (qualifier instanceof PsiThisExpression) {
                    referencedClass = PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)qualifier).getType());
                }
            }
            if (resolved instanceof PsiField) {
                PsiField referencedField = (PsiField)resolved;
                if (referencedField.hasModifierProperty("static")) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatVariable((PsiVariable)referencedField, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                referencedClass = referencedField.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return null;
                }
                PsiElement nameElement = expression2 instanceof PsiThisExpression ? expression2 : ((PsiJavaCodeReferenceElement)expression2).getReferenceNameElement();
                String string = name = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return null;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)superClass.getContainingClass(), (boolean)true)) return null;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return null;
                aClass = (PsiClass)resolved;
                if (aClass.hasModifierProperty("static")) {
                    return null;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1);
            }
        } else {
            if (!(expression2 instanceof PsiThisExpression)) return null;
            PsiThisExpression thisExpression = (PsiThisExpression)expression2;
            type2 = thisExpression.getType();
            referencedClass = PsiUtil.resolveClassInType((PsiType)type2);
            resolvedName = thisExpression.getQualifier() != null ? (referencedClass == null ? null : PsiFormatUtil.formatClass((PsiClass)referencedClass, (int)1) + ".this") : "this";
        }
        if (referencedClass == null || PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiReferenceParameterList.class, (boolean)true, (Class[])new Class[]{PsiExpression.class}) != null) {
            return null;
        }
        PsiElement element = expression2.getParent();
        while (element != null) {
            PsiReferenceExpressionImpl referenceExpression;
            JavaResolveResult[] results;
            PsiElement resolve;
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)element)) {
                PsiElement parentClass = new PsiMatcherImpl(element).parent(PsiMatchers.hasClass(PsiExpressionStatement.class)).parent(PsiMatchers.hasClass(PsiCodeBlock.class)).parent(PsiMatchers.hasClass(PsiMethod.class)).dot(JavaMatchers.isConstructor(true)).parent(PsiMatchers.hasClass(PsiClass.class)).getElement();
                if (parentClass == null) {
                    return null;
                }
                aClass = (PsiClass)parentClass;
                if (PsiUtil.isInnerClass((PsiClass)aClass) && referencedClass == aClass.getContainingClass()) {
                    return null;
                }
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)referencedClass, (boolean)true)) {
                    return null;
                }
                if (expression2 instanceof PsiReferenceExpression && !HighlightUtil.thisOrSuperReference(((PsiReferenceExpression)expression2).getQualifierExpression(), aClass)) {
                    return null;
                }
                if (expression2 instanceof PsiJavaCodeReferenceElement && !aClass.equals(PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class)) && PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTypeElement.class) != null) {
                    return null;
                }
                if (expression2 instanceof PsiJavaCodeReferenceElement && PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClassObjectAccessExpression.class) != null) {
                    return null;
                }
                HighlightInfo highlightInfo = HighlightUtil.createMemberReferencedError(resolvedName, expression2.getTextRange());
                if (!(expression2 instanceof PsiReferenceExpression) || !PsiUtil.isInnerClass((PsiClass)aClass)) return highlightInfo;
                String referenceName = ((PsiReferenceExpression)expression2).getReferenceName();
                PsiClass containingClass = aClass.getContainingClass();
                LOG.assertTrue(containingClass != null);
                PsiField fieldInContainingClass = containingClass.findFieldByName(referenceName, true);
                if (fieldInContainingClass == null || ((PsiReferenceExpression)expression2).getQualifierExpression() != null) return highlightInfo;
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new QualifyWithThisFix(containingClass, expression2));
                return highlightInfo;
            }
            if (element instanceof PsiReferenceExpression && (resolve = element instanceof PsiReferenceExpressionImpl ? ((results = JavaResolveUtil.resolveWithContainingFile(referenceExpression = (PsiReferenceExpressionImpl)element, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, false, containingFile)).length == 1 ? results[0].getElement() : null) : ((PsiReferenceExpression)element).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static")) {
                return null;
            }
            if (!((element = element.getParent()) instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)referencedClass, (boolean)true)) continue;
            return null;
        }
        return null;
    }

    private static HighlightInfo createMemberReferencedError(@NotNull String resolvedName, @NotNull TextRange textRange) {
        if (resolvedName == null) {
            HighlightUtil.$$$reportNull$$$0(138);
        }
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(139);
        }
        String description = JavaErrorMessages.message("member.referenced.before.constructor.called", resolvedName);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkImplicitThisReferenceBeforeSuper(@NotNull PsiClass aClass, @NotNull JavaSdkVersion javaSdkVersion) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(140);
        }
        if (javaSdkVersion == null) {
            HighlightUtil.$$$reportNull$$$0(141);
        }
        if (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass)) {
            return null;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)outerClass, (boolean)true)) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", range);
        }
        for (PsiMethod constructor : constructors) {
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) continue;
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", HighlightNamesUtil.getMethodDeclarationTextRange(constructor));
        }
        return null;
    }

    private static boolean thisOrSuperReference(@Nullable PsiExpression qualifierExpression2, @NotNull PsiClass aClass) {
        PsiJavaCodeReferenceElement qualifier;
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(142);
        }
        if (qualifierExpression2 == null) {
            return true;
        }
        if (qualifierExpression2 instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)qualifierExpression2).getQualifier();
        } else if (qualifierExpression2 instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)qualifierExpression2).getQualifier();
        } else {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)((PsiClass)resolved), (boolean)true);
    }

    @Nullable
    static HighlightInfo checkLabelWithoutStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(143);
        }
        if (statement.getStatement() == null) {
            String description = JavaErrorMessages.message("label.without.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkLabelAlreadyInUse(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(144);
        }
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text2 = identifier.getText();
        for (PsiLabeledStatement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement) || element == statement || !Comparing.equal((String)element.getLabelIdentifier().getText(), (String)text2)) continue;
            String description = JavaErrorMessages.message("duplicate.label", text2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnclosedComment(@NotNull PsiComment comment) {
        if (comment == null) {
            HighlightUtil.$$$reportNull$$$0(145);
        }
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return null;
        }
        if (!comment.getText().endsWith("*/")) {
            int start = comment.getTextRange().getEndOffset() - 1;
            int end = start + 1;
            String description = JavaErrorMessages.message("unclosed.comment", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkCatchTypeIsDisjoint(@NotNull PsiParameter parameter2) {
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(146);
        }
        if (!(parameter2.getType() instanceof PsiDisjunctionType)) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        int size = typeElements.size();
        block0: for (int i = 0; i < size; ++i) {
            PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(i)).getType());
            if (class1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(j)).getType());
                if (class2 == null) continue;
                boolean sub = InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)class2, (boolean)true);
                boolean sup = InheritanceUtil.isInheritorOrSelf((PsiClass)class2, (PsiClass)class1, (boolean)true);
                if (!sub && !sup) continue;
                String name1 = PsiFormatUtil.formatClass((PsiClass)class1, (int)2049);
                String name2 = PsiFormatUtil.formatClass((PsiClass)class2, (int)2049);
                String message2 = JavaErrorMessages.message("exception.must.be.disjoint", sub ? name1 : name2, sub ? name2 : name1);
                PsiTypeElement element = (PsiTypeElement)typeElements.get(sub ? i : j);
                HighlightInfo highlight = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlight, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMultiCatchFix(element));
                result.add(highlight);
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    static Collection<HighlightInfo> checkExceptionAlreadyCaught(@NotNull PsiParameter parameter2) {
        PsiElement scope;
        if (parameter2 == null) {
            HighlightUtil.$$$reportNull$$$0(147);
        }
        if (!((scope = parameter2.getDeclarationScope()) instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int startFrom = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection) - 1;
        if (startFrom < 0) {
            return null;
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        boolean isInMultiCatch = typeElements.size() > 1;
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass catchClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (catchClass == null) continue;
            for (int i = startFrom; i >= 0; --i) {
                boolean highlight;
                Object upperCatchSection = allCatchSections[i];
                PsiType upperCatchType = upperCatchSection.getCatchType();
                boolean bl = highlight = upperCatchType instanceof PsiDisjunctionType ? HighlightUtil.checkMultipleTypes(catchClass, ((PsiDisjunctionType)upperCatchType).getDisjunctions()) : HighlightUtil.checkSingleType(catchClass, upperCatchType);
                if (!highlight) continue;
                String className = PsiFormatUtil.formatClass((PsiClass)catchClass, (int)2049);
                String description = JavaErrorMessages.message("exception.already.caught", className);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                result.add(highlightInfo);
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createMoveCatchUpFix(catchSection, (PsiCatchSection)upperCatchSection));
                if (isInMultiCatch) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
                    continue;
                }
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createDeleteCatchFix(parameter2));
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static boolean checkMultipleTypes(@NotNull PsiClass catchClass, @NotNull List<? extends PsiType> upperCatchTypes) {
        if (catchClass == null) {
            HighlightUtil.$$$reportNull$$$0(148);
        }
        if (upperCatchTypes == null) {
            HighlightUtil.$$$reportNull$$$0(149);
        }
        for (int i = upperCatchTypes.size() - 1; i >= 0; --i) {
            if (!HighlightUtil.checkSingleType(catchClass, upperCatchTypes.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSingleType(@NotNull PsiClass catchClass, @Nullable PsiType upperCatchType) {
        PsiClass upperCatchClass;
        if (catchClass == null) {
            HighlightUtil.$$$reportNull$$$0(150);
        }
        return (upperCatchClass = PsiUtil.resolveClassInType((PsiType)upperCatchType)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)catchClass, (PsiClass)upperCatchClass, (boolean)true);
    }

    @Nullable
    static HighlightInfo checkTernaryOperatorConditionIsBoolean(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(151);
        }
        if (expression2.getParent() instanceof PsiConditionalExpression && ((PsiConditionalExpression)expression2.getParent()).getCondition() == expression2 && !TypeConversionUtil.isBooleanType((PsiType)type2)) {
            return HighlightUtil.createMustBeBooleanInfo(expression2, type2);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSwitchBlockStatements(@NotNull PsiSwitchBlock switchBlock, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        PsiCodeBlock body2;
        if (switchBlock == null) {
            HighlightUtil.$$$reportNull$$$0(152);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(153);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(154);
        }
        if ((body2 = switchBlock.getBody()) != null) {
            PsiElement first = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)body2.getLBrace());
            if (first != null && !(first instanceof PsiSwitchLabelStatementBase) && !PsiUtil.isJavaToken((PsiElement)first, (IElementType)JavaTokenType.RBRACE)) {
                String description = JavaErrorMessages.message("statement.must.be.prepended.with.case.label", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(first).descriptionAndTooltip(description).create();
            }
            PsiElement element = first;
            PsiElement alien = null;
            boolean classicLabels = false;
            boolean enhancedLabels = false;
            boolean levelChecked = false;
            while (element != null && !PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RBRACE)) {
                PsiExpressionList values;
                if (element instanceof PsiSwitchLabeledRuleStatement) {
                    if (!levelChecked) {
                        HighlightInfo info = HighlightUtil.checkFeature(element, Feature.ENHANCED_SWITCH, languageLevel, file);
                        if (info != null) {
                            return info;
                        }
                        levelChecked = true;
                    }
                    if (classicLabels) {
                        alien = element;
                        break;
                    }
                    enhancedLabels = true;
                } else if (element instanceof PsiStatement) {
                    if (enhancedLabels) {
                        alien = element;
                        break;
                    }
                    classicLabels = true;
                }
                if (!levelChecked && element instanceof PsiSwitchLabelStatementBase && (values = ((PsiSwitchLabelStatementBase)element).getCaseValues()) != null && values.getExpressionCount() > 1) {
                    HighlightInfo info = HighlightUtil.checkFeature((PsiElement)values, Feature.ENHANCED_SWITCH, languageLevel, file);
                    if (info != null) {
                        return info;
                    }
                    levelChecked = true;
                }
                element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            }
            if (alien != null) {
                String description = JavaErrorMessages.message("different.case.kinds.in.switch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(alien).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAssertOperatorTypes(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(155);
        }
        if (type2 == null) {
            return null;
        }
        if (!(expression2.getParent() instanceof PsiAssertStatement)) {
            return null;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)expression2.getParent();
        if (expression2 == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType((PsiType)type2)) {
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type2, expression2.getTextRange(), 0);
            if (expression2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expression2).getOperationTokenType() == JavaTokenType.EQ) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAssignmentToComparisonFix((PsiAssignmentExpression)expression2));
            }
            return highlightInfo;
        }
        if (expression2 == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType((PsiType)type2)) {
            String description = JavaErrorMessages.message("void.type.is.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSynchronizedExpressionType(@NotNull PsiExpression expression2, @Nullable PsiType type2, @NotNull PsiFile containingFile) {
        PsiSynchronizedStatement synchronizedStatement;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(156);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(157);
        }
        if (type2 == null) {
            return null;
        }
        if (expression2.getParent() instanceof PsiSynchronizedStatement && expression2 == (synchronizedStatement = (PsiSynchronizedStatement)expression2.getParent()).getLockExpression() && (type2 instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)type2))) {
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)containingFile.getManager(), (GlobalSearchScope)expression2.getResolveScope());
            return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)objectType, type2, expression2.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkConditionalExpressionBranchTypesMatch(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        PsiElement parent;
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(158);
        }
        if (!((parent = expression2.getParent()) instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
        if (conditionalExpression.getElseExpression() != expression2) {
            return null;
        }
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        assert (thenExpression2 != null);
        PsiType thenType = thenExpression2.getType();
        if (thenType == null || type2 == null) {
            return null;
        }
        if (conditionalExpression.getType() == null) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)conditionalExpression) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)conditionalExpression)) {
                return null;
            }
            return HighlightUtil.createIncompatibleTypeHighlightInfo(thenType, type2, expression2.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo createIncompatibleTypeHighlightInfo(PsiType lType, PsiType rType, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            HighlightUtil.$$$reportNull$$$0(159);
        }
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> lTypeData = HighlightUtil.typeData(lType);
        Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> rTypeData = HighlightUtil.typeData(rType);
        lType = (PsiType)lTypeData.first;
        rType = (PsiType)rTypeData.first;
        PsiTypeParameter[] lTypeParams = (PsiTypeParameter[])lTypeData.second;
        PsiTypeParameter[] rTypeParams = (PsiTypeParameter[])rTypeData.second;
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        StringBuilder requiredRow = new StringBuilder();
        StringBuilder foundRow = new StringBuilder();
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstitutedType = lTypeParameter == null ? null : ((PsiSubstitutor)lTypeData.third).substitute(lTypeParameter);
            PsiType rSubstitutedType = rTypeParameter == null ? null : ((PsiSubstitutor)rTypeData.third).substitute(rTypeParameter);
            boolean matches = Comparing.equal((Object)lSubstitutedType, (Object)rSubstitutedType);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            requiredRow.append("<td>").append(lTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(lSubstitutedType, matches)).append(i < lTypeParams.length ? closeBrace : "").append("</td>");
            foundRow.append("<td>").append(rTypeParams.length == 0 ? "" : openBrace).append(HighlightUtil.redIfNotMatch(rSubstitutedType, matches)).append(i < rTypeParams.length ? closeBrace : "").append("</td>");
        }
        PsiType lRawType = lType instanceof PsiClassType ? ((PsiClassType)lType).rawType() : lType;
        PsiType rRawType = rType instanceof PsiClassType ? ((PsiClassType)rType).rawType() : rType;
        boolean assignable = lRawType == null || rRawType == null || TypeConversionUtil.isAssignable((PsiType)lRawType, (PsiType)rRawType);
        String toolTip = JavaErrorMessages.message("incompatible.types.html.tooltip", HighlightUtil.redIfNotMatch(lRawType, assignable), requiredRow, HighlightUtil.redIfNotMatch(rRawType, assignable), foundRow, HighlightUtil.getReasonForIncompatibleTypes(rType));
        String description = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
    }

    private static String getReasonForIncompatibleTypes(PsiType rType) {
        JavaResolveResult[] results;
        if (rType instanceof PsiMethodReferenceType && (results = ((PsiMethodReferenceType)rType).getExpression().multiResolve(false)).length > 1) {
            PsiElement element1 = results[0].getElement();
            PsiElement element2 = results[1].getElement();
            if (element1 instanceof PsiMethod && element2 instanceof PsiMethod) {
                String candidate1 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element1), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
                String candidate2 = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element2), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
                return JavaErrorMessages.message("incompatible.types.reason.ambiguous.method.reference", candidate1, candidate2);
            }
        }
        return "";
    }

    @NotNull
    private static Trinity<PsiType, PsiTypeParameter[], PsiSubstitutor> typeData(PsiType type2) {
        PsiTypeParameter[] parameters2 = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            substitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                type2 = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)type2).resolveGenerics();
                substitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            parameters2 = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        Trinity trinity = Trinity.create((Object)type2, (Object)parameters2, (Object)substitutor);
        if (trinity == null) {
            HighlightUtil.$$$reportNull$$$0(160);
        }
        return trinity;
    }

    @NotNull
    private static String redIfNotMatch(@Nullable PsiType type2, boolean matches) {
        if (matches) {
            String string = HighlightUtil.getFQName(type2, false);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(161);
            }
            return string;
        }
        String color = UIUtil.isUnderDarcula() ? "FF6B68" : "red";
        String string = "<font color='" + color + "'><b>" + HighlightUtil.getFQName(type2, true) + "</b></font>";
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(162);
        }
        return string;
    }

    @NotNull
    private static String getFQName(@Nullable PsiType type2, boolean longName) {
        String string = type2 == null ? "" : XmlStringUtil.escapeString((String)(longName ? type2.getInternalCanonicalText() : type2.getPresentableText()));
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(163);
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkSingleImportClassConflict(@NotNull PsiImportStatement statement, @NotNull Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> importedClasses, @NotNull PsiFile containingFile) {
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(164);
        }
        if (importedClasses == null) {
            HighlightUtil.$$$reportNull$$$0(165);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(166);
        }
        if (statement.isOnDemand()) {
            return null;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getName();
            Pair<PsiImportStaticReferenceElement, PsiClass> imported = importedClasses.get(name);
            PsiClass importedClass = (PsiClass)Pair.getSecond(imported);
            if (importedClass != null && !containingFile.getManager().areElementsEquivalent((PsiElement)importedClass, element)) {
                String description = JavaErrorMessages.message("single.import.class.conflict", HighlightUtil.formatClass(importedClass));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            }
            importedClasses.put(name, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.pair(null, (Object)((PsiClass)element)));
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeThrowable(@NotNull PsiType type2, @NotNull PsiElement context, boolean addCastIntention) {
        PsiElementFactory factory;
        PsiClassType throwable;
        if (type2 == null) {
            HighlightUtil.$$$reportNull$$$0(167);
        }
        if (context == null) {
            HighlightUtil.$$$reportNull$$$0(168);
        }
        if (!TypeConversionUtil.isAssignable((PsiType)(throwable = (factory = JavaPsiFacade.getElementFactory((Project)context.getProject())).createTypeByFQClassName("java.lang.Throwable", context.getResolveScope())), (PsiType)type2)) {
            PsiClass aClass;
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)throwable, type2, context.getTextRange(), 0);
            if (addCastIntention && TypeConversionUtil.areTypesConvertible((PsiType)type2, (PsiType)throwable) && context instanceof PsiExpression) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix((PsiType)throwable, (PsiExpression)context));
            }
            if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(aClass, throwable, true));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkMustBeThrowable(@NotNull PsiClass aClass, @NotNull PsiElement context) {
        if (aClass == null) {
            HighlightUtil.$$$reportNull$$$0(169);
        }
        if (context == null) {
            HighlightUtil.$$$reportNull$$$0(170);
        }
        PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
        return HighlightUtil.checkMustBeThrowable((PsiType)type2, context, false);
    }

    @Nullable
    static HighlightInfo checkReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        String description;
        boolean skipValidityChecks;
        PsiElement granny;
        PsiElement refName;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(171);
        }
        if (result == null) {
            HighlightUtil.$$$reportNull$$$0(172);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(173);
        }
        if (languageLevel == null) {
            HighlightUtil.$$$reportNull$$$0(174);
        }
        if (!((refName = ref.getReferenceNameElement()) instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return null;
        }
        PsiElement resolved = result.getElement();
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && (granny = refParent.getParent()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression referenceToMethod = ((PsiMethodCallExpression)granny).getMethodExpression();
            PsiExpression qualifierExpression2 = referenceToMethod.getQualifierExpression();
            if (qualifierExpression2 == ref && resolved != null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiVariable)) {
                String message2 = JavaErrorMessages.message("qualifier.must.be.expression", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)qualifierExpression2).descriptionAndTooltip(message2).create();
            }
        } else if (refParent instanceof PsiMethodCallExpression) {
            return null;
        }
        if (resolved == null) {
            String description2;
            PsiJavaCodeReferenceElement parent = HighlightUtil.getOuterReferenceParent(ref);
            PsiElement outerParent = parent.getParent();
            if (outerParent instanceof PsiPackageStatement || result.isPackagePrefixPackageReference() || PsiUtil.isInsideJavadocComment((PsiElement)ref) || parent.resolve() instanceof PsiMember || outerParent instanceof PsiPackageAccessibilityStatement) {
                return null;
            }
            JavaResolveResult[] results = ref.multiResolve(true);
            if (results.length > 1) {
                String t1 = HighlightUtil.format((PsiElement)ObjectUtils.notNull((Object)results[0].getElement()));
                String t2 = HighlightUtil.format((PsiElement)ObjectUtils.notNull((Object)results[1].getElement()));
                description2 = JavaErrorMessages.message("ambiguous.reference", refName.getText(), t1, t2);
            } else {
                description2 = refParent instanceof PsiBreakStatement && !(PsiImplUtil.findEnclosingSwitchOrLoop(refParent) instanceof PsiSwitchExpression) ? JavaErrorMessages.message("unresolved.label", refName.getText()) : JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description2).create();
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
            return info;
        }
        boolean bl = skipValidityChecks = PsiUtil.isInsideJavadocComment((PsiElement)ref) || PsiTreeUtil.getParentOfType((PsiElement)ref, PsiPackageStatement.class, (boolean)true) != null || resolved instanceof PsiPackage && ref.getParent() instanceof PsiJavaCodeReferenceElement;
        if (!skipValidityChecks && !result.isValidResult()) {
            if (!result.isAccessible()) {
                Pair<String, List<IntentionAction>> problem = HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)ref, resolved, result);
                boolean moduleAccessProblem = problem.second != null;
                PsiElement range = moduleAccessProblem ? HighlightUtil.findPackagePrefix(ref) : refName;
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(range).descriptionAndTooltip((String)problem.first).create();
                if (moduleAccessProblem) {
                    ((List)problem.second).forEach(fix2 -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix2));
                } else if (result.isStaticsScopeCorrect() && resolved instanceof PsiMember) {
                    HighlightFixUtil.registerAccessQuickFixAction((PsiMember)resolved, ref, info, result.getCurrentFileResolveScope());
                    if (ref instanceof PsiReferenceExpression) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                    }
                }
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
                return info;
            }
            if (!result.isStaticsScopeCorrect()) {
                description = HighlightUtil.staticContextProblemDescription(resolved);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
                HighlightFixUtil.registerStaticProblemQuickFixAction(resolved, info, ref);
                if (ref instanceof PsiReferenceExpression) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                }
                return info;
            }
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
            return HighlightControlFlowUtil.checkVariableMustBeFinal((PsiVariable)resolved, ref, languageLevel);
        }
        if (resolved instanceof PsiClass && ((PsiClass)resolved).getContainingClass() == null && PsiUtil.isFromDefaultPackage((PsiElement)resolved) && (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null || PsiUtil.isModuleFile((PsiFile)containingFile) || !PsiUtil.isFromDefaultPackage((PsiElement)containingFile))) {
            description = JavaErrorMessages.message("class.in.default.package", ((PsiClass)resolved).getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    private static PsiElement findPackagePrefix(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(175);
        }
        PsiJavaCodeReferenceElement candidate = ref;
        while (candidate instanceof PsiJavaCodeReferenceElement) {
            if (candidate.resolve() instanceof PsiPackage) {
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = candidate;
                if (psiJavaCodeReferenceElement == null) {
                    HighlightUtil.$$$reportNull$$$0(176);
                }
                return psiJavaCodeReferenceElement;
            }
            candidate = candidate.getQualifier();
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref;
        if (psiJavaCodeReferenceElement == null) {
            HighlightUtil.$$$reportNull$$$0(177);
        }
        return psiJavaCodeReferenceElement;
    }

    @NotNull
    private static String format(@NotNull PsiElement element) {
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(178);
        }
        if (element instanceof PsiClass) {
            String string = HighlightUtil.formatClass((PsiClass)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(179);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            String string = JavaHighlightUtil.formatMethod((PsiMethod)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(180);
            }
            return string;
        }
        if (element instanceof PsiField) {
            String string = HighlightUtil.formatField((PsiField)element);
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(181);
            }
            return string;
        }
        if (element instanceof PsiLabeledStatement) {
            String string = ((PsiLabeledStatement)element).getName() + ':';
            if (string == null) {
                HighlightUtil.$$$reportNull$$$0(182);
            }
            return string;
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            HighlightUtil.$$$reportNull$$$0(183);
        }
        return string;
    }

    @NotNull
    private static PsiJavaCodeReferenceElement getOuterReferenceParent(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(184);
        }
        PsiJavaCodeReferenceElement element = ref;
        while ((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement) {
            element = (PsiJavaCodeReferenceElement)parent;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = element;
        if (psiJavaCodeReferenceElement == null) {
            HighlightUtil.$$$reportNull$$$0(185);
        }
        return psiJavaCodeReferenceElement;
    }

    @Nullable
    static HighlightInfo checkPackageAndClassConflict(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        Module module;
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(186);
        }
        if (containingFile == null) {
            HighlightUtil.$$$reportNull$$$0(187);
        }
        if (ref.isQualified() && HighlightUtil.getOuterReferenceParent(ref).getParent() instanceof PsiPackageStatement && (module = ModuleUtilCore.findModuleForFile((PsiFile)containingFile)) != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass(ref.getCanonicalText(), scope);
            if (aClass != null) {
                String message2 = JavaErrorMessages.message("package.clashes.with.class", ref.getText());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message2).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkElementInReferenceList(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult) {
        if (ref == null) {
            HighlightUtil.$$$reportNull$$$0(188);
        }
        if (referenceList == null) {
            HighlightUtil.$$$reportNull$$$0(189);
        }
        if (resolveResult == null) {
            HighlightUtil.$$$reportNull$$$0(190);
        }
        PsiElement resolved = resolveResult.getElement();
        HighlightInfo highlightInfo = null;
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                if (refGrandParent instanceof PsiTypeParameter) {
                    highlightInfo = GenericsHighlightUtil.checkElementInTypeParameterExtendsList(referenceList, (PsiClass)refGrandParent, resolveResult, (PsiElement)ref);
                } else {
                    highlightInfo = HighlightClassUtil.checkExtendsClassAndImplementsInterface(referenceList, resolveResult, ref);
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkCannotInheritFromFinal(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromEnum(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && ((PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                highlightInfo = HighlightUtil.checkMustBeThrowable(aClass, (PsiElement)ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == ((PsiMethod)refGrandParent).getThrowsList()) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create();
        }
        return highlightInfo;
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        String name;
        if (field == null) {
            HighlightUtil.$$$reportNull$$$0(191);
        }
        if (!"serialVersionUID".equals(name = field.getName()) && !SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || JavaHighlightUtil.isSerializable(aClass);
    }

    @Nullable
    static HighlightInfo checkClassReferenceAfterQualifier(@NotNull PsiReferenceExpression expression2, @Nullable PsiElement resolved) {
        if (expression2 == null) {
            HighlightUtil.$$$reportNull$$$0(192);
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            PsiElement qualifierResolved = ((PsiReferenceExpression)qualifier).resolve();
            if (qualifierResolved instanceof PsiClass || qualifierResolved instanceof PsiPackage) {
                return null;
            }
            if (qualifierResolved == null) {
                PsiElement qResolve;
                PsiReferenceExpression qExpression = (PsiReferenceExpression)qualifier;
                while ((qResolve = qExpression.resolve()) == null || qResolve instanceof PsiClass || qResolve instanceof PsiPackage) {
                    PsiExpression qualifierExpression2 = qExpression.getQualifierExpression();
                    if (qualifierExpression2 == null) {
                        return null;
                    }
                    if (!(qualifierExpression2 instanceof PsiReferenceExpression)) break;
                    qExpression = (PsiReferenceExpression)qualifierExpression2;
                }
            }
        }
        String description = JavaErrorMessages.message("expected.class.or.package", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRemoveQualifierFix(qualifier, expression2, (PsiClass)resolved));
        return info;
    }

    @Nullable
    static HighlightInfo checkAnnotationMethodParameters(@NotNull PsiParameterList list) {
        PsiElement parent;
        if (list == null) {
            HighlightUtil.$$$reportNull$$$0(193);
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)(parent = list.getParent())) && !list.isEmpty()) {
            String message2 = JavaErrorMessages.message("annotation.interface.members.may.not.have.parameters", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createRemoveParameterListFix((PsiMethod)parent));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkForStatement(@NotNull PsiForStatement statement) {
        PsiStatement init;
        if (statement == null) {
            HighlightUtil.$$$reportNull$$$0(194);
        }
        if ((init = statement.getInitialization()) == null || init instanceof PsiEmptyStatement || init instanceof PsiDeclarationStatement && ArrayUtil.getFirstElement((Object[])((PsiDeclarationStatement)init).getDeclaredElements()) instanceof PsiLocalVariable || init instanceof PsiExpressionStatement || init instanceof PsiExpressionListStatement) {
            return null;
        }
        String message2 = JavaErrorMessages.message("invalid.statement", new Object[0]);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)init).descriptionAndTooltip(message2).create();
    }

    @Nullable
    static HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull Feature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(195);
        }
        if (feature == null) {
            HighlightUtil.$$$reportNull$$$0(196);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(197);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(198);
        }
        if (file.getManager().isInProject((PsiElement)file) && !feature.isSufficient(level)) {
            String message2 = HighlightUtil.getUnsupportedFeatureMessage(element, feature, level, file);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(feature.level));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createShowModulePropertiesFix(element));
            return info;
        }
        return null;
    }

    private static String getUnsupportedFeatureMessage(@NotNull PsiElement element, @NotNull Feature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        LanguageLevel moduleLanguageLevel;
        if (element == null) {
            HighlightUtil.$$$reportNull$$$0(199);
        }
        if (feature == null) {
            HighlightUtil.$$$reportNull$$$0(200);
        }
        if (level == null) {
            HighlightUtil.$$$reportNull$$$0(201);
        }
        if (file == null) {
            HighlightUtil.$$$reportNull$$$0(202);
        }
        String name = JavaErrorMessages.message(feature.key, new Object[0]);
        String version = JavaSdkVersion.fromLanguageLevel((LanguageLevel)level).getDescription();
        String message2 = JavaErrorMessages.message("insufficient.language.level", name, version);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module)).isAtLeast(feature.level)) {
            for (FilePropertyPusher pusher : (FilePropertyPusher[])FilePropertyPusher.EP_NAME.getExtensions()) {
                String newMessage;
                if (!(pusher instanceof JavaLanguageLevelPusher) || (newMessage = ((JavaLanguageLevelPusher)pusher).getInconsistencyLanguageLevelMessage(message2, element, level, file)) == null) continue;
                return newMessage;
            }
        }
        return message2;
    }

    private static /* synthetic */ boolean lambda$checkIntersectionInTypeCast$0(Ref differentArgumentsMessage, Pair pair) {
        if (!TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second))) {
            return true;
        }
        differentArgumentsMessage.set((Object)(((PsiType)pair.first).getPresentableText() + " and " + ((PsiType)pair.second).getPresentableText()));
        return false;
    }

    static {
        ourClassIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourClassIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourClassIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourClassIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourClassIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourClassIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourClassIncompatibleModifiers.put("static", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("abstract", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourInterfaceIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourInterfaceIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("static", Collections.emptySet());
        ourMethodIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"native", "static", "final", "private", "strictfp", "synchronized", "default"}));
        ourMethodIncompatibleModifiers.put("native", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "strictfp"}));
        ourMethodIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourMethodIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourMethodIncompatibleModifiers.put("static", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "default", "final"}));
        ourMethodIncompatibleModifiers.put("default", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "final", "private"}));
        ourMethodIncompatibleModifiers.put("synchronized", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("strictfp", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourFieldIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"volatile"}));
        ourFieldIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourFieldIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourFieldIncompatibleModifiers.put("static", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("transient", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("volatile", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassInitializerIncompatibleModifiers.put("static", Collections.emptySet());
        ourModuleIncompatibleModifiers.put("open", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("static", Collections.emptySet());
        ourRequiresIncompatibleModifiers.put("transitive", Collections.emptySet());
        FP_LITERAL_PARTS = Pattern.compile("(?:(?:0x([_\\p{XDigit}]*)\\.?([_\\p{XDigit}]*)p[+-]?([_\\d]*))|(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)))[fd]?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 62: 
            case 70: 
            case 91: 
            case 95: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 62: 
            case 70: 
            case 91: 
            case 95: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 48: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleModifiersHash";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 55: 
            case 57: 
            case 78: 
            case 122: 
            case 124: 
            case 128: 
            case 130: 
            case 136: 
            case 151: 
            case 155: 
            case 156: 
            case 158: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 31: 
            case 81: 
            case 82: 
            case 89: 
            case 153: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 6: 
            case 154: 
            case 198: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castTypeElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 14: 
            case 17: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: 
            case 92: 
            case 96: 
            case 171: 
            case 175: 
            case 184: 
            case 186: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: 
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 19: 
            case 139: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 20: 
            case 21: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: 
            case 74: 
            case 125: 
            case 143: 
            case 144: 
            case 164: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandled";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 62: 
            case 70: 
            case 91: 
            case 95: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 32: 
            case 34: 
            case 85: 
            case 88: 
            case 140: 
            case 142: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 36: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 38: 
            case 40: 
            case 178: 
            case 195: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: 
            case 117: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 46: 
            case 56: 
            case 76: 
            case 197: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 59: 
            case 60: 
            case 80: 
            case 83: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 63: 
            case 65: 
            case 68: 
            case 71: 
            case 116: 
            case 146: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 64: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownTypes";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caughtType";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownInTryStatement";
                break;
            }
            case 73: 
            case 137: 
            case 157: 
            case 166: 
            case 173: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 75: 
            case 126: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 77: 
            case 135: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 90: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 94: 
            case 98: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 104: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 105: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 106: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultForIncompleteCode";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedField";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedName";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 148: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchClass";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperCatchTypes";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedClasses";
                break;
            }
            case 168: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 196: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptionsDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypes";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "checkMultiCatchParameter";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "staticContextProblemDescription";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "accessProblemDescription";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "accessProblemDescriptionAndFixes";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "typeData";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "redIfNotMatch";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQName";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagePrefix";
                break;
            }
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterReferenceParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceOfApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkIntersectionInTypeCast";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIntersection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkInconvertibleTypeCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableExpected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentOperatorApplicable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentCompatibleTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCastIntentionApplicable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableInitializerType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkLegalVarReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkVarTypeApplicability";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignability";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnFromSwitchExpr";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnStatementType";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptionsDescriptor";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 62: 
            case 70: 
            case 91: 
            case 95: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "formatTypes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableAlreadyDefined";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkSameNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscore";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledExceptions";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledCloserExceptions";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptionHighlightType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkBreakOutsideSwitchOrLoop";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkValueBreakExpression";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkContinueOutsideLoop";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkContinueTarget";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalModifierCombination";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalModifierCombination";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleModifierMap";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAllowedModifier";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkLiteralExpressionParsingError";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscores";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeBoolean";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createMustBeBooleanInfo";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "checkExceptionThrownInTry";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "checkSimpleCatchParameter";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "checkMultiCatchParameter";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "checkWithImprovedCatchAnalysis";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAStatement";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitchSelectorType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchSelectorKind";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkPolyadicOperatorApplicable";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "checkUnaryOperatorApplicable";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkThisOrSuperExpressionInIllegalContext";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "checkUnqualifiedSuperInDefaultMethod";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isInsideDefaultMethod";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "thisNotFoundInInterfaceInfo";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToImmediateSuperInterface";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "staticContextProblemDescription";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "accessProblemDescription";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "accessProblemDescriptionAndFixes";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleAccess";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "checkAccess";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getContainerName";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkValidArrayAccessExpression";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "checkCatchParameterIsThrowable";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "checkTryResourceIsAutoCloseable";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceVariableIsFinal";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializer";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerCompatibleTypes";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionRequired";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerApplicable";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "checkCaseStatement";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitchLabelValues";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitchExpressionHasResult";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalForwardReferenceToField";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalForwardReferenceToField";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingFieldInitializer";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "findParentClassInitializer";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalType";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalVoidType";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberReferencedBeforeConstructorCalled";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "createMemberReferencedError";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitThisReferenceBeforeSuper";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "thisOrSuperReference";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "checkLabelWithoutStatement";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "checkLabelAlreadyInUse";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "checkUnclosedComment";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "checkCatchTypeIsDisjoint";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "checkExceptionAlreadyCaught";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "checkMultipleTypes";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "checkSingleType";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "checkTernaryOperatorConditionIsBoolean";
                break;
            }
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitchBlockStatements";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "checkAssertOperatorTypes";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "checkSynchronizedExpressionType";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "checkConditionalExpressionBranchTypesMatch";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleTypeHighlightInfo";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "checkSingleImportClassConflict";
                break;
            }
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeThrowable";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "checkReference";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "findPackagePrefix";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "getOuterReferenceParent";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAndClassConflict";
                break;
            }
            case 188: 
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "checkElementInReferenceList";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "isSerializationImplicitlyUsedField";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReferenceAfterQualifier";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationMethodParameters";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "checkForStatement";
                break;
            }
            case 195: 
            case 196: 
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "checkFeature";
                break;
            }
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "getUnsupportedFeatureMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 37: 
            case 62: 
            case 70: 
            case 91: 
            case 95: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Feature {
        GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
        ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
        STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
        FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
        VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
        HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
        DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
        MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch"),
        TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
        BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
        UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
        EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
        METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
        LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
        TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations"),
        RECEIVERS(LanguageLevel.JDK_1_8, "feature.type.receivers"),
        INTERSECTION_CASTS(LanguageLevel.JDK_1_8, "feature.intersections.in.casts"),
        STATIC_INTERFACE_CALLS(LanguageLevel.JDK_1_8, "feature.static.interface.calls"),
        REFS_AS_RESOURCE(LanguageLevel.JDK_1_9, "feature.try.with.resources.refs"),
        MODULES(LanguageLevel.JDK_1_9, "feature.modules"),
        ENHANCED_SWITCH(LanguageLevel.JDK_12_PREVIEW, "feature.enhanced.switch"),
        SWITCH_EXPRESSION(LanguageLevel.JDK_12_PREVIEW, "feature.switch.expressions"),
        RAW_LITERALS(LanguageLevel.JDK_X, "feature.raw.literals");

        private final LanguageLevel level;
        private final String key;

        private Feature(LanguageLevel level, String key2) {
            this.level = level;
            this.key = key2;
        }

        public boolean isAvailable(PsiElement element) {
            return this.isSufficient(PsiUtil.getLanguageLevel((PsiElement)element));
        }

        private boolean isSufficient(LanguageLevel useSiteLevel) {
            return this.level.isPreview() ? useSiteLevel == this.level : useSiteLevel.isAtLeast(this.level);
        }
    }

    private static enum SelectorKind {
        INT,
        ENUM,
        STRING;

    }
}

