/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.simple.RParenthTailType;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SmartCastProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> TYPECAST_TYPE_CANDIDATE = PlatformPatterns.psiElement().afterLeaf(new String[]{"("});

    SmartCastProvider() {
    }

    static boolean shouldSuggestCast(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        PsiElement parent = SmartCastProvider.getParenthesisOwner(position);
        if (parent instanceof PsiTypeCastExpression) {
            return true;
        }
        if (parent instanceof PsiParenthesizedExpression) {
            return parameters2.getOffset() == position.getTextRange().getStartOffset();
        }
        return false;
    }

    private static PsiElement getParenthesisOwner(PsiElement position) {
        PsiElement lParen = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return lParen == null || !lParen.textMatches((CharSequence)"(") ? null : lParen.getParent();
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters2 == null) {
            SmartCastProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SmartCastProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SmartCastProvider.$$$reportNull$$$0(2);
        }
        SmartCastProvider.addCastVariants(parameters2, result.getPrefixMatcher(), (Consumer<? super LookupElement>)result, false);
    }

    static void addCastVariants(@NotNull CompletionParameters parameters2, PrefixMatcher matcher, @NotNull Consumer<? super LookupElement> result, boolean quick) {
        PsiElement parent;
        if (parameters2 == null) {
            SmartCastProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SmartCastProvider.$$$reportNull$$$0(4);
        }
        if (!SmartCastProvider.shouldSuggestCast(parameters2)) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        boolean insideCast = parenthesisOwner instanceof PsiTypeCastExpression;
        if (insideCast && (parent = parenthesisOwner.getParent()) instanceof PsiParenthesizedExpression) {
            if (parent.getParent() instanceof PsiReferenceExpression) {
                for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiParenthesizedExpression)parent), false)) {
                    result.consume((Object)PsiTypeLookupItem.createLookupItem(info.getType(), parent));
                }
            }
            for (ExpectedTypeInfo info : SmartCastProvider.getParenthesizedCastExpectationByOperandType(position)) {
                SmartCastProvider.addHierarchyTypes(parameters2, matcher, info, (Consumer<? super PsiType>)((Consumer)type2 -> result.consume((Object)PsiTypeLookupItem.createLookupItem(type2, parent))), quick);
            }
            return;
        }
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiClassType boxedType;
            PsiType castedType;
            PsiType type3 = info.getDefaultType();
            if (type3 instanceof PsiWildcardType) {
                type3 = ((PsiWildcardType)type3).getBound();
            }
            if (type3 == null || PsiType.VOID.equals((Object)type3)) continue;
            if (type3 instanceof PsiPrimitiveType && (castedType = SmartCastProvider.getCastedExpressionType(parenthesisOwner)) != null && !(castedType instanceof PsiPrimitiveType) && (boxedType = ((PsiPrimitiveType)type3).getBoxedType(position)) != null) {
                type3 = boxedType;
            }
            result.consume((Object)SmartCastProvider.createSmartCastElement(parameters2, insideCast, type3));
        }
    }

    @NotNull
    static List<ExpectedTypeInfo> getParenthesizedCastExpectationByOperandType(PsiElement position) {
        PsiElement parenthesisOwner = SmartCastProvider.getParenthesisOwner(position);
        PsiExpression operand2 = SmartCastProvider.getCastedExpression(parenthesisOwner);
        if (operand2 == null || !(parenthesisOwner.getParent() instanceof PsiParenthesizedExpression)) {
            List<ExpectedTypeInfo> list = Collections.emptyList();
            if (list == null) {
                SmartCastProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<PsiType> dfaTypes = GuessManager.getInstance(operand2.getProject()).getControlFlowExpressionTypeConjuncts(operand2);
        if (!dfaTypes.isEmpty()) {
            List list = ContainerUtil.map(dfaTypes, dfaType -> new ExpectedTypeInfoImpl((PsiType)dfaType, 2, (PsiType)dfaType, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null)));
            if (list == null) {
                SmartCastProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiType type2 = operand2.getType();
        List<ExpectedTypeInfo> list = type2 == null || type2.equalsToText("java.lang.Object") ? Collections.emptyList() : Collections.singletonList(new ExpectedTypeInfoImpl(type2, 1, type2, TailType.NONE, null, (NullableComputable<String>)((NullableComputable)() -> null)));
        if (list == null) {
            SmartCastProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static void addHierarchyTypes(CompletionParameters parameters2, PrefixMatcher matcher, ExpectedTypeInfo info, Consumer<? super PsiType> result, boolean quick) {
        PsiType infoType = info.getType();
        PsiClass infoClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)infoType);
        if (info.getKind() == 2) {
            InheritanceUtil.processSupers((PsiClass)infoClass, (boolean)true, superClass -> {
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) {
                    result.consume((Object)JavaPsiFacade.getElementFactory((Project)superClass.getProject()).createType((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)superClass)));
                }
                return true;
            });
        } else if (infoType instanceof PsiClassType && !quick) {
            JavaInheritorsGetter.processInheritors(parameters2, Collections.singleton((PsiClassType)infoType), matcher, (Consumer<? super PsiType>)((Consumer)type2 -> {
                if (!infoType.equals(type2)) {
                    result.consume(type2);
                }
            }));
        }
    }

    private static PsiType getCastedExpressionType(PsiElement parenthesisOwner) {
        PsiExpression operand2 = SmartCastProvider.getCastedExpression(parenthesisOwner);
        return operand2 == null ? null : operand2.getType();
    }

    private static PsiExpression getCastedExpression(PsiElement parenthesisOwner) {
        if (parenthesisOwner instanceof PsiTypeCastExpression) {
            return ((PsiTypeCastExpression)parenthesisOwner).getOperand();
        }
        if (parenthesisOwner instanceof PsiParenthesizedExpression) {
            PsiElement next = parenthesisOwner.getNextSibling();
            while (next instanceof PsiEmptyExpressionImpl || next instanceof PsiErrorElement || next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next instanceof PsiExpression) {
                return (PsiExpression)next;
            }
        }
        return null;
    }

    private static LookupElement createSmartCastElement(final CompletionParameters parameters2, final boolean overwrite, PsiType type2) {
        return AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE.applyPolicy((LookupElement)new LookupElementDecorator<PsiTypeLookupItem>(PsiTypeLookupItem.createLookupItem(type2, parameters2.getPosition())){

            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.casting");
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                if (overwrite) {
                    document.deleteString(context.getSelectionEndOffset(), context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
                }
                CommonCodeStyleSettings csSettings = context.getCodeStyleSettings();
                int oldTail = context.getTailOffset();
                context.setTailOffset(RParenthTailType.addRParenth(editor, oldTail, csSettings.SPACE_WITHIN_CAST_PARENTHESES));
                ((PsiTypeLookupItem)this.getDelegate()).handleInsert(CompletionUtil.newContext((InsertionContext)context, (LookupElement)this.getDelegate(), (int)context.getStartOffset(), (int)oldTail));
                PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                if (csSettings.SPACE_AFTER_TYPE_CAST) {
                    context.setTailOffset(TailType.insertChar((Editor)editor, (int)context.getTailOffset(), (char)' '));
                }
                if (parameters2.getCompletionType() == CompletionType.SMART) {
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/SmartCastProvider$1", "handleInsert"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/SmartCastProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/SmartCastProvider";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParenthesizedCastExpectationByOperandType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCastVariants";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

