/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.ChainedCallCompletion;
import com.intellij.codeInsight.completion.FromArrayConversion;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.ToArrayConversion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SlowerTypeConversions
implements Runnable {
    private static final PrefixMatcher TRUE_MATCHER = new PrefixMatcher(""){

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                1.$$$reportNull$$$0(1);
            }
            1 v0 = this;
            if (v0 == null) {
                1.$$$reportNull$$$0(2);
            }
            return v0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/SlowerTypeConversions$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/SlowerTypeConversions$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithPrefix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final Set<? extends LookupElement> myBase;
    private final PsiElement myElement;
    private final PsiJavaCodeReferenceElement myReference;
    private final JavaSmartCompletionParameters myParameters;
    private final Consumer<? super LookupElement> myResult;

    SlowerTypeConversions(Set<? extends LookupElement> base, PsiElement element, PsiJavaCodeReferenceElement reference, JavaSmartCompletionParameters parameters2, Consumer<? super LookupElement> result) {
        this.myBase = base;
        this.myElement = element;
        this.myReference = reference;
        this.myParameters = parameters2;
        this.myResult = result;
    }

    @Override
    public void run() {
        HashSet processedChains = ContainerUtil.newHashSet();
        for (LookupElement lookupElement2 : this.myBase) {
            SlowerTypeConversions.addSecondCompletionVariants(this.myElement, (PsiReference)this.myReference, lookupElement2, this.myParameters, (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                ContainerUtil.addIfNotNull((Collection)processedChains, SlowerTypeConversions.chainInfo(lookupElement));
                this.myResult.consume(lookupElement);
            }));
        }
        if (!((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).accepts((Object)this.myElement)) {
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(this.myParameters, null, TRUE_MATCHER, (Consumer<? super LookupElement>)((Consumer)baseItem -> SlowerTypeConversions.addSecondCompletionVariants(this.myElement, (PsiReference)this.myReference, baseItem, this.myParameters, (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                if (!processedChains.contains(SlowerTypeConversions.chainInfo(lookupElement))) {
                    this.myResult.consume(lookupElement);
                }
            }))));
        }
    }

    private static void addSecondCompletionVariants(PsiElement element, PsiReference reference, LookupElement baseItem, JavaSmartCompletionParameters parameters2, Consumer<? super LookupElement> result) {
        Object object = baseItem.getObject();
        try {
            PsiType itemType = JavaCompletionUtil.getLookupElementType(baseItem);
            if (itemType instanceof PsiWildcardType) {
                itemType = ((PsiWildcardType)itemType).getExtendsBound();
            }
            if (itemType == null) {
                return;
            }
            assert (itemType.isValid()) : baseItem + "; " + baseItem.getClass();
            PsiElement element1 = reference.getElement();
            PsiElement qualifier = element1 instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element1).getQualifier() : null;
            PsiType expectedType = parameters2.getExpectedType();
            ChainedCallCompletion.addChains(element, baseItem, result, itemType, expectedType, parameters2);
            PsiFile file = parameters2.getParameters().getOriginalFile();
            String prefix = SlowerTypeConversions.getItemText(file, object);
            if (prefix == null) {
                return;
            }
            FromArrayConversion.addConversions(element, prefix, itemType, result, qualifier, expectedType);
            ToArrayConversion.addConversions(file, element, prefix, itemType, result, qualifier, expectedType);
            ArrayMemberAccess.addMemberAccessors(element, prefix, itemType, qualifier, result, (PsiModifierListOwner)object, expectedType);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    @Nullable
    private static String getItemText(@NotNull PsiFile file, Object o) {
        if (file == null) {
            SlowerTypeConversions.$$$reportNull$$$0(0);
        }
        if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            PsiType type2 = method.getReturnType();
            if (PsiType.VOID.equals((Object)type2) || PsiType.NULL.equals((Object)type2)) {
                return null;
            }
            if (!method.getParameterList().isEmpty()) {
                return null;
            }
            return method.getName() + "(" + ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)file).SPACE_WITHIN_METHOD_CALL_PARENTHESES) + ")";
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getName();
        }
        return null;
    }

    @Nullable
    private static Pair<LookupElement, String> chainInfo(LookupElement lookupElement) {
        Object object;
        if (lookupElement instanceof JavaChainLookupElement && (object = lookupElement.getObject()) instanceof PsiMember) {
            LookupElement qualifier = ((JavaChainLookupElement)lookupElement).getQualifier();
            if (qualifier instanceof CastingLookupElementDecorator) {
                qualifier = ((CastingLookupElementDecorator)qualifier).getDelegate();
            }
            return Pair.create((Object)qualifier, (Object)lookupElement.getLookupString());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/SlowerTypeConversions", "getItemText"));
    }
}

