/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.getters.InstanceOfLeftPartTypeGetter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class InstanceofTypeProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> AFTER_INSTANCEOF = PlatformPatterns.psiElement().afterLeaf(new String[]{"instanceof"});

    InstanceofTypeProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters2 == null) {
            InstanceofTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            InstanceofTypeProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            InstanceofTypeProvider.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters2.getPosition();
        PsiType[] leftTypes = InstanceOfLeftPartTypeGetter.getLeftTypes(position);
        LinkedHashSet<PsiClassType> expectedClassTypes = new LinkedHashSet<PsiClassType>();
        THashSet parameterizedTypes = new THashSet();
        for (PsiType type2 : leftTypes) {
            if (!(type2 instanceof PsiClassType)) continue;
            PsiClassType classType = (PsiClassType)type2;
            if (!classType.isRaw()) {
                ContainerUtil.addIfNotNull((Collection)parameterizedTypes, (Object)classType.resolve());
            }
            expectedClassTypes.add(classType.rawType());
        }
        JavaInheritorsGetter.processInheritors(parameters2, expectedClassTypes, result.getPrefixMatcher(), (Consumer<? super PsiType>)((Consumer)arg_0 -> InstanceofTypeProvider.lambda$addCompletions$0(expectedClassTypes, result, (Set)parameterizedTypes, arg_0)));
    }

    private static LookupElement createInstanceofLookupElement(PsiClass psiClass, Set<PsiClass> toWildcardInheritors) {
        PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
        if (typeParameters.length > 0) {
            for (PsiClass parameterizedType : toWildcardInheritors) {
                if (!psiClass.isInheritor(parameterizedType, true)) continue;
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiWildcardType wildcard = PsiWildcardType.createUnbounded((PsiManager)psiClass.getManager());
                for (PsiTypeParameter typeParameter : typeParameters) {
                    substitutor = substitutor.put(typeParameter, (PsiType)wildcard);
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
                return PsiTypeLookupItem.createLookupItem((PsiType)factory.createType(psiClass, substitutor), (PsiElement)psiClass);
            }
        }
        return new JavaPsiClassReferenceElement(psiClass);
    }

    private static /* synthetic */ void lambda$addCompletions$0(Set expectedClassTypes, CompletionResultSet result, Set parameterizedTypes, PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass instanceof PsiTypeParameter) {
            return;
        }
        if (expectedClassTypes.contains(type2)) {
            return;
        }
        result.addElement(InstanceofTypeProvider.createInstanceofLookupElement(psiClass, parameterizedTypes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/InstanceofTypeProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

