/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.text.CharSequenceReader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotationsCache;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<Object, AnnotationData> cache;
    private final CharTableImpl charTable;
    private static final JavaParserUtil.ParserWrapper ANNOTATION = JavaParser.INSTANCE.getDeclarationParser()::parseAnnotation;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        this.myExternalAnnotationsCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        this.myAnnotationDataCache = ContainerUtil.createWeakKeyWeakValueMap();
        this.myAnnotationFileToDataAndModStampCache = ContainerUtil.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        return BaseExternalAnnotationsManager.getExternalName(listOwner, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        return PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)showParamName, (int)Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        return this.hasAnyAnnotationsRoots();
    }

    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<PsiAnnotation> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(5);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(6);
        }
        return (result = this.findExternalAnnotations(listOwner, annotationFQN)).isEmpty() ? null : result.get(0);
    }

    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        List<PsiAnnotation> list = this.filterAnnotations(result, annotationFQN);
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(10);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(11);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return this.filterAnnotations(result, annotationFQN);
    }

    @NotNull
    private List<PsiAnnotation> filterAnnotations(@NotNull List<AnnotationData> result, @NotNull String annotationFQN) {
        if (result == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(12);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(13);
        }
        List list = (List)((StreamEx)StreamEx.of(result).filter(data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN))).map(data -> data.getAnnotation(this)).toCollection(SmartList::new);
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(15);
        }
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return (List)StreamEx.of(result).map(data -> data.getAnnotation(this)).toCollection(SmartList::new);
    }

    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map2;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(16);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(17);
        }
        return BaseExternalAnnotationsManager.findByFQN(map2 = this.doCollect(listOwner, true), annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        if (map2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(18);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(19);
        }
        return (AnnotationData)ContainerUtil.find(map2, data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN));
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(20);
        }
        return (result = this.collectExternalAnnotations(listOwner)).isEmpty() ? null : (PsiAnnotation[])ContainerUtil.map2Array(result, (Object[])PsiAnnotation.EMPTY_ARRAY, data -> data.getAnnotation(this));
    }

    @NotNull
    private List<AnnotationData> collectDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        List<PsiFile> annotationsFiles;
        if (aClass == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(21);
        }
        if ((annotationsFiles = this.findExternalAnnotationsFiles((PsiModifierListOwner)aClass)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        String defCtrExternalName = BaseExternalAnnotationsManager.getExternalName((PsiModifierListOwner)aClass) + " " + aClass.getName() + "()";
        List<AnnotationData> list = this.collectExternalAnnotations(defCtrExternalName, () -> this.doCollect(defCtrExternalName, annotationsFiles, false));
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(24);
        }
        List<AnnotationData> list = this.collectExternalAnnotations(listOwner, () -> this.doCollect(listOwner, false));
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull Object cacheKey, @NotNull Supplier<List<AnnotationData>> dataSupplier) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (cacheKey == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(26);
        }
        if (dataSupplier == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(27);
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list = Collections.emptyList();
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(28);
            }
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(cacheKey)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list = cached;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(29);
            }
            return list;
        } while (!this.cache.replace(cacheKey, (Collection)cached, computed = dataSupplier.get()));
        cached = computed;
        List<AnnotationData> list = cached;
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(30);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(31);
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data);
        if (interned == null) {
            this.myAnnotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(32);
        return annotationData;
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(33);
        }
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStampCache.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(34);
            }
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(file);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource((Reader)new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file.getViewProvider().getContents()))), (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(file.getViewProvider().getVirtualFile().getPath(), (Throwable)e);
        }
        MostlySingularMultiMap<String, AnnotationData> result = handler.getResult();
        this.myAnnotationFileToDataAndModStampCache.put(file, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)Pair.create(result, (Object)fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result;
        if (mostlySingularMultiMap == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(35);
        }
        return mostlySingularMultiMap;
    }

    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text2) {
        if (file == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(36);
        }
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(37);
        }
        if (text2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(38);
        }
        LOG.error(text2 + "; for signature: '" + externalName + "' in the " + file.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(39);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = this.charTable.doIntern((CharSequence)annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(40);
        return string;
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<PsiFile> files;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(41);
        }
        if ((files = this.findExternalAnnotationsFiles(listOwner)) == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(42);
            }
            return list;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner);
        if (externalName == null) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<AnnotationData> list = this.doCollect(externalName, files, onlyWritable);
        if (list == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull String externalName, @NotNull List<PsiFile> annotationsFiles, boolean onlyWritable) {
        if (externalName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(45);
        }
        if (annotationsFiles == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(46);
        }
        SmartList result = new SmartList();
        for (PsiFile file : annotationsFiles) {
            if (!file.isValid() || onlyWritable && !file.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file);
            ContainerUtil.addAll((Collection)result, (Iterable)fileData.get((Object)externalName));
        }
        if (result.isEmpty()) {
            List<AnnotationData> list = NO_DATA;
            if (list == null) {
                BaseExternalAnnotationsManager.$$$reportNull$$$0(47);
            }
            return list;
        }
        result.trimToSize();
        SmartList smartList = result;
        if (smartList == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(48);
        }
        return smartList;
    }

    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        PsiFile containingFile;
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(49);
        }
        if (!((containingFile = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner).getContainingFile()) instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotationsCache.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (Object file : files) {
                if (file.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        THashSet possibleAnnotationXmls = new THashSet();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(virtualFile, NULL_LIST);
            return null;
        }
        SmartList result = new SmartList((Collection)possibleAnnotationXmls);
        result.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(virtualFile, (List<PsiFile>)result);
        return result;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(50);
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(51);
        }
        return stringBuilder;
    }

    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(52);
        }
        if (annotationFQName == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(53);
        }
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(54);
        }
        throw new UnsupportedOperationException();
    }

    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(55);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(56);
        }
        throw new UnsupportedOperationException();
    }

    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value2) {
        if (listOwner == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(57);
        }
        if (annotationFQN == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(58);
        }
        throw new UnsupportedOperationException();
    }

    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(59);
        }
        throw new UnsupportedOperationException();
    }

    protected void registerExternalAnnotations(@NotNull PsiFile fromFile, @NotNull PsiFile annotationsFile) {
        VirtualFile virtualFile;
        if (fromFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(60);
        }
        if (annotationsFile == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(61);
        }
        if ((virtualFile = fromFile.getVirtualFile()) != null) {
            this.myExternalAnnotationsCache.compute(virtualFile, (k, v) -> {
                if (v == null || v == NULL_LIST) {
                    return new SmartList((Object)annotationsFile);
                }
                v.add(annotationsFile);
                return v;
            });
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(62);
        }
        annotation.putUserData(EXTERNAL_ANNO_MARKER, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            BaseExternalAnnotationsManager.$$$reportNull$$$0(63);
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myPsiManager, (TreeElement)new JavaDummyElement(text2, ANNOTATION, LanguageLevel.HIGHEST), null, (CharTable)this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text2 + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        BaseExternalAnnotationsManager.$$$reportNull$$$0(64);
        return psiAnnotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 16: 
            case 20: 
            case 24: 
            case 41: 
            case 49: 
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 3: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 39: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 10: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSupplier";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 38: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsFiles";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidXml";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAnnotations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExternalAnnotations";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationData";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollect";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAttributes";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExternalName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotationRootsForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotation";
                break;
            }
            case 7: 
            case 8: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotations";
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 64: {
                break;
            }
            case 10: 
            case 11: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultConstructorExternalAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterAnnotations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotationWritable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findByFQN";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectDefaultConstructorExternalAnnotations";
                break;
            }
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectExternalAnnotations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationData";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "duplicateError";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 41: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doCollect";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsFiles";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "escapeAttributes";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternally";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "deannotate";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotation";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "chooseAnnotationsPlace";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "registerExternalAnnotations";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "markAsExternalAnnotation";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 51: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName;
        private String myAnnotationFqn;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(PsiFile file) {
            this.myFile = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get((Object)this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add((Object)this.myExternalName, (Object)BaseExternalAnnotationsManager.this.internAnnotationData(data));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    public static class AnnotationData {
        private final String annotationClassFqName;
        private final String annotationParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters2) {
            if (fqn == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (parameters2 == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters2;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            PsiAnnotation a;
            if (context == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            if ((a = this.myAnnotation) == null) {
                String text2 = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context.createAnnotationFromText(text2);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                AnnotationData.$$$reportNull$$$0(3);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result = this.annotationClassFqName.hashCode();
            result = 31 * result + this.annotationParameters.hashCode();
            return result;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnnotation";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

