/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public abstract class AbstractMessageLogger
implements MessageLogger {
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();
    private boolean showProgress = true;

    @Override
    public void debug(String msg) {
        this.log(msg, 4);
    }

    @Override
    public void verbose(String msg) {
        this.log(msg, 3);
    }

    @Override
    public void deprecated(String msg) {
        this.log("DEPRECATED: " + msg, 1);
    }

    @Override
    public void info(String msg) {
        this.log(msg, 2);
    }

    @Override
    public void rawinfo(String msg) {
        this.rawlog(msg, 2);
    }

    @Override
    public void warn(String msg) {
        this.log("WARN: " + msg, 3);
        this.problems.add("WARN:  " + msg);
        this.getWarns().add(msg);
    }

    @Override
    public void error(String msg) {
        this.log("ERROR: " + msg, 3);
        this.problems.add("\tERROR: " + msg);
        this.getErrors().add(msg);
    }

    public List getProblems() {
        return this.problems;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.problems.clear();
        this.warns.clear();
        this.errors.clear();
    }

    public List getErrors() {
        return this.errors;
    }

    public List getWarns() {
        return this.warns;
    }

    @Override
    public void progress() {
        if (this.showProgress) {
            this.doProgress();
        }
    }

    @Override
    public void endProgress(String msg) {
        if (this.showProgress) {
            this.doEndProgress(msg);
        }
    }

    protected abstract void doProgress();

    protected abstract void doEndProgress(String var1);
}

