/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequestBuilder {
    public abstract RequestBuilder connectTimeout(int var1);

    public abstract RequestBuilder readTimeout(int var1);

    public abstract RequestBuilder redirectLimit(int var1);

    public abstract RequestBuilder gzip(boolean var1);

    public abstract RequestBuilder forceHttps(boolean var1);

    @NotNull
    public abstract RequestBuilder useProxy(boolean var1);

    public abstract RequestBuilder hostNameVerifier(@Nullable HostnameVerifier var1);

    public abstract RequestBuilder userAgent(@Nullable String var1);

    public abstract RequestBuilder productNameAsUserAgent();

    public abstract RequestBuilder accept(@Nullable String var1);

    public abstract RequestBuilder tuner(@Nullable HttpRequests.ConnectionTuner var1);

    public abstract RequestBuilder isReadResponseOnError(boolean var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.1")
    public abstract RequestBuilder untrustedCertificateStrategy(@NotNull UntrustedCertificateStrategy var1);

    @NotNull
    public abstract RequestBuilder throwStatusCodeException(boolean var1);

    public abstract <T> T connect(@NotNull HttpRequests.RequestProcessor<T> var1) throws IOException;

    public int tryConnect() throws IOException {
        return this.connect(request -> {
            URLConnection connection = request.getConnection();
            return connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
        });
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        if (processor == null) {
            RequestBuilder.$$$reportNull$$$0(0);
        }
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
        if (file == null) {
            RequestBuilder.$$$reportNull$$$0(1);
        }
        this.connect(request -> request.saveToFile(file, indicator));
    }

    @NotNull
    public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
        byte[] byArray = this.connect(request -> request.readBytes(indicator));
        if (byArray == null) {
            RequestBuilder.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    @NotNull
    public String readString(@Nullable ProgressIndicator indicator) throws IOException {
        String string = this.connect(request -> request.readString(indicator));
        if (string == null) {
            RequestBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String readString() throws IOException {
        String string = this.readString(null);
        if (string == null) {
            RequestBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
        CharSequence charSequence = this.connect(request -> request.readChars(indicator));
        if (charSequence == null) {
            RequestBuilder.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @NotNull
    public CharSequence readChars() throws IOException {
        CharSequence charSequence = this.readChars(null);
        if (charSequence == null) {
            RequestBuilder.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    public void write(@NotNull String data) throws IOException {
        if (data == null) {
            RequestBuilder.$$$reportNull$$$0(7);
        }
        this.connect(request -> {
            request.write(data);
            return null;
        });
    }

    public void write(@NotNull byte[] data) throws IOException {
        if (data == null) {
            RequestBuilder.$$$reportNull$$$0(8);
        }
        this.connect(request -> {
            request.write(data);
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/RequestBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/RequestBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readBytes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

