/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.IoKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\u0010\u0010\u0015\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a$\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0019\u001a\u00020\u0006\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0014*\u00020\u0007\u001a\u0012\u0010\u001b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007\u001a\n\u0010\u001d\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u001e\u001a\u00020\u0010*\u00020\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007\u001a\u0016\u0010 \u001a\u00020\u0010*\u00020\u00072\b\b\u0002\u0010!\u001a\u00020\u0006H\u0007\u001a\f\u0010\"\u001a\u00020\u0010*\u00020\u0007H\u0002\u001a\u0012\u0010#\u001a\u00020\u0010*\u00020\u00072\u0006\u0010$\u001a\u00020\n\u001a\u0014\u0010!\u001a\n %*\u0004\u0018\u00010\u00070\u0007*\u00020\u0007H\u0002\u001a\u001c\u0010&\u001a\u00020\u0006*\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u0006\u001ah\u0010)\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010**\u00020\u00072#\b\b\u0010+\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b-\u0012\b\b\u0017\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00060,2'\u0010.\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070/\u00a2\u0006\f\b-\u0012\b\b\u0017\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002H*0,H\u0086\b\u00a2\u0006\u0002\u00101\u001aC\u0010)\u001a\u0004\u0018\u0001H*\"\u0004\b\u0000\u0010**\u00020\u00072'\u0010.\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070/\u00a2\u0006\f\b-\u0012\b\b\u0017\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002H*0,H\u0086\b\u00a2\u0006\u0002\u00102\u001a\n\u00103\u001a\u00020\u0006*\u00020\u0007\u001a\n\u00104\u001a\u000205*\u00020\u0007\u001a\f\u00106\u001a\u0004\u0018\u000105*\u00020\u0007\u001a\n\u00107\u001a\u000205*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010(\u001a\u00020\u0006*\u00020\u0007\u001a\n\u00108\u001a\u00020\u0006*\u00020\u0007\u001a\n\u00109\u001a\u00020:*\u00020\u0007\u001a\u0012\u0010;\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007\u001a\n\u0010<\u001a\u00020=*\u00020\u0007\u001a\n\u0010>\u001a\u00020?*\u00020\u0007\u001a\n\u0010@\u001a\u00020A*\u00020\u0007\u001a\n\u0010B\u001a\u00020\n*\u00020\u0007\u001a\n\u0010C\u001a\u00020D*\u00020\u0007\u001a\n\u0010E\u001a\u00020D*\u00020\u0007\u001a(\u0010F\u001a\u00020\u0007*\u00020\u00072\u0006\u0010G\u001a\u00020?2\b\b\u0002\u0010H\u001a\u00020I2\b\b\u0002\u0010C\u001a\u00020IH\u0007\u001a\u001e\u0010F\u001a\u00020\u0007*\u00020\u00072\u0006\u0010G\u001a\u00020\n2\b\b\u0002\u0010J\u001a\u00020\u0006H\u0007\u001a\u001a\u0010K\u001a\u00020\u0007*\u00020\u00072\u0006\u0010L\u001a\u00020\n2\u0006\u0010G\u001a\u00020?\u001a\u001a\u0010K\u001a\u00020\u0007*\u00020\u00072\u0006\u0010L\u001a\u00020\n2\u0006\u0010G\u001a\u00020\n\u001a\u001e\u0010M\u001a\u00020\u0007*\u00020\u00072\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00100,\u001a&\u0010M\u001a\u00020\u0007*\u00020\u00072\u0006\u0010G\u001a\u00020?2\b\b\u0002\u0010H\u001a\u00020I2\b\b\u0002\u0010C\u001a\u00020I\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006O"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "illegalChars", "", "", "isWritable", "", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "parentSystemIndependentPath", "", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "doCreateDirectories", "", "path", "isDirectory", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "isSymbolicLink", "sanitizeFileName", "name", "replacement", "isTruncate", "basicAttributesIfExists", "copy", "target", "createDirectories", "createFile", "createSymbolicLink", "delete", "deleteRecursively", "deleteAsIOFile", "deleteChildrenStartingWith", "prefix", "kotlin.jvm.PlatformType", "deleteWithParentsIfEmpty", "root", "isFile", "directoryStreamIfExists", "R", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "task", "Ljava/nio/file/DirectoryStream;", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "inputStreamIfExists", "inputStreamSkippingBom", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readChars", "", "readText", "size", "", "sizeOrNull", "write", "data", "offset", "", "createParentDirs", "writeChild", "relativePath", "writeSafe", "outConsumer", "intellij.platform.projectModel"})
public final class PathKt {
    private static final Logger LOG;
    private static final Set<Character> illegalChars;

    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.exists($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path createDirectories(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!Files.isDirectory($receiver, new LinkOption[0])) {
            try {
                Path path2 = $receiver.toAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"toAbsolutePath()");
                PathKt.doCreateDirectories(path2);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        return $receiver;
    }

    private static final void doCreateDirectories(Path path2) {
        Path path3 = path2.getParent();
        if (path3 != null) {
            Path path4;
            Path it = path4 = path3;
            boolean bl = false;
            if (!Files.isDirectory(it, new LinkOption[0])) {
                PathKt.doCreateDirectories(it);
            }
        }
        Files.createDirectory(path2, new FileAttribute[0]);
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        InputStream inputStream = Files.newInputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(this)");
        return inputStream;
    }

    @NotNull
    public static final InputStream inputStreamSkippingBom(@NotNull Path $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        InputStream inputStream = PathKt.inputStream($receiver);
        int n = 8192;
        InputStream inputStream2 = CharsetToolkit.inputStreamSkippingBOM((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n)));
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"CharsetToolkit.inputStre\u2026inputStream().buffered())");
        return inputStream2;
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            return PathKt.inputStream($receiver);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $receiver, boolean deleteRecursively2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            if (!deleteRecursively2) {
                Files.delete($receiver);
                return;
            }
            BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
            if (basicFileAttributes == null) {
                return;
            }
            BasicFileAttributes attributes = basicFileAttributes;
            if (attributes.isDirectory()) {
                PathKt.deleteRecursively($receiver);
            } else {
                Files.delete($receiver);
            }
        }
        catch (Exception e) {
            PathKt.deleteAsIOFile($receiver);
        }
    }

    @JvmOverloads
    public static /* synthetic */ void delete$default(Path path2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        PathKt.delete(path2, bl);
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $receiver) {
        PathKt.delete$default($receiver, false, 1, null);
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $receiver, @NotNull Path root, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        try {
            PathKt.delete$default($receiver, false, 1, null);
        }
        catch (NoSuchFileException e) {
            return false;
        }
        for (Path parent = isFile ? $receiver.getParent() : null; parent != null && Intrinsics.areEqual((Object)parent, (Object)root) ^ true; parent = parent.getParent()) {
            try {
                Files.delete(parent);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteChildrenStartingWith(@NotNull Path $receiver, @NotNull String prefix) {
        Iterable iterable;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Path path2 = $receiver;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
            {
                this.$prefix = string;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;

                public final boolean accept(Path it) {
                    Path path2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path2);
                }
                {
                    this.$filter = function1;
                }
            });
            Throwable throwable = null;
            try {
                Iterable it = (DirectoryStream)closeable;
                boolean bl = false;
                it = CollectionsKt.toList((Iterable)it);
                iterable = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable != null) {
            $receiver$iv = iterable;
            for (Object element$iv : $receiver$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Path path3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"it");
                PathKt.delete$default(path3, false, 1, null);
            }
        }
    }

    private static final Path deleteRecursively(@NotNull Path $receiver) {
        return Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>($receiver){
            final /* synthetic */ Path $this_deleteRecursively;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                try {
                    Files.delete(file);
                }
                catch (Exception e) {
                    PathKt.access$deleteAsIOFile(this.$this_deleteRecursively);
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                try {
                    Files.delete(dir);
                }
                catch (Exception e) {
                    PathKt.access$deleteAsIOFile(this.$this_deleteRecursively);
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.$this_deleteRecursively = $receiver;
            }
        });
    }

    private static final void deleteAsIOFile(@NotNull Path $receiver) {
        try {
            FileUtil.delete((File)$receiver.toFile());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public static final FileTime lastModified(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        FileTime fileTime = Files.getLastModifiedTime($receiver, new LinkOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"Files.getLastModifiedTime(this)");
        return fileTime;
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path path2 = $receiver.getParent();
        if (path2 == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path2).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        byte[] byArray = Files.readAllBytes($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public static final String readText(@NotNull Path $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        byte[] byArray = PathKt.readBytes($receiver);
        Charset charset = Charsets.UTF_8;
        return new String(byArray, charset);
    }

    @NotNull
    public static final CharSequence readChars(@NotNull Path $receiver) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        InputStream inputStream = PathKt.inputStream($receiver);
        Charset charset = Charsets.UTF_8;
        return IoKt.readCharSequence(new InputStreamReader(inputStream, charset), (int)PathKt.size($receiver));
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull byte[] data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path2 = $receiver.resolve(relativePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"resolve(relativePath)");
        return PathKt.write$default(path2, data, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull String data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data;
        String string2 = relativePath;
        Path path2 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return PathKt.writeChild(path2, string2, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Closeable closeable = PathKt.outputStream($receiver);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(data, offset, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $receiver;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Path write$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path2, byArray, n, n2);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data, int offset) throws IOException {
        return PathKt.write$default($receiver, data, offset, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data) throws IOException {
        return PathKt.write$default($receiver, data, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        PathKt.writeSafe($receiver, (Function1<? super OutputStream, Unit>)((Function1)new Function1<OutputStream, Unit>(data, offset, size){
            final /* synthetic */ byte[] $data;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $size;

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.write(this.$data, this.$offset, this.$size);
            }
            {
                this.$data = byArray;
                this.$offset = n;
                this.$size = n2;
                super(1);
            }
        }));
        return $receiver;
    }

    @NotNull
    public static /* synthetic */ Path writeSafe$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.writeSafe(path2, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull Function1<? super OutputStream, Unit> outConsumer) {
        Path tempFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(outConsumer, (String)"outConsumer");
        Path path2 = tempFile = $receiver.getParent().resolve($receiver.getFileName() + '.' + UUID.randomUUID() + ".tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"tempFile");
        Closeable closeable = PathKt.outputStream(path2);
        Throwable throwable = null;
        try {
            Object object = outConsumer.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        try {
            Files.move(tempFile, $receiver, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.warn((Throwable)e);
            Files.move(tempFile, $receiver, StandardCopyOption.REPLACE_EXISTING);
        }
        return $receiver;
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull String data, boolean createParentDirs) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (createParentDirs) {
            Path path2 = $receiver.getParent();
            if (path2 != null) {
                PathKt.createDirectories(path2);
            }
        }
        String string = data;
        Path path3 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path3, byArray2, new OpenOption[0]);
        return $receiver;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Path write$default(Path path2, String string, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.write(path2, string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull String data) throws IOException {
        return PathKt.write$default($receiver, data, false, 2, null);
    }

    public static final long size(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.size($receiver);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            return Files.readAttributes($receiver, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileSystemException ignored) {
            return null;
        }
    }

    public static final long sizeOrNull(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
        return basicFileAttributes != null ? basicFileAttributes.size() : -1L;
    }

    public static final boolean isHidden(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isHidden($receiver);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path move(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = Files.move($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.move(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path2;
    }

    @NotNull
    public static final Path copy(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = target.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Path path3 = Files.copy($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.copy(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    public static final void createFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createFile($receiver, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        int $i$f$directoryStreamIfExists = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver);
            Throwable throwable = null;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super Path, Boolean> filter, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        int $i$f$directoryStreamIfExists = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver, (DirectoryStream.Filter<? super Path>)new /* invalid duplicate definition of identical inner class */);
            Throwable throwable = null;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeFileName(@NotNull String name, @Nullable String replacement, boolean isTruncate) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        StringBuilder result2 = null;
        int last = 0;
        int length = name.length();
        int n = 0;
        int n2 = length;
        while (n < n2) {
            char c;
            void i;
            char c2 = name.charAt((int)i);
            if (illegalChars.contains(Character.valueOf(c2)) || Character.isISOControl(c = c2)) {
                if (result2 == null) {
                    result2 = new StringBuilder();
                }
                if (last < i) {
                    result2.append(name, last, (int)i);
                }
                if (replacement != null) {
                    result2.append(replacement);
                }
                last = i + true;
            }
            ++i;
        }
        Function1<String, String> truncateFileName$ = new Function1<String, String>(isTruncate, length){
            final /* synthetic */ boolean $isTruncate;
            final /* synthetic */ int $length;

            @NotNull
            public final String invoke(@NotNull String $receiver) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                if (this.$isTruncate) {
                    String string2 = $receiver;
                    int n = 0;
                    int n2 = Math.min(this.$length, 255);
                    String string3 = string2.substring(n, n2);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = $receiver;
                }
                return string;
            }
            {
                this.$isTruncate = bl;
                this.$length = n;
                super(1);
            }
        };
        if (result2 == null) {
            return truncateFileName$.invoke(name);
        }
        if (last < length) {
            result2.append(name, last, length);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return truncateFileName$.invoke(string);
    }

    @NotNull
    public static /* synthetic */ String sanitizeFileName$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "_";
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return PathKt.sanitizeFileName(string, string2, bl);
    }

    public static final boolean isWritable(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isWritable($receiver);
    }

    public static final boolean isDirectory(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isDirectory();
    }

    public static final boolean isSymbolicLink(@Nullable BasicFileAttributes attributes) {
        return attributes != null && attributes.isSymbolicLink();
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.util.io.FileUtil");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026penapi.util.io.FileUtil\")");
        LOG = logger;
        illegalChars = SetsKt.setOf((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});
    }

    public static final /* synthetic */ void access$deleteAsIOFile(Path $receiver) {
        PathKt.deleteAsIOFile($receiver);
    }
}

