/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;

public abstract class JBEditorTabsPainter {
    protected Color myDefaultTabColor;
    protected final JBEditorTabs myTabs;
    protected static final Color BORDER_COLOR = JBColor.namedColor((String)"EditorTabs.borderColor", (Color)UIUtil.CONTRAST_BORDER_COLOR);
    protected static final Color UNDERLINE_COLOR = JBColor.namedColor((String)"EditorTabs.underlineColor", (int)4431544);
    protected static final Color DEFAULT_TAB_COLOR = JBColor.namedColor((String)"EditorTabs.selectedBackground", (Color)new JBColor(0xFFFFFF, 5330520));
    protected static final Color INACTIVE_MASK_COLOR = JBColor.namedColor((String)"EditorTabs.inactiveMaskColor", (Color)new JBColor(ColorUtil.withAlpha((Color)Gray.x26, (double)0.2), ColorUtil.withAlpha((Color)Gray.x26, (double)0.5)));

    public JBEditorTabsPainter(JBEditorTabs tabs) {
        this.myTabs = tabs;
    }

    public abstract void doPaintInactive(Graphics2D var1, Rectangle var2, int var3, int var4, int var5, int var6, Color var7, int var8, int var9, boolean var10);

    public abstract void doPaintBackground(Graphics2D var1, Rectangle var2, boolean var3, Rectangle var4);

    public abstract void fillSelectionAndBorder(Graphics2D var1, JBTabsImpl.ShapeInfo var2, Color var3, int var4, int var5, int var6);

    public void paintSelectionAndBorder(Graphics2D g2d, Rectangle rect, JBTabsImpl.ShapeInfo selectedShape, Insets insets, Color tabColor) {
        Insets i = selectedShape.path.transformInsets(insets);
        int _x = rect.x;
        int _y = rect.y;
        int _height = rect.height;
        JBTabsPosition position = this.myTabs.getPosition();
        boolean horizontalTabs = this.myTabs.isHorizontalTabs();
        if (this.myTabs.hasUnderlineSelection()) {
            this.fillSelectionAndBorder(g2d, selectedShape, tabColor, _x, _y, _height);
            g2d.setColor(JBEditorTabsPainter.hasFocus(this.myTabs) ? UNDERLINE_COLOR : ColorUtil.withAlpha((Color)UNDERLINE_COLOR, (double)0.5));
            int thickness = 3;
            if (position == JBTabsPosition.bottom) {
                g2d.fillRect(rect.x, rect.y - 1, rect.width, thickness);
            } else if (position == JBTabsPosition.top) {
                g2d.fillRect(rect.x, rect.y + rect.height - thickness + 1, rect.width, thickness);
                g2d.setColor(BORDER_COLOR);
                g2d.drawLine(Math.max(0, rect.x - 1), rect.y, rect.x + rect.width, rect.y);
            } else if (position == JBTabsPosition.left) {
                g2d.fillRect(rect.x + rect.width - thickness + 1, rect.y, thickness, rect.height);
            } else if (position == JBTabsPosition.right) {
                g2d.fillRect(rect.x, rect.y, thickness, rect.height);
            }
            return;
        }
        if (!horizontalTabs) {
            g2d.setColor(Gray._0.withAlpha(45));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.setColor(Gray._0.withAlpha(15));
            g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(5)));
        }
        this.fillSelectionAndBorder(g2d, selectedShape, tabColor, _x, _y, _height);
        if (!horizontalTabs) {
            g2d.setColor(Gray._0.withAlpha(30));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() + selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
            g2d.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
        }
        g2d.setColor(Gray._0.withAlpha(15));
        g2d.draw(selectedShape.labelPath.transformLine(i.left, selectedShape.labelPath.getMaxY(), selectedShape.path.getMaxX(), selectedShape.labelPath.getMaxY()));
    }

    public static boolean hasFocus(Component component) {
        Component focusOwner = JBEditorTabsPainter.findFocusOwner(component);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public abstract Color getBackgroundColor();

    public Color getEmptySpaceColor() {
        return UIUtil.isUnderAquaLookAndFeel() ? Gray.xC8 : UIUtil.getPanelBackground();
    }

    public void setDefaultTabColor(Color color) {
        this.myDefaultTabColor = color;
    }
}

