/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.NotNull;

public class ExtendableTextField
extends JBTextField
implements ExtendableTextComponent {
    private List<ExtendableTextComponent.Extension> extensions = Collections.emptyList();

    public ExtendableTextField() {
        this(null);
    }

    public ExtendableTextField(int columns) {
        this(null, columns);
    }

    public ExtendableTextField(String text) {
        this(text, 20);
    }

    public ExtendableTextField(String text, int columns) {
        super(text, columns);
    }

    @Override
    public List<ExtendableTextComponent.Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(ExtendableTextComponent.Extension ... extensions) {
        this.setExtensions(Arrays.asList(extensions));
    }

    @Override
    public void setExtensions(Collection<? extends ExtendableTextComponent.Extension> extensions) {
        this.setExtensions((List<? extends ExtendableTextComponent.Extension>)new ArrayList<ExtendableTextComponent.Extension>(extensions));
    }

    private void setExtensions(List<? extends ExtendableTextComponent.Extension> extensions) {
        this.putClientProperty("JTextField.variant", null);
        this.extensions = Collections.unmodifiableList(extensions);
        this.putClientProperty("JTextField.variant", "extendable");
    }

    @Override
    public void addExtension(@NotNull ExtendableTextComponent.Extension extension) {
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(0);
        }
        if (!this.getExtensions().contains(extension)) {
            ArrayList<ExtendableTextComponent.Extension> extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions());
            extensions.add(extension);
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    public void removeExtension(@NotNull ExtendableTextComponent.Extension extension) {
        ArrayList<ExtendableTextComponent.Extension> extensions;
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(1);
        }
        if ((extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions())).remove(extension)) {
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    @Deprecated
    public void setUI(TextUI ui) {
        TextUI suggested = ui;
        try {
            if (ui == null || !Class.forName("com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI").isAssignableFrom(ui.getClass())) {
                ui = (TextUI)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI").getDeclaredMethod("createUI", JComponent.class).invoke(null, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUI(ui);
        if (ui != suggested) {
            try {
                this.setBorder((Border)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder").newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "extension";
        objectArray2[1] = "com/intellij/ui/components/fields/ExtendableTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

