/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.JBComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLabel
extends JLabel
implements AnchorableComponent,
JBComponent<JBLabel> {
    private UIUtil.ComponentStyle myComponentStyle;
    private UIUtil.FontColor myFontColor;
    private JComponent myAnchor;
    private JEditorPane myEditorPane;
    private JLabel myIconLabel;
    private boolean myMultiline;
    private boolean myAllowAutoWrapping;

    public JBLabel() {
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(0);
        }
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@Nullable Icon image) {
        super(image);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NotNull String text) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(1);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(2);
        }
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(3);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
    }

    public JBLabel(@NotNull String text, @NotNull UIUtil.ComponentStyle componentStyle, @NotNull UIUtil.FontColor fontColor) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(4);
        }
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(5);
        }
        if (fontColor == null) {
            JBLabel.$$$reportNull$$$0(6);
        }
        super(text);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
        this.setComponentStyle(componentStyle);
        this.setFontColor(fontColor);
    }

    public JBLabel(@NotNull String text, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(7);
        }
        super(text, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@Nullable Icon image, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public JBLabel(@NotNull String text, @Nullable Icon icon, @JdkConstants.HorizontalAlignment int horizontalAlignment) {
        if (text == null) {
            JBLabel.$$$reportNull$$$0(8);
        }
        super(text, icon, horizontalAlignment);
        this.myComponentStyle = UIUtil.ComponentStyle.REGULAR;
        this.myFontColor = UIUtil.FontColor.NORMAL;
        this.myAllowAutoWrapping = false;
    }

    public void setComponentStyle(@NotNull UIUtil.ComponentStyle componentStyle) {
        if (componentStyle == null) {
            JBLabel.$$$reportNull$$$0(9);
        }
        this.myComponentStyle = componentStyle;
        UIUtil.applyStyle((UIUtil.ComponentStyle)componentStyle, (Component)this);
    }

    public UIUtil.ComponentStyle getComponentStyle() {
        return this.myComponentStyle;
    }

    public UIUtil.FontColor getFontColor() {
        return this.myFontColor;
    }

    public void setFontColor(@NotNull UIUtil.FontColor fontColor) {
        if (fontColor == null) {
            JBLabel.$$$reportNull$$$0(10);
        }
        this.myFontColor = fontColor;
    }

    @Override
    public Color getForeground() {
        if (!this.isEnabled()) {
            return UIUtil.getLabelDisabledForeground();
        }
        if (this.myFontColor != null) {
            return UIUtil.getLabelFontColor((UIUtil.FontColor)this.myFontColor);
        }
        return super.getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.myFontColor = null;
        super.setForeground(fg);
        if (this.myEditorPane != null) {
            this.updateStyle(this.myEditorPane);
        }
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getPreferredSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myAnchor != null && this.myAnchor != this) {
            return this.myAnchor.getMinimumSize();
        }
        if (this.myEditorPane != null) {
            return this.getLayout().minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myEditorPane == null) {
            super.paintComponent(g);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.myEditorPane != null) {
            this.myEditorPane.setText(this.getText());
            this.updateStyle(this.myEditorPane);
            this.checkMultiline();
            this.updateTextAlignment();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (this.myIconLabel != null) {
            this.myIconLabel.setIcon(icon);
            this.updateLayout();
            this.updateTextAlignment();
        }
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        if (this.myEditorPane != null) {
            this.myEditorPane.setFocusable(focusable);
        }
    }

    private void checkMultiline() {
        this.myMultiline = StringUtil.removeHtmlTags((String)this.getText()).contains(SystemProperties.getLineSeparator());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorPane != null) {
            this.updateStyle(this.myEditorPane);
            this.updateTextAlignment();
        }
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        super.setIconTextGap(iconTextGap);
        if (this.myEditorPane != null) {
            this.updateLayout();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.myEditorPane != null) {
            this.updateTextAlignment();
        }
    }

    @Override
    public void setVerticalTextPosition(int textPosition) {
        super.setVerticalTextPosition(textPosition);
        if (this.myEditorPane != null) {
            this.updateTextAlignment();
        }
    }

    protected void updateLayout() {
        this.setLayout(new BorderLayout(this.getIcon() == null ? 0 : this.getIconTextGap(), 0));
        this.add((Component)this.myIconLabel, "West");
        this.add((Component)this.myEditorPane, "Center");
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myEditorPane != null) {
            this.setCopyable(false);
            this.setCopyable(true);
        }
        UISettings.setupComponentAntialiasing(this);
    }

    public JBLabel setCopyable(boolean copyable) {
        if (copyable ^ this.myEditorPane != null) {
            if (this.myEditorPane == null) {
                final JBLabel ellipsisLabel = new JBLabel("...");
                this.myIconLabel = new JLabel(this.getIcon());
                this.myEditorPane = new JEditorPane(){

                    @Override
                    public void paint(Graphics g) {
                        boolean paintEllipsis;
                        Dimension size = this.getSize();
                        boolean bl = paintEllipsis = this.getPreferredSize().width > size.width && !JBLabel.this.myMultiline;
                        if (!paintEllipsis) {
                            super.paint(g);
                        } else {
                            Dimension ellipsisSize = ellipsisLabel.getPreferredSize();
                            int endOffset = size.width - ellipsisSize.width;
                            try {
                                endOffset = this.modelToView((int)(this.viewToModel((Point)new Point((int)endOffset, (int)(this.getHeight() / 2))) - 1)).x;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            Shape oldClip = g.getClip();
                            g.clipRect(0, 0, endOffset, size.height);
                            super.paint(g);
                            g.setClip(oldClip);
                            g.translate(endOffset, 0);
                            ellipsisLabel.setSize(ellipsisSize);
                            ellipsisLabel.paint(g);
                            g.translate(-endOffset, 0);
                        }
                    }
                };
                this.myEditorPane.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (JBLabel.this.myEditorPane == null) {
                            return;
                        }
                        int caretPosition = JBLabel.this.myEditorPane.getCaretPosition();
                        JBLabel.this.myEditorPane.setSelectionStart(caretPosition);
                        JBLabel.this.myEditorPane.setSelectionEnd(caretPosition);
                    }
                });
                this.myEditorPane.setContentType("text/html");
                this.myEditorPane.setEditable(false);
                this.myEditorPane.setBackground(UIUtil.TRANSPARENT_COLOR);
                this.myEditorPane.setOpaque(false);
                this.myEditorPane.addHyperlinkListener(BrowserHyperlinkListener.INSTANCE);
                UIUtil.putClientProperty((JComponent)this.myEditorPane, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, Collections.singleton(ellipsisLabel));
                this.myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
                this.updateStyle(this.myEditorPane);
                if (this.myEditorPane.getCaret() instanceof DefaultCaret) {
                    ((DefaultCaret)this.myEditorPane.getCaret()).setUpdatePolicy(1);
                }
                this.myEditorPane.setText(this.getText());
                this.checkMultiline();
                this.myEditorPane.setCaretPosition(0);
                this.updateLayout();
                this.updateTextAlignment();
            } else {
                this.removeAll();
                this.myEditorPane = null;
                this.myIconLabel = null;
            }
        }
        return this;
    }

    private void updateStyle(@NotNull JEditorPane pane) {
        if (pane == null) {
            JBLabel.$$$reportNull$$$0(11);
        }
        this.myEditorPane.setFont(this.getFont());
        this.myEditorPane.setForeground(this.getForeground());
        EditorKit kit = pane.getEditorKit();
        if (kit instanceof HTMLEditorKit) {
            StyleSheet css = ((HTMLEditorKit)kit).getStyleSheet();
            css.addRule("body, p {color:#" + ColorUtil.toHex((Color)this.getForeground()) + ";font-family:" + this.getFont().getFamily() + ";font-size:" + this.getFont().getSize() + "pt;white-space:" + (this.myAllowAutoWrapping ? "normal" : "nowrap") + ";}");
        }
    }

    public JBLabel setAllowAutoWrapping(boolean allowAutoWrapping) {
        this.myAllowAutoWrapping = allowAutoWrapping;
        return this;
    }

    private void updateTextAlignment() {
        if (this.myEditorPane == null) {
            return;
        }
        this.myEditorPane.setBorder(null);
        int position = this.getVerticalTextPosition();
        if (position == 1) {
            return;
        }
        int preferredHeight = this.myEditorPane.getPreferredSize().height;
        int availableHeight = this.getHeight();
        if (availableHeight <= preferredHeight) {
            return;
        }
        this.myEditorPane.setBorder(new EmptyBorder(position == 0 ? (availableHeight - preferredHeight + 1) / 2 : availableHeight - preferredHeight, 0, 0, 0));
    }

    public JBLabel withBorder(Border border) {
        this.setBorder(border);
        return this;
    }

    public JBLabel withFont(JBFont font) {
        this.setFont((Font)font);
        return this;
    }

    public JBLabel andTransparent() {
        this.setOpaque(false);
        return this;
    }

    public JBLabel andOpaque() {
        this.setOpaque(true);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentStyle";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontColor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/JBLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponentStyle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setFontColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStyle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

