/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchTextField
extends JPanel {
    public static final DataKey<SearchTextField> KEY = DataKey.create("search.text.field");
    public static final KeyStroke SHOW_HISTORY_KEYSTROKE = KeyStroke.getKeyStroke(40, 512);
    public static final CustomShortcutSet SHOW_HISTORY_SHORTCUT = new CustomShortcutSet(SHOW_HISTORY_KEYSTROKE);
    public static final KeyStroke ALT_SHOW_HISTORY_KEYSTROKE = KeyStroke.getKeyStroke(38, 512);
    public static final CustomShortcutSet ALT_SHOW_HISTORY_SHORTCUT = new CustomShortcutSet(ALT_SHOW_HISTORY_KEYSTROKE);
    private int myHistorySize = 5;
    private int myCurrentHistoryIndex;
    private final MyModel myModel = new MyModel();
    private final TextFieldWithProcessing myTextField = new TextFieldWithProcessing(){

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (SearchTextField.this.preprocessEventForTextField(e)) {
                return;
            }
            super.processKeyEvent(e);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            TextUI ui = this.getUI();
            if (ui instanceof Condition && ((Condition)ui).value((Object)e)) {
                return;
            }
            super.processMouseEvent(e);
        }

        @Override
        public void setUI(TextUI ui) {
            if (SearchTextField.this.customSetupUIAndTextField(this, (Consumer<? super TextUI>)((Consumer)textUI -> super.setUI((TextUI)textUI)))) {
                return;
            }
            super.setUI(ui);
        }

        @Override
        protected Rectangle getEmptyTextComponentBounds(Rectangle bounds) {
            Integer gap = (Integer)this.getClientProperty("JTextField.Search.GapEmptyText");
            if (gap != null) {
                bounds.x += gap.intValue();
                bounds.width -= 2 * gap;
            }
            return bounds;
        }
    };
    private JBPopup myPopup;
    private JPopupMenu myNativeSearchPopup;
    private JMenuItem myNoItems;
    private String myHistoryPropertyName;

    public SearchTextField() {
        this(true);
    }

    public SearchTextField(boolean historyPopupEnabled) {
        this(historyPopupEnabled, null);
    }

    public SearchTextField(String historyPropertyName) {
        this(true, historyPropertyName);
    }

    public SearchTextField(boolean historyPopupEnabled, @Nullable String historyPropertyName) {
        super(new BorderLayout());
        ActionManager actionManager;
        this.myTextField.setColumns(15);
        this.myTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchTextField.this.onFocusLost();
                super.focusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchTextField.this.onFocusGained();
                super.focusGained(e);
            }
        });
        this.add((Component)this.myTextField, "Center");
        this.setHistoryPropertyName(historyPropertyName);
        if (historyPopupEnabled) {
            DumbAwareAction.create((Consumer<? super AnActionEvent>)((Consumer)event -> {
                if (this.myNativeSearchPopup != null) {
                    this.myNativeSearchPopup.show(this.myTextField, 5, this.myTextField.getHeight());
                } else if (this.myPopup == null || !this.myPopup.isVisible()) {
                    this.showPopup();
                }
            })).registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts("ShowSearchHistory"), this.myTextField);
        } else if (historyPropertyName != null) {
            this.myTextField.getActionMap().put("showPrevHistoryItem", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SearchTextField.this.myModel.myFullList.contains(SearchTextField.this.getText())) {
                        SearchTextField.this.addCurrentTextToHistory();
                    }
                    if (SearchTextField.this.myModel.getSize() < 2) {
                        return;
                    }
                    SearchTextField.this.myCurrentHistoryIndex--;
                    if (SearchTextField.this.myCurrentHistoryIndex < 0) {
                        SearchTextField.this.myCurrentHistoryIndex = SearchTextField.this.myModel.getSize() - 1;
                    }
                    SearchTextField.this.setText(SearchTextField.this.myModel.getElementAt(SearchTextField.this.myCurrentHistoryIndex));
                }
            });
            this.myTextField.getInputMap().put(ALT_SHOW_HISTORY_KEYSTROKE, "showPrevHistoryItem");
            this.myTextField.getActionMap().put("showNextHistoryItem", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SearchTextField.this.myModel.myFullList.contains(SearchTextField.this.getText())) {
                        SearchTextField.this.addCurrentTextToHistory();
                    }
                    if (SearchTextField.this.myModel.getSize() < 2) {
                        return;
                    }
                    SearchTextField.this.myCurrentHistoryIndex++;
                    if (SearchTextField.this.myCurrentHistoryIndex > SearchTextField.this.myModel.getSize() - 1) {
                        SearchTextField.this.myCurrentHistoryIndex = 0;
                    }
                    SearchTextField.this.setText(SearchTextField.this.myModel.getElementAt(SearchTextField.this.myCurrentHistoryIndex));
                }
            });
            this.myTextField.getInputMap().put(SHOW_HISTORY_KEYSTROKE, "showNextHistoryItem");
        }
        this.myTextField.putClientProperty("JTextField.variant", "search");
        this.myTextField.putClientProperty("JTextField.Search.CancelAction", e -> {
            this.myTextField.setText("");
            this.onFieldCleared();
        });
        if (historyPopupEnabled) {
            this.myNativeSearchPopup = new JBPopupMenu();
            this.myNoItems = new JBMenuItem("No recent searches");
            this.myNoItems.setEnabled(false);
            this.updateMenu();
            this.myTextField.putClientProperty("JTextField.Search.FindPopup", this.myNativeSearchPopup);
        }
        if (this.toClearTextOnEscape() && (actionManager = ActionManager.getInstance()) != null) {
            EmptyAction.registerWithShortcutSet("TextComponent.ClearAction", CommonShortcuts.ESCAPE, this);
        }
    }

    protected boolean toClearTextOnEscape() {
        return ApplicationManager.getApplication() != null;
    }

    protected void onFieldCleared() {
    }

    protected void onFocusLost() {
        this.addCurrentTextToHistory();
    }

    protected void onFocusGained() {
    }

    private void updateMenu() {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.removeAll();
            int itemsCount = this.myModel.getSize();
            if (itemsCount == 0) {
                this.myNativeSearchPopup.add(this.myNoItems);
            } else {
                for (int i = 0; i < itemsCount; ++i) {
                    String item = this.myModel.getElementAt(i);
                    this.addMenuItem(item);
                }
            }
        }
    }

    @Deprecated
    protected boolean isSearchControlUISupported() {
        return true;
    }

    @Deprecated
    protected boolean hasIconsOutsideOfTextField() {
        return false;
    }

    protected boolean customSetupUIAndTextField(@NotNull TextFieldWithProcessing textField, @NotNull Consumer<? super TextUI> uiConsumer) {
        if (textField == null) {
            SearchTextField.$$$reportNull$$$0(0);
        }
        if (uiConsumer == null) {
            SearchTextField.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isMac) {
            try {
                Class<?> uiClass = UIUtil.isUnderIntelliJLaF() ? Class.forName("com.intellij.ide.ui.laf.intellij.MacIntelliJTextFieldUI") : Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI");
                Method method = ReflectionUtil.getMethod(uiClass, (String)"createUI", (Class[])new Class[]{JComponent.class});
                if (method != null) {
                    uiConsumer.consume((Object)((TextUI)method.invoke(uiClass, textField)));
                    Class<?> borderClass = UIUtil.isUnderIntelliJLaF() ? Class.forName("com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder") : Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder");
                    textField.setBorder((Border)ReflectionUtil.newInstance(borderClass));
                    textField.setOpaque(false);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().removeDocumentListener(listener);
    }

    public void addKeyboardListener(KeyListener listener) {
        this.getTextEditor().addKeyListener(listener);
    }

    public void setHistorySize(int historySize) {
        if (historySize <= 0) {
            throw new IllegalArgumentException("history size must be a positive number");
        }
        this.myHistorySize = historySize;
    }

    public void setHistory(List<String> aHistory) {
        this.myModel.setItems(aHistory);
    }

    public List<String> getHistory() {
        int itemsCount = this.myModel.getSize();
        ArrayList<String> history = new ArrayList<String>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            history.add(this.myModel.getElementAt(i));
        }
        return history;
    }

    public void setText(String aText) {
        this.getTextEditor().setText(aText);
    }

    public String getText() {
        return this.getTextEditor().getText();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.hidePopup();
    }

    public void addCurrentTextToHistory() {
        if (this.myModel.addElement(this.getText()) && this.myHistoryPropertyName != null) {
            PropertiesComponent.getInstance().setValue(this.myHistoryPropertyName, StringUtil.join(this.getHistory(), (String)"\n"));
        }
    }

    private void addMenuItem(String item) {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.remove(this.myNoItems);
            JBMenuItem menuItem = new JBMenuItem(item);
            this.myNativeSearchPopup.add(menuItem);
            menuItem.addActionListener(e -> {
                this.myTextField.setText(item);
                this.addCurrentTextToHistory();
            });
        }
    }

    public void selectText() {
        this.getTextEditor().selectAll();
    }

    public JBTextField getTextEditor() {
        return this.myTextField;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myTextField.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.getTextEditor(), true));
    }

    protected void setHistoryPropertyName(String historyPropertyName) {
        this.myHistoryPropertyName = historyPropertyName;
        this.myTextField.putClientProperty("JTextField.Search.InplaceHistory", this.myHistoryPropertyName);
        this.reset();
    }

    public void reset() {
        if (this.myHistoryPropertyName == null) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String history = propertiesComponent.getValue(this.myHistoryPropertyName);
        if (history != null) {
            String[] items = history.split("\n");
            ArrayList<String> result2 = new ArrayList<String>();
            for (String item : items) {
                if (item == null || item.length() <= 0) continue;
                result2.add(item);
            }
            this.setHistory(result2);
        } else {
            this.setEmptyHistory();
        }
        this.setSelectedItem("");
    }

    protected void setEmptyHistory() {
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Border border = super.getBorder();
        if (border != null && UIUtil.isUnderAquaLookAndFeel()) {
            JBInsets.addTo((Dimension)size, (Insets)border.getBorderInsets(this));
        }
        return size;
    }

    protected Runnable createItemChosenCallback(JList list) {
        return () -> {
            String value = (String)list.getSelectedValue();
            this.getTextEditor().setText(value != null ? value : "");
            this.addCurrentTextToHistory();
            if (this.myPopup != null) {
                this.myPopup.cancel();
                this.myPopup = null;
            }
        };
    }

    protected void showPopup() {
        this.addCurrentTextToHistory();
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            JBList list = new JBList(this.myModel);
            Runnable chooseRunnable = this.createItemChosenCallback(list);
            this.myPopup = ((PopupChooserBuilder)((PopupChooserBuilder)JBPopupFactory.getInstance().createListPopupBuilder(list).setMovable(false)).setRequestFocus(true)).setItemChoosenCallback(chooseRunnable).createPopup();
            if (this.isShowing()) {
                this.myPopup.showUnderneathOf(this.getPopupLocationComponent());
            }
        }
    }

    protected Component getPopupLocationComponent() {
        return this;
    }

    public void setSelectedItem(String s) {
        this.getTextEditor().setText(s);
    }

    public int getSelectedIndex() {
        return this.myModel.myFullList.indexOf(this.getText());
    }

    protected final void keyEventToTextField(KeyEvent e) {
        this.myTextField.processKeyEvent(e);
    }

    protected boolean preprocessEventForTextField(KeyEvent e) {
        if (SHOW_HISTORY_KEYSTROKE.equals(KeyStroke.getKeyStrokeForEvent(e)) && this.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu) {
            this.showPopup();
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSearchIcon(Icon icon) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "textField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "uiConsumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/SearchTextField";
        objectArray[2] = "customSetupUIAndTextField";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class FindAction
    extends DumbAwareAction {
        @Override
        public void actionPerformed(@NotNull AnActionEvent event) {
            SearchTextField search;
            if (event == null) {
                FindAction.$$$reportNull$$$0(0);
            }
            if ((search = event.getData(KEY)) != null) {
                search.selectText();
                search.requestFocus();
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FindAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(e.getData(KEY) != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/SearchTextField$FindAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TextFieldWithProcessing
    extends JBTextField {
        protected TextFieldWithProcessing() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }

    public class MyModel
    extends AbstractListModel {
        private List<String> myFullList = new ArrayList<String>();
        private String mySelectedItem;

        @Override
        public String getElementAt(int index2) {
            return this.myFullList.get(index2);
        }

        @Override
        public int getSize() {
            return Math.min(SearchTextField.this.myHistorySize, this.myFullList.size());
        }

        public boolean addElement(String item) {
            String newItem = item.trim();
            if (newItem.isEmpty()) {
                return false;
            }
            int length = this.myFullList.size();
            int index2 = -1;
            for (int i = 0; i < length; ++i) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)this.myFullList.get(i), (CharSequence)newItem)) continue;
                index2 = i;
                break;
            }
            if (index2 == 0) {
                return false;
            }
            if (index2 > 0) {
                this.myFullList.remove(index2);
            } else if (this.myFullList.size() >= SearchTextField.this.myHistorySize && this.myFullList.size() > 0) {
                this.myFullList.remove(this.myFullList.size() - 1);
            }
            this.insertElementAt(newItem, 0);
            return true;
        }

        public void insertElementAt(String item, int index2) {
            this.myFullList.add(index2, item);
            this.fireContentsChanged();
        }

        public String getSelectedItem() {
            return this.mySelectedItem;
        }

        public void setSelectedItem(String anItem) {
            this.mySelectedItem = anItem;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
            SearchTextField.this.updateMenu();
        }

        public void setItems(List<String> aList) {
            this.myFullList = new ArrayList<String>(aList);
            this.fireContentsChanged();
        }
    }
}

