/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncValueLoaderManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater;

    public AsyncValueLoaderManager(@NotNull AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            AsyncValueLoaderManager.$$$reportNull$$$0(0);
        }
        this.fieldUpdater = fieldUpdater;
    }

    public AsyncValueLoaderManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            AsyncValueLoaderManager.$$$reportNull$$$0(1);
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, AsyncResult.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        if (host == null) {
            AsyncValueLoaderManager.$$$reportNull$$$0(2);
        }
        if (value == null) {
            AsyncValueLoaderManager.$$$reportNull$$$0(3);
        }
        return true;
    }

    public abstract void load(@NotNull HOST var1, @NotNull AsyncResult<VALUE> var2);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            this.getOrCreateAsyncResult(host, false, false).setDone(value);
        }
    }

    public final boolean has(HOST host) {
        AsyncResult result2 = (AsyncResult)this.fieldUpdater.get(host);
        return result2 != null && result2.isDone() && result2.getResult() != null;
    }

    @NotNull
    public final AsyncResult<VALUE> get(HOST host) {
        AsyncResult<VALUE> asyncResult = this.get(host, true);
        if (asyncResult == null) {
            AsyncValueLoaderManager.$$$reportNull$$$0(4);
        }
        return asyncResult;
    }

    public final AsyncResult<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    private AsyncResult<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        AsyncResult asyncResult = (AsyncResult)this.fieldUpdater.get(host);
        if (asyncResult == null) {
            asyncResult = new AsyncResult();
            if (!this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                return (AsyncResult)this.fieldUpdater.get(host);
            }
        } else {
            if (!asyncResult.isProcessed()) {
                return asyncResult;
            }
            if (asyncResult.isDone()) {
                if (!checkFreshness || this.isUpToDate(host, asyncResult.getResult())) {
                    return asyncResult;
                }
                if (!this.fieldUpdater.compareAndSet(host, asyncResult, asyncResult = new AsyncResult())) {
                    AsyncResult valueFromAnotherThread = (AsyncResult)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                            if (load) {
                                this.load(host, asyncResult);
                            }
                            return asyncResult;
                        }
                        valueFromAnotherThread = (AsyncResult)this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        if (load) {
            this.load(host, asyncResult);
        }
        return asyncResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldUpdater";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/AsyncValueLoaderManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/AsyncValueLoaderManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

