/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";
    private static final String JAVAAGENT = "-javaagent";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (jdk == null) {
            JdkUtil.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(1);
        }
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    @Nullable
    public static String suggestJdkName(@Nullable String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        if (version == null) {
            return null;
        }
        StringBuilder suggested = new StringBuilder();
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        return suggested.toString();
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(2);
        }
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(3);
        }
        return (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()) && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(4);
        }
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(5);
        }
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(6);
        }
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || JdkUtil.isModularRuntime(homePath) || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(7);
        }
        return JdkUtil.isModularRuntime(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean isModularRuntime(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(8);
        }
        return new File(homePath, "lib/jrt-fs.jar").isFile() || JdkUtil.isExplodedModularRuntime(homePath.getPath());
    }

    public static boolean isExplodedModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(9);
        }
        return new File(homePath, "modules/java.base").isDirectory();
    }

    @NotNull
    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        Sdk jdk;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(10);
        }
        if ((jdk = javaParameters.getJdk()) == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        SdkTypeId type = jdk.getSdkType();
        if (!(type instanceof JavaSdkType)) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        String exePath = ((JavaSdkType)((Object)type)).getVMExecutablePath(jdk);
        if (exePath == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0]));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
        JdkUtil.setupCommandLine(commandLine, javaParameters);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            JdkUtil.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    private static void setupCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(12);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(13);
        }
        commandLine.withWorkDirectory(javaParameters.getWorkingDirectory());
        commandLine.withEnvironment(javaParameters.getEnv());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        boolean dynamicClasspath = javaParameters.isDynamicClasspath();
        boolean dynamicVMOptions = dynamicClasspath && javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
        boolean dynamicParameters = dynamicClasspath && javaParameters.isDynamicParameters() && JdkUtil.useDynamicParameters();
        boolean dynamicMainClass = false;
        if (JdkUtil.isUrlClassloader(vmParameters)) {
            for (String parameter : vmParameters.getParameters()) {
                if (!parameter.startsWith(JAVAAGENT)) continue;
                int agentArgsIdx = parameter.indexOf("=", JAVAAGENT.length());
                javaParameters.getClassPath().addFirst(parameter.substring(JAVAAGENT.length() + 1, agentArgsIdx > -1 ? agentArgsIdx : parameter.length()));
            }
        }
        if (dynamicClasspath) {
            Class commandLineWrapper;
            if (javaParameters.isArgFile()) {
                JdkUtil.setArgFileParams(commandLine, javaParameters, vmParameters, dynamicVMOptions, dynamicParameters);
                dynamicMainClass = dynamicParameters;
            } else if (!JdkUtil.explicitClassPath(vmParameters) && javaParameters.getJarPath() == null && (commandLineWrapper = JdkUtil.getCommandLineWrapperClass()) != null) {
                if (javaParameters.isUseClasspathJar()) {
                    JdkUtil.setClasspathJarParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                } else if (javaParameters.isClasspathFile()) {
                    JdkUtil.setCommandLineWrapperParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                }
            } else {
                dynamicParameters = false;
                dynamicClasspath = false;
            }
        }
        if (!dynamicClasspath) {
            JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParameters);
        }
        if (!dynamicMainClass) {
            commandLine.addParameters(JdkUtil.getMainClassParams(javaParameters));
        }
        if (!dynamicParameters) {
            commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        }
    }

    private static boolean isUrlClassloader(@NotNull ParametersList vmParameters) {
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(14);
        }
        return UrlClassLoader.class.getName().equals(vmParameters.getPropertyValue("java.system.class.loader"));
    }

    private static boolean explicitClassPath(@NotNull ParametersList vmParameters) {
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(15);
        }
        return vmParameters.hasParameter("-cp") || vmParameters.hasParameter("-classpath") || vmParameters.hasParameter("--class-path");
    }

    private static boolean explicitModulePath(@NotNull ParametersList vmParameters) {
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(16);
        }
        return vmParameters.hasParameter("-p") || vmParameters.hasParameter("--module-path");
    }

    private static void setArgFileParams(@NotNull GeneralCommandLine commandLine, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(17);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(18);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(19);
        }
        try {
            File argFile = FileUtil.createTempFile((String)("idea_arg_file" + Math.abs(new Random().nextInt())), null);
            try (PrintWriter writer = JdkUtil.createOutputWriter(argFile);){
                PathsList modulePath;
                if (dynamicVMOptions) {
                    for (String param : vmParameters.getList()) {
                        writer.print(JdkUtil.quoteArg(param));
                        writer.print('\n');
                    }
                } else {
                    commandLine.addParameters(vmParameters.getList());
                }
                PathsList classPath = javaParameters.getClassPath();
                if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
                    writer.print("-classpath\n");
                    writer.print(JdkUtil.quoteArg(classPath.getPathsString()));
                    writer.print('\n');
                }
                if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
                    writer.print("-p\n");
                    writer.print(JdkUtil.quoteArg(modulePath.getPathsString()));
                    writer.print('\n');
                }
                if (dynamicParameters) {
                    for (String parameter : JdkUtil.getMainClassParams(javaParameters)) {
                        writer.print(JdkUtil.quoteArg(parameter));
                        writer.print('\n');
                    }
                    for (String parameter : javaParameters.getProgramParametersList().getList()) {
                        writer.print(JdkUtil.quoteArg(parameter));
                        writer.print('\n');
                    }
                }
            }
            commandLine.putUserData(COMMAND_LINE_CONTENT, ContainerUtil.stringMap((String[])new String[]{argFile.getAbsolutePath(), FileUtil.loadFile((File)argFile)}));
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            commandLine.addParameter("@" + argFile.getAbsolutePath());
            OSProcessHandler.deleteFileOnTermination(commandLine, argFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    @NotNull
    private static String quoteArg(@NotNull String arg) {
        String specials;
        if (arg == null) {
            JdkUtil.$$$reportNull$$$0(20);
        }
        if (!StringUtil.containsAnyChar((String)arg, (String)(specials = " #'\"\n\r\t\f"))) {
            String string = arg;
            if (string == null) {
                JdkUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == ' ' || c == '#' || c == '\'') {
                sb.append('\"').append(c).append('\"');
                continue;
            }
            if (c == '\"') {
                sb.append("\"\\\"\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\"\\n\"");
                continue;
            }
            if (c == '\r') {
                sb.append("\"\\r\"");
                continue;
            }
            if (c == '\t') {
                sb.append("\"\\t\"");
                continue;
            }
            if (c == '\f') {
                sb.append("\"\\f\"");
                continue;
            }
            sb.append(c);
        }
        String string = sb.toString();
        if (string == null) {
            JdkUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static void setCommandLineWrapperParams(@NotNull GeneralCommandLine commandLine, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, @NotNull Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(23);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(24);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(25);
        }
        if (commandLineWrapper == null) {
            JdkUtil.$$$reportNull$$$0(26);
        }
        try {
            int pseudoUniquePrefix = Math.abs(new Random().nextInt());
            File vmParamsFile = null;
            if (dynamicVMOptions) {
                vmParamsFile = FileUtil.createTempFile((String)("idea_vm_params" + pseudoUniquePrefix), null);
                try (PrintWriter writer = JdkUtil.createOutputWriter(vmParamsFile);){
                    for (String string : vmParameters.getList()) {
                        if (JdkUtil.isUserDefinedProperty(string)) {
                            writer.println(string);
                            continue;
                        }
                        commandLine.addParameter(string);
                    }
                }
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            File appParamsFile = null;
            if (dynamicParameters) {
                appParamsFile = FileUtil.createTempFile((String)("idea_app_params" + pseudoUniquePrefix), null);
                PrintWriter writer = JdkUtil.createOutputWriter(appParamsFile);
                Object object = null;
                try {
                    for (String string : javaParameters.getProgramParametersList().getList()) {
                        writer.println(string);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            File classpathFile = FileUtil.createTempFile((String)("idea_classpath" + pseudoUniquePrefix), null);
            PathsList classPath = javaParameters.getClassPath();
            Throwable throwable = null;
            try (PrintWriter printWriter = JdkUtil.createOutputWriter(classpathFile);){
                for (String path2 : classPath.getPathList()) {
                    printWriter.println(path2);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            Map map = ContainerUtil.stringMap((String[])new String[]{classpathFile.getAbsolutePath(), classPath.getPathsString()});
            commandLine.putUserData(COMMAND_LINE_CONTENT, map);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(PathUtil.getJarPathForClass(commandLineWrapper));
            if (JdkUtil.isUrlClassloader(vmParameters)) {
                linkedHashSet.add(PathUtil.getJarPathForClass(UrlClassLoader.class));
                linkedHashSet.add(PathUtil.getJarPathForClass(StringUtilRt.class));
                linkedHashSet.add(PathUtil.getJarPathForClass(THashMap.class));
            }
            commandLine.addParameter("-classpath");
            commandLine.addParameter(StringUtil.join(linkedHashSet, (String)File.pathSeparator));
            commandLine.addParameter(commandLineWrapper.getName());
            commandLine.addParameter(classpathFile.getAbsolutePath());
            OSProcessHandler.deleteFileOnTermination(commandLine, classpathFile);
            if (vmParamsFile != null) {
                commandLine.addParameter("@vm_params");
                commandLine.addParameter(vmParamsFile.getAbsolutePath());
                map.put(vmParamsFile.getAbsolutePath(), FileUtil.loadFile((File)vmParamsFile));
                OSProcessHandler.deleteFileOnTermination(commandLine, vmParamsFile);
            }
            if (appParamsFile != null) {
                commandLine.addParameter("@app_params");
                commandLine.addParameter(appParamsFile.getAbsolutePath());
                map.put(appParamsFile.getAbsolutePath(), FileUtil.loadFile((File)appParamsFile));
                OSProcessHandler.deleteFileOnTermination(commandLine, appParamsFile);
            }
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    @NotNull
    private static PrintWriter createOutputWriter(@NotNull File vmParamsFile) throws FileNotFoundException {
        if (vmParamsFile == null) {
            JdkUtil.$$$reportNull$$$0(27);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(vmParamsFile), StandardCharsets.UTF_8));
        if (printWriter == null) {
            JdkUtil.$$$reportNull$$$0(28);
        }
        return printWriter;
    }

    private static void setClasspathJarParams(@NotNull GeneralCommandLine commandLine, @NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters, @NotNull Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(29);
        }
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(30);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(31);
        }
        if (commandLineWrapper == null) {
            JdkUtil.$$$reportNull$$$0(32);
        }
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
            String manifestText = "";
            if (dynamicVMOptions) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String param : vmParameters.getList()) {
                    if (JdkUtil.isUserDefinedProperty(param)) {
                        properties.add(param);
                        continue;
                    }
                    commandLine.addParameter(param);
                }
                manifest.getMainAttributes().putValue("VM-Options", ParametersListUtil.join(properties));
                manifestText = manifestText + "VM-Options: " + ParametersListUtil.join(properties) + "\n";
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            if (dynamicParameters) {
                manifest.getMainAttributes().putValue("Program-Parameters", ParametersListUtil.join(javaParameters.getProgramParametersList().getList()));
                manifestText = manifestText + "Program-Parameters: " + ParametersListUtil.join(javaParameters.getProgramParametersList().getList()) + "\n";
            }
            boolean notEscape = vmParameters.hasParameter(PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL);
            PathsList path2 = javaParameters.getClassPath();
            File classpathJarFile = CommandLineWrapperUtil.createClasspathJarFile((Manifest)manifest, path2.getPathList(), (boolean)notEscape);
            String jarFilePath = classpathJarFile.getAbsolutePath();
            commandLine.addParameter("-classpath");
            if (dynamicVMOptions || dynamicParameters) {
                commandLine.addParameter(PathUtil.getJarPathForClass(commandLineWrapper) + File.pathSeparator + jarFilePath);
                commandLine.addParameter(commandLineWrapper.getName());
            }
            commandLine.addParameter(jarFilePath);
            commandLine.putUserData(COMMAND_LINE_CONTENT, ContainerUtil.stringMap((String[])new String[]{jarFilePath, manifestText + "Class-Path: " + path2.getPathsString()}));
            OSProcessHandler.deleteFileOnTermination(commandLine, classpathJarFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static boolean isUserDefinedProperty(@NotNull String param) {
        if (param == null) {
            JdkUtil.$$$reportNull$$$0(33);
        }
        return param.startsWith("-D") && !param.startsWith("-Dsun.") && !param.startsWith("-Djava.");
    }

    private static void throwUnableToCreateTempFile(@NotNull IOException cause) throws CantRunException {
        if (cause == null) {
            JdkUtil.$$$reportNull$$$0(34);
        }
        throw new CantRunException("Failed to a create temporary file in " + FileUtilRt.getTempDirectory(), cause);
    }

    private static void appendParamsEncodingClasspath(@NotNull SimpleJavaParameters javaParameters, @NotNull GeneralCommandLine commandLine, @NotNull ParametersList vmParameters) {
        PathsList modulePath;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(35);
        }
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(36);
        }
        if (vmParameters == null) {
            JdkUtil.$$$reportNull$$$0(37);
        }
        commandLine.addParameters(vmParameters.getList());
        JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
        PathsList classPath = javaParameters.getClassPath();
        if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(classPath.getPathsString());
        }
        if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
            commandLine.addParameter("-p");
            commandLine.addParameter(modulePath.getPathsString());
        }
    }

    private static void appendEncoding(@NotNull SimpleJavaParameters javaParameters, @NotNull GeneralCommandLine commandLine, @NotNull ParametersList parametersList) {
        String encoding;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(38);
        }
        if (commandLine == null) {
            JdkUtil.$$$reportNull$$$0(39);
        }
        if (parametersList == null) {
            JdkUtil.$$$reportNull$$$0(40);
        }
        if ((encoding = parametersList.getPropertyValue("file.encoding")) == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.withCharset(charset);
        } else {
            try {
                Charset charset = Charset.forName(encoding);
                commandLine.withCharset(charset);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @NotNull
    private static List<String> getMainClassParams(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(41);
        }
        String mainClass = javaParameters.getMainClass();
        String moduleName = javaParameters.getModuleName();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null && moduleName != null) {
            List<String> list = Arrays.asList("-m", moduleName + '/' + mainClass);
            if (list == null) {
                JdkUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        if (mainClass != null) {
            List<String> list = Collections.singletonList(mainClass);
            if (list == null) {
                JdkUtil.$$$reportNull$$$0(43);
            }
            return list;
        }
        if (jarPath != null) {
            List<String> list = Arrays.asList("-jar", jarPath);
            if (list == null) {
                JdkUtil.$$$reportNull$$$0(44);
            }
            return list;
        }
        throw new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0]));
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    @Deprecated
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 21: 
            case 22: 
            case 28: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 21: 
            case 22: 
            case 28: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 24: 
            case 30: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 11: 
            case 21: 
            case 22: 
            case 28: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 12: 
            case 17: 
            case 23: 
            case 29: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 25: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineWrapper";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParamsFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setupJVMCommandLine";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteArg";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputWriter";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainClassParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkMainAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForJre";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForRuntime";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isModularRuntime";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExplodedModularRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupJVMCommandLine";
                break;
            }
            case 11: 
            case 21: 
            case 22: 
            case 28: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isUrlClassloader";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "explicitClassPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "explicitModulePath";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setArgFileParams";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "quoteArg";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLineWrapperParams";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createOutputWriter";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setClasspathJarParams";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isUserDefinedProperty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "throwUnableToCreateTempFile";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendParamsEncodingClasspath";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendEncoding";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMainClassParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 21: 
            case 22: 
            case 28: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

