/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSystemId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ProjectSystemId> ourExistingIds = ContainerUtil.newConcurrentMap();
    @NotNull
    public static final ProjectSystemId IDE = new ProjectSystemId("IDE");
    @NotNull
    private final String myId;
    @NotNull
    private final String myReadableName;

    public ProjectSystemId(@NotNull String id) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(0);
        }
        this(id, StringUtil.capitalize((String)id.toLowerCase()));
    }

    public ProjectSystemId(@NotNull String id, @NotNull String readableName) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(1);
        }
        if (readableName == null) {
            ProjectSystemId.$$$reportNull$$$0(2);
        }
        this.myId = id;
        this.myReadableName = readableName;
        ourExistingIds.put(id, this);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSystemId owner = (ProjectSystemId)o;
        return this.myId.equals(owner.myId);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ProjectSystemId.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getReadableName() {
        String string = this.myReadableName;
        if (string == null) {
            ProjectSystemId.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String toString() {
        return this.myId;
    }

    @Nullable
    public static ProjectSystemId findById(@NotNull String id) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(5);
        }
        return ourExistingIds.get(id);
    }

    private Object readResolve() {
        ProjectSystemId cached = ourExistingIds.get(this.myId);
        if (cached != null) {
            return cached;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readableName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/ProjectSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/ProjectSystemId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

