/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributesEffectsBuilder {
    private static final Logger LOG = Logger.getInstance(TextAttributesEffectsBuilder.class);
    private static final Map<EffectType, EffectSlot> EFFECT_SLOTS_MAP = ContainerUtil.immutableMapBuilder().put((Object)EffectType.STRIKEOUT, (Object)EffectSlot.STRIKE_SLOT).put((Object)EffectType.BOXED, (Object)EffectSlot.FRAME_SLOT).put((Object)EffectType.ROUNDED_BOX, (Object)EffectSlot.FRAME_SLOT).put((Object)EffectType.BOLD_LINE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.LINE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.WAVE_UNDERSCORE, (Object)EffectSlot.UNDERLINE_SLOT).put((Object)EffectType.BOLD_DOTTED_LINE, (Object)EffectSlot.UNDERLINE_SLOT).build();
    private final Map<EffectSlot, EffectDescriptor> myEffectsMap = ContainerUtilRt.newHashMap((int)EffectSlot.values().length);

    private TextAttributesEffectsBuilder() {
    }

    @NotNull
    public static TextAttributesEffectsBuilder create() {
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = new TextAttributesEffectsBuilder();
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(0);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public static TextAttributesEffectsBuilder create(@NotNull TextAttributes deepestAttributes) {
        if (deepestAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(1);
        }
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = TextAttributesEffectsBuilder.create().coverWith(deepestAttributes);
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(2);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public final TextAttributesEffectsBuilder coverWith(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(3);
        }
        attributes.forEachAdditionalEffect(this::coverWith);
        this.coverWith(attributes.getEffectType(), attributes.getEffectColor());
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(4);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public final TextAttributesEffectsBuilder slipUnder(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(5);
        }
        this.slipUnder(attributes.getEffectType(), attributes.getEffectColor());
        attributes.forEachAdditionalEffect(this::slipUnder);
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(6);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder coverWith(@Nullable EffectType effectType, @Nullable Color effectColor) {
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this.mutateBuilder(effectType, effectColor, this.myEffectsMap::put);
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(7);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    public TextAttributesEffectsBuilder slipUnder(@Nullable EffectType effectType, @Nullable Color effectColor) {
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this.mutateBuilder(effectType, effectColor, this.myEffectsMap::putIfAbsent);
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(8);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    private TextAttributesEffectsBuilder mutateBuilder(@Nullable EffectType effectType, @Nullable Color effectColor, @NotNull BiConsumer<EffectSlot, EffectDescriptor> slotMutator) {
        if (slotMutator == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(9);
        }
        if (effectColor != null && effectType != null) {
            EffectSlot slot = EFFECT_SLOTS_MAP.get((Object)effectType);
            if (slot != null) {
                slotMutator.accept(slot, EffectDescriptor.create(effectType, effectColor));
            } else {
                LOG.debug("Effect " + (Object)((Object)effectType) + " is not supported by builder");
            }
        }
        TextAttributesEffectsBuilder textAttributesEffectsBuilder = this;
        if (textAttributesEffectsBuilder == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(10);
        }
        return textAttributesEffectsBuilder;
    }

    @NotNull
    List<EffectDescriptor> getDescriptorsList() {
        List list = this.myEffectsMap.isEmpty() ? ContainerUtil.emptyList() : ContainerUtil.newArrayList(this.myEffectsMap.values());
        if (list == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    Map<EffectType, Color> getEffectsMap() {
        if (this.myEffectsMap.isEmpty()) {
            Map<EffectType, Color> map = Collections.emptyMap();
            if (map == null) {
                TextAttributesEffectsBuilder.$$$reportNull$$$0(12);
            }
            return map;
        }
        HashMap result2 = ContainerUtil.newHashMap();
        this.myEffectsMap.forEach((key, val) -> {
            if (val != null) {
                result2.put(val.effectType, val.effectColor);
            }
        });
        HashMap hashMap = result2;
        if (hashMap == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    public TextAttributes applyTo(@NotNull TextAttributes targetAttributes) {
        List<EffectDescriptor> allEffects;
        if (targetAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(14);
        }
        if ((allEffects = this.getDescriptorsList()).isEmpty()) {
            targetAttributes.setEffectColor(null);
            targetAttributes.setEffectType(null);
            targetAttributes.setAdditionalEffects(Collections.emptyMap());
        } else {
            HashMap effectsMap = ContainerUtil.newHashMap();
            EffectDescriptor mainEffectDescriptor = allEffects.remove(0);
            targetAttributes.setEffectType(mainEffectDescriptor.effectType);
            targetAttributes.setEffectColor(mainEffectDescriptor.effectColor);
            allEffects.forEach(it -> effectsMap.put(it.effectType, it.effectColor));
            targetAttributes.setAdditionalEffects(effectsMap);
        }
        TextAttributes textAttributes = targetAttributes;
        if (textAttributes == null) {
            TextAttributesEffectsBuilder.$$$reportNull$$$0(15);
        }
        return textAttributes;
    }

    @Nullable
    @Contract(value="null -> null")
    public EffectDescriptor getEffectDescriptor(@Nullable EffectSlot effectSlot) {
        return this.myEffectsMap.get((Object)effectSlot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepestAttributes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slotMutator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "coverWith";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "slipUnder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mutateBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorsList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectsMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "coverWith";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "slipUnder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mutateBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EffectDescriptor {
        @NotNull
        public final EffectType effectType;
        @NotNull
        public final Color effectColor;

        private EffectDescriptor(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(0);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(1);
            }
            this.effectType = effectType;
            this.effectColor = effectColor;
        }

        @NotNull
        static EffectDescriptor create(@NotNull EffectType effectType, @NotNull Color effectColor) {
            if (effectType == null) {
                EffectDescriptor.$$$reportNull$$$0(2);
            }
            if (effectColor == null) {
                EffectDescriptor.$$$reportNull$$$0(3);
            }
            EffectDescriptor effectDescriptor = new EffectDescriptor(effectType, effectColor);
            if (effectDescriptor == null) {
                EffectDescriptor.$$$reportNull$$$0(4);
            }
            return effectDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectColor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder$EffectDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributesEffectsBuilder$EffectDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum EffectSlot {
        FRAME_SLOT,
        UNDERLINE_SLOT,
        STRIKE_SLOT;

    }
}

