/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartFMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    private SmartFMap<String, Object> myUserMap = SmartFMap.emptyMap();
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport;
    private String myText;
    private String myDescription;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    private int myMnemonic;
    private int myDisplayedMnemonicIndex = -1;
    private boolean myVisible = true;
    private boolean myEnabled = true;
    private double myWeight = 0.0;

    public Presentation() {
    }

    public Presentation(String text) {
        this.myText = text;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support == null) {
            support = this.myChangeSupport = new PropertyChangeSupport(this);
        }
        support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null) {
            support.removePropertyChangeListener(l);
        }
    }

    public String getText() {
        return this.myText;
    }

    public void setText(@Nullable String text, boolean mayContainMnemonic) {
        int oldMnemonic = this.myMnemonic;
        int oldDisplayedMnemonicIndex = this.myDisplayedMnemonicIndex;
        String oldText = this.myText;
        this.myMnemonic = 0;
        this.myDisplayedMnemonicIndex = -1;
        if (text != null) {
            if (text.indexOf(27) >= 0) {
                text = text.replace('\u001b', '&');
            }
            if (mayContainMnemonic) {
                StringBuilder plainText = new StringBuilder();
                int backShift = 0;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (this.myMnemonic == 0 && (ch == '_' || ch == '&')) {
                        if (++i >= text.length()) break;
                        ch = text.charAt(i);
                        if (ch != '_' && ch != '&') {
                            this.myMnemonic = Character.toUpperCase(ch);
                            this.myDisplayedMnemonicIndex = i - 1 - backShift;
                        } else {
                            ++backShift;
                        }
                    }
                    plainText.append(ch);
                }
                this.myText = plainText.length() == 0 ? "" : plainText.toString();
            } else {
                this.myText = text.isEmpty() ? "" : text;
            }
        } else {
            this.myText = null;
        }
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings != null && uiSettings.getDisableMnemonicsInControls()) {
            this.myMnemonic = 0;
            this.myDisplayedMnemonicIndex = -1;
        }
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.myText);
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.myMnemonic);
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldDisplayedMnemonicIndex, this.myDisplayedMnemonicIndex);
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public String getTextWithMnemonic() {
        return Presentation.wrapTextWithMnemonic(this.myText, this.myDisplayedMnemonicIndex);
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
    }

    public static String restoreTextWithMnemonic(@Nullable String text, int mnemonic) {
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.toUpperCase(text.charAt(i)) != mnemonic) continue;
            return Presentation.wrapTextWithMnemonic(text, i);
        }
        return Presentation.wrapTextWithMnemonic(text, -1);
    }

    @Nullable
    private static String wrapTextWithMnemonic(@Nullable String text, int mnemonicIndex) {
        if (text == null) {
            return null;
        }
        if (mnemonicIndex > -1) {
            String prefix = StringUtil.escapeMnemonics((String)text.substring(0, mnemonicIndex));
            String suffix = text.substring(mnemonicIndex);
            return prefix + "_" + suffix;
        }
        return StringUtil.escapeMnemonics((String)text);
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        String oldDescription = this.myDescription;
        this.myDescription = description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription, this.myDescription);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public int getDisplayedMnemonicIndex() {
        return this.myDisplayedMnemonicIndex;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.myVisible);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.myEnabled);
    }

    public final void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (oldValue != newValue && support != null) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireObjectPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null && !Objects.equals(oldValue, newValue)) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myChangeSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(Presentation presentation) {
        if (presentation == this) {
            return;
        }
        if (!Objects.equals(this.myText, presentation.myText) || this.myDisplayedMnemonicIndex != presentation.myDisplayedMnemonicIndex || this.myMnemonic != presentation.myMnemonic) {
            this.setText(presentation.getTextWithMnemonic());
        }
        this.setDescription(presentation.getDescription());
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
        this.setWeight(presentation.getWeight());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet allKeys = new HashSet(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        return (T)this.myUserMap.get((Object)key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        this.putClientProperty(key.toString(), value);
    }

    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(2);
        }
        return this.myUserMap.get((Object)key);
    }

    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(3);
        }
        if (Comparing.equal((Object)(oldValue = this.myUserMap.get((Object)key)), (Object)value)) {
            return;
        }
        this.myUserMap = value == null ? this.myUserMap.minus((Object)key) : this.myUserMap.plus((Object)key, value);
        this.fireObjectPropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    public String toString() {
        return this.myText + " (" + this.myDescription + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "key";
        objectArray2[1] = "com/intellij/openapi/actionSystem/Presentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getClientProperty";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "putClientProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

